import "core-js/modules/es.symbol";
import "core-js/modules/es.symbol.description";
import "core-js/modules/es.symbol.iterator";
import "core-js/modules/es.array.from";
import "core-js/modules/es.array.iterator";
import "core-js/modules/es.array.slice";
import "core-js/modules/es.function.name";
import "core-js/modules/es.object.to-string";
import "core-js/modules/es.regexp.to-string";
import "core-js/modules/es.string.iterator";
import "core-js/modules/web.dom-collections.iterator";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createForOfIteratorHelper(o) { if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

import jsonld from 'jsonld';
import * as Constants from '../constants/Constants.js';
import FormUtils from '../util/FormUtils';
import Utils from './Utils';
var formShape = {
  root: _defineProperty({}, Constants.HAS_LAYOUT_CLASS, Constants.FORM),
  expandProperties: [Constants.HAS_SUBQUESTION, Constants.IS_RELEVANT_IF, Constants.HAS_ANSWER, Constants.HAS_DECLARED_PREFIX]
};

var JsonLdFramingUtils = /*#__PURE__*/function () {
  function JsonLdFramingUtils() {
    _classCallCheck(this, JsonLdFramingUtils);
  }

  _createClass(JsonLdFramingUtils, null, [{
    key: "customFrame",
    //TODO revise

    /**
     * Performs JSON-LD custom framing using shapes. Shape is declaration of the JSON-LD framing
     * in a language that is incompatible with JSON-LD specification.
     *
     * @param input the JSON-LD input to framing by a shape.
     * @param shape the JSON-LD custom frame configuration using shapes.
     * @param callback(err, framed) called once the operation completes.
     */
    value: function customFrame(input, shape, callback) {
      if (arguments.length < 2) {
        return jsonld.nextTick(function () {
          callback(new TypeError('Could not frame, too few arguments.'));
        });
      }

      if (shape === null) {
        //TODO remove
        shape = formShape;
      }

      var flattened = null;
      var err = null;

      var flattenedCallback = function flattenedCallback(e, f) {
        flattened = f;
        err = e;
      };

      jsonld.flatten(input, null, null, flattenedCallback);
    }
  }, {
    key: "modifyStructure",
    value: function modifyStructure(structure) {
      var defs = structure['@graph'];
      var item;
      var form;
      var id2objectMap = {}; // mapping @id -> object

      for (var i = 0; i < defs.length; i++) {
        item = defs[i];
        id2objectMap[item['@id']] = item;

        if (FormUtils.isForm(item)) {
          form = item;
        }
      }

      try {
        this._expandGraph(form, formShape, id2objectMap);
      } catch (e) {
        console.error("Error '" + e + "' occured, while trying to apply frame-ing with custom shape.");
      }

      return id2objectMap;
    }
  }, {
    key: "_expandGraph",
    value: function _expandGraph(parentNode, shape, id2ObjectMap) {
      var childArray;
      var child;
      var childId;

      var _iterator = _createForOfIteratorHelper(shape.expandProperties),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var prop = _step.value;

          if (parentNode.hasOwnProperty(prop)) {
            parentNode[prop] = Utils.asArray(parentNode[prop]);
            childArray = parentNode[prop];

            for (var i = 0; i < childArray.length; i++) {
              childId = childArray[i]['@id'];
              child = id2ObjectMap[childId];

              if (child !== undefined) {
                childArray[i] = child; //console.log(childId + " expanded.");

                this._expandGraph(child, shape, id2ObjectMap);
              } else {
                console.warn('object with @id ' + childId + ' was not defined in input data.');
              }
            }
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
  }]);

  return JsonLdFramingUtils;
}();

export { JsonLdFramingUtils as default };