import "core-js/modules/es.array.for-each";
import "core-js/modules/es.array.map";
import "core-js/modules/es.array.sort";
import "core-js/modules/web.dom-collections.for-each";
import _typeof from "@babel/runtime/helpers/typeof";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import jsonld from 'jsonld';
import JsonLdUtils from 'jsonld-utils';
import Utils from './Utils';
import tsort from 'tsort';

var JsonLdObjectUtils = /*#__PURE__*/function () {
  function JsonLdObjectUtils() {
    _classCallCheck(this, JsonLdObjectUtils);
  }

  _createClass(JsonLdObjectUtils, null, [{
    key: "getFirstObject",
    value: function getFirstObject(subject, predicate) {
      var values = jsonld.getValues(subject, predicate);

      if (values.length === 0) {
        //throw "Subject "  + subject[@id] + " does not have any value of property " + predicate;
        return null;
      }

      return values[0];
    }
  }, {
    key: "compareValues",
    value: function compareValues(jsonLdValue1, jsonLdValue2) {
      jsonLdValue1 = _typeof(jsonLdValue1) === 'object' ? jsonLdValue1 : {
        '@value': jsonLdValue1
      };
      jsonLdValue2 = _typeof(jsonLdValue2) === 'object' ? jsonLdValue2 : {
        '@value': jsonLdValue2
      }; // TODO remove: workaround for bad persistance of boolean values -- { @value: "true" } instead of { @value: true }

      if (jsonLdValue1 && jsonLdValue1['@value'] && jsonLdValue2 && jsonLdValue2['@value']) {
        var strValue1 = typeof jsonLdValue1['@value'] === 'string' ? jsonLdValue1['@value'] : JSON.stringify(jsonLdValue1['@value']);
        var strValue2 = typeof jsonLdValue2['@value'] === 'string' ? jsonLdValue2['@value'] : JSON.stringify(jsonLdValue2['@value']);

        if (strValue1 === strValue2) {
          return true;
        }
      }

      return jsonld.compareValues(jsonLdValue1, jsonLdValue2);
    }
    /**
     * Sorts the specified JSON-LD data using a topological sort over partially ordered set defined by gtProperty.
     *
     * This is useful for situations where each item only knows its immediate neighbour in the list.
     * @param data The data to sort, should be an array
     * @param gtProperty Property specifying that an item is greater than another item. It is used for comparison.
     *
     */

  }, {
    key: "toplogicalSort",
    value: function toplogicalSort(data, gtProperty) {
      var swapped;

      do {
        swapped = false;

        for (var i = 0; i < data.length; i++) {
          for (var j = i; j < data.length; j++) {
            if (data[i][gtProperty]) {
              var gtId = _typeof(data[i][gtProperty]) === 'object' ? data[i][gtProperty]['@id'] : data[i][gtProperty];

              if (gtId === data[j]['@id']) {
                var tmp = data[i];
                data[i] = data[j];
                data[j] = tmp;
                swapped = true;
                break;
              }
            }
          }
        }
      } while (swapped);

      return data;
    }
    /**
     * Sorts the specified JSON-LD data using a topological sort over partially ordered set defined by gtProperty,
     * while preserving original order.
     *
     * This is useful for situations where each item only knows its immediate neighbour in the list.
     * @param data The data to sort, should be an array
     * @param gtProperty Property specifying that an item is greater than another item. It is used for comparison.
     *
     */

  }, {
    key: "orderPreservingToplogicalSort",
    value: function orderPreservingToplogicalSort(data, gtProperty) {
      var graph = tsort();
      var id2ObjectMap = {};

      var _loop = function _loop(i) {
        var currentId = data[i]['@id'];
        graph.add(currentId);
        id2ObjectMap[currentId] = data[i];
        Utils.asArray(data[i][gtProperty]).map(function (val) {
          return _typeof(val) === 'object' ? val['@id'] : val;
        }).map(function (val) {
          return [val, currentId];
        }).forEach(function (edge) {
          return graph.add(edge);
        });
      };

      for (var i = 0; i < data.length; i++) {
        _loop(i);
      }

      var sortedIds = graph.sort();

      for (var _i = 0; _i < sortedIds.length; _i++) {
        data[_i] = id2ObjectMap[sortedIds[_i]];
      }

      return data;
    }
  }, {
    key: "getCompareLocalizedLabelFunction",
    value: function getCompareLocalizedLabelFunction(intl) {
      return function (a, b) {
        var aLabel = JsonLdUtils.getLocalized(a[JsonLdUtils.RDFS_LABEL], intl);
        var bLabel = JsonLdUtils.getLocalized(b[JsonLdUtils.RDFS_LABEL], intl);

        if (aLabel < bLabel) {
          return -1;
        } else if (aLabel > bLabel) {
          return 1;
        }

        return 0;
      };
    }
  }]);

  return JsonLdObjectUtils;
}();

export { JsonLdObjectUtils as default };