module.exports =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./s-forms.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./components/Answer.jsx":
/*!*******************************!*\
  !*** ./components/Answer.jsx ***!
  \*******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor */ "core-js/modules/es.object.get-own-property-descriptor");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.keys */ "core-js/modules/es.object.keys");
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _answer_CheckboxAnswer__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./answer/CheckboxAnswer */ "./components/answer/CheckboxAnswer.jsx");
/* harmony import */ var _answer_DateTimeAnswer__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./answer/DateTimeAnswer */ "./components/answer/DateTimeAnswer.jsx");
/* harmony import */ var _answer_InputAnswer__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./answer/InputAnswer */ "./components/answer/InputAnswer.jsx");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _answer_MaskedInputAnswer__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./answer/MaskedInputAnswer */ "./components/answer/MaskedInputAnswer.jsx");
/* harmony import */ var _answer_SelectAnswer__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./answer/SelectAnswer */ "./components/answer/SelectAnswer.jsx");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _util_Utils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../util/Utils */ "./util/Utils.js");
/* harmony import */ var _answer_TypeaheadAnswer__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./answer/TypeaheadAnswer */ "./components/answer/TypeaheadAnswer.jsx");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _contexts_FormGenContext__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../contexts/FormGenContext */ "./contexts/FormGenContext.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");









function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }
















var Answer = function Answer(props) {
  var formGenContext = react__WEBPACK_IMPORTED_MODULE_8___default.a.useContext(_contexts_FormGenContext__WEBPACK_IMPORTED_MODULE_20__["FormGenContext"]);

  var _React$useContext = react__WEBPACK_IMPORTED_MODULE_8___default.a.useContext(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_21__["ConfigurationContext"]),
      options = _React$useContext.options;

  var onValueChange = function onValueChange(value) {
    var change = _objectSpread({}, props.answer);

    _setValue(change, value);

    props.onChange(props.index, change);
  };

  var _setValue = function _setValue(change, value) {
    if (value === null) {
      change[_constants_Constants__WEBPACK_IMPORTED_MODULE_19__["HAS_OBJECT_VALUE"]] = null;
      change[_constants_Constants__WEBPACK_IMPORTED_MODULE_19__["HAS_DATA_VALUE"]] = null;
    } else if (props.answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_19__["HAS_OBJECT_VALUE"]] || _util_FormUtils__WEBPACK_IMPORTED_MODULE_16__["default"].isTypeahead(props.question)) {
      change[_constants_Constants__WEBPACK_IMPORTED_MODULE_19__["HAS_OBJECT_VALUE"]] = {
        '@id': value
      };
    } else {
      change[_constants_Constants__WEBPACK_IMPORTED_MODULE_19__["HAS_DATA_VALUE"]] = {
        '@value': value
      };
    }
  };

  var _hasOptions = function _hasOptions(item) {
    return item[_constants_Constants__WEBPACK_IMPORTED_MODULE_19__["HAS_OPTION"]] && item[_constants_Constants__WEBPACK_IMPORTED_MODULE_19__["HAS_OPTION"]].length !== 0;
  };

  var _renderTypeahead = function _renderTypeahead(value, label, title) {
    var queryHash = _util_Utils__WEBPACK_IMPORTED_MODULE_17__["default"].getStringHash(_util_FormUtils__WEBPACK_IMPORTED_MODULE_16__["default"].getPossibleValuesQuery(props.question));
    var options = formGenContext.getOptions(queryHash) || [];
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(_answer_TypeaheadAnswer__WEBPACK_IMPORTED_MODULE_18__["default"], {
      question: props.question,
      answer: props.answer,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      options: options
    });
  };

  var _renderSelect = function _renderSelect(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(_answer_SelectAnswer__WEBPACK_IMPORTED_MODULE_15__["default"], {
      question: props.question,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange
    });
  };

  var _renderDateTimePicker = function _renderDateTimePicker(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(_answer_DateTimeAnswer__WEBPACK_IMPORTED_MODULE_11__["default"], {
      question: props.question,
      value: value,
      title: title,
      label: label,
      onChange: onValueChange
    });
  };

  var _renderCheckbox = function _renderCheckbox(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(_answer_CheckboxAnswer__WEBPACK_IMPORTED_MODULE_10__["default"], {
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      question: props.question
    });
  };

  var _renderMaskedInput = function _renderMaskedInput(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(_answer_MaskedInputAnswer__WEBPACK_IMPORTED_MODULE_14__["default"], {
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      question: props.question,
      answer: props.answer
    });
    return null;
  };

  var _renderRegularInput = function _renderRegularInput(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(_answer_InputAnswer__WEBPACK_IMPORTED_MODULE_12__["default"], {
      question: props.question,
      answer: props.answer,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange
    });
  };

  var _renderSparqlInput = function _renderSparqlInput(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(_answer_InputAnswer__WEBPACK_IMPORTED_MODULE_12__["default"], {
      question: props.question,
      answer: props.answer,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      sparql: true
    });
  };

  var _renderTurtleInput = function _renderTurtleInput(value, label, title) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(_answer_InputAnswer__WEBPACK_IMPORTED_MODULE_12__["default"], {
      question: props.question,
      answer: props.answer,
      label: label,
      title: title,
      value: value,
      onChange: onValueChange,
      turtle: true
    });
  };

  var question = props.question;
  var value = _util_FormUtils__WEBPACK_IMPORTED_MODULE_16__["default"].resolveValue(props.answer);
  var label = jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.getLocalized(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_19__["RDFS_LABEL"]], options.intl);
  var title = jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.getLocalized(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_19__["RDFS_COMMENT"]], options.intl);
  var component;

  if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_16__["default"].isTypeahead(question)) {
    component = _renderTypeahead(value, label, title);
  } else if (_hasOptions(question)) {
    component = _renderSelect(value, label, title);
  } else if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_16__["default"].isCalendar(question)) {
    component = _renderDateTimePicker(value, label, title);
  } else if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_16__["default"].isCheckbox(question)) {
    component = _renderCheckbox(value, label, title);
  } else if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_16__["default"].isMaskedInput(question)) {
    component = _renderMaskedInput(value, label, title);
  } else if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_16__["default"].isSparqlInput(question)) {
    component = _renderSparqlInput(value, label, title);
  } else if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_16__["default"].isTurtleInput(question)) {
    component = _renderTurtleInput(value, label, title);
  } else {
    component = _renderRegularInput(value, label, title);
  }

  return component;
};

Answer.propTypes = {
  answer: prop_types__WEBPACK_IMPORTED_MODULE_9___default.a.object.isRequired,
  question: prop_types__WEBPACK_IMPORTED_MODULE_9___default.a.object.isRequired,
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_9___default.a.func.isRequired,
  index: prop_types__WEBPACK_IMPORTED_MODULE_9___default.a.number
};
/* harmony default export */ __webpack_exports__["default"] = (Answer);

/***/ }),

/***/ "./components/DefaultInput.jsx":
/*!*************************************!*\
  !*** ./components/DefaultInput.jsx ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DefaultInput; });
/* harmony import */ var core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.number.constructor */ "core-js/modules/es.number.constructor");
/* harmony import */ var core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_number_max_safe_integer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.number.max-safe-integer */ "core-js/modules/es.number.max-safe-integer");
/* harmony import */ var core_js_modules_es_number_max_safe_integer__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_max_safe_integer__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "@babel/runtime/helpers/extends");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__);












function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_10___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_10___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_9___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var DefaultInput = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_8___default()(DefaultInput, _React$Component);

  var _super = _createSuper(DefaultInput);

  function DefaultInput() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_6___default()(this, DefaultInput);

    return _super.apply(this, arguments);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_7___default()(DefaultInput, [{
    key: "focus",
    value: function focus() {
      react_dom__WEBPACK_IMPORTED_MODULE_12___default.a.findDOMNode(this.input).focus();
    }
  }, {
    key: "getInputDOMNode",
    value: function getInputDOMNode() {
      return react_dom__WEBPACK_IMPORTED_MODULE_12___default.a.findDOMNode(this.input);
    }
  }, {
    key: "render",
    value: function render() {
      switch (this.props.type) {
        case 'radio':
          return this._renderRadio();

        case 'checkbox':
          return this._renderCheckbox();

        case 'select':
          return this._renderSelect();

        case 'textarea':
          return this._renderTextArea();

        default:
          return this._renderInput();
      }
    }
  }, {
    key: "_renderCheckbox",
    value: function _renderCheckbox() {
      var _this = this;

      // TODO change control id to hash of label
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["Form"].Group, {
        size: "small",
        controlId: Math.floor(Math.random() * Number.MAX_SAFE_INTEGER)
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["Form"].Check, _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_5___default()({
        type: "checkbox",
        ref: function ref(c) {
          return _this.input = c;
        }
      }, this.props, {
        label: this.props.label
      })));
    }
  }, {
    key: "_renderRadio",
    value: function _renderRadio() {
      var _this2 = this;

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["FormGroup"], {
        size: "small"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["Form"].Check, _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_5___default()({
        type: "radio",
        ref: function ref(c) {
          return _this2.input = c;
        }
      }, this.props, {
        label: this.props.label
      })));
    }
  }, {
    key: "_renderSelect",
    value: function _renderSelect() {
      var _this3 = this;

      // TODO validation
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["FormGroup"], {
        size: "small"
      }, this._renderLabel(), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["FormControl"], _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_5___default()({
        as: "select",
        ref: function ref(c) {
          return _this3.input = c;
        }
      }, this.props), this.props.children), this.props.validation && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["FormControl"].Feedback, null), this._renderHelp());
    }
  }, {
    key: "_renderLabel",
    value: function _renderLabel() {
      return this.props.label ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["Form"].Label, null, this.props.label) : null;
    }
  }, {
    key: "_renderTextArea",
    value: function _renderTextArea() {
      var _this4 = this;

      // TODO validation
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["FormGroup"], {
        size: "small"
      }, this._renderLabel(), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["FormControl"], _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_5___default()({
        as: "textarea",
        style: {
          height: 'auto'
        },
        ref: function ref(c) {
          return _this4.input = c;
        }
      }, this.props)), this.props.validation && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["FormControl"].Feedback, null), this._renderHelp());
    }
  }, {
    key: "_renderHelp",
    value: function _renderHelp() {
      return this.props.help ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["FormText"], null, this.props.help) : null;
    }
  }, {
    key: "_renderInput",
    value: function _renderInput() {
      var _this5 = this;

      // TODO validation
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["FormGroup"], {
        size: "small"
      }, this._renderLabel(), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["FormControl"], _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_5___default()({
        ref: function ref(c) {
          return _this5.input = c;
        },
        as: "input"
      }, this.props)), this.props.validation && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_14__["FormControl"].Feedback, null), this._renderHelp());
    }
  }]);

  return DefaultInput;
}(react__WEBPACK_IMPORTED_MODULE_11___default.a.Component);


DefaultInput.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_13___default.a.string,
  label: prop_types__WEBPACK_IMPORTED_MODULE_13___default.a.string,
  value: prop_types__WEBPACK_IMPORTED_MODULE_13___default.a.any,
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_13___default.a.func,
  help: prop_types__WEBPACK_IMPORTED_MODULE_13___default.a.string,
  validation: prop_types__WEBPACK_IMPORTED_MODULE_13___default.a.oneOf(['success', 'warning', 'error'])
};
DefaultInput.defaultProps = {
  type: 'text'
};

/***/ }),

/***/ "./components/FormManager.jsx":
/*!************************************!*\
  !*** ./components/FormManager.jsx ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_concat__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.concat */ "core-js/modules/es.array.concat");
/* harmony import */ var core_js_modules_es_array_concat__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_every__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.every */ "core-js/modules/es.array.every");
/* harmony import */ var core_js_modules_es_array_every__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_every__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor */ "core-js/modules/es.object.get-own-property-descriptor");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.keys */ "core-js/modules/es.object.keys");
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "@babel/runtime/helpers/assertThisInitialized");
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var _model_QuestionAnswerProcessor__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../model/QuestionAnswerProcessor */ "./model/QuestionAnswerProcessor.js");
/* harmony import */ var _contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../contexts/FormQuestionsContext */ "./contexts/FormQuestionsContext.js");
/* harmony import */ var _wizard_Wizard__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./wizard/Wizard */ "./components/wizard/Wizard.jsx");
/* harmony import */ var _s_forms__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../s-forms */ "./s-forms.js");
/* harmony import */ var _Question__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./Question */ "./components/Question.jsx");
/* harmony import */ var _FormWindow__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./FormWindow */ "./components/FormWindow.jsx");
/* harmony import */ var react_bootstrap_Card__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! react-bootstrap/Card */ "react-bootstrap/Card");
/* harmony import */ var react_bootstrap_Card__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap_Card__WEBPACK_IMPORTED_MODULE_27__);





















function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_19___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_18___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_18___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_17___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }










var FormManager = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_16___default()(FormManager, _React$Component);

  var _super = _createSuper(FormManager);

  function FormManager() {
    var _this;

    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_13___default()(this, FormManager);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_19___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_15___default()(_this), "getFormData", function () {
      var data = _this.context.getData();

      var formQuestionsData = _this.context.getFormQuestionsData();

      return _model_QuestionAnswerProcessor__WEBPACK_IMPORTED_MODULE_21__["default"].buildQuestionAnswerModel(data, formQuestionsData);
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_19___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_15___default()(_this), "onStepChange", function (question, index, change) {
      _this.context.updateFormQuestionsData(index, _objectSpread(_objectSpread({}, question), change));
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_19___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_15___default()(_this), "renderWizardlessForm", function () {
      var formQuestionsData = _this.context.getFormQuestionsData();

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_20___default.a.createElement(react_bootstrap_Card__WEBPACK_IMPORTED_MODULE_27___default.a, {
        className: "p-3"
      }, formQuestionsData.map(function (question, index) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_20___default.a.createElement(_Question__WEBPACK_IMPORTED_MODULE_25__["default"], {
          key: question['@id'],
          question: question,
          onChange: function onChange(index, change) {
            return _this.onStepChange(question, index, change);
          },
          index: index
        });
      }));
    });

    return _this;
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_14___default()(FormManager, [{
    key: "render",
    value: function render() {
      var modalView = this.props.modalView;
      var formQuestionsData = this.context.getFormQuestionsData();

      if (!formQuestionsData.length) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_20___default.a.createElement(react_bootstrap_Card__WEBPACK_IMPORTED_MODULE_27___default.a, {
          className: "p-3 font-italic"
        }, "There are no questions available...");
      }

      var isWizardless = formQuestionsData.every(function (question) {
        return !_s_forms__WEBPACK_IMPORTED_MODULE_24__["FormUtils"].isWizardStep(question);
      });

      if (modalView) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_20___default.a.createElement(_FormWindow__WEBPACK_IMPORTED_MODULE_26__["default"], null, isWizardless ? this.renderWizardlessForm() : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_20___default.a.createElement(_wizard_Wizard__WEBPACK_IMPORTED_MODULE_23__["default"], null));
      }

      return isWizardless ? this.renderWizardlessForm() : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_20___default.a.createElement(_wizard_Wizard__WEBPACK_IMPORTED_MODULE_23__["default"], null);
    }
  }]);

  return FormManager;
}(react__WEBPACK_IMPORTED_MODULE_20___default.a.Component);

FormManager.contextType = _contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_22__["FormQuestionsContext"];
/* harmony default export */ __webpack_exports__["default"] = (FormManager);

/***/ }),

/***/ "./components/FormWindow.jsx":
/*!***********************************!*\
  !*** ./components/FormWindow.jsx ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "@babel/runtime/helpers/extends");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");





var FormWindow = react__WEBPACK_IMPORTED_MODULE_1___default.a.forwardRef(function (props, ref) {
  var _React$useContext = react__WEBPACK_IMPORTED_MODULE_1___default.a.useContext(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_4__["ConfigurationContext"]),
      options = _React$useContext.options;

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Modal"], _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_0___default()({
    size: "xl",
    animation: true
  }, options.modalProps), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Modal"].Header, {
    closeButton: true
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Modal"].Title, null, options.modalProps.title)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Modal"].Body, {
    className: "overflow-hidden p-0"
  }, props.children));
});
FormWindow.propTypes = {
  children: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.element.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (FormWindow);

/***/ }),

/***/ "./components/HelpIcon.jsx":
/*!*********************************!*\
  !*** ./components/HelpIcon.jsx ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _styles_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../styles/icons */ "./styles/icons/index.js");





var HelpIcon = function HelpIcon(props) {
  var tooltip = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["Tooltip"], {
    id: "help-tooltip",
    className: "tooltip-content"
  }, props.text);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["OverlayTrigger"], {
    placement: "right",
    overlay: tooltip
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
    className: props.iconClassContainer,
    style: {
      position: 'absolute'
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_styles_icons__WEBPACK_IMPORTED_MODULE_3__["QuestionCircle"], {
    className: props.iconClass
  })));
};

HelpIcon.propTypes = {
  text: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string.isRequired,
  iconClassContainer: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string,
  iconClass: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string
};
HelpIcon.defaultProps = {
  iconClassContainer: '',
  iconClass: ''
};
/* harmony default export */ __webpack_exports__["default"] = (HelpIcon);

/***/ }),

/***/ "./components/MaskedInput.jsx":
/*!************************************!*\
  !*** ./components/MaskedInput.jsx ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return MaskedInput; });
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor */ "core-js/modules/es.object.get-own-property-descriptor");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.keys */ "core-js/modules/es.object.keys");
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "@babel/runtime/helpers/objectWithoutProperties");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "@babel/runtime/helpers/assertThisInitialized");
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var inputmask_core__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! inputmask-core */ "inputmask-core");
/* harmony import */ var inputmask_core__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(inputmask_core__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var _util_MaskMapper__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../util/MaskMapper */ "./util/MaskMapper.js");
/* harmony import */ var _util_MaskMapper__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(_util_MaskMapper__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");



















function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_16___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_16___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_15___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }







var KEYCODE_Z = 90;
var KEYCODE_Y = 89;

function isUndo(e) {
  return e.ctrlKey && e.keyCode === KEYCODE_Z;
}

function isRedo(e) {
  return e.ctrlKey && e.keyCode === KEYCODE_Y;
} // Copied from https://github.com/insin/react-maskedinput


function getSelection(el) {
  var start;
  var end;
  var rangeEl;
  var clone;

  if (el.selectionStart !== undefined) {
    start = el.selectionStart;
    end = el.selectionEnd;
  } else {
    try {
      el.focus();
      rangeEl = el.createTextRange();
      clone = rangeEl.duplicate();
      rangeEl.moveToBookmark(document.selection.createRange().getBookmark());
      clone.setEndPoint('EndToStart', rangeEl);
      start = clone.text.length;
      end = start + rangeEl.text.length;
    } catch (e) {
      /* not focused or not visible */
    }
  }

  return {
    start: start,
    end: end
  };
}

function setSelection(el, selection) {
  var rangeEl;

  try {
    if (el.selectionStart !== undefined) {
      el.focus();
      el.setSelectionRange(selection.start, selection.end);
    } else {
      el.focus();
      rangeEl = el.createTextRange();
      rangeEl.collapse(true);
      rangeEl.moveStart('character', selection.start);
      rangeEl.moveEnd('character', selection.end - selection.start);
      rangeEl.select();
    }
  } catch (e) {
    /* not focused or not visible */
  }
}

var MaskedInput = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_14___default()(MaskedInput, _React$Component);

  var _super = _createSuper(MaskedInput);

  function MaskedInput(_props) {
    var _this;

    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11___default()(this, MaskedInput);

    _this = _super.call(this, _props);

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13___default()(_this), "_updatePattern", function (props) {
      _this.mask.setPattern(_util_MaskMapper__WEBPACK_IMPORTED_MODULE_22___default.a.mapMask(props.mask), {
        value: _this.mask.getRawValue(),
        selection: getSelection(_this.input)
      });
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13___default()(_this), "_updateMaskSelection", function () {
      _this.mask.selection = getSelection(_this.input);
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13___default()(_this), "_updateInputSelection", function () {
      setSelection(_this.input, _this.mask.selection);
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13___default()(_this), "_onChange", function (e) {
      var maskValue = _this.mask.getValue();

      if (e.target.value !== maskValue) {
        // Cut or delete operations will have shortened the value
        if (e.target.value.length < maskValue.length) {
          var sizeDiff = maskValue.length - e.target.value.length;

          _this._updateMaskSelection();

          _this.mask.selection.end = _this.mask.selection.start + sizeDiff;

          _this.mask.backspace();
        }

        var value = _this._getDisplayValue();

        e.target.value = value;

        if (value) {
          _this._updateInputSelection();
        }
      }

      if (_this.props.onChange) {
        _this.props.onChange(e);
      }
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13___default()(_this), "_onKeyDown", function (e) {
      if (isUndo(e)) {
        e.preventDefault();

        if (_this.mask.undo()) {
          e.target.value = _this._getDisplayValue();

          _this._updateInputSelection();

          if (_this.props.onChange) {
            _this.props.onChange(e);
          }
        }
      } else if (isRedo(e)) {
        e.preventDefault();

        if (_this.mask.redo()) {
          e.target.value = _this._getDisplayValue();

          _this._updateInputSelection();

          if (_this.props.onChange) {
            _this.props.onChange(e);
          }
        }
      } else if (e.key === 'Backspace') {
        e.preventDefault();

        _this._updateMaskSelection();

        if (_this.mask.backspace()) {
          var value = _this._getDisplayValue();

          e.target.value = value;

          if (value) {
            _this._updateInputSelection();
          }

          if (_this.props.onChange) {
            _this.props.onChange(e);
          }
        }
      }
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13___default()(_this), "_onKeyPress", function (e) {
      // Ignore modified key presses
      // Ignore enter key to allow form submission
      if (e.metaKey || e.altKey || e.ctrlKey || e.key === 'Enter') {
        return;
      }

      e.preventDefault();

      _this._updateMaskSelection();

      if (_this.mask.input(e.key)) {
        e.target.value = _this.mask.getValue();

        _this._updateInputSelection();

        if (_this.props.onChange) {
          _this.props.onChange(e);
        }
      }
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_17___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_13___default()(_this), "_onPaste", function (e) {
      e.preventDefault();

      _this._updateMaskSelection(); // getData value needed for IE also works in FF & Chrome


      if (_this.mask.paste(e.clipboardData.getData('Text'))) {
        e.target.value = _this.mask.getValue(); // Timeout needed for IE

        setTimeout(_this._updateInputSelection, 0);

        if (_this.props.onChange) {
          _this.props.onChange(e);
        }
      }
    });

    _this.mask = new inputmask_core__WEBPACK_IMPORTED_MODULE_21___default.a({
      pattern: _util_MaskMapper__WEBPACK_IMPORTED_MODULE_22___default.a.mapMask(_props.mask),
      value: _props.value,
      formatCharacters: _props.formatCharacters,
      placeholderChar: _props.placeholderChar || '_'
    });
    return _this;
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12___default()(MaskedInput, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.mask !== this.props.mask) {
        this._updatePattern(this.props);
      }

      if (prevProps.mask !== this.props.mask && prevProps.value !== this.props.mask) {
        // if we get a new value and a new mask at the same time
        // check if the mask.value is still the initial value
        // - if so use the nextProps value
        // - otherwise the `this.mask` has a value for us (most likely from paste action)
        if (this.mask.getValue() === this.mask.emptyValue) {
          this.mask.setPattern(_util_MaskMapper__WEBPACK_IMPORTED_MODULE_22___default.a.mapMask(this.props.mask), {
            value: this.props.value
          });
        } else {
          this.mask.setPattern(_util_MaskMapper__WEBPACK_IMPORTED_MODULE_22___default.a.mapMask(this.props.mask), {
            value: this.mask.getRawValue()
          });
        }
      } else if (prevProps.mask !== this.props.mask) {
        this.mask.setPattern(_util_MaskMapper__WEBPACK_IMPORTED_MODULE_22___default.a.mapMask(this.props.mask), {
          value: this.mask.getRawValue()
        });
      } else if (prevProps.value !== this.props.value) {
        this.mask.setValue(this.props.value);
      }

      if (prevProps.mask !== this.props.mask && this.mask.selection.start) {
        this._updateInputSelection();
      }
    }
  }, {
    key: "_getDisplayValue",
    value: function _getDisplayValue() {
      var value = this.mask.getValue();
      return value === this.mask.emptyValue ? '' : value;
    }
  }, {
    key: "focus",
    value: function focus() {
      this.input.focus();
    }
  }, {
    key: "blur",
    value: function blur() {
      this.input.blur();
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          size = _this$props.size,
          placeholder = _this$props.placeholder,
          props = _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_10___default()(_this$props, ["size", "placeholder"]),
          patternLength = this.mask.pattern.length;

      return react__WEBPACK_IMPORTED_MODULE_18___default.a.createElement(this.context.inputComponent, _objectSpread(_objectSpread({}, props), {}, {
        ref: function ref(r) {
          if (r) {
            _this2.input = r.input ? react_dom__WEBPACK_IMPORTED_MODULE_20___default.a.findDOMNode(r.input) : r;
          }
        },
        maxLength: patternLength,
        onChange: this._onChange,
        onKeyDown: this._onKeyDown,
        onKeyPress: this._onKeyPress,
        onPaste: this._onPaste,
        placeholder: placeholder || this.mask.emptyValue,
        size: size || patternLength,
        value: this._getDisplayValue(),
        type: 'text'
      }));
    }
  }]);

  return MaskedInput;
}(react__WEBPACK_IMPORTED_MODULE_18___default.a.Component);


MaskedInput.contextType = _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_23__["ConfigurationContext"];
MaskedInput.propTypes = {
  mask: prop_types__WEBPACK_IMPORTED_MODULE_19___default.a.string.isRequired
};
MaskedInput.defaultProps = {
  value: ''
};

/***/ }),

/***/ "./components/MediaContent.jsx":
/*!*************************************!*\
  !*** ./components/MediaContent.jsx ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return MediaContent; });
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");










function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var MediaContent = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6___default()(MediaContent, _React$Component);

  var _super = _createSuper(MediaContent);

  function MediaContent() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4___default()(this, MediaContent);

    return _super.apply(this, arguments);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5___default()(MediaContent, [{
    key: "render",
    value: function render() {
      var mediaContent = jsonld_utils__WEBPACK_IMPORTED_MODULE_11___default.a.getJsonAttValue(this.props.question, _constants_Constants__WEBPACK_IMPORTED_MODULE_12__["HAS_MEDIA_CONTENT"]);

      if (!mediaContent) {
        return null;
      }

      return this._renderDangerously(mediaContent);
    }
  }, {
    key: "_renderDangerously",
    value: function _renderDangerously(mediaContent) {
      if (Array.isArray(mediaContent)) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement("div", {
          className: "col-6"
        }, mediaContent.map(function (src) {
          return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement("div", {
            key: 'media-' + src,
            className: "row embed-responsive-21by9 media-content-video-container mb-3"
          }, MediaContent.iframe(src));
        }));
      } else {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement("div", {
          className: "row"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement("div", {
          className: "col-6 embed-responsive-21by9 media-content-video-container mb-3"
        }, MediaContent.iframe(mediaContent)));
      }
    }
  }], [{
    key: "iframe",
    value: function iframe(src) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement("iframe", {
        src: src,
        className: "embed-responsive-item",
        allowFullScreen: true
      });
    }
  }]);

  return MediaContent;
}(react__WEBPACK_IMPORTED_MODULE_9___default.a.Component);


MediaContent.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_10___default.a.object.isRequired
};

/***/ }),

/***/ "./components/PrefixIcon.jsx":
/*!***********************************!*\
  !*** ./components/PrefixIcon.jsx ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.sort */ "core-js/modules/es.array.sort");
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");











function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_9___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_8___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }






var PrefixIcon = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_7___default()(PrefixIcon, _React$Component);

  var _super = _createSuper(PrefixIcon);

  function PrefixIcon(props) {
    var _this;

    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5___default()(this, PrefixIcon);

    _this = _super.call(this, props);
    _this.state = {
      show: props.show,
      prefixes: props.prefixes
    };
    return _this;
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6___default()(PrefixIcon, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var p = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_12__["Popover"], {
        id: "prefixes",
        title: "Prefixes"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_12__["ListGroup"], null, this.state.prefixes.sort(function (l, r) {
        var res = l[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["PREFIX"]] < r[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["PREFIX"]];
        if (res) return -1;
        return 1;
      }).map(function (p) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_12__["ListGroupItem"], {
          key: p[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["PREFIX"]]
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement("strong", null, p[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["PREFIX"]]), ": ", p[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["NAMESPACE"]]);
      })));
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_12__["OverlayTrigger"], {
        trigger: "click",
        placement: "right",
        overlay: p
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement("span", {
        className: this.props.iconClass,
        onClick: function onClick() {
          return _this2.setState({
            show: !_this2.state.show
          });
        }
      }, this.props.children));
    }
  }]);

  return PrefixIcon;
}(react__WEBPACK_IMPORTED_MODULE_10___default.a.Component);

PrefixIcon.propTypes = {
  prefixes: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.array.isRequired,
  children: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.element.isRequired,
  iconClass: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.string,
  show: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.bool
};
PrefixIcon.defaultProps = {
  iconClass: '',
  show: false
};
/* harmony default export */ __webpack_exports__["default"] = (PrefixIcon);

/***/ }),

/***/ "./components/Question.jsx":
/*!*********************************!*\
  !*** ./components/Question.jsx ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Question; });
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor */ "core-js/modules/es.object.get-own-property-descriptor");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.keys */ "core-js/modules/es.object.keys");
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "@babel/runtime/helpers/assertThisInitialized");
/* harmony import */ var _babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var _Answer__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./Answer */ "./components/Answer.jsx");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _HelpIcon__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./HelpIcon */ "./components/HelpIcon.jsx");
/* harmony import */ var _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../util/JsonLdObjectMap */ "./util/JsonLdObjectMap.js");
/* harmony import */ var _model_QuestionAnswerProcessor__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../model/QuestionAnswerProcessor */ "./model/QuestionAnswerProcessor.js");
/* harmony import */ var _model_ValidatorFactory__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../model/ValidatorFactory */ "./model/ValidatorFactory.js");
/* harmony import */ var _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../util/JsonLdObjectUtils */ "./util/JsonLdObjectUtils.js");
/* harmony import */ var _PrefixIcon__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./PrefixIcon */ "./components/PrefixIcon.jsx");
/* harmony import */ var _MediaContent__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./MediaContent */ "./components/MediaContent.jsx");
/* harmony import */ var _styles_icons__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../styles/icons */ "./styles/icons/index.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! classnames */ "classnames");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_33___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_33__);


















function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_15___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_15___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_14___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

















 // TODO Remove once the pretty layout is tested

var PRETTY_ANSWERABLE_LAYOUT = false;

var Question = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_13___default()(Question, _React$Component);

  var _super = _createSuper(Question);

  function Question(props) {
    var _this;

    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_10___default()(this, Question);

    _this = _super.call(this, props);

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12___default()(_this), "onAnswerChange", function (answerIndex, change) {
      _this._onChange(_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_ANSWER"], answerIndex, change);
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12___default()(_this), "onSubQuestionChange", function (subQuestionIndex, change) {
      _this._onChange(_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_SUBQUESTION"], subQuestionIndex, change);
    });

    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_16___default()(_babel_runtime_helpers_assertThisInitialized__WEBPACK_IMPORTED_MODULE_12___default()(_this), "_toggleCollapse", function () {
      if (_this.props.collapsible) {
        _this.setState({
          expanded: !_this.state.expanded
        });
      }
    });

    _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_25__["default"].putObject(props.question['@id'], props.question);
    _this.state = {
      validator: null,
      expanded: !_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isCollapsed(props.question)
    };
    return _this;
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_11___default()(Question, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setState({
        validator: _model_ValidatorFactory__WEBPACK_IMPORTED_MODULE_27__["default"].createValidator(this.props.question, this.context.options.intl)
      });
    }
  }, {
    key: "_onChange",
    value: function _onChange(att, valueIndex, newValue) {
      var newState = _objectSpread({}, this.props.question);

      newState[att][valueIndex] = newValue;

      if (att === _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_ANSWER"]) {
        var result = this.state.validator(newValue);
        newState = _objectSpread(_objectSpread({}, newState), result);
      }

      _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_25__["default"].putObject(newState['@id'], newState);
      this.props.onChange(this.props.index, newState);
    }
  }, {
    key: "render",
    value: function render() {
      var question = this.props.question;

      if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isHidden(question)) {
        return null;
      }

      if (!_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isRelevant(question)) {
        return null;
      }

      if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isAnswerable(question)) {
        if (PRETTY_ANSWERABLE_LAYOUT) {
          return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
            id: question['@id']
          }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
            className: "panel-title answerable-question"
          }, this.renderAnswers()), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
            className: "answerable-subquestions"
          }, this.renderSubQuestions()));
        } else {
          return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
            id: question['@id']
          }, this.renderAnswers(), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
            className: "ml-4 mt-n2"
          }, this.renderSubQuestions()));
        }
      }

      if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isSection(question)) {
        var _this$props = this.props,
            collapsible = _this$props.collapsible,
            withoutCard = _this$props.withoutCard;

        if (withoutCard) {
          return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", null, this._renderQuestionContent());
        }

        var label = jsonld_utils__WEBPACK_IMPORTED_MODULE_19___default.a.getLocalized(question[jsonld_utils__WEBPACK_IMPORTED_MODULE_19___default.a.RDFS_LABEL], this.context.options.intl);
        var cardBody = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Card"].Body, {
          className: "p-3"
        }, this._renderQuestionContent());
        var headerClassName = classnames__WEBPACK_IMPORTED_MODULE_33___default()(_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isEmphasised(question) ? Question.getEmphasizedClass(question) : 'bg-info', collapsible ? 'cursor-pointer' : ''); // TODO change defaultActiveKey to label when expanded + add eventKey to Accordion.Collapse

        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Accordion"], {
          defaultActiveKey: !this.state.expanded ? label : undefined
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Card"], {
          className: "mb-3"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Accordion"].Toggle, {
          as: react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Card"].Header,
          onClick: this._toggleCollapse,
          className: headerClassName
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("h6", {
          className: "d-inline",
          id: question['@id']
        }, collapsible && this._renderCollapseToggle(), label), this._renderQuestionHelp()), collapsible ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_18__["Accordion"].Collapse, null, cardBody) : {
          cardBody: cardBody
        }));
      } else {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", null, this._renderQuestionContent());
      }
    }
  }, {
    key: "_renderQuestionContent",
    value: function _renderQuestionContent() {
      var content = [];

      if (this.state.expanded) {
        content.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_MediaContent__WEBPACK_IMPORTED_MODULE_30__["default"], {
          key: this.props.question['@id'] + '-media',
          question: this.props.question
        }));
      }

      content.push(this.renderAnswers());
      content.push(this.renderSubQuestions());
      return content;
    }
  }, {
    key: "renderAnswers",
    value: function renderAnswers() {
      var question = this.props.question,
          children = [],
          answers = this._getAnswers();

      var row = [],
          cls,
          isTextarea;

      for (var _i = 0, len = answers.length; _i < len; _i++) {
        isTextarea = _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isTextarea(question, _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].resolveValue(answers[_i])) || _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isSparqlInput(question) || _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isTurtleInput(question);
        cls = Question._getAnswerClass(isTextarea);
        row.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
          key: 'row-item-' + _i,
          className: cls,
          id: question['@id']
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
          className: "row"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
          className: "col-10"
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_Answer__WEBPACK_IMPORTED_MODULE_21__["default"], {
          index: _i,
          answer: answers[_i],
          question: question,
          onChange: this.onAnswerChange
        })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", null, this._renderUnits(), this._renderQuestionHelp(), this._renderPrefixes()))));

        if (row.length === _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["GENERATED_ROW_SIZE"] || isTextarea) {
          children.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
            className: "row",
            key: 'question-row-' + _i
          }, row));
          row = [];
        }
      }

      if (row.length > 0) {
        children.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
          className: "row",
          key: 'question-row-' + i
        }, row));
      }

      return children;
    }
  }, {
    key: "_getAnswers",
    value: function _getAnswers() {
      var question = this.props.question;

      if (!question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_ANSWER"]]) {
        question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_ANSWER"]] = [];
      }

      if (!Array.isArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_ANSWER"]])) {
        question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_ANSWER"]] = [question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_ANSWER"]]];
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_ANSWER"]].length === 0) {
        if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isSection(question) && !_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isAnswerable(question) || _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isWizardStep(question)) {
          question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_ANSWER"]] = [];
        } else {
          question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_ANSWER"]] = [_model_QuestionAnswerProcessor__WEBPACK_IMPORTED_MODULE_26__["default"].generateAnswer(question)];
        }
      }

      return question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_ANSWER"]];
    }
  }, {
    key: "_renderCollapseToggle",
    value: function _renderCollapseToggle() {
      var options = this.context.options;
      var title = this.state.expanded ? options.i18n['section.collapse'] : options.i18n['section.expand'];
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("span", {
        onClick: this._toggleCollapse,
        title: title
      }, this.state.expanded ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_styles_icons__WEBPACK_IMPORTED_MODULE_31__["CaretSquareUp"], {
        title: title
      }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_styles_icons__WEBPACK_IMPORTED_MODULE_31__["CaretSquareDown"], {
        title: title
      }));
    }
  }, {
    key: "_renderQuestionHelp",
    value: function _renderQuestionHelp() {
      var question = this.props.question;
      var helpClass = _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isCheckbox(question) ? 'help-icon-checkbox' : 'help-icon-text-input';

      if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isSection(question)) {
        helpClass = 'help-icon-section';
      }

      return question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HELP_DESCRIPTION"]] ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_HelpIcon__WEBPACK_IMPORTED_MODULE_24__["default"], {
        text: jsonld_utils__WEBPACK_IMPORTED_MODULE_19___default.a.getLocalized(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HELP_DESCRIPTION"]], this.context.options.intl),
        iconClassContainer: helpClass
      }) : null;
    }
  }, {
    key: "_renderPrefixes",
    value: function _renderPrefixes() {
      var question = this.props.question;
      return question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_DECLARED_PREFIX"]] && question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_DECLARED_PREFIX"]].length ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_PrefixIcon__WEBPACK_IMPORTED_MODULE_29__["default"], {
        prefixes: question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_DECLARED_PREFIX"]],
        iconClass: 'help-icon-checkbox'
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(_styles_icons__WEBPACK_IMPORTED_MODULE_31__["InfoCircle"], null)) : null;
    }
  }, {
    key: "_renderUnits",
    value: function _renderUnits() {
      var question = this.props.question;
      return question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_UNIT"]] ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement("div", {
        className: "has-unit-label"
      }, question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_UNIT"]]) : null;
    }
  }, {
    key: "renderSubQuestions",
    value: function renderSubQuestions() {
      var children = [];

      var subQuestions = this._getSubQuestions();

      for (var _i2 = 0; _i2 < subQuestions.length; _i2++) {
        children.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_17___default.a.createElement(Question, {
          key: 'sub-question-' + _i2,
          index: _i2,
          question: subQuestions[_i2],
          onChange: this.onSubQuestionChange
        }));
      }

      return children;
    }
  }, {
    key: "_getSubQuestions",
    value: function _getSubQuestions() {
      var question = this.props.question;

      if (!question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_SUBQUESTION"]]) {
        question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_SUBQUESTION"]] = [];
      }

      if (!Array.isArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_SUBQUESTION"]])) {
        question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_SUBQUESTION"]] = [question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_SUBQUESTION"]]];
      } // sort by label


      _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_28__["default"].orderByLocalizedLabels(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_SUBQUESTION"]], this.context.options.intl); // sort by property

      _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_28__["default"].orderPreservingToplogicalSort(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_SUBQUESTION"]], _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_PRECEDING_QUESTION"]);
      return question[_constants_Constants__WEBPACK_IMPORTED_MODULE_22__["HAS_SUBQUESTION"]];
    }
  }], [{
    key: "_getAnswerClass",
    value: function _getAnswerClass(isTextarea) {
      return isTextarea ? 'col-12' : _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["GENERATED_ROW_SIZE"] === 1 ? 'col-6' : 'col-' + _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["COLUMN_COUNT"] / _constants_Constants__WEBPACK_IMPORTED_MODULE_22__["GENERATED_ROW_SIZE"];
    }
  }, {
    key: "getEmphasizedClass",
    value: function getEmphasizedClass(question) {
      return _util_FormUtils__WEBPACK_IMPORTED_MODULE_23__["default"].isEmphasised(question) ? 'bg-warning' : "";
    }
  }]);

  return Question;
}(react__WEBPACK_IMPORTED_MODULE_17___default.a.Component);


Question.contextType = _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_32__["ConfigurationContext"];
Question.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_20___default.a.object.isRequired,
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_20___default.a.func.isRequired,
  index: prop_types__WEBPACK_IMPORTED_MODULE_20___default.a.number,
  withoutCard: prop_types__WEBPACK_IMPORTED_MODULE_20___default.a.bool,
  collapsible: prop_types__WEBPACK_IMPORTED_MODULE_20___default.a.bool // Whether the section is collapsible (if the question is a section)

};
Question.defaultProps = {
  withoutCard: false,
  collapsible: true
};

/***/ }),

/***/ "./components/SForms.jsx":
/*!*******************************!*\
  !*** ./components/SForms.jsx ***!
  \*******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_some__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.some */ "core-js/modules/es.array.some");
/* harmony import */ var core_js_modules_es_array_some__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_some__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/regenerator */ "@babel/runtime/regenerator");
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! regenerator-runtime/runtime */ "regenerator-runtime/runtime");
/* harmony import */ var regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "@babel/runtime/helpers/asyncToGenerator");
/* harmony import */ var _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _contexts_FormGenContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../contexts/FormGenContext */ "./contexts/FormGenContext.js");
/* harmony import */ var _contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../contexts/FormQuestionsContext */ "./contexts/FormQuestionsContext.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _model_FormGenerator__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../model/FormGenerator */ "./model/FormGenerator.js");
/* harmony import */ var _FormManager__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./FormManager */ "./components/FormManager.jsx");
/* harmony import */ var _s_forms__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../s-forms */ "./s-forms.js");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__);














var SForms = Object(react__WEBPACK_IMPORTED_MODULE_5__["forwardRef"])(function (props, ref) {
  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_5__["useState"])(true),
      _useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_4___default()(_useState, 2),
      loading = _useState2[0],
      setLoading = _useState2[1];

  var _useState3 = Object(react__WEBPACK_IMPORTED_MODULE_5__["useState"])(null),
      _useState4 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_4___default()(_useState3, 2),
      formProperties = _useState4[0],
      setFormProperties = _useState4[1];

  var _useState5 = Object(react__WEBPACK_IMPORTED_MODULE_5__["useState"])(null),
      _useState6 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_4___default()(_useState5, 2),
      form = _useState6[0],
      setForm = _useState6[1];

  Object(react__WEBPACK_IMPORTED_MODULE_5__["useEffect"])(function () {
    var initialiseSForms = /*#__PURE__*/function () {
      var _ref = _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_3___default()( /*#__PURE__*/_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_1___default.a.mark(function _callee() {
        var intl, _yield$FormGenerator$, _yield$FormGenerator$2, formProperties, structure;

        return _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_1___default.a.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                intl = props.options.intl;
                _context.next = 3;
                return _model_FormGenerator__WEBPACK_IMPORTED_MODULE_10__["default"].constructForm(props.form, intl);

              case 3:
                _yield$FormGenerator$ = _context.sent;
                _yield$FormGenerator$2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_4___default()(_yield$FormGenerator$, 2);
                formProperties = _yield$FormGenerator$2[0];
                structure = _yield$FormGenerator$2[1];

                if (formProperties.formQuestions.some(function (step) {
                  return _s_forms__WEBPACK_IMPORTED_MODULE_12__["FormUtils"].isWizardStep(step);
                })) {
                  formProperties.formQuestions[0].visited = true;
                }

                setFormProperties(formProperties);
                setForm(structure);
                setLoading(false);

              case 11:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function initialiseSForms() {
        return _ref.apply(this, arguments);
      };
    }();

    initialiseSForms();
  }, []);

  if (loading) {
    return props.loader || /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_13__["Card"], {
      className: "p-3 font-italic"
    }, "Loading SForms...");
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default.a.createElement(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_9__["ConfigurationContextProvider"], {
    components: props.components,
    componentsOptions: props.componentsOptions,
    options: props.options
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default.a.createElement(_contexts_FormGenContext__WEBPACK_IMPORTED_MODULE_7__["FormGenContextProvider"], {
    fetchTypeAheadValues: props.fetchTypeAheadValues
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default.a.createElement(_contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_8__["FormQuestionsProvider"], {
    data: form,
    formQuestions: formProperties.formQuestions,
    isFormValid: props.isFormValid
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default.a.createElement(_FormManager__WEBPACK_IMPORTED_MODULE_11__["default"], {
    ref: ref,
    modalView: props.options && props.options.modalView
  }))));
});
SForms.propTypes = {
  form: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.object.isRequired,
  options: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.object.isRequired,
  components: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.object,
  componentsOptions: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.object,
  fetchTypeAheadValues: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.func,
  isFormValid: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.func,
  loader: prop_types__WEBPACK_IMPORTED_MODULE_6___default.a.element
};
/* harmony default export */ __webpack_exports__["default"] = (SForms);

/***/ }),

/***/ "./components/answer/CheckboxAnswer.jsx":
/*!**********************************************!*\
  !*** ./components/answer/CheckboxAnswer.jsx ***!
  \**********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor */ "core-js/modules/es.object.get-own-property-descriptor");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.keys */ "core-js/modules/es.object.keys");
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");











function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }







var InputPropertiesResolver = /*#__PURE__*/function () {
  function InputPropertiesResolver() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_8___default()(this, InputPropertiesResolver);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_9___default()(InputPropertiesResolver, null, [{
    key: "resolveValidationProperties",
    value: function resolveValidationProperties(question) {
      var props = {};

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["HAS_VALID_ANSWER"]] === false) {
        props['validation'] = 'error';
        props['help'] = question[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["HAS_VALIDATION_MESSAGE"]];
      }

      return props;
    }
  }]);

  return InputPropertiesResolver;
}();

var CheckboxAnswer = function CheckboxAnswer(props) {
  var _useContext = Object(react__WEBPACK_IMPORTED_MODULE_10__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_14__["ConfigurationContext"]),
      inputComponent = _useContext.inputComponent,
      componentsOptions = _useContext.componentsOptions;

  var question = props.question;
  return react__WEBPACK_IMPORTED_MODULE_10___default.a.createElement(inputComponent, _objectSpread(_objectSpread({}, InputPropertiesResolver.resolveValidationProperties(question)), {}, {
    type: 'checkbox',
    label: props.label,
    title: props.title,
    checked: props.value === true || props.value === 'true',
    onChange: function onChange(e) {
      props.onChange(e.target.checked);
    },
    disabled: componentsOptions.readOnly || _util_FormUtils__WEBPACK_IMPORTED_MODULE_12__["default"].isDisabled(question)
  }));
};

CheckboxAnswer.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.object.isRequired,
  label: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.string.isRequired,
  title: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.string,
  value: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.string, prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.bool]),
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (CheckboxAnswer);

/***/ }),

/***/ "./components/answer/DateTimeAnswer.jsx":
/*!**********************************************!*\
  !*** ./components/answer/DateTimeAnswer.jsx ***!
  \**********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.number.constructor */ "core-js/modules/es.number.constructor");
/* harmony import */ var core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_constructor__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_datepicker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-datepicker */ "react-datepicker");
/* harmony import */ var react_datepicker__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_datepicker__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! date-fns */ "date-fns");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(date_fns__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _util_Utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/Utils */ "./util/Utils.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");











var DateTimeAnswer = function DateTimeAnswer(props) {
  var _useContext = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_9__["ConfigurationContext"]),
      componentsOptions = _useContext.componentsOptions;

  var dateFormat = _util_Utils__WEBPACK_IMPORTED_MODULE_6__["default"].resolveDateTimeFormat(props.question, props.value, componentsOptions.dateTimeAnswer);
  var isDate = _util_FormUtils__WEBPACK_IMPORTED_MODULE_7__["default"].isDate(props.question);
  var isTime = _util_FormUtils__WEBPACK_IMPORTED_MODULE_7__["default"].isTime(props.question); // workaround because it is not possible to construct Date only with time

  var value;

  if (isTime && props.value) {
    value = new Date("0 ".concat(props.value));
  } else {
    value = props.value ? new Date(props.value) : null;
  } // DatePicker does not know dateFormat "x", translate to datetime


  var datePickerFormat = dateFormat === 'x' ? componentsOptions.dateTimeAnswer.dateTimeFormat : dateFormat;

  var onChange = function onChange(date) {
    if (dateFormat === _constants_Constants__WEBPACK_IMPORTED_MODULE_8__["DATETIME_NUMBER_FORMAT"]) {
      props.onChange(Number(date));
    } else {
      props.onChange(Object(date_fns__WEBPACK_IMPORTED_MODULE_5__["format"])(date, dateFormat));
    }
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["FormGroup"], {
    size: "small"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Form"].Label, {
    className: 'w-100'
  }, props.label), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_datepicker__WEBPACK_IMPORTED_MODULE_2___default.a, {
    selected: value,
    placeholderText: datePickerFormat.toUpperCase(),
    onChange: onChange,
    showTimeSelect: !isDate,
    showTimeSelectOnly: isTime,
    timeFormat: "HH:mm",
    timeIntervals: 1,
    timeCaption: "Time",
    dateFormat: datePickerFormat,
    className: "form-control",
    disabled: componentsOptions.readOnly || _util_FormUtils__WEBPACK_IMPORTED_MODULE_7__["default"].isDisabled(props.question)
  }));
};

DateTimeAnswer.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.object.isRequired,
  label: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.string.isRequired,
  title: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.string,
  value: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.string, prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.number]),
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_4___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (DateTimeAnswer);

/***/ }),

/***/ "./components/answer/InputAnswer.jsx":
/*!*******************************************!*\
  !*** ./components/answer/InputAnswer.jsx ***!
  \*******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_index_of__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.index-of */ "core-js/modules/es.array.index-of");
/* harmony import */ var core_js_modules_es_array_index_of__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_index_of__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.slice */ "core-js/modules/es.array.slice");
/* harmony import */ var core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor */ "core-js/modules/es.object.get-own-property-descriptor");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_object_get_own_property_names__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-names */ "core-js/modules/es.object.get-own-property-names");
/* harmony import */ var core_js_modules_es_object_get_own_property_names__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_names__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.keys */ "core-js/modules/es.object.keys");
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var yasgui_yasqe__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! yasgui-yasqe */ "yasgui-yasqe");
/* harmony import */ var yasgui_yasqe__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(yasgui_yasqe__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");














var _this = undefined;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_10___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }








var NUMERIC_DATATYPES = [_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].INT, _constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].INTEGER, _constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].NON_NEGATIVE_INTEGER, _constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].NON_POSITIVE_INTEGER, _constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].NEGATIVE_INTEGER, _constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].POSITIVE_INTEGER];
var DECLARED_PREFIXES = 'http://onto.fel.cvut.cz/ontologies/form-spin/has-declared-prefix';
var NUMBER_RULES = {};
NUMBER_RULES[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].NON_NEGATIVE_INTEGER] = {
  min: 0
};
NUMBER_RULES[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].NON_POSITIVE_INTEGER] = {
  max: 0
};
NUMBER_RULES[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].NEGATIVE_INTEGER] = {
  max: -1
};
NUMBER_RULES[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].POSITIVE_INTEGER] = {
  min: 1
};
var tokenTypes = {
  'string-2': 'prefixed',
  atom: 'var'
};

var InputPropertiesResolver = /*#__PURE__*/function () {
  function InputPropertiesResolver() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11___default()(this, InputPropertiesResolver);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12___default()(InputPropertiesResolver, null, [{
    key: "_resolveInputType",
    value: function _resolveInputType(question, value) {
      if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_17__["default"].isSparqlInput(question) || _util_FormUtils__WEBPACK_IMPORTED_MODULE_17__["default"].isTurtleInput(question) || _util_FormUtils__WEBPACK_IMPORTED_MODULE_17__["default"].isTextarea(question, value)) {
        return 'textarea';
      } else if (InputPropertiesResolver._isNumeric(question)) {
        return 'number';
      }

      return 'text';
    }
  }, {
    key: "_isNumeric",
    value: function _isNumeric(question) {
      for (var i = 0, len = NUMERIC_DATATYPES.length; i < len; i++) {
        if (jsonld_utils__WEBPACK_IMPORTED_MODULE_14___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_16__["HAS_DATATYPE"], NUMERIC_DATATYPES[i])) {
          return true;
        }
      }

      return false;
    }
  }, {
    key: "resolveInputProperties",
    value: function resolveInputProperties(question, value, componentsOptions) {
      var props = {};
      props.type = InputPropertiesResolver._resolveInputType(question, value);

      switch (props['type']) {
        case 'textarea':
          props.rows = 5;
          break;

        case 'number':
          props = _objectSpread(_objectSpread({}, props), InputPropertiesResolver._resolveNumberRestrictions(question));
          break;

        default:
          break;
      }

      props.disabled = componentsOptions.readOnly || _util_FormUtils__WEBPACK_IMPORTED_MODULE_17__["default"].isDisabled(question);

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["HAS_VALID_ANSWER"]] === false) {
        props.validation = 'error';
        props.help = question[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["HAS_VALIDATION_MESSAGE"]];
      }

      return props;
    }
  }, {
    key: "_resolveNumberRestrictions",
    value: function _resolveNumberRestrictions(question) {
      var restriction = {};
      Object.getOwnPropertyNames(NUMBER_RULES).forEach(function (key) {
        if (jsonld_utils__WEBPACK_IMPORTED_MODULE_14___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_16__["HAS_DATATYPE"], key)) {
          restriction = _objectSpread(_objectSpread({}, restriction), NUMBER_RULES[key]);
        }
      });

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].MIN_INCLUSIVE] !== undefined) {
        restriction['min'] = question[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].MIN_INCLUSIVE];
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].MIN_EXCLUSIVE] !== undefined) {
        restriction['min'] = question[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].MIN_EXCLUSIVE] + 1;
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].MAX_EXCLUSIVE] !== undefined) {
        restriction['max'] = question[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].MAX_EXCLUSIVE] - 1;
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].MAX_INCLUSIVE] !== undefined) {
        restriction['max'] = question[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["XSD"].MAX_INCLUSIVE];
      }

      return restriction;
    }
  }]);

  return InputPropertiesResolver;
}();

var InputAnswer = function InputAnswer(props) {
  var _useContext = Object(react__WEBPACK_IMPORTED_MODULE_13__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_19__["ConfigurationContext"]),
      inputComponent = _useContext.inputComponent,
      componentsOptions = _useContext.componentsOptions;

  var question = props.question;
  var answer = props.answer;
  var value = props.value; // When the value is an object_value, but the layout does not specify neither typeahead nor select,
  // show at least the value's label

  if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["HAS_OBJECT_VALUE"]] && answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["HAS_OBJECT_VALUE"]][jsonld_utils__WEBPACK_IMPORTED_MODULE_14___default.a.RDFS_LABEL]) {
    value = jsonld_utils__WEBPACK_IMPORTED_MODULE_14___default.a.getJsonAttValue(answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["HAS_OBJECT_VALUE"]], jsonld_utils__WEBPACK_IMPORTED_MODULE_14___default.a.RDFS_LABEL);
  }

  return react__WEBPACK_IMPORTED_MODULE_13___default.a.createElement(inputComponent, _objectSpread(_objectSpread({}, InputPropertiesResolver.resolveInputProperties(question, value, componentsOptions)), {}, {
    label: props.label,
    title: props.title,
    value: value == null ? '' : value,
    onChange: function onChange(e) {
      props.onChange(e.target.value);
      if (props.sparql || props.turtle) _this.hide();
    },
    onFocus: function onFocus(e) {
      if (props.sparql) {
        var yasqe = yasgui_yasqe__WEBPACK_IMPORTED_MODULE_18___default.a.fromTextArea(e.target);
        yasqe.setValue(value);
        yasqe.on('change', function () {
          props.onChange(yasqe.getValue());
        });

        yasgui_yasqe__WEBPACK_IMPORTED_MODULE_18___default.a.Autocompleters.prefixes.appendPrefixIfNeeded = function (yasqe, completerName) {
          if (!yasqe.autocompleters.getTrie(completerName)) return; // no prefixed defined. just stop

          if (!yasqe.options.autocompleters || yasqe.options.autocompleters.indexOf(completerName) === -1) return; //this autocompleter is disabled

          var cur = yasqe.getCursor();
          var token = yasqe.getTokenAt(cur);

          if (tokenTypes[token.type] === 'prefixed') {
            var colonIndex = token.string.indexOf(':');

            if (colonIndex !== -1) {
              // check previous token isnt PREFIX, or a '<'(which would mean we are in a uri)
              //			const firstTokenString = yasqe.getNextNonWsToken(cur.line).string.toUpperCase();
              var lastNonWsTokenString = yasqe.getPreviousNonWsToken(cur.line, token).string.toUpperCase();
              var previousToken = yasqe.getTokenAt({
                line: cur.line,
                ch: token.start
              }); // needs to be null (beginning of line), or whitespace

              if (lastNonWsTokenString !== 'PREFIX' && (previousToken.type === 'ws' || previousToken.type == null)) {
                // check whether it isnt defined already (saves us from looping
                // through the array)
                var currentPrefix = token.string.substring(0, colonIndex + 1);
                var queryPrefixes = yasqe.getPrefixesFromQuery();

                if (queryPrefixes[currentPrefix.slice(0, -1)] == null) {
                  // ok, so it isnt added yet!
                  if (props.question[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["HAS_DECLARED_PREFIX"]] && props.question[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["HAS_DECLARED_PREFIX"]].filter(function (p) {
                    return p[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["PREFIX"]] === currentPrefix.slice(0, -1);
                  }).length) {
                    var prefix = props.question[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["HAS_DECLARED_PREFIX"]].filter(function (p) {
                      return p[_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["PREFIX"]] === currentPrefix.slice(0, -1);
                    });
                    var px = {};
                    px[prefix[0][_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["PREFIX"]]] = prefix[0][_constants_Constants__WEBPACK_IMPORTED_MODULE_16__["NAMESPACE"]];
                    yasqe.addPrefixes(px);
                  } else {
                    var completions = yasqe.autocompleters.getTrie(completerName).autoComplete(currentPrefix);

                    if (completions.length > 0) {
                      yasqe.addPrefixes(completions[0]);
                    }
                  }
                }
              }
            }
          }
        };
      } else if (props.turtle) {
        console.log('TTL');
        var yate = YATE.fromTextArea(e.target);
        yate.setValue(value);
        yate.on('change', function () {
          props.onChange(yate.getValue());
        });
      }
    }
  }));
};

InputAnswer.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_15___default.a.object.isRequired,
  answer: prop_types__WEBPACK_IMPORTED_MODULE_15___default.a.object.isRequired,
  label: prop_types__WEBPACK_IMPORTED_MODULE_15___default.a.string.isRequired,
  title: prop_types__WEBPACK_IMPORTED_MODULE_15___default.a.string,
  value: prop_types__WEBPACK_IMPORTED_MODULE_15___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_15___default.a.string, prop_types__WEBPACK_IMPORTED_MODULE_15___default.a.number]),
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_15___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (InputAnswer);

/***/ }),

/***/ "./components/answer/MaskedInputAnswer.jsx":
/*!*************************************************!*\
  !*** ./components/answer/MaskedInputAnswer.jsx ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _InputAnswer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./InputAnswer */ "./components/answer/InputAnswer.jsx");
/* harmony import */ var _util_Logger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/Logger */ "./util/Logger.js");
/* harmony import */ var _MaskedInput__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../MaskedInput */ "./components/MaskedInput.jsx");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");










var MaskedInputAnswer = function MaskedInputAnswer(props) {
  var _useContext = Object(react__WEBPACK_IMPORTED_MODULE_0__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_8__["ConfigurationContext"]),
      componentsOptions = _useContext.componentsOptions;

  var question = props.question;
  var value = props.value;
  var mask = jsonld_utils__WEBPACK_IMPORTED_MODULE_1___default.a.getJsonAttValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["INPUT_MASK"]);

  if (!mask) {
    _util_Logger__WEBPACK_IMPORTED_MODULE_6__["default"].warn('Input mask not provided. Falling back to regular input.');
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_InputAnswer__WEBPACK_IMPORTED_MODULE_5__["default"], props);
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_MaskedInput__WEBPACK_IMPORTED_MODULE_7__["default"], {
    mask: mask,
    value: value,
    label: props.label,
    title: props.title,
    placeholder: mask,
    onChange: function onChange(e) {
      return props.onChange(e.target.value);
    },
    disabled: componentsOptions.readOnly || _util_FormUtils__WEBPACK_IMPORTED_MODULE_4__["default"].isDisabled(question)
  });
};

MaskedInputAnswer.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.object.isRequired,
  answer: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.object.isRequired,
  label: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.string.isRequired,
  title: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.string,
  value: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.string, prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.number]),
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (MaskedInputAnswer);

/***/ }),

/***/ "./components/answer/OptimizedMenuList.jsx":
/*!*************************************************!*\
  !*** ./components/answer/OptimizedMenuList.jsx ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_index_of__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.index-of */ "core-js/modules/es.array.index-of");
/* harmony import */ var core_js_modules_es_array_index_of__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_index_of__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_window__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-window */ "react-window");
/* harmony import */ var react_window__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_window__WEBPACK_IMPORTED_MODULE_2__);



var HEIGHT = 40;
/**
 * Uses react-window to optimize menu list in react-select in case it has a lot of options.
 */

var OptimizedMenuList = function OptimizedMenuList(props) {
  var options = props.options,
      children = props.children,
      maxHeight = props.maxHeight,
      getValue = props.getValue;
  var selectedValues = getValue();
  var initialOffset = selectedValues && selectedValues[0] ? options.indexOf(selectedValues[0]) * HEIGHT : 0;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_window__WEBPACK_IMPORTED_MODULE_2__["FixedSizeList"], {
    height: maxHeight,
    itemCount: children["length"],
    itemSize: HEIGHT,
    initialScrollOffset: initialOffset,
    width: "" // 100% width

  }, function (_ref) {
    var index = _ref.index,
        style = _ref.style;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", {
      className: "option-wrapper",
      style: style
    }, children[index]);
  });
};

/* harmony default export */ __webpack_exports__["default"] = (OptimizedMenuList);

/***/ }),

/***/ "./components/answer/SelectAnswer.jsx":
/*!********************************************!*\
  !*** ./components/answer/SelectAnswer.jsx ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return SelectAnswer; });
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.sort */ "core-js/modules/es.array.sort");
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.reflect.construct */ "core-js/modules/es.reflect.construct");
/* harmony import */ var core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_reflect_construct__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/inherits */ "@babel/runtime/helpers/inherits");
/* harmony import */ var _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "@babel/runtime/helpers/possibleConstructorReturn");
/* harmony import */ var _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "@babel/runtime/helpers/getPrototypeOf");
/* harmony import */ var _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");










function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8___default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _babel_runtime_helpers_getPrototypeOf__WEBPACK_IMPORTED_MODULE_8___default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _babel_runtime_helpers_possibleConstructorReturn__WEBPACK_IMPORTED_MODULE_7___default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }








var SelectAnswer = /*#__PURE__*/function (_React$Component) {
  _babel_runtime_helpers_inherits__WEBPACK_IMPORTED_MODULE_6___default()(SelectAnswer, _React$Component);

  var _super = _createSuper(SelectAnswer);

  function SelectAnswer() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_4___default()(this, SelectAnswer);

    return _super.apply(this, arguments);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_5___default()(SelectAnswer, [{
    key: "_generateSelectOptions",
    value: function _generateSelectOptions(options) {
      var rendered = [];
      options.sort(function (a, b) {
        var aLabel = jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default.a.getJsonAttValue(a, JsonldUtils.RDFS_LABEL),
            bLabel = jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default.a.getJsonAttValue(b, JsonldUtils.RDFS_LABEL);

        if (aLabel < bLabel) {
          return -1;
        }

        if (aLabel > bLabel) {
          return 1;
        }

        return 0;
      });

      for (var i = 0, len = options.length; i < len; i++) {
        rendered.push( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement("option", {
          value: jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default.a.getJsonAttValue(options[i], JsonldUtils.RDFS_LABEL),
          key: 'opt-' + i
        }, jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default.a.getJsonAttValue(options[i], JsonldUtils.RDFS_LABEL)));
      }

      return rendered;
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var question = this.props.question;
      return react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement(this.context.inputComponent, {
        type: 'select',
        label: this.props.label,
        value: this.props.value,
        title: this.props.title,
        onChange: function onChange(e) {
          _this.props.onChange(e.target.value);
        },
        disabled: this.context.componentsOptions.readOnly || _util_FormUtils__WEBPACK_IMPORTED_MODULE_13__["default"].isDisabled(question)
      }, this._generateSelectOptions(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_12__["HAS_OPTION"]]));
    }
  }]);

  return SelectAnswer;
}(react__WEBPACK_IMPORTED_MODULE_9___default.a.Component);


SelectAnswer.contextType = _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_14__["ConfigurationContext"];
SelectAnswer.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.object.isRequired,
  label: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.string.isRequired,
  title: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.string,
  value: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.string,
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.func.isRequired
};

/***/ }),

/***/ "./components/answer/TypeaheadAnswer.jsx":
/*!***********************************************!*\
  !*** ./components/answer/TypeaheadAnswer.jsx ***!
  \***********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description */ "core-js/modules/es.symbol.description");
/* harmony import */ var core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.sort */ "core-js/modules/es.array.sort");
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_function_name__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.function.name */ "core-js/modules/es.function.name");
/* harmony import */ var core_js_modules_es_function_name__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor */ "core-js/modules/es.object.get-own-property-descriptor");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.keys */ "core-js/modules/es.object.keys");
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "@babel/runtime/helpers/extends");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @babel/runtime/regenerator */ "@babel/runtime/regenerator");
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! regenerator-runtime/runtime */ "regenerator-runtime/runtime");
/* harmony import */ var regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "@babel/runtime/helpers/asyncToGenerator");
/* harmony import */ var _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react-select */ "react-select");
/* harmony import */ var react_select__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react_select__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _util_Utils__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../util/Utils */ "./util/Utils.js");
/* harmony import */ var _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../util/JsonLdObjectUtils */ "./util/JsonLdObjectUtils.js");
/* harmony import */ var _util_Logger__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../util/Logger */ "./util/Logger.js");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var _contexts_FormGenContext__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../contexts/FormGenContext */ "./contexts/FormGenContext.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _OptimizedMenuList__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./OptimizedMenuList */ "./components/answer/OptimizedMenuList.jsx");

















function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_11___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }















var processTypeaheadOptions = function processTypeaheadOptions(options, intl) {
  if (!options) {
    return [];
  } // sort by label


  options.sort(_util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_23__["default"].getCompareLocalizedLabelFunction(intl)); // sort by property

  _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_23__["default"].orderPreservingToplogicalSort(options, _constants_Constants__WEBPACK_IMPORTED_MODULE_20__["HAS_PRECEDING_VALUE"]);
  return jsonld_utils__WEBPACK_IMPORTED_MODULE_17___default.a.processTypeaheadOptions(options, intl);
};

var TypeaheadAnswer = function TypeaheadAnswer(props) {
  var queryHash = _util_Utils__WEBPACK_IMPORTED_MODULE_22__["default"].getStringHash(_util_FormUtils__WEBPACK_IMPORTED_MODULE_21__["default"].getPossibleValuesQuery(props.question));
  var formGenContext = Object(react__WEBPACK_IMPORTED_MODULE_16__["useContext"])(_contexts_FormGenContext__WEBPACK_IMPORTED_MODULE_26__["FormGenContext"]);
  var configurationContext = Object(react__WEBPACK_IMPORTED_MODULE_16__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_27__["ConfigurationContext"]);
  var intl = configurationContext.options.intl;

  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_16__["useState"])(true),
      _useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_15___default()(_useState, 2),
      isLoading = _useState2[0],
      setLoading = _useState2[1];

  var _useState3 = Object(react__WEBPACK_IMPORTED_MODULE_16__["useState"])(processTypeaheadOptions(props.options, intl)),
      _useState4 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_15___default()(_useState3, 2),
      options = _useState4[0],
      setOptions = _useState4[1];

  Object(react__WEBPACK_IMPORTED_MODULE_16__["useEffect"])(function () {
    var isCancelled = false;
    var question = props.question;

    function loadFormOptions() {
      return _loadFormOptions.apply(this, arguments);
    }

    function _loadFormOptions() {
      _loadFormOptions = _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_14___default()( /*#__PURE__*/_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_12___default.a.mark(function _callee() {
        var _options;

        return _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_12___default.a.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return formGenContext.loadFormOptions(queryHash, _util_FormUtils__WEBPACK_IMPORTED_MODULE_21__["default"].getPossibleValuesQuery(question));

              case 3:
                _options = _context.sent;

                if (!isCancelled) {
                  setLoading(false);
                  setOptions(processTypeaheadOptions(_options, intl));
                }

                _context.next = 10;
                break;

              case 7:
                _context.prev = 7;
                _context.t0 = _context["catch"](0);
                _util_Logger__WEBPACK_IMPORTED_MODULE_24__["default"].error("An error has occurred during loadFormOptions for query hash: ".concat(queryHash));

              case 10:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[0, 7]]);
      }));
      return _loadFormOptions.apply(this, arguments);
    }

    if (!question[_constants_Constants__WEBPACK_IMPORTED_MODULE_20__["HAS_OPTION"]] && _util_FormUtils__WEBPACK_IMPORTED_MODULE_21__["default"].getPossibleValuesQuery(question)) {
      loadFormOptions();
    } else {
      setLoading(false);
      setOptions(processTypeaheadOptions(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_20__["HAS_OPTION"]], intl));
    }

    return function () {
      isCancelled = true;
    };
  }, []);

  var onOptionSelected = function onOptionSelected(option) {
    props.onChange(option ? option.id : null);
  };

  var Option = react_select__WEBPACK_IMPORTED_MODULE_18__["components"].Option;

  var DescriptionOption = function DescriptionOption(props) {
    var innerProps = _objectSpread(_objectSpread({}, props.innerProps), {}, {
      title: props.data.description
    });

    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_16___default.a.createElement(Option, _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_10___default()({}, props, {
      title: props.data.description,
      innerProps: innerProps
    }));
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_16___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_25__["FormGroup"], {
    size: "small"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_16___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_25__["Form"].Label, null, props.label), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_16___default.a.createElement(react_select__WEBPACK_IMPORTED_MODULE_18___default.a, {
    options: options,
    isSearchable: true,
    isLoading: isLoading,
    isClearable: true,
    isDisabled: isLoading || configurationContext.componentsOptions.readOnly || _util_FormUtils__WEBPACK_IMPORTED_MODULE_21__["default"].isDisabled(props.question),
    value: options.filter(function (option) {
      return option.id === props.value;
    }),
    placeholder: '',
    getOptionLabel: function getOptionLabel(option) {
      return option.name;
    },
    getOptionValue: function getOptionValue(option) {
      return option.id;
    },
    onChange: onOptionSelected,
    components: {
      MenuList: _OptimizedMenuList__WEBPACK_IMPORTED_MODULE_28__["default"],
      Option: DescriptionOption
    }
  }));
};

TypeaheadAnswer.propTypes = {
  question: prop_types__WEBPACK_IMPORTED_MODULE_19___default.a.object.isRequired,
  answer: prop_types__WEBPACK_IMPORTED_MODULE_19___default.a.object.isRequired,
  label: prop_types__WEBPACK_IMPORTED_MODULE_19___default.a.string.isRequired,
  title: prop_types__WEBPACK_IMPORTED_MODULE_19___default.a.string,
  value: prop_types__WEBPACK_IMPORTED_MODULE_19___default.a.string,
  onChange: prop_types__WEBPACK_IMPORTED_MODULE_19___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (TypeaheadAnswer);

/***/ }),

/***/ "./components/wizard/HorizontalWizardNav.jsx":
/*!***************************************************!*\
  !*** ./components/wizard/HorizontalWizardNav.jsx ***!
  \***************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _Question__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Question */ "./components/Question.jsx");









var HorizontalWizardNav = function HorizontalWizardNav(_ref) {
  var steps = _ref.steps,
      onNavigate = _ref.onNavigate,
      currentStep = _ref.currentStep;

  var _useContext = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_6__["ConfigurationContext"]),
      options = _useContext.options;

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["Card"].Header, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["Nav"], {
    variant: "tabs",
    activeKey: currentStep,
    onSelect: function onSelect(key) {
      return onNavigate(parseInt(key));
    }
  }, steps.map(function (step, index) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["NavItem"], {
      key: 'nav' + index,
      id: 'wizard-nav-' + index,
      className: _Question__WEBPACK_IMPORTED_MODULE_7__["default"].getEmphasizedClass(step)
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["NavLink"], {
      eventKey: index,
      active: index === currentStep,
      disabled: !_util_FormUtils__WEBPACK_IMPORTED_MODULE_5__["default"].isRelevant(step)
    }, jsonld_utils__WEBPACK_IMPORTED_MODULE_4___default.a.getLocalized(step[jsonld_utils__WEBPACK_IMPORTED_MODULE_4___default.a.RDFS_LABEL], options.intl)));
  })));
};

HorizontalWizardNav.propTypes = {
  currentStep: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.number.isRequired,
  steps: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.array.isRequired,
  onNavigate: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (HorizontalWizardNav);

/***/ }),

/***/ "./components/wizard/VerticalWizardNav.jsx":
/*!*************************************************!*\
  !*** ./components/wizard/VerticalWizardNav.jsx ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _Question__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Question */ "./components/Question.jsx");









var VerticalWizardNav = function VerticalWizardNav(_ref) {
  var steps = _ref.steps,
      onNavigate = _ref.onNavigate,
      currentStep = _ref.currentStep;

  var _useContext = Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_5__["ConfigurationContext"]),
      options = _useContext.options;

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", {
    className: "wizard-nav col-2 p-0"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["ListGroup"], null, steps.map(function (step, index) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__["ListGroupItem"], {
      disabled: !_util_FormUtils__WEBPACK_IMPORTED_MODULE_6__["default"].isRelevant(step),
      key: 'nav' + index,
      onClick: function onClick() {
        return onNavigate(index);
      },
      id: 'wizard-nav-' + index,
      action: true,
      active: index === currentStep ? 'active' : '',
      variant: 'default',
      className: _Question__WEBPACK_IMPORTED_MODULE_7__["default"].getEmphasizedClass(step)
    }, jsonld_utils__WEBPACK_IMPORTED_MODULE_4___default.a.getLocalized(step[jsonld_utils__WEBPACK_IMPORTED_MODULE_4___default.a.RDFS_LABEL], options.intl));
  })));
};

VerticalWizardNav.propTypes = {
  currentStep: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.number.isRequired,
  steps: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.array.isRequired,
  onNavigate: prop_types__WEBPACK_IMPORTED_MODULE_3___default.a.func.isRequired
};
/* harmony default export */ __webpack_exports__["default"] = (VerticalWizardNav);

/***/ }),

/***/ "./components/wizard/Wizard.jsx":
/*!**************************************!*\
  !*** ./components/wizard/Wizard.jsx ***!
  \**************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_array_find_index__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.find-index */ "core-js/modules/es.array.find-index");
/* harmony import */ var core_js_modules_es_array_find_index__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_find_index__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _WizardStep__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./WizardStep */ "./components/wizard/WizardStep.jsx");
/* harmony import */ var _HorizontalWizardNav__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./HorizontalWizardNav */ "./components/wizard/HorizontalWizardNav.jsx");
/* harmony import */ var _VerticalWizardNav__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./VerticalWizardNav */ "./components/wizard/VerticalWizardNav.jsx");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../contexts/FormQuestionsContext */ "./contexts/FormQuestionsContext.js");
/* harmony import */ var _util_Utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../util/Utils */ "./util/Utils.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");












var findStepByQuestionId = function findStepByQuestionId(stepData, id) {
  var findQuestionTraversal = function findQuestionTraversal(question, index) {
    if (!question) {
      return -1;
    }

    if (question['@id'] === id) {
      return index;
    }

    var subQuestions = _util_Utils__WEBPACK_IMPORTED_MODULE_9__["default"].asArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_10__["HAS_SUBQUESTION"]]);
    return subQuestions.findIndex(function (q, index) {
      return findQuestionTraversal(q, index) !== -1;
    });
  };

  return stepData.findIndex(function (step, index) {
    return findQuestionTraversal(step, index) !== -1;
  });
};

var Wizard = function Wizard() {
  var formQuestionsContext = react__WEBPACK_IMPORTED_MODULE_2___default.a.useContext(_contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_8__["FormQuestionsContext"]);

  var _React$useContext = react__WEBPACK_IMPORTED_MODULE_2___default.a.useContext(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_7__["ConfigurationContext"]),
      options = _React$useContext.options;

  var startingStep = 0;

  if (options.startingQuestionId) {
    startingStep = findStepByQuestionId(formQuestionsContext.getFormQuestionsData(), options.startingQuestionId);

    if (startingStep === -1) {
      console.warn("Question with id ".concat(options.startingQuestionId, " not found!"));
      startingStep = 0;
    }
  } else if (options.startingStep) {
    startingStep = options.startingStep < formQuestionsContext.getFormQuestionsData().length ? options.startingStep : 0;
  }

  var _React$useState = react__WEBPACK_IMPORTED_MODULE_2___default.a.useState(startingStep),
      _React$useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1___default()(_React$useState, 2),
      currentStep = _React$useState2[0],
      setCurrentStep = _React$useState2[1];

  var _React$useState3 = react__WEBPACK_IMPORTED_MODULE_2___default.a.useState(false),
      _React$useState4 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1___default()(_React$useState3, 2),
      scrolledToStartingQuestionId = _React$useState4[0],
      setScrolledToStartingQuestionId = _React$useState4[1];

  Object(react__WEBPACK_IMPORTED_MODULE_2__["useEffect"])(function () {
    if (options.startingQuestionId && !scrolledToStartingQuestionId) {
      var element = document.getElementById(options.startingQuestionId);

      if (element) {
        element.scrollIntoView();
        element.classList.add('text-danger');
        setScrolledToStartingQuestionId(true);
      }
    }
  });

  var onNextStep = function onNextStep() {
    var stepData = formQuestionsContext.getFormQuestionsData();

    if (currentStep !== stepData.length - 1) {
      stepData[currentStep + 1].visited = true;
      setCurrentStep(function (prevCurrentStep) {
        return prevCurrentStep + 1;
      });
    }
  };

  var onPreviousStep = function onPreviousStep() {
    if (currentStep === 0) {
      return;
    }

    setCurrentStep(function (prevCurrentStep) {
      return prevCurrentStep - 1;
    });
  };

  var navigate = function navigate(stepIndex) {
    var stepData = formQuestionsContext.getFormQuestionsData();

    if (stepIndex === currentStep || stepIndex >= stepData.length) {
      return;
    } // Can we jump forward?


    if (stepIndex > currentStep && !stepData[stepIndex].visited && !options.enableForwardSkip) {
      return;
    }

    setCurrentStep(stepIndex);
  };

  var renderNav = function renderNav() {
    var formQuestionsData = formQuestionsContext.getFormQuestionsData();
    return options.horizontalWizardNav ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_HorizontalWizardNav__WEBPACK_IMPORTED_MODULE_5__["default"], {
      currentStep: currentStep,
      steps: formQuestionsData,
      onNavigate: navigate
    }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_VerticalWizardNav__WEBPACK_IMPORTED_MODULE_6__["default"], {
      currentStep: currentStep,
      steps: formQuestionsData,
      onNavigate: navigate
    });
  };

  var initComponent = function initComponent() {
    var stepData = formQuestionsContext.getFormQuestionsData();
    var step = stepData[currentStep];
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_WizardStep__WEBPACK_IMPORTED_MODULE_4__["default"], {
      key: 'step' + currentStep,
      step: step,
      onNextStep: onNextStep,
      onPreviousStep: onPreviousStep,
      stepIndex: currentStep,
      isFirstStep: currentStep === 0,
      isLastStep: currentStep === formQuestionsContext.getFormQuestionsData().length - 1
    });
  };

  var nav = null;

  if (formQuestionsContext.getFormQuestionsData().length > 1) {
    nav = renderNav();
  }

  var isHorizontal = options.horizontalWizardNav;
  var cardClassname = isHorizontal ? '' : 'flex-row p-3';
  var containerClassname = isHorizontal ? 'card-body p-3' : nav ? 'col-10 p-0 pl-3' : 'col-12 p-0';
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_3__["Card"], {
    className: cardClassname
  }, nav, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("div", {
    className: containerClassname
  }, initComponent()));
};

/* harmony default export */ __webpack_exports__["default"] = (Wizard);

/***/ }),

/***/ "./components/wizard/WizardStep.jsx":
/*!******************************************!*\
  !*** ./components/wizard/WizardStep.jsx ***!
  \******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor */ "core-js/modules/es.object.get-own-property-descriptor");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.keys */ "core-js/modules/es.object.keys");
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-bootstrap */ "react-bootstrap");
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _HelpIcon__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../HelpIcon */ "./components/HelpIcon.jsx");
/* harmony import */ var _contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../contexts/FormQuestionsContext */ "./contexts/FormQuestionsContext.js");
/* harmony import */ var _contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../contexts/ConfigurationContext */ "./contexts/ConfigurationContext.js");
/* harmony import */ var _Question__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../Question */ "./components/Question.jsx");









function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }











var WizardStep = function WizardStep(props) {
  var formQuestionsContext = react__WEBPACK_IMPORTED_MODULE_8___default.a.useContext(_contexts_FormQuestionsContext__WEBPACK_IMPORTED_MODULE_14__["FormQuestionsContext"]);

  var _React$useContext = react__WEBPACK_IMPORTED_MODULE_8___default.a.useContext(_contexts_ConfigurationContext__WEBPACK_IMPORTED_MODULE_15__["ConfigurationContext"]),
      options = _React$useContext.options;

  var onNextStep = function onNextStep() {
    formQuestionsContext.updateFormQuestionsData(props.stepIndex, formQuestionsContext.getFormQuestionsData());
    props.onNextStep();
  };

  var onPreviousStep = function onPreviousStep() {
    props.onPreviousStep();
  };

  var _renderHelpIcon = function _renderHelpIcon() {
    var question = formQuestionsContext.getFormQuestionsData([props.stepIndex]);
    return question[_constants_Constants__WEBPACK_IMPORTED_MODULE_12__["HELP_DESCRIPTION"]] ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(_HelpIcon__WEBPACK_IMPORTED_MODULE_13__["default"], {
      text: jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default.a.getLocalized(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_12__["HELP_DESCRIPTION"]], options.intl),
      iconClass: "help-icon-section"
    }) : null;
  };

  var _renderWizardStepButtons = function _renderWizardStepButtons() {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_9__["ButtonToolbar"], {
      className: "m-3 float-right"
    }, !props.isFirstStep && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_9__["Button"], {
      className: "mr-2",
      onClick: onPreviousStep,
      variant: "primary",
      size: "sm"
    }, options.i18n['wizard.previous']), !props.isLastStep && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_9__["Button"], {
      onClick: onNextStep,
      variant: "primary",
      size: "sm"
    }, options.i18n['wizard.next']));
  };

  var onChange = function onChange(index, change) {
    formQuestionsContext.updateFormQuestionsData(props.stepIndex || index, _objectSpread(_objectSpread({}, props.step), change));
  };

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement("div", {
    className: "wizard-step"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_9__["Card"], {
    className: "wizard-step-content"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_9__["Card"].Header, {
    className: "bg-primary text-white",
    as: "h6",
    id: props.step['@id']
  }, jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default.a.getLocalized(props.step[jsonld_utils__WEBPACK_IMPORTED_MODULE_10___default.a.RDFS_LABEL], options.intl), _renderHelpIcon()), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(react_bootstrap__WEBPACK_IMPORTED_MODULE_9__["Card"].Body, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_8___default.a.createElement(_Question__WEBPACK_IMPORTED_MODULE_16__["default"], {
    question: props.step,
    onChange: onChange,
    withoutCard: true,
    index: props.stepIndex
  }))), options.wizardStepButtons && _renderWizardStepButtons());
};

WizardStep.propTypes = {
  step: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.object.isRequired,
  onNextStep: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.func,
  onPreviousStep: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.func,
  stepIndex: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.number.isRequired,
  isFirstStep: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.bool,
  isLastStep: prop_types__WEBPACK_IMPORTED_MODULE_11___default.a.bool
};
/* harmony default export */ __webpack_exports__["default"] = (WizardStep);

/***/ }),

/***/ "./constants/Constants.js":
/*!********************************!*\
  !*** ./constants/Constants.js ***!
  \********************************/
/*! exports provided: COLUMN_COUNT, INPUT_LENGTH_THRESHOLD, DATETIME_NUMBER_FORMAT, FORM, HAS_SUBQUESTION, HAS_ANSWER, HAS_OPTION, HAS_OPTIONS_QUERY, HAS_VALUE_TYPE, IS_DISABLED, INPUT_MASK, LAYOUT_CLASS, LAYOUT, VALUE_TYPE_CODE, VALUE_TYPE_TEXT, GENERATED_ROW_SIZE, HAS_QUESTION_ORIGIN, HAS_ANSWER_ORIGIN, HAS_DATA_VALUE, HAS_OBJECT_VALUE, HELP_DESCRIPTION, XSD, ACCEPTS_ANSWER_VALUE, HAS_DATATYPE, HAS_LAYOUT_CLASS, HAS_POSSIBLE_VALUES_QUERY, HAS_REQUIRED_VALUE, HAS_TESTED_QUESTION, HAS_UNIT, HAS_VALID_ANSWER, IS_RELEVANT_IF, ACCEPTS_VALIDATION_VALUE, HAS_VALIDATION_MESSAGE, NEGATIVE_CONDITION, REQUIRES_ANSWER, REQUIRES_ANSWER_DESCRIPTION_IF, REQUIRES_ANSWER_IF, REQUIRES_ANSWER_VALUE, REQUIRES_DESCRIPTION, HAS_PRECEDING_QUESTION, HAS_PRECEDING_VALUE, HAS_MEDIA_CONTENT, CONDITION, HAS_PATTERN, HAS_DECLARED_PREFIX, PREFIX, NAMESPACE, RDFS_LABEL, RDFS_COMMENT, DEFAULT_HAS_CHILD */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "COLUMN_COUNT", function() { return COLUMN_COUNT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "INPUT_LENGTH_THRESHOLD", function() { return INPUT_LENGTH_THRESHOLD; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DATETIME_NUMBER_FORMAT", function() { return DATETIME_NUMBER_FORMAT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FORM", function() { return FORM; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_SUBQUESTION", function() { return HAS_SUBQUESTION; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_ANSWER", function() { return HAS_ANSWER; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_OPTION", function() { return HAS_OPTION; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_OPTIONS_QUERY", function() { return HAS_OPTIONS_QUERY; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_VALUE_TYPE", function() { return HAS_VALUE_TYPE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "IS_DISABLED", function() { return IS_DISABLED; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "INPUT_MASK", function() { return INPUT_MASK; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LAYOUT_CLASS", function() { return LAYOUT_CLASS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LAYOUT", function() { return LAYOUT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VALUE_TYPE_CODE", function() { return VALUE_TYPE_CODE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VALUE_TYPE_TEXT", function() { return VALUE_TYPE_TEXT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GENERATED_ROW_SIZE", function() { return GENERATED_ROW_SIZE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_QUESTION_ORIGIN", function() { return HAS_QUESTION_ORIGIN; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_ANSWER_ORIGIN", function() { return HAS_ANSWER_ORIGIN; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_DATA_VALUE", function() { return HAS_DATA_VALUE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_OBJECT_VALUE", function() { return HAS_OBJECT_VALUE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HELP_DESCRIPTION", function() { return HELP_DESCRIPTION; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "XSD", function() { return XSD; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ACCEPTS_ANSWER_VALUE", function() { return ACCEPTS_ANSWER_VALUE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_DATATYPE", function() { return HAS_DATATYPE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_LAYOUT_CLASS", function() { return HAS_LAYOUT_CLASS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_POSSIBLE_VALUES_QUERY", function() { return HAS_POSSIBLE_VALUES_QUERY; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_REQUIRED_VALUE", function() { return HAS_REQUIRED_VALUE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_TESTED_QUESTION", function() { return HAS_TESTED_QUESTION; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_UNIT", function() { return HAS_UNIT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_VALID_ANSWER", function() { return HAS_VALID_ANSWER; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "IS_RELEVANT_IF", function() { return IS_RELEVANT_IF; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ACCEPTS_VALIDATION_VALUE", function() { return ACCEPTS_VALIDATION_VALUE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_VALIDATION_MESSAGE", function() { return HAS_VALIDATION_MESSAGE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NEGATIVE_CONDITION", function() { return NEGATIVE_CONDITION; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "REQUIRES_ANSWER", function() { return REQUIRES_ANSWER; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "REQUIRES_ANSWER_DESCRIPTION_IF", function() { return REQUIRES_ANSWER_DESCRIPTION_IF; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "REQUIRES_ANSWER_IF", function() { return REQUIRES_ANSWER_IF; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "REQUIRES_ANSWER_VALUE", function() { return REQUIRES_ANSWER_VALUE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "REQUIRES_DESCRIPTION", function() { return REQUIRES_DESCRIPTION; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_PRECEDING_QUESTION", function() { return HAS_PRECEDING_QUESTION; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_PRECEDING_VALUE", function() { return HAS_PRECEDING_VALUE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_MEDIA_CONTENT", function() { return HAS_MEDIA_CONTENT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CONDITION", function() { return CONDITION; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_PATTERN", function() { return HAS_PATTERN; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HAS_DECLARED_PREFIX", function() { return HAS_DECLARED_PREFIX; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PREFIX", function() { return PREFIX; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NAMESPACE", function() { return NAMESPACE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RDFS_LABEL", function() { return RDFS_LABEL; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RDFS_COMMENT", function() { return RDFS_COMMENT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DEFAULT_HAS_CHILD", function() { return DEFAULT_HAS_CHILD; });
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_0__);
 // Default bootstrap column count

var COLUMN_COUNT = 12;
var INPUT_LENGTH_THRESHOLD = 50;
var DATETIME_NUMBER_FORMAT = 'x';
/**
 * Contains mainly definition of constants used to parse the form declaration.
 */

var FORM = 'http://onto.fel.cvut.cz/ontologies/documentation/form';
var HAS_SUBQUESTION = 'http://onto.fel.cvut.cz/ontologies/documentation/has_related_question';
var HAS_ANSWER = 'http://onto.fel.cvut.cz/ontologies/documentation/has_answer';
var HAS_OPTION = 'http=//onto.fel.cvut.cz/ontologies/form/has-possible-value';
var HAS_OPTIONS_QUERY = 'http://onto.fel.cvut.cz/ontologies/form/has-possible-values-query';
var HAS_VALUE_TYPE = 'http://onto.fel.cvut.cz/ontologies/form/has-value-type';
var IS_DISABLED = 'http://onto.fel.cvut.cz/ontologies/aviation/form-376/is-disabled';
var INPUT_MASK = 'http://onto.fel.cvut.cz/ontologies/form/has-input-mask';
var LAYOUT_CLASS = 'http://onto.fel.cvut.cz/ontologies/form-layout/has-layout-class';
var LAYOUT = {
  FORM: 'form',
  QUESTION_SECTION: 'section',
  WIZARD_STEP: 'wizard-step',
  DATE: 'date',
  TIME: 'time',
  DATETIME: 'datetime',
  TEXTAREA: 'textarea',
  CHECKBOX: 'checkbox',
  QUESTION_TYPEAHEAD: 'type-ahead',
  MASKED_INPUT: 'masked-input',
  ANSWERABLE: 'answerable',
  SPARQL: 'sparql',
  TURTLE: 'ttl',
  DISABLED: 'disabled',
  HIDDEN: 'hidden',
  COLLAPSED: 'collapsed',
  EMPHASISED: 'emphasised'
};
var VALUE_TYPE_CODE = 'code';
var VALUE_TYPE_TEXT = 'text';
var GENERATED_ROW_SIZE = 1;
var HAS_QUESTION_ORIGIN = 'http://onto.fel.cvut.cz/ontologies/form/has-question-origin';
var HAS_ANSWER_ORIGIN = 'http://onto.fel.cvut.cz/ontologies/form/has-answer-origin';
var HAS_DATA_VALUE = 'http://onto.fel.cvut.cz/ontologies/documentation/has_data_value';
var HAS_OBJECT_VALUE = 'http://onto.fel.cvut.cz/ontologies/documentation/has_object_value';
var HELP_DESCRIPTION = 'http://purl.org/dc/elements/1.1/description';
var XSD = {
  MAX_EXCLUSIVE: 'http://www.w3.org/2001/XMLSchema#maxExclusive',
  MAX_INCLUSIVE: 'http://www.w3.org/2001/XMLSchema#maxInclusive',
  MIN_EXCLUSIVE: 'http://www.w3.org/2001/XMLSchema#minExclusive',
  MIN_INCLUSIVE: 'http://www.w3.org/2001/XMLSchema#minInclusive',
  INT: 'http://www.w3.org/2001/XMLSchema#int',
  INTEGER: 'http://www.w3.org/2001/XMLSchema#integer',
  NEGATIVE_INTEGER: 'http://www.w3.org/2001/XMLSchema#negativeInteger',
  NON_NEGATIVE_INTEGER: 'http://www.w3.org/2001/XMLSchema#nonNegativeInteger',
  NON_POSITIVE_INTEGER: 'http://www.w3.org/2001/XMLSchema#nonPositiveInteger',
  POSITIVE_INTEGER: 'http://www.w3.org/2001/XMLSchema#positiveInteger',
  BOOLEAN: 'http://www.w3.org/2001/XMLSchema#boolean'
};
var ACCEPTS_ANSWER_VALUE = 'http://onto.fel.cvut.cz/ontologies/form/accepts-answer-value';
var HAS_DATATYPE = 'http://onto.fel.cvut.cz/ontologies/form/has-datatype';
var HAS_LAYOUT_CLASS = 'http://onto.fel.cvut.cz/ontologies/form/has-layout-class';
var HAS_POSSIBLE_VALUES_QUERY = 'http://onto.fel.cvut.cz/ontologies/form/has-possible-values-query';
var HAS_REQUIRED_VALUE = 'http://onto.fel.cvut.cz/ontologies/form/has-required-value';
var HAS_TESTED_QUESTION = 'http://onto.fel.cvut.cz/ontologies/form/has-tested-question';
var HAS_UNIT = 'http://onto.fel.cvut.cz/ontologies/form/has-unit';
var HAS_VALID_ANSWER = 'http://onto.fel.cvut.cz/ontologies/form/has-valid-answer';
var IS_RELEVANT_IF = 'http://onto.fel.cvut.cz/ontologies/form/is-relevant-if';
var ACCEPTS_VALIDATION_VALUE = 'http://onto.fel.cvut.cz/ontologies/form/accepts-validation-value';
var HAS_VALIDATION_MESSAGE = 'http://onto.fel.cvut.cz/ontologies/form/has-validation-message';
var NEGATIVE_CONDITION = 'http://onto.fel.cvut.cz/ontologies/form/negative-condition';
var REQUIRES_ANSWER = 'http://onto.fel.cvut.cz/ontologies/form/requires-answer';
var REQUIRES_ANSWER_DESCRIPTION_IF = 'http://onto.fel.cvut.cz/ontologies/form/requires-answer-description-if';
var REQUIRES_ANSWER_IF = 'http://onto.fel.cvut.cz/ontologies/form/requires-answer-if';
var REQUIRES_ANSWER_VALUE = 'http://onto.fel.cvut.cz/ontologies/form/requires-answer-value';
var REQUIRES_DESCRIPTION = 'http://onto.fel.cvut.cz/ontologies/form/requires-description';
var HAS_PRECEDING_QUESTION = 'http://onto.fel.cvut.cz/ontologies/form/has-preceding-question';
var HAS_PRECEDING_VALUE = 'http://onto.fel.cvut.cz/ontologies/form/has-preceding-value';
var HAS_MEDIA_CONTENT = 'http://onto.fel.cvut.cz/ontologies/form/has-media-content';
var CONDITION = 'http://onto.fel.cvut.cz/ontologies/form/condition';
var HAS_PATTERN = 'http://onto.fel.cvut.cz/ontologies/form-lt/has-pattern';
var HAS_DECLARED_PREFIX = 'http://onto.fel.cvut.cz/ontologies/form-spin/has-declared-prefix';
var PREFIX = 'http://www.w3.org/ns/shacl#prefix';
var NAMESPACE = 'http://www.w3.org/ns/shacl#namespace';
var RDFS_LABEL = jsonld_utils__WEBPACK_IMPORTED_MODULE_0___default.a.RDFS_LABEL;
var RDFS_COMMENT = jsonld_utils__WEBPACK_IMPORTED_MODULE_0___default.a.RDFS_COMMENT;
var DEFAULT_HAS_CHILD = jsonld_utils__WEBPACK_IMPORTED_MODULE_0___default.a.DEFAULT_HAS_CHILD;

/***/ }),

/***/ "./contexts/ConfigurationContext.js":
/*!******************************************!*\
  !*** ./contexts/ConfigurationContext.js ***!
  \******************************************/
/*! exports provided: ConfigurationContext, ConfigurationContextProvider */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConfigurationContext", function() { return ConfigurationContext; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConfigurationContextProvider", function() { return ConfigurationContextProvider; });
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor */ "core-js/modules/es.object.get-own-property-descriptor");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.keys */ "core-js/modules/es.object.keys");
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "@babel/runtime/helpers/objectWithoutProperties");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);










function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_7___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var ConfigurationContext = react__WEBPACK_IMPORTED_MODULE_9___default.a.createContext({});
var defaultProps = {
  components: {
    inputComponent: __webpack_require__(/*! ../components/DefaultInput */ "./components/DefaultInput.jsx").default
  },
  componentsOptions: {
    dateTimeAnswer: {
      dateFormat: 'yyyy-MM-dd',
      timeFormat: 'HH:mm:ss',
      dateTimeFormat: 'yyyy-MM-dd HH:mm:ss'
    },
    readOnly: false
  },
  options: {
    intl: {
      locale: 'en'
    },
    i18n: {
      'wizard.next': 'Next',
      'wizard.previous': 'Previous'
    },
    modalView: false,
    modalProps: {},
    horizontalWizardNav: true,
    wizardStepButtons: true,
    enableForwardSkip: false,
    startingStep: 0
  }
};

var ConfigurationContextProvider = function ConfigurationContextProvider(_ref) {
  var children = _ref.children,
      props = _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_8___default()(_ref, ["children"]);

  var values = Object(react__WEBPACK_IMPORTED_MODULE_9__["useMemo"])(function () {
    return {
      inputComponent: props.components && props.components.inputComponent || defaultProps.components.inputComponent,
      componentsOptions: _objectSpread(_objectSpread({}, defaultProps.componentsOptions), props.componentsOptions),
      options: _objectSpread(_objectSpread({}, defaultProps.options), props.options)
    };
  }, [props]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_9___default.a.createElement(ConfigurationContext.Provider, {
    value: values
  }, children);
};

ConfigurationContextProvider.propTypes = {
  children: prop_types__WEBPACK_IMPORTED_MODULE_10___default.a.element.isRequired,
  components: prop_types__WEBPACK_IMPORTED_MODULE_10___default.a.object,
  componentsOptions: prop_types__WEBPACK_IMPORTED_MODULE_10___default.a.object,
  options: prop_types__WEBPACK_IMPORTED_MODULE_10___default.a.object
};


/***/ }),

/***/ "./contexts/FormGenContext.js":
/*!************************************!*\
  !*** ./contexts/FormGenContext.js ***!
  \************************************/
/*! exports provided: FormGenContext, FormGenContextProvider */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FormGenContext", function() { return FormGenContext; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FormGenContextProvider", function() { return FormGenContextProvider; });
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor */ "core-js/modules/es.object.get-own-property-descriptor");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.keys */ "core-js/modules/es.object.keys");
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_promise__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.promise */ "core-js/modules/es.promise");
/* harmony import */ var core_js_modules_es_promise__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "@babel/runtime/helpers/extends");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @babel/runtime/regenerator */ "@babel/runtime/regenerator");
/* harmony import */ var _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! regenerator-runtime/runtime */ "regenerator-runtime/runtime");
/* harmony import */ var regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(regenerator_runtime_runtime__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "@babel/runtime/helpers/asyncToGenerator");
/* harmony import */ var _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "@babel/runtime/helpers/objectWithoutProperties");
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! jsonld */ "jsonld");
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(jsonld__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _util_Logger__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../util/Logger */ "./util/Logger.js");

















function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_11___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var FormGenContext = react__WEBPACK_IMPORTED_MODULE_16___default.a.createContext({});

var FormGenContextProvider = function FormGenContextProvider(_ref) {
  var children = _ref.children,
      props = _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_15___default()(_ref, ["children"]);

  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_16__["useState"])({}),
      _useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_14___default()(_useState, 2),
      options = _useState2[0],
      setOptions = _useState2[1];

  var loadFormOptions = /*#__PURE__*/function () {
    var _ref2 = _babel_runtime_helpers_asyncToGenerator__WEBPACK_IMPORTED_MODULE_13___default()( /*#__PURE__*/_babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_10___default.a.mark(function _callee(id, query) {
      var option, data;
      return _babel_runtime_regenerator__WEBPACK_IMPORTED_MODULE_10___default.a.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              option = options[id];

              if (!(option && option.length)) {
                _context.next = 3;
                break;
              }

              return _context.abrupt("return", option);

            case 3:
              _context.next = 5;
              return props.fetchTypeAheadValues(query);

            case 5:
              data = _context.sent;

              if (!data.length) {
                _context.next = 8;
                break;
              }

              return _context.abrupt("return", new Promise(function (resolve) {
                jsonld__WEBPACK_IMPORTED_MODULE_18___default.a.frame(data, {}, null, function (err, framed) {
                  var option = framed['@graph'];
                  setOptions(function (prevState) {
                    return _objectSpread(_objectSpread({}, prevState), {}, _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_11___default()({}, id, option));
                  });
                  return resolve(option);
                });
              }));

            case 8:
              _util_Logger__WEBPACK_IMPORTED_MODULE_19__["default"].warn("No data received when loading options using id ".concat(id));
              return _context.abrupt("return", []);

            case 10:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function loadFormOptions(_x, _x2) {
      return _ref2.apply(this, arguments);
    };
  }();

  var getOptions = function getOptions(id) {
    return options[id] || [];
  };

  var values = Object(react__WEBPACK_IMPORTED_MODULE_16__["useMemo"])(function () {
    return {
      loadFormOptions: loadFormOptions,
      getOptions: getOptions
    };
  }, [loadFormOptions, getOptions]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_16___default.a.createElement(FormGenContext.Provider, _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_9___default()({
    value: values
  }, props), children);
};

FormGenContextProvider.propTypes = {
  children: prop_types__WEBPACK_IMPORTED_MODULE_17___default.a.element.isRequired,
  fetchTypeAheadValues: prop_types__WEBPACK_IMPORTED_MODULE_17___default.a.func
};


/***/ }),

/***/ "./contexts/FormQuestionsContext.js":
/*!******************************************!*\
  !*** ./contexts/FormQuestionsContext.js ***!
  \******************************************/
/*! exports provided: FormQuestionsContext, FormQuestionsProvider */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FormQuestionsContext", function() { return FormQuestionsContext; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FormQuestionsProvider", function() { return FormQuestionsProvider; });
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor */ "core-js/modules/es.object.get-own-property-descriptor");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors */ "core-js/modules/es.object.get-own-property-descriptors");
/* harmony import */ var core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.keys */ "core-js/modules/es.object.keys");
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "@babel/runtime/helpers/extends");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "@babel/runtime/helpers/toConsumableArray");
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "prop-types");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../util/FormUtils */ "./util/FormUtils.js");












function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_9___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }




var INITIAL_DATA = {};
var INITIAL_FORM_QUESTIONS_DATA = [];
var FormQuestionsContext = react__WEBPACK_IMPORTED_MODULE_11___default.a.createContext({});

var FormQuestionsProvider = function FormQuestionsProvider(props) {
  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_11__["useState"])(props.data || INITIAL_DATA),
      _useState2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_10___default()(_useState, 2),
      data = _useState2[0],
      setData = _useState2[1];

  var _useState3 = Object(react__WEBPACK_IMPORTED_MODULE_11__["useState"])(props.formQuestions || INITIAL_FORM_QUESTIONS_DATA),
      _useState4 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_10___default()(_useState3, 2),
      formQuestionsData = _useState4[0],
      setFormQuestionsData = _useState4[1];

  Object(react__WEBPACK_IMPORTED_MODULE_11__["useEffect"])(function () {
    if (props.isFormValid) {
      var isValid = _util_FormUtils__WEBPACK_IMPORTED_MODULE_13__["default"].isValid(data);
      props.isFormValid(isValid);
    }
  }, []);

  var updateData = function updateData(update) {
    if (!update) return;
    setData(_objectSpread(_objectSpread({}, data), update));
  };

  var updateFormQuestionsData = function updateFormQuestionsData(index, update) {
    if (!update || index < 0 || index >= formQuestionsData.length) return;

    var newFormQuestionsData = _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_8___default()(formQuestionsData);

    newFormQuestionsData[index] = _objectSpread(_objectSpread({}, newFormQuestionsData[index]), update);
    setFormQuestionsData(newFormQuestionsData);

    if (props.isFormValid) {
      var isValid = _util_FormUtils__WEBPACK_IMPORTED_MODULE_13__["default"].isValid(data);
      props.isFormValid(isValid);
    }
  };

  var getData = function getData() {
    return data;
  };

  var getFormQuestionsData = function getFormQuestionsData(index) {
    return index === null || index === undefined ? formQuestionsData : formQuestionsData[index];
  };

  var values = Object(react__WEBPACK_IMPORTED_MODULE_11__["useMemo"])(function () {
    return {
      updateData: updateData,
      updateFormQuestionsData: updateFormQuestionsData,
      getData: getData,
      getFormQuestionsData: getFormQuestionsData
    };
  }, [getFormQuestionsData, getData]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_11___default.a.createElement(FormQuestionsContext.Provider, _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_7___default()({
    value: values
  }, props), props.children);
};

FormQuestionsProvider.propTypes = {
  children: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.element.isRequired,
  data: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.object.isRequired,
  formQuestions: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.array.isRequired,
  isFormValid: prop_types__WEBPACK_IMPORTED_MODULE_12___default.a.func
};


/***/ }),

/***/ "./model/DefaultFormGenerator.js":
/*!***************************************!*\
  !*** ./model/DefaultFormGenerator.js ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DefaultFormGenerator; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);



var DefaultFormGenerator = /*#__PURE__*/function () {
  function DefaultFormGenerator() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, DefaultFormGenerator);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(DefaultFormGenerator, null, [{
    key: "generateForm",

    /**
     * Generates default form for the wizard framework.
     *
     * The form consists of a single step, which contains one text area for the description.
     */
    value: function generateForm() {
      var formTemplate = __webpack_require__(/*! ./defaultForm */ "./model/defaultForm.js"); // Deep copy of the form template to prevent modifications


      formTemplate = JSON.parse(JSON.stringify(formTemplate));
      return formTemplate;
    }
  }]);

  return DefaultFormGenerator;
}();



/***/ }),

/***/ "./model/FormGenerator.js":
/*!********************************!*\
  !*** ./model/FormGenerator.js ***!
  \********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return FormGenerator; });
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.filter */ "core-js/modules/es.array.filter");
/* harmony import */ var core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.find */ "core-js/modules/es.array.find");
/* harmony import */ var core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_find__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.sort */ "core-js/modules/es.array.sort");
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.keys */ "core-js/modules/es.object.keys");
/* harmony import */ var core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_promise__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.promise */ "core-js/modules/es.promise");
/* harmony import */ var core_js_modules_es_promise__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "@babel/runtime/helpers/slicedToArray");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! jsonld */ "jsonld");
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(jsonld__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _DefaultFormGenerator__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./DefaultFormGenerator */ "./model/DefaultFormGenerator.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _util_Logger__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../util/Logger */ "./util/Logger.js");
/* harmony import */ var _util_JsonLdFramingUtils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../util/JsonLdFramingUtils */ "./util/JsonLdFramingUtils.js");
/* harmony import */ var _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../util/JsonLdObjectUtils */ "./util/JsonLdObjectUtils.js");
/* harmony import */ var _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../util/JsonLdObjectMap */ "./util/JsonLdObjectMap.js");





















var FormGenerator = /*#__PURE__*/function () {
  function FormGenerator() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_10___default()(this, FormGenerator);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_11___default()(FormGenerator, null, [{
    key: "constructDefaultForm",

    /**
     * Generates a default form with one-step wizard.
     *
     * @param intl Preferred language of questions
     *
     * @return Form definition (a one-step wizard with one question) and form data
     */
    value: function constructDefaultForm(intl) {
      var defaultFormData = _DefaultFormGenerator__WEBPACK_IMPORTED_MODULE_14__["default"].generateForm();

      var _FormGenerator$_const = FormGenerator._constructFormQuestions(defaultFormData, intl),
          _FormGenerator$_const2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_9___default()(_FormGenerator$_const, 2),
          formQuestions = _FormGenerator$_const2[0],
          form = _FormGenerator$_const2[1];

      return [formQuestions, {
        root: form
      }];
    }
    /**
     * Generates form definition from the specified data-enriched template.
     *
     * @param structure The form structure in JSON-LD
     * @param intl Preferred language of questions
     *
     * @return Promise with generated form definition and form data
     */

  }, {
    key: "constructForm",
    value: function constructForm(structure, intl) {
      return new Promise(function (resolve) {
        return jsonld__WEBPACK_IMPORTED_MODULE_12___default.a.flatten(structure, {}, null, function (err, structure) {
          var formProperties;
          var form;

          if (err) {
            _util_Logger__WEBPACK_IMPORTED_MODULE_16__["default"].error(err);
          }

          try {
            var _FormGenerator$_const3 = FormGenerator._constructFormQuestions(structure, intl),
                _FormGenerator$_const4 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_9___default()(_FormGenerator$_const3, 2),
                formQuestions = _FormGenerator$_const4[0],
                rootForm = _FormGenerator$_const4[1];

            form = rootForm;
            formProperties = {
              formQuestions: formQuestions
            };
          } catch (e) {
            var _FormGenerator$constr = FormGenerator.constructDefaultForm(intl),
                _FormGenerator$constr2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_9___default()(_FormGenerator$constr, 2),
                _formQuestions = _FormGenerator$constr2[0],
                _rootForm = _FormGenerator$constr2[1];

            form = _rootForm;
            formProperties = {
              formQuestions: _formQuestions
            };
          }

          return resolve([formProperties, form]);
        });
      });
    }
  }, {
    key: "_constructFormQuestions",
    value: function _constructFormQuestions(structure, intl) {
      var form;
      var formElements;
      var id2ObjectMap;
      var formQuestions = [];

      if (structure['@graph'][0]['@id'] !== undefined) {
        id2ObjectMap = _util_JsonLdFramingUtils__WEBPACK_IMPORTED_MODULE_17__["default"].expandStructure(structure); //TODO make as callback

        Object.keys(id2ObjectMap).map(function (key) {
          _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_19__["default"].putObject(key, id2ObjectMap[key]);
        });
      } else {
        console.warn('default form is constructed.');
      }

      form = structure['@graph'].find(function (item) {
        return _util_FormUtils__WEBPACK_IMPORTED_MODULE_15__["default"].isForm(item);
      });
      formElements = form[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["HAS_SUBQUESTION"]];

      if (!formElements) {
        _util_Logger__WEBPACK_IMPORTED_MODULE_16__["default"].error('Could not find any questions in the received data.');
        throw 'No questions in the form';
      }

      formQuestions = formElements.filter(function (item) {
        if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_15__["default"].isWizardStep(item) && !_util_FormUtils__WEBPACK_IMPORTED_MODULE_15__["default"].isHidden(item)) {
          return true;
        }

        _util_Logger__WEBPACK_IMPORTED_MODULE_16__["default"].warn('Item is not a wizard step: ' + item);
        return false;
      });

      if (!formQuestions.length) {
        _util_Logger__WEBPACK_IMPORTED_MODULE_16__["default"].log('Could not find any wizard steps in the received data. Building form without steps');
        form[_constants_Constants__WEBPACK_IMPORTED_MODULE_13__["HAS_SUBQUESTION"]].forEach(function (question) {
          return formQuestions.push(question);
        });
      } // sort by label


      formQuestions.sort(_util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_18__["default"].getCompareLocalizedLabelFunction(intl)); // sort by property

      _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_18__["default"].orderPreservingToplogicalSort(formQuestions, _constants_Constants__WEBPACK_IMPORTED_MODULE_13__["HAS_PRECEDING_QUESTION"]);
      return [formQuestions, {
        root: form
      }];
    }
  }]);

  return FormGenerator;
}();



/***/ }),

/***/ "./model/QuestionAnswerProcessor.js":
/*!******************************************!*\
  !*** ./model/QuestionAnswerProcessor.js ***!
  \******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return QuestionAnswerProcessor; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");





var QuestionAnswerProcessor = /*#__PURE__*/function () {
  function QuestionAnswerProcessor() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, QuestionAnswerProcessor);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(QuestionAnswerProcessor, null, [{
    key: "buildQuestionAnswerModel",

    /**
     * Builds question answer model from the specified wizard data.
     * @param wizardData Global wizard data
     * @param stepData Data from individual wizard steps
     */
    value: function buildQuestionAnswerModel(wizardData, stepData) {
      var question = {
        subQuestions: []
      };
      var processedQuestion;

      if (wizardData) {
        question.uri = wizardData.root['@id'];
        question.origin = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(wizardData.root, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_QUESTION_ORIGIN"], '@id');
      }

      if (stepData) {
        for (var i = 0; i < stepData.length; i++) {
          // This will skip questions corresponding to empty steps in the wizard
          processedQuestion = QuestionAnswerProcessor.processQuestionAnswerHierarchy(stepData[i]);

          if (processedQuestion) {
            question.subQuestions.push(processedQuestion);
          }
        }
      }

      return question;
    }
    /**
     * Transforms the QA hierarchy from JSON-LD-based structure to the object model-based one.
     * @param rootQuestion
     */

  }, {
    key: "processQuestionAnswerHierarchy",
    value: function processQuestionAnswerHierarchy(rootQuestion) {
      if (!rootQuestion) {
        return null;
      }

      return QuestionAnswerProcessor._processQuestion(rootQuestion);
    }
  }, {
    key: "_processQuestion",
    value: function _processQuestion(question) {
      var result = {};
      result.uri = question['@id'];
      result.origin = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_QUESTION_ORIGIN"], '@id');

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_SUBQUESTION"]]) {
        result.subQuestions = [];

        for (var i = 0; i < question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_SUBQUESTION"]].length; i++) {
          result.subQuestions.push(QuestionAnswerProcessor._processQuestion(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_SUBQUESTION"]][i]));
        }
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_ANSWER"]]) {
        result.answers = [];

        if (!Array.isArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_ANSWER"]])) {
          question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_ANSWER"]] = [question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_ANSWER"]]];
        }

        for (var _i = 0; _i < question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_ANSWER"]].length; _i++) {
          result.answers.push(QuestionAnswerProcessor.processAnswer(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_ANSWER"]][_i]));
        }
      }

      return result;
    }
  }, {
    key: "processAnswer",
    value: function processAnswer(answer) {
      var result = {};
      result.uri = answer['@id'];
      result.origin = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_ANSWER_ORIGIN"], '@id');

      if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_OBJECT_VALUE"]]) {
        result.codeValue = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_OBJECT_VALUE"], '@id');
      } else {
        result.textValue = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_DATA_VALUE"]);
      }

      return result;
    }
    /**
     * Generates an empty answer for the specified question
     * @param question
     */

  }, {
    key: "generateAnswer",
    value: function generateAnswer(question) {
      var answer = {};
      answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_DATA_VALUE"]] = '';
      return answer;
    }
  }]);

  return QuestionAnswerProcessor;
}();



/***/ }),

/***/ "./model/ValidatorFactory.js":
/*!***********************************!*\
  !*** ./model/ValidatorFactory.js ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ValidatorFactory; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/FormUtils */ "./util/FormUtils.js");



/**
 * Created by blcha on 4.11.16.
 */




var ValidatorFactory = /*#__PURE__*/function () {
  function ValidatorFactory() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, ValidatorFactory);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(ValidatorFactory, null, [{
    key: "createValidator",
    value: function createValidator(question, intl) {
      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["REQUIRES_ANSWER"]]) {
        if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_4__["default"].isCheckbox(question)) {
          //TODO revise
          return ValidatorFactory._generateRequiresAnswerCheckBoxValidator(question, intl);
        }

        return ValidatorFactory._generateRequiresAnswerValidator(question, intl);
      } else {
        return function () {
          var result = {};
          result[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_VALID_ANSWER"]] = true;
          delete result[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_VALIDATION_MESSAGE"]];
          return result;
        };
      }
    }
  }, {
    key: "_generateRequiresAnswerValidator",
    value: function _generateRequiresAnswerValidator(question, intl) {
      return function (answer) {
        var val = null;

        if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_DATA_VALUE"]]) {
          val = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_DATA_VALUE"]);
        } else if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_OBJECT_VALUE"]]) {
          val = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_OBJECT_VALUE"], '@id');
        }

        var isValid = val !== null && val !== undefined && val !== '';
        var result = {};
        result[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_VALID_ANSWER"]] = isValid;
        result[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_VALIDATION_MESSAGE"]] = isValid ? null : jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getLocalized(question[jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.RDFS_LABEL], intl) + ' is missing a value.';
        return result;
      };
    }
  }, {
    key: "_generateRequiresAnswerCheckBoxValidator",
    value: function _generateRequiresAnswerCheckBoxValidator(question, intl) {
      return function (answer) {
        var val = null;

        if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_DATA_VALUE"]]) {
          val = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_DATA_VALUE"]);
        } else if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_OBJECT_VALUE"]]) {
          val = jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_OBJECT_VALUE"], '@id');
        }

        var isValid = val !== null && val !== undefined && val !== '' && val !== false;
        var result = {};
        result[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_VALID_ANSWER"]] = isValid;
        result[_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["HAS_VALIDATION_MESSAGE"]] = isValid ? null : jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.getLocalized(question[jsonld_utils__WEBPACK_IMPORTED_MODULE_2___default.a.RDFS_LABEL], intl) + ' must be checked.';
        return result;
      };
    }
  }]);

  return ValidatorFactory;
}();



/***/ }),

/***/ "./model/defaultForm.js":
/*!******************************!*\
  !*** ./model/defaultForm.js ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = {
  '@graph': [{
    '@type': 'http://onto.fel.cvut.cz/ontologies/documentation/question',
    'http://onto.fel.cvut.cz/ontologies/form-layout/has-layout-class': 'form',
    'http://onto.fel.cvut.cz/ontologies/documentation/has_related_question': [{
      'http://onto.fel.cvut.cz/ontologies/form-layout/has-layout-class': ['wizard-step', 'section'],
      'http://www.w3.org/2000/01/rdf-schema#label': [{
        '@language': 'en',
        '@value': 'Description'
      }, {
        '@language': 'cs',
        '@value': 'Popis'
      }],
      'http://onto.fel.cvut.cz/ontologies/documentation/has_related_question': [{
        '@type': 'http://onto.fel.cvut.cz/ontologies/documentation/question',
        'http://onto.fel.cvut.cz/ontologies/form-layout/has-layout-class': ['textarea'],
        'http://www.w3.org/2000/01/rdf-schema#label': [{
          '@language': 'en',
          '@value': 'Description'
        }, {
          '@language': 'cs',
          '@value': 'Popis'
        }],
        'http://onto.fel.cvut.cz/ontologies/documentation/has_answer': {
          '@type': 'http://onto.fel.cvut.cz/ontologies/documentation/answer',
          'http://onto.fel.cvut.cz/ontologies/documentation/has_data_value': ''
        }
      }]
    }]
  }]
};

/***/ }),

/***/ "./s-forms.js":
/*!********************!*\
  !*** ./s-forms.js ***!
  \********************/
/*! exports provided: default, Constants, JsonLdObjectUtils, JsonLdFramingUtils, JsonLdObjectMap, FormUtils */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_SForms__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/SForms */ "./components/SForms.jsx");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants/Constants */ "./constants/Constants.js");
/* harmony reexport (module object) */ __webpack_require__.d(__webpack_exports__, "Constants", function() { return _constants_Constants__WEBPACK_IMPORTED_MODULE_1__; });
/* harmony import */ var _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./util/JsonLdObjectUtils */ "./util/JsonLdObjectUtils.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonLdObjectUtils", function() { return _util_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_2__["default"]; });

/* harmony import */ var _util_JsonLdFramingUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./util/JsonLdFramingUtils */ "./util/JsonLdFramingUtils.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonLdFramingUtils", function() { return _util_JsonLdFramingUtils__WEBPACK_IMPORTED_MODULE_3__["default"]; });

/* harmony import */ var _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./util/JsonLdObjectMap */ "./util/JsonLdObjectMap.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonLdObjectMap", function() { return _util_JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_4__["default"]; });

/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./util/FormUtils */ "./util/FormUtils.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FormUtils", function() { return _util_FormUtils__WEBPACK_IMPORTED_MODULE_5__["default"]; });







/* harmony default export */ __webpack_exports__["default"] = (_components_SForms__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "./styles/icons/CaretSquareDown.jsx":
/*!******************************************!*\
  !*** ./styles/icons/CaretSquareDown.jsx ***!
  \******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var CaretSquareDown = function CaretSquareDown(_ref) {
  var title = _ref.title;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("svg", {
    className: "caret-square-down",
    version: "1.1",
    xmlns: "http://www.w3.org/2000/svg",
    width: "24",
    height: "28",
    viewBox: "0 0 24 28"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("title", null, title || ''), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("path", {
    d: "M17.891 10.547c0.172 0.328 0.141 0.734-0.078 1.031l-5 7c-0.187 0.266-0.484 0.422-0.812 0.422s-0.625-0.156-0.812-0.422l-5-7c-0.219-0.297-0.25-0.703-0.078-1.031 0.172-0.344 0.516-0.547 0.891-0.547h10c0.375 0 0.719 0.203 0.891 0.547zM20 21.5v-15c0-0.266-0.234-0.5-0.5-0.5h-15c-0.266 0-0.5 0.234-0.5 0.5v15c0 0.266 0.234 0.5 0.5 0.5h15c0.266 0 0.5-0.234 0.5-0.5zM24 6.5v15c0 2.484-2.016 4.5-4.5 4.5h-15c-2.484 0-4.5-2.016-4.5-4.5v-15c0-2.484 2.016-4.5 4.5-4.5h15c2.484 0 4.5 2.016 4.5 4.5z"
  }));
};

/* harmony default export */ __webpack_exports__["default"] = (CaretSquareDown);

/***/ }),

/***/ "./styles/icons/CaretSquareUp.jsx":
/*!****************************************!*\
  !*** ./styles/icons/CaretSquareUp.jsx ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var CaretSquareUp = function CaretSquareUp(_ref) {
  var title = _ref.title;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("svg", {
    className: "caret-square-up",
    version: "1.1",
    xmlns: "http://www.w3.org/2000/svg",
    width: "24",
    height: "28",
    viewBox: "0 0 24 28"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("title", null, title || ''), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("path", {
    d: "M17.891 17.453c-0.172 0.344-0.516 0.547-0.891 0.547h-10c-0.375 0-0.719-0.203-0.891-0.547-0.172-0.328-0.141-0.734 0.078-1.031l5-7c0.187-0.266 0.484-0.422 0.812-0.422s0.625 0.156 0.812 0.422l5 7c0.219 0.297 0.25 0.703 0.078 1.031zM20 21.5v-15c0-0.266-0.234-0.5-0.5-0.5h-15c-0.266 0-0.5 0.234-0.5 0.5v15c0 0.266 0.234 0.5 0.5 0.5h15c0.266 0 0.5-0.234 0.5-0.5zM24 6.5v15c0 2.484-2.016 4.5-4.5 4.5h-15c-2.484 0-4.5-2.016-4.5-4.5v-15c0-2.484 2.016-4.5 4.5-4.5h15c2.484 0 4.5 2.016 4.5 4.5z"
  }));
};

/* harmony default export */ __webpack_exports__["default"] = (CaretSquareUp);

/***/ }),

/***/ "./styles/icons/InfoCircle.jsx":
/*!*************************************!*\
  !*** ./styles/icons/InfoCircle.jsx ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var InfoCircle = function InfoCircle() {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("svg", {
    className: "info-circle",
    version: "1.1",
    xmlns: "http://www.w3.org/2000/svg",
    width: "24",
    height: "28",
    viewBox: "0 0 24 28"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("title", null, "info-circle"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("path", {
    d: "M16 21.5v-2.5c0-0.281-0.219-0.5-0.5-0.5h-1.5v-8c0-0.281-0.219-0.5-0.5-0.5h-5c-0.281 0-0.5 0.219-0.5 0.5v2.5c0 0.281 0.219 0.5 0.5 0.5h1.5v5h-1.5c-0.281 0-0.5 0.219-0.5 0.5v2.5c0 0.281 0.219 0.5 0.5 0.5h7c0.281 0 0.5-0.219 0.5-0.5zM14 7.5v-2.5c0-0.281-0.219-0.5-0.5-0.5h-3c-0.281 0-0.5 0.219-0.5 0.5v2.5c0 0.281 0.219 0.5 0.5 0.5h3c0.281 0 0.5-0.219 0.5-0.5zM24 14c0 6.625-5.375 12-12 12s-12-5.375-12-12 5.375-12 12-12 12 5.375 12 12z"
  }));
};

/* harmony default export */ __webpack_exports__["default"] = (InfoCircle);

/***/ }),

/***/ "./styles/icons/QuestionCircle.jsx":
/*!*****************************************!*\
  !*** ./styles/icons/QuestionCircle.jsx ***!
  \*****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var QuestionCircle = function QuestionCircle() {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("svg", {
    className: "question-circle",
    version: "1.1",
    xmlns: "http://www.w3.org/2000/svg",
    width: "24",
    height: "28",
    viewBox: "0 0 24 28"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("title", null, "question-circle"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("path", {
    d: "M14 21.5v-3c0-0.281-0.219-0.5-0.5-0.5h-3c-0.281 0-0.5 0.219-0.5 0.5v3c0 0.281 0.219 0.5 0.5 0.5h3c0.281 0 0.5-0.219 0.5-0.5zM18 11c0-2.859-3-5-5.688-5-2.547 0-4.453 1.094-5.797 3.328-0.141 0.219-0.078 0.5 0.125 0.656l2.063 1.563c0.078 0.063 0.187 0.094 0.297 0.094 0.141 0 0.297-0.063 0.391-0.187 0.734-0.938 1.047-1.219 1.344-1.437 0.266-0.187 0.781-0.375 1.344-0.375 1 0 1.922 0.641 1.922 1.328 0 0.812-0.422 1.219-1.375 1.656-1.109 0.5-2.625 1.797-2.625 3.313v0.562c0 0.281 0.219 0.5 0.5 0.5h3c0.281 0 0.5-0.219 0.5-0.5v0c0-0.359 0.453-1.125 1.188-1.547 1.188-0.672 2.812-1.578 2.812-3.953zM24 14c0 6.625-5.375 12-12 12s-12-5.375-12-12 5.375-12 12-12 12 5.375 12 12z"
  }));
};

/* harmony default export */ __webpack_exports__["default"] = (QuestionCircle);

/***/ }),

/***/ "./styles/icons/index.js":
/*!*******************************!*\
  !*** ./styles/icons/index.js ***!
  \*******************************/
/*! exports provided: CaretSquareUp, CaretSquareDown, InfoCircle, QuestionCircle */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _CaretSquareUp__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CaretSquareUp */ "./styles/icons/CaretSquareUp.jsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CaretSquareUp", function() { return _CaretSquareUp__WEBPACK_IMPORTED_MODULE_0__["default"]; });

/* harmony import */ var _CaretSquareDown__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CaretSquareDown */ "./styles/icons/CaretSquareDown.jsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CaretSquareDown", function() { return _CaretSquareDown__WEBPACK_IMPORTED_MODULE_1__["default"]; });

/* harmony import */ var _InfoCircle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InfoCircle */ "./styles/icons/InfoCircle.jsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "InfoCircle", function() { return _InfoCircle__WEBPACK_IMPORTED_MODULE_2__["default"]; });

/* harmony import */ var _QuestionCircle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./QuestionCircle */ "./styles/icons/QuestionCircle.jsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCircle", function() { return _QuestionCircle__WEBPACK_IMPORTED_MODULE_3__["default"]; });






/***/ }),

/***/ "./util/FormUtils.js":
/*!***************************!*\
  !*** ./util/FormUtils.js ***!
  \***************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return FormUtils; });
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol */ "core-js/modules/es.symbol");
/* harmony import */ var core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description */ "core-js/modules/es.symbol.description");
/* harmony import */ var core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_symbol_iterator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.iterator */ "core-js/modules/es.symbol.iterator");
/* harmony import */ var core_js_modules_es_symbol_iterator__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_iterator__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_from__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.from */ "core-js/modules/es.array.from");
/* harmony import */ var core_js_modules_es_array_from__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_from__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.iterator */ "core-js/modules/es.array.iterator");
/* harmony import */ var core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.slice */ "core-js/modules/es.array.slice");
/* harmony import */ var core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_function_name__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.function.name */ "core-js/modules/es.function.name");
/* harmony import */ var core_js_modules_es_function_name__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_function_name__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string */ "core-js/modules/es.regexp.to-string");
/* harmony import */ var core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_string_iterator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.string.iterator */ "core-js/modules/es.string.iterator");
/* harmony import */ var core_js_modules_es_string_iterator__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator */ "core-js/modules/web.dom-collections.iterator");
/* harmony import */ var core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! jsonld */ "jsonld");
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(jsonld__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Utils */ "./util/Utils.js");
/* harmony import */ var _JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./JsonLdObjectMap */ "./util/JsonLdObjectMap.js");
/* harmony import */ var _JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./JsonLdObjectUtils */ "./util/JsonLdObjectUtils.js");














function _createForOfIteratorHelper(o) { if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }








var FormUtils = /*#__PURE__*/function () {
  function FormUtils() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_11___default()(this, FormUtils);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_12___default()(FormUtils, null, [{
    key: "isForm",
    value: function isForm(structure) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(structure, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].FORM);
    }
  }, {
    key: "isWizardStep",
    value: function isWizardStep(structure) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(structure, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].WIZARD_STEP);
    }
  }, {
    key: "isSection",
    value: function isSection(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].QUESTION_SECTION);
    }
  }, {
    key: "isAnswerable",
    value: function isAnswerable(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].ANSWERABLE);
    }
  }, {
    key: "isTypeahead",
    value: function isTypeahead(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].QUESTION_TYPEAHEAD);
    }
  }, {
    key: "getPossibleValuesQuery",
    value: function getPossibleValuesQuery(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.getJsonAttValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["HAS_OPTIONS_QUERY"]);
    }
  }, {
    key: "isDisabled",
    value: function isDisabled(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].DISABLED);
    }
  }, {
    key: "isHidden",
    value: function isHidden(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].HIDDEN);
    }
  }, {
    key: "isTextarea",
    value: function isTextarea(question, answerValue) {
      return answerValue && answerValue.length > _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["INPUT_LENGTH_THRESHOLD"] && !FormUtils.isTypeahead(question) || jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].TEXTAREA);
    }
  }, {
    key: "isCalendar",
    value: function isCalendar(question) {
      return FormUtils.isDate(question) || FormUtils.isTime(question) || FormUtils.isDateTime(question);
    }
  }, {
    key: "isDate",
    value: function isDate(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].DATE);
    }
  }, {
    key: "isTime",
    value: function isTime(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].TIME);
    }
  }, {
    key: "isDateTime",
    value: function isDateTime(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].DATETIME);
    }
  }, {
    key: "isCheckbox",
    value: function isCheckbox(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].CHECKBOX);
    }
  }, {
    key: "isMaskedInput",
    value: function isMaskedInput(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].MASKED_INPUT);
    }
  }, {
    key: "isSparqlInput",
    value: function isSparqlInput(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].SPARQL);
    }
  }, {
    key: "isTurtleInput",
    value: function isTurtleInput(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].TURTLE);
    }
  }, {
    key: "isCollapsed",
    value: function isCollapsed(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].COLLAPSED);
    }
  }, {
    key: "isEmphasised",
    value: function isEmphasised(question) {
      return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.hasValue(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT_CLASS"], _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["LAYOUT"].EMPHASISED);
    }
  }, {
    key: "resolveValue",
    value: function resolveValue(answer) {
      if (!answer) {
        return null;
      }

      if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["HAS_OBJECT_VALUE"]]) {
        return answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["HAS_OBJECT_VALUE"]]['@id'];
      } else {
        return jsonld_utils__WEBPACK_IMPORTED_MODULE_13___default.a.getJsonAttValue(answer, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["HAS_DATA_VALUE"]);
      }
    }
  }, {
    key: "resolveValueObject",
    value: function resolveValueObject(answer) {
      if (!answer) {
        return null;
      }

      if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["HAS_OBJECT_VALUE"]]) {
        return _Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["HAS_OBJECT_VALUE"]])[0];
      }

      if (answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["HAS_DATA_VALUE"]]) {
        return _Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(answer[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["HAS_DATA_VALUE"]])[0];
      }

      return null;
    }
  }, {
    key: "isRelevant",
    value: function isRelevant(question) {
      if (!question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["IS_RELEVANT_IF"]]) {
        return true;
      }

      var _iterator = _createForOfIteratorHelper(_Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["IS_RELEVANT_IF"]])),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var cond = _step.value;

          if (!FormUtils.testCondition(cond)) {
            return false;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return true;
    }
  }, {
    key: "hasValidationLogic",
    value: function hasValidationLogic(question) {
      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["REQUIRES_ANSWER_VALUE"]]) {
        return true;
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["REQUIRES_ANSWER"]]) {
        return true;
      }

      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["REQUIRES_ANSWER_IF"]]) {
        return true;
      }

      return false;
    }
  }, {
    key: "isValid",
    value: function isValid(question) {
      if (question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["HAS_VALID_ANSWER"]] === false) {
        return false;
      }

      var _iterator2 = _createForOfIteratorHelper(_Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(question[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["HAS_SUBQUESTION"]])),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var subQ = _step2.value;

          if (this.isValid(subQ) === false) {
            return false;
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      return true;
    }
  }, {
    key: "testCondition",
    value: function testCondition(condition) {
      var acceptedValidationsValues = condition[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["ACCEPTS_VALIDATION_VALUE"]];
      var acceptedAnswerValues = condition[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["ACCEPTS_ANSWER_VALUE"]];
      var testedQuestions = condition[_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["HAS_TESTED_QUESTION"]];
      var question;

      if (acceptedValidationsValues && acceptedAnswerValues) {
        console.warn('Support for validation and requirement constraints at same time is not implemented !');
      } // valid answers


      if (acceptedValidationsValues && testedQuestions) {
        var arr = _Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(acceptedValidationsValues);

        if (arr.length !== 1 || arr[0] !== true && arr[0] !== 'true') {
          console.warn('Validation values other than "true" are not implemented !');
        }

        var _iterator3 = _createForOfIteratorHelper(_Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(testedQuestions)),
            _step3;

        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var q = _step3.value;
            question = _JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_17__["default"].getObject(q['@id']);

            if (question === undefined) {
              console.warn('Questions is not loaded in an object map.');
              return true;
            }

            if (this.isValid(question) === false) {
              return false;
            }
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }

        return true;
      } // concrete values


      if (acceptedAnswerValues && testedQuestions) {
        question = _JsonLdObjectMap__WEBPACK_IMPORTED_MODULE_17__["default"].getObject(testedQuestions['@id']);

        var _iterator4 = _createForOfIteratorHelper(_Utils__WEBPACK_IMPORTED_MODULE_16__["default"].asArray(acceptedAnswerValues)),
            _step4;

        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
            var expValue = _step4.value;

            if (!question) {
              console.warn('Question is not defined.');
              return true;
            }

            if (!question.hasOwnProperty(_constants_Constants__WEBPACK_IMPORTED_MODULE_15__["HAS_ANSWER"])) {
              console.warn('Question does not have answer value defined.');
              return true;
            }

            var answers = jsonld__WEBPACK_IMPORTED_MODULE_14___default.a.getValues(question, _constants_Constants__WEBPACK_IMPORTED_MODULE_15__["HAS_ANSWER"]);

            if (answers.length === 0) {
              return false;
            }

            var qValue = FormUtils.resolveValueObject(answers[0]);

            if (qValue && expValue && qValue.hasOwnProperty('@value') && expValue.hasOwnProperty('@id') && qValue['@value'] == expValue['@id']) {
              // TODO remove !, this is temporary fix as type-ahead component returns data-value instead of
              // code-value
              return true;
            }

            if (_JsonLdObjectUtils__WEBPACK_IMPORTED_MODULE_18__["default"].compareValues(qValue, expValue)) {
              return true;
            }
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }
      }

      return false;
    }
  }]);

  return FormUtils;
}();



/***/ }),

/***/ "./util/JsonLdFramingUtils.js":
/*!************************************!*\
  !*** ./util/JsonLdFramingUtils.js ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return JsonLdFramingUtils; });
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.iterator */ "core-js/modules/es.array.iterator");
/* harmony import */ var core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.sort */ "core-js/modules/es.array.sort");
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.to-string */ "core-js/modules/es.object.to-string");
/* harmony import */ var core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_set__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.set */ "core-js/modules/es.set");
/* harmony import */ var core_js_modules_es_set__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_set__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_string_iterator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.string.iterator */ "core-js/modules/es.string.iterator");
/* harmony import */ var core_js_modules_es_string_iterator__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_esnext_set_add_all__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/esnext.set.add-all */ "core-js/modules/esnext.set.add-all");
/* harmony import */ var core_js_modules_esnext_set_add_all__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_add_all__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_esnext_set_delete_all__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/esnext.set.delete-all */ "core-js/modules/esnext.set.delete-all");
/* harmony import */ var core_js_modules_esnext_set_delete_all__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_delete_all__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_esnext_set_difference__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/esnext.set.difference */ "core-js/modules/esnext.set.difference");
/* harmony import */ var core_js_modules_esnext_set_difference__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_difference__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_esnext_set_every__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/esnext.set.every */ "core-js/modules/esnext.set.every");
/* harmony import */ var core_js_modules_esnext_set_every__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_every__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_esnext_set_filter__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/esnext.set.filter */ "core-js/modules/esnext.set.filter");
/* harmony import */ var core_js_modules_esnext_set_filter__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_filter__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_esnext_set_find__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/esnext.set.find */ "core-js/modules/esnext.set.find");
/* harmony import */ var core_js_modules_esnext_set_find__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_find__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_esnext_set_intersection__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/esnext.set.intersection */ "core-js/modules/esnext.set.intersection");
/* harmony import */ var core_js_modules_esnext_set_intersection__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_intersection__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_esnext_set_is_disjoint_from__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/esnext.set.is-disjoint-from */ "core-js/modules/esnext.set.is-disjoint-from");
/* harmony import */ var core_js_modules_esnext_set_is_disjoint_from__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_is_disjoint_from__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_esnext_set_is_subset_of__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/esnext.set.is-subset-of */ "core-js/modules/esnext.set.is-subset-of");
/* harmony import */ var core_js_modules_esnext_set_is_subset_of__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_is_subset_of__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_esnext_set_is_superset_of__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/esnext.set.is-superset-of */ "core-js/modules/esnext.set.is-superset-of");
/* harmony import */ var core_js_modules_esnext_set_is_superset_of__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_is_superset_of__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_esnext_set_join__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/esnext.set.join */ "core-js/modules/esnext.set.join");
/* harmony import */ var core_js_modules_esnext_set_join__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_join__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_esnext_set_map__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/esnext.set.map */ "core-js/modules/esnext.set.map");
/* harmony import */ var core_js_modules_esnext_set_map__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_map__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_esnext_set_reduce__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/esnext.set.reduce */ "core-js/modules/esnext.set.reduce");
/* harmony import */ var core_js_modules_esnext_set_reduce__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_reduce__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_esnext_set_some__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/esnext.set.some */ "core-js/modules/esnext.set.some");
/* harmony import */ var core_js_modules_esnext_set_some__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_some__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_esnext_set_symmetric_difference__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/esnext.set.symmetric-difference */ "core-js/modules/esnext.set.symmetric-difference");
/* harmony import */ var core_js_modules_esnext_set_symmetric_difference__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_symmetric_difference__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_esnext_set_union__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/esnext.set.union */ "core-js/modules/esnext.set.union");
/* harmony import */ var core_js_modules_esnext_set_union__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_esnext_set_union__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator */ "core-js/modules/web.dom-collections.iterator");
/* harmony import */ var core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! jsonld */ "jsonld");
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(jsonld__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var _constants_Constants_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../constants/Constants.js */ "./constants/Constants.js");
/* harmony import */ var _util_FormUtils__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../util/FormUtils */ "./util/FormUtils.js");
/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./Utils */ "./util/Utils.js");































var formShape = {
  root: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_26___default()({}, _constants_Constants_js__WEBPACK_IMPORTED_MODULE_28__["HAS_LAYOUT_CLASS"], _constants_Constants_js__WEBPACK_IMPORTED_MODULE_28__["FORM"]),
  expandProperties: [_constants_Constants_js__WEBPACK_IMPORTED_MODULE_28__["HAS_SUBQUESTION"], _constants_Constants_js__WEBPACK_IMPORTED_MODULE_28__["IS_RELEVANT_IF"], _constants_Constants_js__WEBPACK_IMPORTED_MODULE_28__["HAS_ANSWER"], _constants_Constants_js__WEBPACK_IMPORTED_MODULE_28__["HAS_DECLARED_PREFIX"]]
};

var JsonLdFramingUtils = /*#__PURE__*/function () {
  function JsonLdFramingUtils() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_24___default()(this, JsonLdFramingUtils);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_25___default()(JsonLdFramingUtils, null, [{
    key: "customFrame",
    //TODO revise

    /**
     * Performs JSON-LD custom framing using shapes. Shape is declaration of the JSON-LD framing
     * in a language that is incompatible with JSON-LD specification.
     *
     * @param input the JSON-LD input to framing by a shape.
     * @param shape the JSON-LD custom frame configuration using shapes.
     * @param callback(err, framed) called once the operation completes.
     */
    value: function customFrame(input, shape, callback) {
      if (arguments.length < 2) {
        return jsonld__WEBPACK_IMPORTED_MODULE_27___default.a.nextTick(function () {
          callback(new TypeError('Could not frame, too few arguments.'));
        });
      }

      if (shape === null) {
        //TODO remove
        shape = formShape;
      }

      var flattened = null;
      var err = null;

      var flattenedCallback = function flattenedCallback(e, f) {
        flattened = f;
        err = e;
      };

      jsonld__WEBPACK_IMPORTED_MODULE_27___default.a.flatten(input, null, null, flattenedCallback);
    }
  }, {
    key: "expandStructure",
    value: function expandStructure(structure) {
      var root;
      var id2objectMap = {}; // mapping @id -> object

      structure['@graph'].forEach(function (item) {
        id2objectMap[item['@id']] = item;

        if (_util_FormUtils__WEBPACK_IMPORTED_MODULE_29__["default"].isForm(item)) {
          root = item;
        }
      });

      try {
        this._expandGraph(root, formShape, id2objectMap);
      } catch (e) {
        console.error("Error '" + e + "' occured, while trying to apply frame-ing with custom shape.");
      }

      return id2objectMap;
    }
  }, {
    key: "_expandGraph",
    value: function _expandGraph(parentNode, shape, id2ObjectMap) {
      var _this = this;

      var childArray;
      var child;
      var childId;
      shape.expandProperties.forEach(function (prop) {
        if (parentNode.hasOwnProperty(prop)) {
          parentNode[prop] = _Utils__WEBPACK_IMPORTED_MODULE_30__["default"].asArray(parentNode[prop]);
          childArray = parentNode[prop];

          for (var i = 0; i < childArray.length; i++) {
            childId = childArray[i]['@id'];
            child = id2ObjectMap[childId];

            if (child !== undefined) {
              childArray[i] = child; //console.log(childId + " expanded.");

              _this._expandGraph(child, shape, id2ObjectMap);
            } else {
              console.warn('object with @id ' + childId + ' was not defined in input data.');
            }
          }
        }
      });
    }
  }]);

  return JsonLdFramingUtils;
}();

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_26___default()(JsonLdFramingUtils, "compressStructure", function (rootNode) {
  var object2IdMap = []; // mapping object -> id

  var idIncluded = new Set();
  object2IdMap = JsonLdFramingUtils._compressGraph(rootNode, object2IdMap, idIncluded);
  object2IdMap = object2IdMap.sort(function (a, b) {
    return a['@id'].localeCompare(b['@id']);
  });
  return object2IdMap;
});

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_26___default()(JsonLdFramingUtils, "_compressGraph", function (parentNode, object2IdMap, idIncluded) {
  if (!idIncluded.has(parentNode['@id'])) {
    object2IdMap.push(parentNode);
    idIncluded.add(parentNode['@id']);
  }

  formShape.expandProperties.forEach(function (prop) {
    if (parentNode.hasOwnProperty(prop)) {
      var childArray = parentNode[prop];

      for (var i = 0; i < childArray.length; i++) {
        var child = childArray[i];

        if (child !== undefined) {
          childArray[i] = child;
          object2IdMap = JsonLdFramingUtils._compressGraph(child, object2IdMap, idIncluded);
          parentNode[prop][i] = {
            '@id': child['@id']
          };
        }
      }
    }
  });
  return object2IdMap;
});



/***/ }),

/***/ "./util/JsonLdObjectMap.js":
/*!*********************************!*\
  !*** ./util/JsonLdObjectMap.js ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return JsonLdObjectMap; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "@babel/runtime/helpers/defineProperty");
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__);




var JsonLdObjectMap = /*#__PURE__*/function () {
  function JsonLdObjectMap() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, JsonLdObjectMap);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(JsonLdObjectMap, null, [{
    key: "putObject",
    value: function putObject(id, question) {
      JsonLdObjectMap.objectMap[id] = question;
    }
  }, {
    key: "getObject",
    value: function getObject(id) {
      return JsonLdObjectMap.objectMap[id];
    }
  }]);

  return JsonLdObjectMap;
}();

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default()(JsonLdObjectMap, "objectMap", {});



/***/ }),

/***/ "./util/JsonLdObjectUtils.js":
/*!***********************************!*\
  !*** ./util/JsonLdObjectUtils.js ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return JsonLdObjectUtils; });
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.for-each */ "core-js/modules/es.array.for-each");
/* harmony import */ var core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_for_each__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.map */ "core-js/modules/es.array.map");
/* harmony import */ var core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.sort */ "core-js/modules/es.array.sort");
/* harmony import */ var core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each */ "core-js/modules/web.dom-collections.for-each");
/* harmony import */ var core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "@babel/runtime/helpers/typeof");
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! jsonld */ "jsonld");
/* harmony import */ var jsonld__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(jsonld__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! jsonld-utils */ "jsonld-utils");
/* harmony import */ var jsonld_utils__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(jsonld_utils__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Utils */ "./util/Utils.js");
/* harmony import */ var tsort__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! tsort */ "tsort");
/* harmony import */ var tsort__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(tsort__WEBPACK_IMPORTED_MODULE_10__);












var JsonLdObjectUtils = /*#__PURE__*/function () {
  function JsonLdObjectUtils() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_5___default()(this, JsonLdObjectUtils);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_6___default()(JsonLdObjectUtils, null, [{
    key: "getFirstObject",
    value: function getFirstObject(subject, predicate) {
      var values = jsonld__WEBPACK_IMPORTED_MODULE_7___default.a.getValues(subject, predicate);

      if (values.length === 0) {
        //throw "Subject "  + subject[@id] + " does not have any value of property " + predicate;
        return null;
      }

      return values[0];
    }
  }, {
    key: "compareValues",
    value: function compareValues(jsonLdValue1, jsonLdValue2) {
      jsonLdValue1 = _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_4___default()(jsonLdValue1) === 'object' ? jsonLdValue1 : {
        '@value': jsonLdValue1
      };
      jsonLdValue2 = _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_4___default()(jsonLdValue2) === 'object' ? jsonLdValue2 : {
        '@value': jsonLdValue2
      }; // TODO remove: workaround for bad persistance of boolean values -- { @value: "true" } instead of { @value: true }

      if (jsonLdValue1 && jsonLdValue1['@value'] && jsonLdValue2 && jsonLdValue2['@value']) {
        var strValue1 = typeof jsonLdValue1['@value'] === 'string' ? jsonLdValue1['@value'] : JSON.stringify(jsonLdValue1['@value']);
        var strValue2 = typeof jsonLdValue2['@value'] === 'string' ? jsonLdValue2['@value'] : JSON.stringify(jsonLdValue2['@value']);

        if (strValue1 === strValue2) {
          return true;
        }
      }

      return jsonld__WEBPACK_IMPORTED_MODULE_7___default.a.compareValues(jsonLdValue1, jsonLdValue2);
    }
    /**
     * Sorts the specified JSON-LD data using a topological sort over partially ordered set defined by gtProperty.
     *
     * This is useful for situations where each item only knows its immediate neighbour in the list.
     * @param data The data to sort, should be an array
     * @param gtProperty Property specifying that an item is greater than another item. It is used for comparison.
     *
     */

  }, {
    key: "toplogicalSort",
    value: function toplogicalSort(data, gtProperty) {
      var swapped;

      do {
        swapped = false;

        for (var i = 0; i < data.length; i++) {
          for (var j = i; j < data.length; j++) {
            if (data[i][gtProperty]) {
              var gtId = _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_4___default()(data[i][gtProperty]) === 'object' ? data[i][gtProperty]['@id'] : data[i][gtProperty];

              if (gtId === data[j]['@id']) {
                var tmp = data[i];
                data[i] = data[j];
                data[j] = tmp;
                swapped = true;
                break;
              }
            }
          }
        }
      } while (swapped);

      return data;
    }
    /**
     * Sorts the specified JSON-LD data using a topological sort over partially ordered set defined by gtProperty,
     * while preserving original order.
     *
     * This is useful for situations where each item only knows its immediate neighbour in the list.
     * @param data The data to sort, should be an array
     * @param gtProperty Property specifying that an item is greater than another item. It is used for comparison.
     *
     */

  }, {
    key: "orderPreservingToplogicalSort",
    value: function orderPreservingToplogicalSort(data, gtProperty) {
      var graph = tsort__WEBPACK_IMPORTED_MODULE_10___default()();
      var id2ObjectMap = {};

      var _loop = function _loop(i) {
        var currentId = data[i]['@id'];
        graph.add(currentId);
        id2ObjectMap[currentId] = data[i];
        _Utils__WEBPACK_IMPORTED_MODULE_9__["default"].asArray(data[i][gtProperty]).map(function (val) {
          return _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_4___default()(val) === 'object' ? val['@id'] : val;
        }).map(function (val) {
          return [val, currentId];
        }).forEach(function (edge) {
          return graph.add(edge);
        });
      };

      for (var i = 0; i < data.length; i++) {
        _loop(i);
      }

      var sortedIds = graph.sort();

      for (var _i = 0; _i < sortedIds.length; _i++) {
        data[_i] = id2ObjectMap[sortedIds[_i]];
      }

      return data;
    }
  }, {
    key: "getCompareLocalizedLabelFunction",
    value: function getCompareLocalizedLabelFunction(intl) {
      return function (a, b) {
        var aLabel = jsonld_utils__WEBPACK_IMPORTED_MODULE_8___default.a.getLocalized(a[jsonld_utils__WEBPACK_IMPORTED_MODULE_8___default.a.RDFS_LABEL], intl);
        var bLabel = jsonld_utils__WEBPACK_IMPORTED_MODULE_8___default.a.getLocalized(b[jsonld_utils__WEBPACK_IMPORTED_MODULE_8___default.a.RDFS_LABEL], intl);

        if (aLabel < bLabel) {
          return -1;
        } else if (aLabel > bLabel) {
          return 1;
        }

        return 0;
      };
    }
  }, {
    key: "orderByLocalizedLabels",
    value: function orderByLocalizedLabels(data, intl) {
      return data.sort(JsonLdObjectUtils.getCompareLocalizedLabelFunction(intl));
    }
  }]);

  return JsonLdObjectUtils;
}();



/***/ }),

/***/ "./util/Logger.js":
/*!************************!*\
  !*** ./util/Logger.js ***!
  \************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Logger; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);



var Logger = /*#__PURE__*/function () {
  function Logger() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, Logger);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(Logger, null, [{
    key: "log",
    value: function log(msg) {
      console.log(msg);
    }
  }, {
    key: "warn",
    value: function warn(msg) {
      if (console.warn) {
        console.warn(msg);
      } else {
        console.log('WARNING: ' + msg);
      }
    }
  }, {
    key: "error",
    value: function error(msg) {
      if (console.error) {
        console.error(msg);
      } else {
        console.log('ERROR: ' + msg);
      }
    }
  }]);

  return Logger;
}();



/***/ }),

/***/ "./util/MaskMapper.js":
/*!****************************!*\
  !*** ./util/MaskMapper.js ***!
  \****************************/
/*! no static exports found */
/***/ (function(module, exports) {

var REPLACEMENTS = {
  D: '1',
  M: '1',
  Y: '1',
  h: '1',
  m: '1',
  s: '1'
};
module.exports = {
  /**
   * Attempts to map regular mask (e.g. date) to the format supported by inputmask-core.
   *
   * E.g. it maps (DD-MM-YYYY) to 11-11-1111.
   *
   * If an unsupported mask character is encountered, it is simply skipped. Datetime masks are processed according to
   * ISO 8601 acronyms (e.g. M for month and m for minute).
   * @param mask The mask to map
   */
  mapMask: function mapMask(mask) {
    if (!mask) {
      return mask;
    }

    var result = '',
        character;

    for (var i = 0, len = mask.length; i < len; i++) {
      character = mask.charAt(i);
      result += REPLACEMENTS[character] ? REPLACEMENTS[character] : character;
    }

    return result;
  }
};

/***/ }),

/***/ "./util/Utils.js":
/*!***********************!*\
  !*** ./util/Utils.js ***!
  \***********************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Utils; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "@babel/runtime/helpers/classCallCheck");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "@babel/runtime/helpers/createClass");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants/Constants */ "./constants/Constants.js");
/* harmony import */ var _FormUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./FormUtils */ "./util/FormUtils.js");





var Utils = /*#__PURE__*/function () {
  function Utils() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, Utils);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(Utils, null, [{
    key: "getStringHash",

    /**
     * Calculates a simple hash of the specified string, much like usual Java implementations.
     * @param str The string to compute has for
     * @return {number}
     */
    value: function getStringHash(str) {
      var hash = 0;
      var strlen = str ? str.length : 0;

      if (strlen === 0) {
        return hash;
      }

      for (var i = 0; i < strlen; i++) {
        hash = (hash << 5) - hash + str.charCodeAt(i);
        hash = hash & hash; // Convert to 32bit integer
      }

      return hash;
    }
    /**
     * Resolves which format of date/time/datetime value should be used in the datetime picker.
     * @param question Question with format info
     * @param originalValue Value read from answer, not processed by the rendered component
     * @param options Object with datetime formats
     * @return {*} Format from Configuration
     */

  }, {
    key: "resolveDateTimeFormat",
    value: function resolveDateTimeFormat(question, originalValue, options) {
      if (typeof originalValue === 'number') {
        return _constants_Constants__WEBPACK_IMPORTED_MODULE_2__["DATETIME_NUMBER_FORMAT"];
      }

      if (_FormUtils__WEBPACK_IMPORTED_MODULE_3__["default"].isDate(question)) {
        return options.dateFormat;
      } else if (_FormUtils__WEBPACK_IMPORTED_MODULE_3__["default"].isTime(question)) {
        return options.timeFormat;
      }

      return options.dateTimeFormat;
    }
    /**
     * Wraps passed object into new array if it is not array already.
     * @param object_or_array An object or array.
     * @returns {*} New array containing passed object or passed array.
     */

  }, {
    key: "asArray",
    value: function asArray(object_or_array) {
      if (!object_or_array) {
        return [];
      }

      if (object_or_array.constructor === Array) {
        return object_or_array;
      }

      return [object_or_array];
    }
  }]);

  return Utils;
}();



/***/ }),

/***/ "@babel/runtime/helpers/assertThisInitialized":
/*!***************************************************************!*\
  !*** external "@babel/runtime/helpers/assertThisInitialized" ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/assertThisInitialized");

/***/ }),

/***/ "@babel/runtime/helpers/asyncToGenerator":
/*!**********************************************************!*\
  !*** external "@babel/runtime/helpers/asyncToGenerator" ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/asyncToGenerator");

/***/ }),

/***/ "@babel/runtime/helpers/classCallCheck":
/*!********************************************************!*\
  !*** external "@babel/runtime/helpers/classCallCheck" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/classCallCheck");

/***/ }),

/***/ "@babel/runtime/helpers/createClass":
/*!*****************************************************!*\
  !*** external "@babel/runtime/helpers/createClass" ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/createClass");

/***/ }),

/***/ "@babel/runtime/helpers/defineProperty":
/*!********************************************************!*\
  !*** external "@babel/runtime/helpers/defineProperty" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/defineProperty");

/***/ }),

/***/ "@babel/runtime/helpers/extends":
/*!*************************************************!*\
  !*** external "@babel/runtime/helpers/extends" ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/extends");

/***/ }),

/***/ "@babel/runtime/helpers/getPrototypeOf":
/*!********************************************************!*\
  !*** external "@babel/runtime/helpers/getPrototypeOf" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/getPrototypeOf");

/***/ }),

/***/ "@babel/runtime/helpers/inherits":
/*!**************************************************!*\
  !*** external "@babel/runtime/helpers/inherits" ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/inherits");

/***/ }),

/***/ "@babel/runtime/helpers/objectWithoutProperties":
/*!*****************************************************************!*\
  !*** external "@babel/runtime/helpers/objectWithoutProperties" ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/objectWithoutProperties");

/***/ }),

/***/ "@babel/runtime/helpers/possibleConstructorReturn":
/*!*******************************************************************!*\
  !*** external "@babel/runtime/helpers/possibleConstructorReturn" ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/possibleConstructorReturn");

/***/ }),

/***/ "@babel/runtime/helpers/slicedToArray":
/*!*******************************************************!*\
  !*** external "@babel/runtime/helpers/slicedToArray" ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/slicedToArray");

/***/ }),

/***/ "@babel/runtime/helpers/toConsumableArray":
/*!***********************************************************!*\
  !*** external "@babel/runtime/helpers/toConsumableArray" ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/toConsumableArray");

/***/ }),

/***/ "@babel/runtime/helpers/typeof":
/*!************************************************!*\
  !*** external "@babel/runtime/helpers/typeof" ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/helpers/typeof");

/***/ }),

/***/ "@babel/runtime/regenerator":
/*!*********************************************!*\
  !*** external "@babel/runtime/regenerator" ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@babel/runtime/regenerator");

/***/ }),

/***/ "classnames":
/*!*****************************!*\
  !*** external "classnames" ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("classnames");

/***/ }),

/***/ "core-js/modules/es.array.concat":
/*!**************************************************!*\
  !*** external "core-js/modules/es.array.concat" ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.concat");

/***/ }),

/***/ "core-js/modules/es.array.every":
/*!*************************************************!*\
  !*** external "core-js/modules/es.array.every" ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.every");

/***/ }),

/***/ "core-js/modules/es.array.filter":
/*!**************************************************!*\
  !*** external "core-js/modules/es.array.filter" ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.filter");

/***/ }),

/***/ "core-js/modules/es.array.find":
/*!************************************************!*\
  !*** external "core-js/modules/es.array.find" ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.find");

/***/ }),

/***/ "core-js/modules/es.array.find-index":
/*!******************************************************!*\
  !*** external "core-js/modules/es.array.find-index" ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.find-index");

/***/ }),

/***/ "core-js/modules/es.array.for-each":
/*!****************************************************!*\
  !*** external "core-js/modules/es.array.for-each" ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.for-each");

/***/ }),

/***/ "core-js/modules/es.array.from":
/*!************************************************!*\
  !*** external "core-js/modules/es.array.from" ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.from");

/***/ }),

/***/ "core-js/modules/es.array.index-of":
/*!****************************************************!*\
  !*** external "core-js/modules/es.array.index-of" ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.index-of");

/***/ }),

/***/ "core-js/modules/es.array.iterator":
/*!****************************************************!*\
  !*** external "core-js/modules/es.array.iterator" ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.iterator");

/***/ }),

/***/ "core-js/modules/es.array.map":
/*!***********************************************!*\
  !*** external "core-js/modules/es.array.map" ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.map");

/***/ }),

/***/ "core-js/modules/es.array.slice":
/*!*************************************************!*\
  !*** external "core-js/modules/es.array.slice" ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.slice");

/***/ }),

/***/ "core-js/modules/es.array.some":
/*!************************************************!*\
  !*** external "core-js/modules/es.array.some" ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.some");

/***/ }),

/***/ "core-js/modules/es.array.sort":
/*!************************************************!*\
  !*** external "core-js/modules/es.array.sort" ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.array.sort");

/***/ }),

/***/ "core-js/modules/es.function.name":
/*!***************************************************!*\
  !*** external "core-js/modules/es.function.name" ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.function.name");

/***/ }),

/***/ "core-js/modules/es.number.constructor":
/*!********************************************************!*\
  !*** external "core-js/modules/es.number.constructor" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.number.constructor");

/***/ }),

/***/ "core-js/modules/es.number.max-safe-integer":
/*!*************************************************************!*\
  !*** external "core-js/modules/es.number.max-safe-integer" ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.number.max-safe-integer");

/***/ }),

/***/ "core-js/modules/es.object.get-own-property-descriptor":
/*!************************************************************************!*\
  !*** external "core-js/modules/es.object.get-own-property-descriptor" ***!
  \************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.object.get-own-property-descriptor");

/***/ }),

/***/ "core-js/modules/es.object.get-own-property-descriptors":
/*!*************************************************************************!*\
  !*** external "core-js/modules/es.object.get-own-property-descriptors" ***!
  \*************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.object.get-own-property-descriptors");

/***/ }),

/***/ "core-js/modules/es.object.get-own-property-names":
/*!*******************************************************************!*\
  !*** external "core-js/modules/es.object.get-own-property-names" ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.object.get-own-property-names");

/***/ }),

/***/ "core-js/modules/es.object.keys":
/*!*************************************************!*\
  !*** external "core-js/modules/es.object.keys" ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.object.keys");

/***/ }),

/***/ "core-js/modules/es.object.to-string":
/*!******************************************************!*\
  !*** external "core-js/modules/es.object.to-string" ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.object.to-string");

/***/ }),

/***/ "core-js/modules/es.promise":
/*!*********************************************!*\
  !*** external "core-js/modules/es.promise" ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.promise");

/***/ }),

/***/ "core-js/modules/es.reflect.construct":
/*!*******************************************************!*\
  !*** external "core-js/modules/es.reflect.construct" ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.reflect.construct");

/***/ }),

/***/ "core-js/modules/es.regexp.to-string":
/*!******************************************************!*\
  !*** external "core-js/modules/es.regexp.to-string" ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.regexp.to-string");

/***/ }),

/***/ "core-js/modules/es.set":
/*!*****************************************!*\
  !*** external "core-js/modules/es.set" ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.set");

/***/ }),

/***/ "core-js/modules/es.string.iterator":
/*!*****************************************************!*\
  !*** external "core-js/modules/es.string.iterator" ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.string.iterator");

/***/ }),

/***/ "core-js/modules/es.symbol":
/*!********************************************!*\
  !*** external "core-js/modules/es.symbol" ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.symbol");

/***/ }),

/***/ "core-js/modules/es.symbol.description":
/*!********************************************************!*\
  !*** external "core-js/modules/es.symbol.description" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.symbol.description");

/***/ }),

/***/ "core-js/modules/es.symbol.iterator":
/*!*****************************************************!*\
  !*** external "core-js/modules/es.symbol.iterator" ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/es.symbol.iterator");

/***/ }),

/***/ "core-js/modules/esnext.set.add-all":
/*!*****************************************************!*\
  !*** external "core-js/modules/esnext.set.add-all" ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.add-all");

/***/ }),

/***/ "core-js/modules/esnext.set.delete-all":
/*!********************************************************!*\
  !*** external "core-js/modules/esnext.set.delete-all" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.delete-all");

/***/ }),

/***/ "core-js/modules/esnext.set.difference":
/*!********************************************************!*\
  !*** external "core-js/modules/esnext.set.difference" ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.difference");

/***/ }),

/***/ "core-js/modules/esnext.set.every":
/*!***************************************************!*\
  !*** external "core-js/modules/esnext.set.every" ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.every");

/***/ }),

/***/ "core-js/modules/esnext.set.filter":
/*!****************************************************!*\
  !*** external "core-js/modules/esnext.set.filter" ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.filter");

/***/ }),

/***/ "core-js/modules/esnext.set.find":
/*!**************************************************!*\
  !*** external "core-js/modules/esnext.set.find" ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.find");

/***/ }),

/***/ "core-js/modules/esnext.set.intersection":
/*!**********************************************************!*\
  !*** external "core-js/modules/esnext.set.intersection" ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.intersection");

/***/ }),

/***/ "core-js/modules/esnext.set.is-disjoint-from":
/*!**************************************************************!*\
  !*** external "core-js/modules/esnext.set.is-disjoint-from" ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.is-disjoint-from");

/***/ }),

/***/ "core-js/modules/esnext.set.is-subset-of":
/*!**********************************************************!*\
  !*** external "core-js/modules/esnext.set.is-subset-of" ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.is-subset-of");

/***/ }),

/***/ "core-js/modules/esnext.set.is-superset-of":
/*!************************************************************!*\
  !*** external "core-js/modules/esnext.set.is-superset-of" ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.is-superset-of");

/***/ }),

/***/ "core-js/modules/esnext.set.join":
/*!**************************************************!*\
  !*** external "core-js/modules/esnext.set.join" ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.join");

/***/ }),

/***/ "core-js/modules/esnext.set.map":
/*!*************************************************!*\
  !*** external "core-js/modules/esnext.set.map" ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.map");

/***/ }),

/***/ "core-js/modules/esnext.set.reduce":
/*!****************************************************!*\
  !*** external "core-js/modules/esnext.set.reduce" ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.reduce");

/***/ }),

/***/ "core-js/modules/esnext.set.some":
/*!**************************************************!*\
  !*** external "core-js/modules/esnext.set.some" ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.some");

/***/ }),

/***/ "core-js/modules/esnext.set.symmetric-difference":
/*!******************************************************************!*\
  !*** external "core-js/modules/esnext.set.symmetric-difference" ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.symmetric-difference");

/***/ }),

/***/ "core-js/modules/esnext.set.union":
/*!***************************************************!*\
  !*** external "core-js/modules/esnext.set.union" ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/esnext.set.union");

/***/ }),

/***/ "core-js/modules/web.dom-collections.for-each":
/*!***************************************************************!*\
  !*** external "core-js/modules/web.dom-collections.for-each" ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/web.dom-collections.for-each");

/***/ }),

/***/ "core-js/modules/web.dom-collections.iterator":
/*!***************************************************************!*\
  !*** external "core-js/modules/web.dom-collections.iterator" ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("core-js/modules/web.dom-collections.iterator");

/***/ }),

/***/ "date-fns":
/*!***************************!*\
  !*** external "date-fns" ***!
  \***************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("date-fns");

/***/ }),

/***/ "inputmask-core":
/*!*********************************!*\
  !*** external "inputmask-core" ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("inputmask-core");

/***/ }),

/***/ "jsonld":
/*!*************************!*\
  !*** external "jsonld" ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("jsonld");

/***/ }),

/***/ "jsonld-utils":
/*!*******************************!*\
  !*** external "jsonld-utils" ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("jsonld-utils");

/***/ }),

/***/ "prop-types":
/*!*****************************!*\
  !*** external "prop-types" ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("prop-types");

/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "react" ***!
  \************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react");

/***/ }),

/***/ "react-bootstrap":
/*!**********************************!*\
  !*** external "react-bootstrap" ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react-bootstrap");

/***/ }),

/***/ "react-bootstrap/Card":
/*!***************************************!*\
  !*** external "react-bootstrap/Card" ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react-bootstrap/Card");

/***/ }),

/***/ "react-datepicker":
/*!***********************************!*\
  !*** external "react-datepicker" ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react-datepicker");

/***/ }),

/***/ "react-dom":
/*!****************************!*\
  !*** external "react-dom" ***!
  \****************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react-dom");

/***/ }),

/***/ "react-select":
/*!*******************************!*\
  !*** external "react-select" ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react-select");

/***/ }),

/***/ "react-window":
/*!*******************************!*\
  !*** external "react-window" ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react-window");

/***/ }),

/***/ "regenerator-runtime/runtime":
/*!**********************************************!*\
  !*** external "regenerator-runtime/runtime" ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("regenerator-runtime/runtime");

/***/ }),

/***/ "tsort":
/*!************************!*\
  !*** external "tsort" ***!
  \************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("tsort");

/***/ }),

/***/ "yasgui-yasqe":
/*!*******************************!*\
  !*** external "yasgui-yasqe" ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("yasgui-yasqe");

/***/ })

/******/ });