export default class FormGenerator {
    /**
     * Generates a default form with one-step wizard.
     *
     * @param intl Preferred language of questions
     *
     * @return Form definition (a one-step wizard with one question) and form data
     */
    static constructDefaultForm(intl: any): any[];
    /**
     * Generates form definition from the specified data-enriched template.
     *
     * @param structure The form structure in JSON-LD
     * @param intl Preferred language of questions
     *
     * @return Promise with generated form definition and form data
     */
    static constructForm(structure: any, intl: any): Promise<any>;
    static _constructFormQuestions(structure: any, intl: any): any[];
}
