export default class QuestionAnswerProcessor {
    /**
     * Builds question answer model from the specified wizard data.
     * @param wizardData Global wizard data
     * @param stepData Data from individual wizard steps
     */
    static buildQuestionAnswerModel(wizardData: any, stepData: any): {
        subQuestions: never[];
    };
    /**
     * Transforms the QA hierarchy from JSON-LD-based structure to the object model-based one.
     * @param rootQuestion
     */
    static processQuestionAnswerHierarchy(rootQuestion: any): {
        uri: any;
        origin: any;
        subQuestions: any[];
        answers: any[];
        comments: any[];
    } | null;
    static _processQuestion(question: any): {
        uri: any;
        origin: any;
        subQuestions: any[];
        answers: any[];
        comments: any[];
    };
    static processComment(comment: any): {
        author: any;
        value: any;
        timestamp: any;
    };
    static processAnswer(answer: any): {
        uri: any;
        origin: any;
        codeValue: any;
        textValue: any;
    };
    /**
     * Generates an empty answer for the specified question
     * @param question
     */
    static generateAnswer(question: any): {};
}
