/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.e5xml;

import cz.cvut.kbss.commons.io.NamedStream;
import cz.cvut.kbss.commons.io.zip.ZipSource;
import cz.cvut.kbss.commons.io.zip.ZipSourceEntry;
import cz.cvut.kbss.eccairs.report.e5xml.E5FConstants;
import cz.cvut.kbss.eccairs.report.e5xml.E5XConstants;
import cz.cvut.kbss.eccairs.report.e5xml.E5XMLReportParser;
import cz.cvut.kbss.eccairs.report.e5xml.e5f.E5FXMLParser;
import cz.cvut.kbss.eccairs.report.e5xml.e5x.E5XXMLParser;
import cz.cvut.kbss.eccairs.report.model.EccairsReport;
import cz.cvut.kbss.eccairs.schema.dao.SingeltonEccairsAccessFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.lang.StringUtils;
import org.jooq.lambda.Unchecked;

public class E5XMLLoader {
    protected E5XMLReportParser parser;
    protected Pattern pathPattern;
    protected NamedStream ns;
    protected SingeltonEccairsAccessFactory eaf;

    public E5XMLLoader() {
    }

    public E5XMLLoader(NamedStream ns, SingeltonEccairsAccessFactory eaf) {
        assert (ns != null);
        assert (eaf != null);
        this.ns = ns;
        this.eaf = eaf;
        this.prepareFor(ns);
    }

    public E5XMLLoader prepareFor(NamedStream ns) {
        this.ns = ns;
        if (StringUtils.endsWithIgnoreCase((String)ns.getName(), (String)".e5x")) {
            this.parser = new E5XXMLParser(this.eaf);
            this.pathPattern = E5XConstants.XML_FILE_PATH_PATTERNp;
        } else if (StringUtils.endsWithIgnoreCase((String)ns.getName(), (String)"e5f")) {
            this.parser = new E5FXMLParser(this.eaf);
            this.pathPattern = E5FConstants.XML_FILE_PATH_PATTERNp;
        } else {
            this.parser = null;
            this.pathPattern = null;
        }
        return this;
    }

    public Stream<EccairsReport> loadData() {
        if (this.pathPattern == null) {
            return Stream.of(new EccairsReport[0]);
        }
        return this.loadDataImpl(this.ns, this.parser);
    }

    private Stream<EccairsReport> loadDataImpl(NamedStream ns, E5XMLReportParser parser) {
        return this.e5xmlEntries().map(Unchecked.function(zse -> this.loadReport(zse.getInputStream(), ns.getName() + "/" + zse.getName(), parser)));
    }

    public EccairsReport loadReport(InputStream is, String reportFileName, E5XMLReportParser parser) throws IOException {
        parser.resetParser();
        parser.parseDocument(new NamedStream(reportFileName, (InputStream)new ProxyInputStream(is){

            public void close() {
            }
        }));
        EccairsReport er = parser.getReport();
        er.setOriginalFile(reportFileName);
        return er;
    }

    public Stream<ZipSourceEntry> e5xmlEntries() {
        if (this.pathPattern == null) {
            return Stream.of(new ZipSourceEntry[0]);
        }
        return E5XMLLoader.e5xmlEntriesImpl(this.ns, this.pathPattern);
    }

    public E5XMLReportParser getParser() {
        return this.parser;
    }

    public void setParser(E5XMLReportParser parser) {
        this.parser = parser;
    }

    public Pattern getPathPattern() {
        return this.pathPattern;
    }

    public void setPathPattern(Pattern pathPattern) {
        this.pathPattern = pathPattern;
    }

    public static Stream<ZipSourceEntry> e5xmlEntriesImpl(NamedStream ns, Pattern pathPattern) {
        return ZipSource.wrap((InputStream)ns.getContent()).streamEntries().filter(e -> pathPattern.matcher(e.getName()).matches());
    }
}

