/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ucl;

import cz.cvut.kbss.eccairs.LanguagesMap;
import cz.cvut.kbss.eccairs.Vocabulary;
import cz.cvut.kbss.eccairs.report.model.Context;
import cz.cvut.kbss.eccairs.report.model.EccairsReport;
import cz.cvut.kbss.eccairs.report.model.Value;
import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess;
import cz.cvut.kbss.eccairs.schema.dao.SingeltonEccairsAccessFactory;
import cz.cvut.kbss.jopa.model.EntityManager;
import cz.cvut.kbss.jopa.model.query.Query;
import cz.cvut.kbss.sparql.GenericSparqlBuilder;
import cz.cvut.kbss.ucl.RLPE5XMapperContext;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingEccairsData2Aso
extends GenericSparqlBuilder {
    private static final Logger LOG = LoggerFactory.getLogger((String)MappingEccairsData2Aso.class.getName());
    public static final String ENCODING = "UTF-8";
    public static final String noValueSelected = "http://onto.fel.cvut/ontologies/form/interaction/no_value_selected";
    public static final Long MILISECONDS_PER_DAY = 86400000L;
    protected ThreadLocal<EntityManager> threadLocalEntityManager = new ThreadLocal();
    public static final CharSequenceTranslator ESCAPE_SPARQL = new LookupTranslator((CharSequence[][])new String[][]{{"\\", "\\\\"}, {"\"", "\\\""}, {"'", "\\'"}}).with(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.JAVA_CTRL_CHARS_ESCAPE())});
    protected SingeltonEccairsAccessFactory eaf;
    protected Map<String, String> defaultValues = new HashMap<String, String>();
    private Pattern lastPartOfUriPattern = Pattern.compile("^.+[/#]([^/#]+)$");
    private static final int RANDOM_BOUND = 10000;
    private static final Random RANDOM = new Random();

    public MappingEccairsData2Aso(SingeltonEccairsAccessFactory eaf) {
        this.eaf = eaf;
        this.setDefaultValues();
    }

    protected void setDefaultValues() {
    }

    protected String getDefaultValue(String attributeId) {
        return this.defaultValues.getOrDefault(attributeId, noValueSelected);
    }

    public static String[][] getMappingToAsoTypes() {
        return new String[][]{MappingEccairsData2Aso.arr("48", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Vehicle"), MappingEccairsData2Aso.arr("31", "http://onto.fel.cvut.cz/ontologies/aviation-safety/runway"), MappingEccairsData2Aso.arr("33", "http://onto.fel.cvut.cz/ontologies/ufo/Physical_object"), MappingEccairsData2Aso.arr("22", "http://onto.fel.cvut.cz/ontologies/documentation/logical_record"), MappingEccairsData2Aso.arr("13", "http://onto.fel.cvut.cz/ontologies/ufo/Physical_object"), MappingEccairsData2Aso.arr("28", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Weather"), MappingEccairsData2Aso.arr("2", "http://onto.fel.cvut.cz/ontologies/documentation/report"), MappingEccairsData2Aso.arr("1", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Aerodrome"), MappingEccairsData2Aso.arr("10", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Air_traffic_service"), MappingEccairsData2Aso.arr("9", "http://onto.fel.cvut.cz/ontologies/aviation-safety/air_traffic_management_agent"), MappingEccairsData2Aso.arr("17", "http://onto.fel.cvut.cz/ontologies/ufo/Agent"), MappingEccairsData2Aso.arr("16", "http://onto.fel.cvut.cz/ontologies/aviation/core/license"), MappingEccairsData2Aso.arr("24", "http://onto.fel.cvut.cz/ontologies/ufo/Event"), MappingEccairsData2Aso.arr("24", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Occurrence"), MappingEccairsData2Aso.arr("47", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Runway_incursion"), MappingEccairsData2Aso.arr("34", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Loss_of_Separation"), MappingEccairsData2Aso.arr("35", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Loss_of_Separation")};
    }

    public String getUFOTypesQuery(String version, String context) {
        String[][] types = MappingEccairsData2Aso.getMappingToAsoTypes();
        String vars = MappingEccairsData2Aso.vars("type", "ufoType");
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        List rows = Stream.of(types).map(x -> MappingEccairsData2Aso.row(MappingEccairsData2Aso.uri(ea.getEntityURI(x[0])), MappingEccairsData2Aso.uri(x[1]))).collect(Collectors.toList());
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\n" + String.format("PREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\n", version) + "INSERT {\n" + String.format("    GRAPH <%s>{\n", context) + "       ?entity a ?ufoType.\n    }\n}WHERE{\n" + String.format("    GRAPH <%s>{\n", context) + "        ?entity a ?type.\n        ?entity a e-m:instance.\n    }\n" + MappingEccairsData2Aso.values(vars, rows.toArray()) + "\n}";
        return query;
    }

    public String generateEventsFromTypes(String version, String context) {
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        String[][] data = new String[][]{MappingEccairsData2Aso.arr("14", "390"), MappingEccairsData2Aso.arr("14", "391")};
        String vars = MappingEccairsData2Aso.vars("eventEntity", "eventType");
        List rows = Stream.of(data).map(x -> MappingEccairsData2Aso.row(MappingEccairsData2Aso.uri(ea.getEntityURI(x[0])), MappingEccairsData2Aso.uri(ea.getAttributeURI(x[1])))).collect(Collectors.toList());
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\n" + String.format("PREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\n", version) + "INSERT {\n" + String.format("    GRAPH <%s>{\n", context) + "\t?se a ufo:Event.\n" + String.format("     ?se <%s> ?vt.", "http://onto.fel.cvut.cz/ontologies/reporting-tool/has_event_type") + "\t?se a ?vt.\n\t?occ ufo:has_part ?se.\n    }\n}WHERE{\n" + String.format("    GRAPH <%s>{\n", context) + String.format("       ?occ a <%s>.\n", ea.getEntityURI("24")) + "       ?occ e-m:has-child-instance ?o.\n       ?o a ?eventEntity.\n       ?o e-m:has-child-instance ?x.\n       ?x a ?eventType. \n       ?x e-m:has-value ?v.\n       ?v e-m:has-code-value ?vt.\n       BIND(\n         IF(strstarts(str(?vt),\"http://onto.fel.cvut.cz/ontologies/eccairs/aviation-\"), \n           iri(concat(str(?o), \"-\", replace(str(?vt), \"^.*/v-([^/]*$)\", \"$1\") )), \"\"\n         ) as ?se)\n       \n       BIND(\n         IF(?se=\"\" && strstarts(str(?vt),\"http://onto.fel.cvut.cz/ontologies/cz/ans/tis/event-type/\"), \n           iri(concat(str(?o), \"-\", replace(str(?vt), \"^http://onto.fel.cvut.cz/ontologies/cz/ans/tis/event-type/\", \"\") )), ?se\n         ) as ?se)    }\n" + MappingEccairsData2Aso.values(vars, rows.toArray()) + "\n}";
        return query;
    }

    public String generatePartOfRelationBetweenEvents(String version, String context) {
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\n" + String.format("PREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\n", version) + "INSERT {\n" + String.format("    GRAPH <%s>{\n", context) + "       ?event1 ufo:has_part ?event2.    }\n}WHERE{\n" + String.format("    GRAPH <%s>{\n", context) + "\t?event1 e-m:has-child-instance ?event2.\n\t?event1 a ufo:Event.\n\t?event2 a ufo:Event.\n    }\n}";
        return query;
    }

    public String createAutomatedImporterPerson(String context) {
        return "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\nPREFIX aviation-safety: <http://onto.fel.cvut.cz/ontologies/aviation-safety/>\nPREFIX doc: <http://onto.fel.cvut.cz/ontologies/documentation/>\nINSERT {\n" + String.format("    GRAPH <%s>{\n", context) + String.format("<%s> <%s> <%s>;\n", "http://onto.fel.cvut.cz/ointologies/tools/e5xml-data-importer-0001", RDF.type.toString(), "http://onto.fel.cvut.cz/ontologies/ufo/Person") + String.format(" <%s> \"%s\";\n", "http://xmlns.com/foaf/0.1/firstName", "importer") + String.format(" <%s> \"%s\";\n", "http://xmlns.com/foaf/0.1/lastName", "") + String.format(" <%s> \"%s\";\n", "http://xmlns.com/foaf/0.1/accountName", "e5xml-data-importer-0001") + "    }\n}WHERE{}\n";
    }

    public String fixOccurrenceReport(String version, String context, Context eo) {
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        String reportingdDate = MappingEccairsData2Aso.getTextValConcat(eo, "\n\n", ea.getEntityURI("53"), ea.getAttributeURI("801"));
        if (reportingdDate == null || (reportingdDate = reportingdDate.trim()).isEmpty()) {
            reportingdDate = MappingEccairsData2Aso.getTextValConcat(eo, "\n\n", ea.getAttributeURI("434"));
        }
        reportingdDate = this.checkAndFixDateToStr(reportingdDate, new Date());
        String description = this.createMegedDescription(eo, ea);
        return this.fixOccurrenceReport(eo, version, context, reportingdDate, description, ea);
    }

    protected String createMegedDescription(Context eo, EccairsAccess ea) {
        List narratives = MappingEccairsData2Aso.getDescendentContexts(eo, ea.getEntityURI("22")).collect(Collectors.toList());
        String description = narratives.stream().map(n -> {
            String nt;
            URI nl = MappingEccairsData2Aso.getCodeValFirst(n, ea.getAttributeURI("424"));
            String nlCode = null;
            if (nl != null) {
                String codePrefix;
                String nlUri = nl.toString();
                int index = nlUri.lastIndexOf(codePrefix = "/v-");
                if (index < 0 || index + codePrefix.length() >= nlUri.length()) {
                    LOG.warn("the specified language uri <{}> has an unknown format!", (Object)nlUri);
                } else {
                    String nlc = nlUri.substring(index + codePrefix.length());
                    nlCode = LanguagesMap.languageMap.get(nlc);
                    if (nlCode == null) {
                        LOG.warn("the code in the specified language uri <{}> is unknown!", (Object)nlUri);
                        nlCode = "unknown language";
                    }
                }
            } else {
                LOG.warn("no language uri specified for narrative <{}>!", (Object)n.getUri());
            }
            if (nlCode == null) {
                nlCode = "unspecified language";
            }
            if ((nt = MappingEccairsData2Aso.getTextValFirst(n, ea.getAttributeURI("425"))) != null && !(nt = nt.trim()).isEmpty()) {
                nt = MappingEccairsData2Aso.queryTermCompliantString(nt);
                return String.format("== %s ==\\n%s", nlCode, nt);
            }
            return null;
        }).filter(desc -> desc != null).collect(Collectors.joining("\\n\\n"));
        return description != null && !description.isEmpty() ? description : "Description not specified";
    }

    protected String urlDecodeDate(String date) {
        try {
            return URLDecoder.decode(date, ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error(String.format("The encoding %s is not supported", ENCODING), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    protected String checkAndFixDateToStr(String date, Date def) {
        Date d = this.checkAndFixDate(date, def, TimeZone.getDefault());
        return "" + MappingEccairsData2Aso.dateToInstant(d);
    }

    protected <T> T optionalURLDecodeParsingImpl(Function<String, T> parser, String input, T def) {
        T d;
        String urlDecoded = input;
        if (input.contains("%3A")) {
            urlDecoded = this.urlDecodeDate(input);
        }
        if ((d = parser.apply(urlDecoded)) == null && (d = parser.apply(input)) == null) {
            LOG.trace("Parsing failed, returning default value.");
            d = def;
        }
        return d;
    }

    protected Long checkAndFixTime(String time, Long def, TimeZone tz) {
        return this.optionalURLDecodeParsingImpl(dateString -> RLPE5XMapperContext.parseTime(dateString, tz), time, def);
    }

    protected Date checkAndFixDate(String date, Date def, TimeZone tz) {
        return this.optionalURLDecodeParsingImpl(dateString -> RLPE5XMapperContext.parse(dateString, tz), date, def);
    }

    protected Date checkAndConstructDateAndTime(String date, String time, TimeZone tz) {
        Long t;
        Date d = this.checkAndFixDate(date, null, tz);
        if (d != null && time != null && (t = this.checkAndFixTime(time, 0L, tz)) != null) {
            d.setTime(d.getTime() + t);
        }
        return d;
    }

    public String fixOccurrenceReport(Context eo, String version, String context, String reportingdDate, String description, EccairsAccess ea) {
        String[] aircraftQueryFragments = this.aircraftAndOperator(version, eo);
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\n" + String.format("PREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\n", version) + "PREFIX aviation-safety: <http://onto.fel.cvut.cz/ontologies/aviation-safety/>\nPREFIX doc: <http://onto.fel.cvut.cz/ontologies/documentation/>\nINSERT {\n" + String.format("    GRAPH <%s>{\n", context) + MappingEccairsData2Aso.t("?o", MappingEccairsData2Aso.uri("http://www.w3.org/2000/01/rdf-schema#label"), "?tval") + "\n" + MappingEccairsData2Aso.t("?o", "a", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/aviation-safety/Occurrence")) + "\n" + MappingEccairsData2Aso.t("?o", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/reporting-tool/has_event_type"), "?oc") + "\n" + MappingEccairsData2Aso.t("?o", "a", "?oc") + "\n" + MappingEccairsData2Aso.t("?o", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has_key"), MappingEccairsData2Aso.generateKeyS()) + "\n" + MappingEccairsData2Aso.t("?o", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/aviation-safety/has_location"), "?loc") + "\n" + aircraftQueryFragments[0] + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/created_from"), MappingEccairsData2Aso.uri(context)) + "\n" + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has_file_number"), MappingEccairsData2Aso.generateFileNumberS()) + "\n" + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri(Vocabulary.created), MappingEccairsData2Aso.date(reportingdDate)) + "\n" + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has_revision"), "\"1\"^^xsd:integer") + "\n" + MappingEccairsData2Aso.t("?or", "a", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/occurrence_report")) + "\n" + MappingEccairsData2Aso.t("?or", "a", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/report")) + "\n" + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has_reporting_phase"), MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/not_processed")) + "\n" + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has_key"), MappingEccairsData2Aso.generateKeyS()) + "\n" + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has-author"), MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ointologies/tools/e5xml-data-importer-0001")) + "\n" + (!description.isEmpty() ? MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://purl.org/dc/terms/description"), String.format("\"%s\"", description)) + "\n" : "") + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has_severity_assessment"), "?occCls") + "    }\n}WHERE{\n" + String.format("    GRAPH <%s>{\n", context) + "    {SELECT ?or ?o ?loc ?tval (sample(?occCat)  as ?oc) ?reportingDate ?occCls ?ac ?opOrg{\n" + String.format("?or a <%s>;\n", "http://onto.fel.cvut.cz/ontologies/eccairs/model/eccairs_report") + String.format("    <%s> ?o.\n", "http://onto.fel.cvut.cz/ontologies/documentation/documents") + MappingEccairsData2Aso.optionalEccairsAttributePattern("?o", "?occCat", "430", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-code-value", MappingEccairsData2Aso.uri(noValueSelected), ea) + MappingEccairsData2Aso.optionalEccairsAttributePattern("?o", "?occCls", "431", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-code-value", MappingEccairsData2Aso.uri(noValueSelected), ea) + MappingEccairsData2Aso.optionalEccairsAttributePattern("?o", "?tval", "601", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-text-value", "\"No title\"", ea) + "OPTIONAL {" + MappingEccairsData2Aso.eccairsAttributePattern("?o", "?loc", "440", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-text-value", ea) + "}OPTIONAL{" + String.format("?o <%s> ?rh.\n", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-child-instance") + String.format("?rh a <%s>.\n", ea.getEntityURI("53")) + MappingEccairsData2Aso.eccairsAttributePattern("?rh", "?reportingDate", "801", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-text-value", ea) + "}" + aircraftQueryFragments[1] + "      }GROUP BY ?or ?o ?loc ?tval ?reportingDate ?occCls ?ac ?opOrg\n    }\n  }\n}";
        return query;
    }

    public String[] aircraftAndOperator(String version, Context eo) {
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        String[] ret = new String[]{"", ""};
        boolean constructFragment = false;
        boolean selectFragment = true;
        Context aircraft = MappingEccairsData2Aso.getDescendentContext(eo, ea.getEntityURI("4"));
        if (aircraft != null) {
            String[] aircraftQueryFragments = this.mappingAircraft(version, aircraft);
            String[] operatorQueryFragments = this.mappingOperatorOrganization(version, aircraft);
            ret[0] = ret[0] + aircraftQueryFragments[0] + operatorQueryFragments[0];
            ret[1] = ret[1] + aircraftQueryFragments[1] + operatorQueryFragments[1];
        }
        return ret;
    }

    public String[] mappingAircraft(String version, Context aircraft) {
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        Objects.requireNonNull(aircraft.getUri());
        Context aircraftType = MappingEccairsData2Aso.getDescendentContext(aircraft, ea.getAttributeURI("21"));
        String aircraftTypeUri = null;
        if (aircraftType != null && aircraftType.getValue() != null && !aircraftType.getValue().isEmpty()) {
            Value aircraftTypeValue = aircraftType.getValue().iterator().next();
            if (aircraftTypeValue.getCode() != null && !aircraftTypeValue.getCode().toString().isEmpty()) {
                aircraftTypeUri = aircraftTypeValue.getCode().toString();
            } else if (aircraftTypeValue.getText() != null && !aircraftTypeValue.getText().isEmpty()) {
                String text = aircraftTypeValue.getText();
                text = MappingEccairsData2Aso.queryTermUriCompliantString(text);
                aircraftTypeUri = "http://www.inbas.cz/ontologies/reporting-tool/organizations#" + text;
            }
        }
        return this.constructAircraftQueryFragments(aircraft.getUri(), aircraftTypeUri);
    }

    public String[] constructAircraftQueryFragments(String aircraftUri, String aircraftTypeUri) {
        return new String[]{String.format("?o <%s> ?ac.\n", "http://onto.fel.cvut.cz/ontologies/ufo/has_participant") + String.format("?ac a <%s>.\n", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Aircraft") + (aircraftTypeUri != null ? String.format("?ac a <%s>.\n", aircraftTypeUri) : ""), String.format("BIND(<%s> as ?ac).\n", aircraftUri)};
    }

    public String[] mappingOperatorOrganization(String version, Context aircraft) {
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        Context operator = MappingEccairsData2Aso.getDescendentContext(aircraft, ea.getAttributeURI("215"));
        String opUri = null;
        String opLable = null;
        if (operator != null && operator.getValue() != null && !operator.getValue().isEmpty()) {
            Value ov = operator.getValue().iterator().next();
            if (ov.getCode() != null && (ov.getText() == null || ov.getText().isEmpty())) {
                opUri = ov.getCode().toString();
                if (!opUri.isEmpty() && ((opLable = ea.getValueLabel(opUri)) == null || opLable.isEmpty())) {
                    opLable = this.urlDecode(this.getLastPartOfURI(opUri));
                }
            } else if (ov.getText() != null && !ov.getText().isEmpty()) {
                opLable = StringUtils.capitalize((String)ov.getText().toLowerCase());
                String uriLabel = MappingEccairsData2Aso.urlEncode(opLable);
                opUri = "http://www.inbas.cz/ontologies/reporting-tool/organizations#" + uriLabel;
            }
        }
        if (opUri == null || opLable == null || (opLable = opLable.trim()).isEmpty()) {
            opUri = "http://www.inbas.cz/ontologies/reporting-tool/organizations#Unknown";
            opLable = "Unknown";
        }
        opLable = MappingEccairsData2Aso.queryTermCompliantString(opLable);
        return this.constructOperatorQueryFragments(opUri, opLable);
    }

    public String[] constructOperatorQueryFragments(String opUri, String opLable) {
        String[] ret = new String[]{"", ""};
        boolean constructFragment = false;
        boolean selectFragment = true;
        ret[1] = ret[1] + String.format("BIND(<%s> as ?opOrg)\n", opUri);
        ret[0] = ret[0] + String.format("?ac <%s> ?opOrg.\n", "http://onto.fel.cvut.cz/ontologies/aviation-safety/is_operated_by");
        ret[0] = ret[0] + String.format("?opOrg a <%s>.\n", "http://onto.fel.cvut.cz/ontologies/ufo/Organization");
        ret[0] = ret[0] + String.format("?opOrg a <%s>.\n", "http://onto.fel.cvut.cz/ontologies/aviation-safety/operator_organization");
        if (!this.checkOrganizationExists(opUri)) {
            ret[0] = ret[0] + String.format("?opOrg <%s> \"%s\".\n", "http://www.w3.org/2000/01/rdf-schema#label", opLable);
        }
        return ret;
    }

    protected boolean checkOrganizationExists(String opUri) {
        EntityManager em = this.threadLocalEntityManager.get();
        String checkQuery = String.format("ASK {<%s> <%s> ?x.}", opUri, "http://www.w3.org/2000/01/rdf-schema#label");
        return (Boolean)em.createNativeQuery(checkQuery, Boolean.class).getSingleResult();
    }

    protected String getLastPartOfURI(String uri) {
        Matcher m = this.lastPartOfUriPattern.matcher(uri);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    protected static String queryTermCompliantString(String str) {
        return ESCAPE_SPARQL.translate((CharSequence)str);
    }

    protected static String queryTermUriCompliantString(String str) {
        return MappingEccairsData2Aso.urlEncode(MappingEccairsData2Aso.queryTermCompliantString(str));
    }

    protected static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("URL Encoding a string failed.", (Throwable)ex);
            return str;
        }
    }

    protected String urlDecode(String str) {
        try {
            return URLDecoder.decode(MappingEccairsData2Aso.queryTermCompliantString(str), ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("URL Decoding a string failed.", (Throwable)ex);
            return str;
        }
    }

    @Deprecated
    public String mapNarrativesToDescription(String version, String context, EccairsAccess ea) {
        String query = "SELECT ?languageId ?nt{\n    GRAPH <%2$s>{\n" + String.format("?or a <%s>;\n", "http://onto.fel.cvut.cz/ontologies/eccairs/model/eccairs_report") + String.format("    <%s> ?o.\n", "http://onto.fel.cvut.cz/ontologies/documentation/documents") + String.format("?o <%s> ?ne.\n", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-child-instance") + String.format("?ne a <%s>.\n", ea.getEntityURI("22")) + MappingEccairsData2Aso.eccairsAttributePatternNoVersion("?ne", "?narrativeText", "425", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-text-value") + MappingEccairsData2Aso.eccairsAttributePatternNoVersion("?ne", "?narrativeLanguage", "424", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-code-value") + "BIND(replace(str(?narrativeLanguage), \"^.*/v-([^/]+$)\", \"$1\") as ?languageId)BIND(str(?narrativeText) as ?nt)    }\n}";
        return String.format(query, version, context);
    }

    public String fixMultipleOccurrenceReportDescriptions() {
        return "DELETE {\n  GRAPH ?g{\n    ?s <http://purl.org/dc/terms/description> ?o.\n  }\n}\nINSERT {\n  GRAPH ?g{\n    ?s <http://purl.org/dc/terms/description> ?combinedDescription.\n  }\n}\nWHERE {\n  {SELECT ?g ?s (COUNT(DISTINCT ?o) as ?c) (group_concat(?o; separator = \"\\n\") AS ?combinedDescription){\n      GRAPH ?g {\n" + String.format("        ?s a <%s>.\n", "http://onto.fel.cvut.cz/ontologies/documentation/occurrence_report") + "        ?s <http://purl.org/dc/terms/description> ?o.\n      }\n    }GROUP BY ?g ?s\n  }\n  GRAPH ?g {\n" + String.format("    ?s a <%s>.\n", "http://onto.fel.cvut.cz/ontologies/documentation/occurrence_report") + "    ?s <http://purl.org/dc/terms/description> ?o.\n  }\n}";
    }

    public static String filterByNoVersionValueCode(String valueVar, String valueCode) {
        return String.format("FILTER(regex(str(%s), \"http://onto.fel.cvut.cz/ontologies/eccairs/aviation-.*/v-%s\"))", valueVar, valueCode);
    }

    public static String filterByNoVersionEntityId(String entityVar, String entityId) {
        return String.format("FILTER(regex(str(%s), \"http://onto.fel.cvut.cz/ontologies/eccairs/aviation-.*/e-%s\"))", entityVar, entityId);
    }

    public static String eccairsAttributePatternNoVersion(String entityInstatnce, String valueVar, String attributeId, String attributeType) {
        String attrubibuteVar = "?attribute_" + attributeId + "_var";
        return String.format("%s <%s> [a %s; <%s>[<%s> %s]].\nFILTER(regex(str(%s),\"http://onto.fel.cvut.cz/ontologies/eccairs/aviation-.*/a-%s\"))\n", entityInstatnce, "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-child-instance", attrubibuteVar, "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-value", attributeType, valueVar, attrubibuteVar, attributeId);
    }

    public static String eccairsAttributePattern(String entityInstatnce, String valueVar, String attributeId, String attributeType, EccairsAccess ea) {
        return String.format("%s <%s> [a <%s>; <%s>[<%s> %s]].\n", entityInstatnce, "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-child-instance", ea.getAttributeURI(attributeId), "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-value", attributeType, valueVar);
    }

    public static String optionalEccairsAttributePattern(String entityInstatnce, String valueVar, String attributeId, String attributeType, String defaultValue, EccairsAccess ea) {
        String optionalValueVar = valueVar + "_Optional";
        return String.format("OPTIONAL{\n%s}\n" + (defaultValue != null ? String.format("BIND(IF(bound(%s), %s, %s) as %s)\n", optionalValueVar, optionalValueVar, defaultValue, valueVar) : ""), MappingEccairsData2Aso.eccairsAttributePattern(entityInstatnce, optionalValueVar, attributeId, attributeType, ea));
    }

    public String fixOccurrenceAndEvents(String version, String context, Context eo) {
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        Date startTime = this.constructOccurrenceUTCDate(version, eo, "477", "478");
        if (startTime == null) {
            startTime = this.constructOccurrenceDefualtTimeZoneDate(version, eo, "433", "457");
        }
        if (startTime == null) {
            LOG.debug("start time could not be parsed, using current time.");
            startTime = new Date(0L);
        }
        Instant i1 = MappingEccairsData2Aso.dateToInstant(startTime);
        Instant i2 = i1.plusMillis(1000L);
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\n" + String.format("PREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\n", version) + "PREFIX aviation-safety: <http://onto.fel.cvut.cz/ontologies/aviation-safety/>\nPREFIX doc: <http://onto.fel.cvut.cz/ontologies/documentation/>\nINSERT {\n" + String.format("    GRAPH <%s>{\n", context) + String.format("?e <%s> \"%s\"^^xsd:dateTime;\n", "http://onto.fel.cvut.cz/ontologies/aviation-safety/has_start_time", i1) + String.format(" <%s> \"%s\"^^xsd:dateTime;\n", "http://onto.fel.cvut.cz/ontologies/aviation-safety/has_end_time", i2) + "    }\n}WHERE{\n" + String.format("    GRAPH <%s>{\n", context) + String.format("?e a <%s>;\n", "http://onto.fel.cvut.cz/ontologies/ufo/Event") + "    }\n}";
        return query;
    }

    public Date constructOccurrenceUTCDate(String version, Context eo, String dateAttribute, String timeAttribute) {
        return this.constructOccurrenceDate(version, eo, dateAttribute, timeAttribute, TimeZone.getTimeZone("Z"));
    }

    public Date constructOccurrenceDefualtTimeZoneDate(String version, Context eo, String dateAttribute, String timeAttribute) {
        return this.constructOccurrenceDate(version, eo, dateAttribute, timeAttribute, TimeZone.getDefault());
    }

    public Date constructOccurrenceDate(String version, Context eo, String dateAttribute, String timeAttribute, TimeZone tz) {
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        String occurrenceDate = MappingEccairsData2Aso.getTextValFirst(eo, ea.getAttributeURI(dateAttribute));
        Date startTime = null;
        if (occurrenceDate != null && !occurrenceDate.isEmpty()) {
            occurrenceDate = occurrenceDate.replaceAll("\\.", "-");
            String occurrenceTime = MappingEccairsData2Aso.getTextValFirst(eo, ea.getAttributeURI(timeAttribute));
            startTime = this.checkAndConstructDateAndTime(occurrenceDate, occurrenceTime, tz);
        }
        return startTime;
    }

    public static String[] arr(String ... els) {
        return els;
    }

    public String[] getAllUpdates(EccairsReport r, String context) {
        return new String[]{this.getUFOTypesQuery(r.getTaxonomyVersion(), context), this.generateEventsFromTypes(r.getTaxonomyVersion(), context), this.generatePartOfRelationBetweenEvents(r.getTaxonomyVersion(), context), this.fixOccurrenceReport(r.getTaxonomyVersion(), context, r.getOccurrence()), this.fixOccurrenceAndEvents(r.getTaxonomyVersion(), context, r.getOccurrence()), this.fixMultipleOccurrenceReportDescriptions()};
    }

    public void mapReport(EccairsReport r, EntityManager em, String context) {
        String[] updates;
        this.threadLocalEntityManager.set(em);
        for (String update : updates = this.getAllUpdates(r, context)) {
            Query q = null;
            try {
                q = em.createNativeQuery(update);
            }
            catch (Exception ex) {
                LOG.error("The update query can not be instantiated from the generated query string \n {}", (Object)update);
                throw ex;
            }
            try {
                q.executeUpdate();
            }
            catch (IllegalStateException e) {
                LOG.error("Update query expected \n {}", (Object)update);
                throw e;
            }
        }
    }

    public static Instant dateToInstant(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.toInstant();
    }

    public static String date(String date) {
        return String.format("\"%s\"^^xsd:dateTime", date);
    }

    public static String generateKeyS() {
        String key = Long.toString(System.nanoTime());
        return String.format("\"%s\"@en", "" + key.concat(Integer.toString(RANDOM.nextInt(10000))));
    }

    public static String generateFileNumberS() {
        return String.format("\"%s\"^^xsd:long", "" + System.currentTimeMillis());
    }

    protected static Context getDescendentContext(Context c, String ... path) {
        Optional<Context> ot = MappingEccairsData2Aso.getDescendentContexts(c, path).findFirst();
        if (ot.isPresent()) {
            return ot.get();
        }
        return null;
    }

    protected static Stream<Context> getDescendentContexts(Stream<Context> in, String contextUri) {
        return in.flatMap(x -> x.getContexts().isEmpty() ? Stream.of(x) : MappingEccairsData2Aso.getDescendentContexts(x.getContexts().stream(), contextUri)).filter(x -> x.getContextTypes().contains(contextUri));
    }

    protected static Stream<Context> getDescendentContexts(Context c, String ... path) {
        Stream<Context> s = Stream.of(c);
        for (String uri : path) {
            s = s.flatMap(x -> x.getContexts().stream()).filter(x -> x.getContextTypes().contains(uri));
        }
        return s;
    }

    protected static URI getCodeValFirst(Context c, String ... attributeUri) {
        return MappingEccairsData2Aso.getAttributeValue(c, attributeUri).stream().map(x -> x.getCode()).filter(x -> x != null).findFirst().orElse(null);
    }

    protected static List<URI> getCodeValAll(Context c, String ... attributeUri) {
        return MappingEccairsData2Aso.getAttributeValue(c, attributeUri).stream().map(x -> x.getCode()).filter(x -> x != null).collect(Collectors.toList());
    }

    protected static String getTextValFirst(Context c, String ... attributeUri) {
        return MappingEccairsData2Aso.getAttributeValue(c, attributeUri).stream().map(x -> x.getText()).filter(x -> x != null).findFirst().orElse(null);
    }

    protected static String getTextValConcat(Context c, String sep, String ... attributeUri) {
        return MappingEccairsData2Aso.getAttributeValue(c, attributeUri).stream().map(x -> x.getText()).filter(x -> x != null).collect(Collectors.joining(sep));
    }

    protected static List<Value> getAttributeValue(Context c, String ... attributeUri) {
        Context ctx = MappingEccairsData2Aso.getDescendentContext(c, attributeUri);
        if (ctx != null) {
            return new ArrayList<Value>(ctx.getValue());
        }
        return Collections.EMPTY_LIST;
    }
}

