/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.e5xml.e5x;

import cz.cvut.kbss.commons.io.NamedStream;
import cz.cvut.kbss.commons.utils.URIUtils;
import cz.cvut.kbss.eccairs.cfg.Configuration;
import cz.cvut.kbss.eccairs.report.e5xml.AbstractE5XMLReportLoader;
import cz.cvut.kbss.eccairs.report.e5xml.DataValueUtils;
import cz.cvut.kbss.eccairs.report.e5xml.e5x.E5XTISExtensionParser;
import cz.cvut.kbss.eccairs.report.e5xml.e5x.EntityNameToIdMap;
import cz.cvut.kbss.eccairs.report.model.ConceptTermCollection;
import cz.cvut.kbss.eccairs.report.model.Context;
import cz.cvut.kbss.eccairs.report.model.EccairsReport;
import cz.cvut.kbss.eccairs.report.model.Value;
import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess;
import cz.cvut.kbss.eccairs.schema.dao.SingeltonEccairsAccessFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class E5XXMLParser
extends AbstractE5XMLReportLoader {
    private static final Logger LOG = LoggerFactory.getLogger(E5XXMLParser.class);
    protected static final String reportContextUri = "http://onto.fel.cvut.cz/ontologies/rlp/occurrence-report/";
    protected static final String attrTaxonomyVersion = "TaxonomyVersion";
    protected static final String attrTaxonomyName = "TaxonomyName";
    protected static final String attrAdditionalText = "AdditionalText";
    protected static final String attrAdditionalTextEncoding = "AdditionalTextEncoding";
    protected static final String attrAlternativeText = "AlternativeText";
    protected static final String attrAlternativeTextEncoding = "AlternativeTextEncoding";
    protected static final String attrAttributeId = "attributeId";
    protected static final String attrREF = "REF";
    protected static final String attrID = "ID";
    protected static final String setEl = "SET";
    protected static final String occurrenceEl = "Occurrence";
    protected static final String attributesEl = "ATTRIBUTES";
    protected static final String entitiesEl = "ENTITIES";
    protected static final String linksEl = "LINKS";
    protected static final String plainTextEl = "PLAINTEXT";
    protected static final String encodedTextEl = "ENCODEDTEXT";
    protected static final String entityId = "entityId";
    protected static final String tisFactorsPart = "FACTORS";
    protected static final String VT_PredefinedValueList = "PredefinedValueList";
    protected static final String DT_CodeOrAlternativeText = "Code or Alternative Text";
    protected static final String DT_CodeAndAdditionalText = "Code and Additional Text";
    protected SingeltonEccairsAccessFactory eaf;
    protected EccairsAccess ea;
    protected Stack<SyntaxElement> elementStack = new Stack();
    protected SyntaxElement currentElement;
    protected SyntaxElement parentElement;
    protected EccairsReport report;
    protected ConceptTermCollection evocab;
    protected Map<EntityCacheKey, Context> entityRegistry = new HashMap<EntityCacheKey, Context>();
    protected E5XTISExtensionParser tisParser = new E5XTISExtensionParser(this);

    public E5XXMLParser(SingeltonEccairsAccessFactory eaf) {
        this.eaf = eaf;
    }

    public E5XXMLParser() {
        this(new SingeltonEccairsAccessFactory());
    }

    public SyntaxElement getParentElement() {
        return this.parentElement;
    }

    public SyntaxElement getCurrentElement() {
        return this.currentElement;
    }

    public EccairsAccess getEa() {
        return this.ea;
    }

    @Override
    public void parseDocument(NamedStream ns) throws IOException {
        this.currentStream = ns;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        spf.setNamespaceAware(true);
        try {
            Schema s = Configuration.getConfiguredSchema();
            spf.setSchema(s);
        }
        catch (MalformedURLException | SAXException ex) {
            LOG.error("Could not load ECCAIRS schema. Parsing report without it.", (Throwable)ex);
        }
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(new InputSource(ns.getContent()), (DefaultHandler)this);
        }
        catch (IOException | ParserConfigurationException | SAXException se) {
            se.printStackTrace();
        }
    }

    public SingeltonEccairsAccessFactory getEc() {
        return this.eaf;
    }

    public void setEc(SingeltonEccairsAccessFactory ec) {
        this.eaf = ec;
    }

    @Override
    public void resetParser() {
        this.ea = null;
        this.report = null;
        this.currentElement = null;
        this.parentElement = null;
        this.elementStack = new Stack();
        this.entityRegistry = new HashMap<EntityCacheKey, Context>();
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.createChildContext(qName, attributes);
        qName = qName.toUpperCase();
        if (qName.contains(":")) {
            qName = qName.substring(qName.indexOf(":") + 1);
        }
        switch (qName) {
            case "SET": {
                this.handleSet();
                break;
            }
            case "PLAINTEXT": 
            case "ENCODEDTEXT": 
            case "ENTITIES": 
            case "ATTRIBUTES": 
            case "LINKS": {
                this.setCurrentPart(qName);
                break;
            }
            default: {
                LOG.trace("Processing element with qName = {}", (Object)qName);
                this.handleOtherElements();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.currentElement.type != null) {
            switch (this.currentElement.type) {
                case Attribute: {
                    this.handleAttributeValue();
                    break;
                }
                case Factor: {
                    this.tisParser.handleTISFactorChildElementTextValue();
                }
            }
        }
        this.moveToParentContext();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.currentElement.currentVal != null) {
            this.currentElement.currentVal.append(ch, start, length);
        }
    }

    public void handleOtherElements() {
        if (this.parentElement == null) {
            LOG.warn(String.format("Couldn't parse the file. The root element \"%s\" was not found.", setEl));
            return;
        }
        if (this.parentElement.part == null) {
            LOG.trace(String.format("Couldn't parse an element \"%s\" in the e5xxml file. ", this.parentElement.qName));
            return;
        }
        switch (this.parentElement.part) {
            case "ATTRIBUTES": {
                this.handleAttribute();
                break;
            }
            case "LINKS": 
            case "ENTITIES": {
                this.handleENTITIESChildElements();
                break;
            }
            case "FACTORS": {
                this.tisParser.handleTISFactorChildElement();
            }
        }
        if (this.report.getOccurrence() == null) {
            this.report.setOccurrence(this.currentElement.el);
        }
    }

    protected void setCurrentPart(String part) {
        this.currentElement = this.parentElement;
        this.currentElement.part = part;
    }

    protected void createChildContext() {
        if (this.currentElement != null) {
            this.parentElement = this.elementStack.push(this.currentElement);
        }
        this.currentElement = new SyntaxElement();
    }

    protected void createChildContext(String qName, Attributes attributes) {
        this.createChildContext();
        this.currentElement.qName = qName;
        this.currentElement.attributes = attributes;
    }

    protected void moveToParentContext() {
        this.currentElement = this.parentElement;
        if (!this.elementStack.isEmpty()) {
            this.elementStack.pop();
            if (!this.elementStack.isEmpty()) {
                this.parentElement = this.elementStack.peek();
            }
        }
    }

    public void handleSet() {
        if (this.isPrintable(this.currentElement.qName) && this.currentElement.qName.equalsIgnoreCase(setEl)) {
            this.report = new EccairsReport();
            this.report.setTaxonomyName(this.currentElement.attributes.getValue(attrTaxonomyName));
            this.report.setTaxonomyVersion(this.currentElement.attributes.getValue(attrTaxonomyVersion));
            String eccVersion = this.currentElement.attributes.getValue(attrTaxonomyVersion);
            if (this.isPrintable(eccVersion)) {
                this.ea = this.eaf.getEccairsVersionOrDefault(eccVersion);
                LOG.trace("Setting report ECCAIRS schema, old value = '{}', new value='{}'", (Object)this.report.getTaxonomyVersion(), (Object)this.ea.getEccairsVersion());
                this.report.setTaxonomyVersion(this.ea.getEccairsVersion());
            }
            this.evocab = new ConceptTermCollection();
            this.evocab.setUri(this.ea != null ? this.ea.getUri() : this.eaf.getConfiguration().getEccairsContext(""));
            this.evocab.setName(this.report.getTaxonomyName());
            this.report.getVocabulariesSafe().add(this.evocab);
            this.currentElement.part = entitiesEl;
        }
    }

    protected String getEntityId() {
        try {
            String eid;
            Schema s = Configuration.getConfiguredSchema();
            if (s != null && (eid = this.currentElement.attributes.getValue(entityId)) != null) {
                return eid;
            }
        }
        catch (MalformedURLException | SAXException ex) {
            LOG.error("Could not load ECCAIRS schema.", (Throwable)ex);
        }
        return EntityNameToIdMap.getId(this.currentElement.qName);
    }

    protected String getEntityTypeId() {
        String eid = this.getEntityId();
        return !Objects.isNull(eid) ? eid : (this.ea != null ? this.ea.getEntityId(this.currentElement.qName.replace("_", " ")) : null);
    }

    protected String getEntityTypeURI() {
        String uri;
        String id = this.getEntityTypeId();
        if (id != null) {
            uri = this.ea.getEntityURI(id);
        } else {
            uri = this.createUnknownTermUri(reportContextUri, "context");
            this.currentElement.unknownTerm = true;
        }
        return uri;
    }

    protected String getEccairsEntityInstanceKey() {
        String eccairsEntityInstanceKey = null;
        switch (this.parentElement.part) {
            case "LINKS": {
                eccairsEntityInstanceKey = this.currentElement.attributes.getValue(attrREF);
                if (eccairsEntityInstanceKey != null) break;
                LOG.warn("reference to the entity with qName = <{}> was not found!", (Object)this.currentElement.qName);
                break;
            }
            case "ENTITIES": {
                eccairsEntityInstanceKey = this.currentElement.attributes.getValue(attrID);
            }
        }
        return eccairsEntityInstanceKey;
    }

    public String getAttributeTypeId() {
        return this.currentElement.attributes.getValue(attrAttributeId);
    }

    public String getAttributeTypeUri() {
        String uri;
        String id = this.getAttributeTypeId();
        if (id != null) {
            uri = this.ea.getAttributeURI(id);
        } else {
            uri = this.createUnknownTermUri(reportContextUri, "context");
            this.currentElement.unknownTerm = true;
        }
        return uri;
    }

    public String createUnknownTermUri(String prefix, String type) {
        return URIUtils.getUniqueURI((String)prefix, (String)type);
    }

    protected void flagTermUnknownToEccairs(Context ctx, String label) {
        ctx.setLabel(label);
        this.evocab.getUnknownTerms().add(ctx.getUri());
    }

    protected void handleENTITIESChildElements() {
        if (this.tisParser.acceptENTITIESElemnt()) {
            this.tisParser.handleTISFacotrsElement();
        } else {
            this.handleEntity();
        }
    }

    public void handleEntity() {
        Context entity;
        String instanceId = this.getEccairsEntityInstanceKey();
        String entityTypeURI = this.getEntityTypeURI();
        if (instanceId != null && !(instanceId = instanceId.trim()).isEmpty()) {
            EntityCacheKey key = new EntityCacheKey(instanceId, entityTypeURI);
            entity = this.entityRegistry.get(key);
            if (entity == null) {
                entity = new Context();
                entity.setEccairsKey(instanceId);
                this.entityRegistry.put(key, entity);
            }
        } else {
            entity = new Context();
        }
        this.currentElement.el = entity;
        this.currentElement.el.setContextType(entityTypeURI);
        if (this.parentElement.el != null) {
            this.parentElement.el.addContext(this.currentElement.el);
        }
    }

    public void handleAttribute() {
        this.currentElement.el = new Context();
        String attributeTypeUri = this.getAttributeTypeUri();
        this.currentElement.el.setContextType(attributeTypeUri);
        this.currentElement.currentVal = new StringBuffer();
        this.currentElement.type = ElementType.Attribute;
        if (this.currentElement.unknownTerm) {
            this.flagTermUnknownToEccairs(this.currentElement.el, this.currentElement.qName);
        }
        if (this.parentElement.el != null) {
            this.parentElement.el.addContext(this.currentElement.el);
        }
    }

    public void handleAttributeValue() {
        if (this.currentElement.currentVal != null) {
            String valueType;
            Value v = null;
            String elementTextContent = this.getTextContentValue();
            String string = valueType = !this.currentElement.unknownTerm ? this.ea.getValueType(this.currentElement.el.getContextType()) : null;
            if (VT_PredefinedValueList.equals(valueType)) {
                String predefinedValueId = this.ea.getValueURI(this.currentElement.el.getContextType(), elementTextContent);
                if (predefinedValueId != null) {
                    v = new Value();
                    v.setCode(predefinedValueId);
                }
                String dataType = this.ea.getDataType(this.currentElement.el.getContextType());
                String text = null;
                if (null != dataType) {
                    switch (dataType) {
                        case "Code and Additional Text": {
                            text = this.getDecodedAdditionalText();
                            break;
                        }
                        case "Code or Alternative Text": {
                            text = this.getDecodedAlternativeText();
                        }
                    }
                }
                if (text != null) {
                    if (v == null) {
                        v = new Value();
                    }
                    v.setText(text);
                }
            } else if (this.isPrintable(elementTextContent)) {
                v = new Value();
                v.setText(elementTextContent);
            }
            if (v != null) {
                this.currentElement.el.getValue().add(v);
            }
        }
    }

    protected String getDecodedAdditionalText() {
        return this._getDecodedAttributeText(attrAdditionalText, attrAdditionalTextEncoding);
    }

    protected String getDecodedAlternativeText() {
        return this._getDecodedAttributeText(attrAlternativeText, attrAlternativeTextEncoding);
    }

    private String _getDecodedAttributeText(String attrName, String encodingAttrName) {
        String text = this.currentElement.attributes.getValue(attrName);
        String attrEncoding = this.currentElement.attributes.getValue(encodingAttrName);
        if (attrEncoding != null && StringUtils.equalsIgnoreCase((CharSequence)attrEncoding, (CharSequence)"http://www.w3.org/2001/XMLSchema/base64Binary")) {
            text = DataValueUtils.base64Decode(text);
        }
        return text;
    }

    protected String getTextContentValue() {
        String elementTextContent = this.currentElement.currentVal.toString().trim();
        this.currentElement.currentVal = null;
        if (this.currentElement.part != null && StringUtils.equalsIgnoreCase((CharSequence)this.currentElement.part, (CharSequence)encodedTextEl)) {
            elementTextContent = DataValueUtils.base64Decode(elementTextContent);
        }
        return elementTextContent;
    }

    protected boolean isPrintable(String s) {
        return s != null && !s.trim().isEmpty();
    }

    @Override
    public EccairsReport getReport() {
        return this.report;
    }

    private static class EntityCacheKey {
        private final String eccairsId;
        private final String entityType;

        public EntityCacheKey(String eccairsId, String entityType) {
            this.eccairsId = eccairsId;
            this.entityType = entityType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EntityCacheKey)) {
                return false;
            }
            EntityCacheKey that = (EntityCacheKey)o;
            return this.eccairsId.equals(that.eccairsId) && Objects.equals(this.entityType, that.entityType);
        }

        public int hashCode() {
            return Objects.hash(this.eccairsId, this.entityType);
        }
    }

    public static class SyntaxElement {
        public ElementType type;
        public Context el;
        public String part;
        public Attributes attributes;
        public String qName;
        public StringBuffer currentVal;
        public boolean unknownTerm = false;
    }

    public static enum ElementType {
        Entity,
        Attribute,
        Factor;

    }
}

