/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.schema.rit.processing;

import cz.cvut.kbss.commons.utils.PoiUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RITCoversionTool {
    protected static Model m;
    protected Property hasChild;
    protected Resource ont;
    protected Resource doc;
    protected Resource group;
    protected Resource entity;
    protected Resource cat1;
    protected Resource cat2;
    protected Property eccusage;
    protected Property attributeRemarks;
    protected String docpref = "http://onto.fel.cvut.cz/ontologies/documentation/";
    protected String ECCAIRSBASE = "http://onto.fel.cvut.cz/ontologies/eccairs/aviation-";
    protected String ECCAIRSMODEL = "http://onto.fel.cvut.cz/ontologies/eccairs/model/";
    protected String eccpref;
    protected String ritbaseTemplate = "http://onto.fel.cvut.cz/ontologies/aviation/rit-";
    protected String ritbase = "http://onto.fel.cvut.cz/ontologies/aviation/rit-";
    protected String ritmodel = "http://onto.fel.cvut.cz/ontologies/aviation/rit/model/";
    protected String ritpref;
    protected String attrpref;

    public void initModel(String label, String version) {
        this.ritbase = this.ritbaseTemplate + version;
        this.ritpref = this.ritbase + "/";
        m = ModelFactory.createDefaultModel();
        m.setNsPrefix("e-m", this.ECCAIRSMODEL);
        m.setNsPrefix("e-a-" + version, this.ECCAIRSBASE + version + "/");
        m.setNsPrefix("rit-m", this.ritmodel);
        m.setNsPrefix("rit-" + version, this.ritpref);
        m.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        m.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        m.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.hasChild = m.createProperty(this.ritmodel + "has_child");
        this.hasChild.addProperty(RDF.type, (RDFNode)OWL2.ObjectProperty);
        this.doc = m.getResource(this.ritbase);
        this.doc.addProperty(RDF.type, (RDFNode)OWL2.Ontology);
        this.doc.addProperty(RDFS.label, label);
        this.doc.addProperty(RDFS.comment, "Compiled from file rit-fields-for-european-occurrence-report-set.xlsx.");
        this.doc.addProperty(OWL2.versionIRI, this.ritbase);
        this.group = this.createTypeContext("group", "group");
        this.entity = this.createTypeContext("entity", "entity");
        this.cat1 = this.createTypeContext("cat1", "cat1");
        this.cat2 = this.createTypeContext("cat2", "cat2");
        this.eccpref = this.ECCAIRSBASE + version + "/";
        this.eccusage = m.createProperty(this.ritpref + "ecc_usage");
        this.eccusage.addProperty(RDF.type, (RDFNode)OWL2.DatatypeProperty);
        this.eccusage.addProperty(RDFS.label, "ECR Use", "en");
        this.eccusage.addProperty(RDFS.comment, "The use of rit attributes in occurrence reports found in the ECCAIRS information system.", "en");
        this.attributeRemarks = m.createProperty(this.ritpref + "remarks");
        this.attributeRemarks.addProperty(RDF.type, (RDFNode)OWL2.DatatypeProperty);
        this.attributeRemarks.addProperty(RDFS.label, "Remarks", "en");
        this.attrpref = this.eccpref + "a-";
    }

    public Model getModel() {
        return m;
    }

    protected Resource createTypeContext(String localURI, String name) {
        Resource res = m.createResource(this.ritmodel + localURI);
        res.addProperty(RDF.type, (RDFNode)OWL2.Class);
        res.addProperty(RDFS.label, name, "en");
        return res;
    }

    public void transform(Sheet s) throws IOException {
        Iterator iter = s.iterator();
        iter.next();
        HashMap<String, Resource> groups = new HashMap<String, Resource>();
        HashMap<String, Resource> enties = new HashMap<String, Resource>();
        HashMap<String, Resource> cats1 = new HashMap<String, Resource>();
        HashMap<String, Resource> cats2 = new HashMap<String, Resource>();
        while (iter.hasNext()) {
            Row r = (Row)iter.next();
            Resource attr = this.getAttribute(PoiUtils.getAsString((Cell)r.getCell(1)), PoiUtils.getAsString((Cell)r.getCell(0)), PoiUtils.getAsString((Cell)r.getCell(5)), PoiUtils.getAsString((Cell)r.getCell(4)));
            Resource g = this.processContext(attr, PoiUtils.getAsString((Cell)r.getCell(2)), "group", this.group, groups);
            Resource e = this.processContext(attr, PoiUtils.getAsString((Cell)r.getCell(3)), "entity", this.entity, enties);
            Resource c1 = this.processContext(attr, PoiUtils.getAsString((Cell)r.getCell(6)), "cat1", this.cat1, cats1);
            Resource c2 = this.processContext(attr, PoiUtils.getAsString((Cell)r.getCell(7)), "cat2", this.cat2, cats2);
            if (c2 == null) continue;
            c1.addProperty(this.hasChild, (RDFNode)c2);
        }
    }

    public Resource processContext(Resource attr, String name, String ctxTypeLabel, Resource ctxType, Map<String, Resource> container) {
        if (name.isEmpty()) {
            return null;
        }
        String pref = this.ritpref + ctxTypeLabel + "-";
        Resource ctx = container.get(name);
        if (ctx == null) {
            ctx = m.createResource(pref + name.replaceAll("[^\\d\\w]", "_"));
            ctx.addProperty(RDF.type, (RDFNode)OWL2.NamedIndividual);
            ctx.addProperty(RDF.type, (RDFNode)ctxType);
            ctx.addProperty(RDFS.label, name, "en");
        }
        ctx.addProperty(this.hasChild, (RDFNode)attr);
        return ctx;
    }

    public Resource getAttribute(String name, String id, String remarks, String usage) {
        Resource a = m.createResource(this.attrpref + id);
        a.addProperty(RDF.type, (RDFNode)OWL2.NamedIndividual);
        a.addProperty(RDFS.label, id + " - " + name, "en");
        if (remarks != null && !remarks.isEmpty()) {
            a.addProperty(this.attributeRemarks, remarks, "en");
        }
        if (usage != null && !usage.isEmpty()) {
            a.addProperty(this.eccusage, usage);
        }
        return a;
    }

    public static File getRitVersionDir(String ritBaseDir, String version) throws IOException {
        File p;
        File file = new File(String.format("%s\\rit-%s\\rit-%s.ttl", ritBaseDir, version, version));
        if (!file.exists() && (p = file.getParentFile()) != null && !p.exists()) {
            p.mkdirs();
        }
        return file;
    }

    public static void main(String[] args) throws IOException {
        String ritBaseDir = "c:\\Users\\user\\Documents\\skola\\projects\\inbas\\code\\inbas-model\\vocabularies\\rit\\";
        File f = new File("c:\\Users\\user\\Documents\\skola\\projects\\inbas\\rit\\rit-plain-attributes-contexts.xlsx");
        XSSFWorkbook myWorkBook = new XSSFWorkbook((InputStream)new FileInputStream(f));
        Model m = RITCoversionTool.processSheet(myWorkBook.getSheetAt(0), "Reduced Inerface Taxonomy", "1.3.0.8");
        FileOutputStream fos = new FileOutputStream(RITCoversionTool.getRitVersionDir(ritBaseDir, "1.3.0.8"));
        m.write((OutputStream)fos, "TTL");
        m = RITCoversionTool.processSheet(myWorkBook.getSheetAt(1), "Reduced Inerface Taxonomy", "2.4.0.0");
        fos = new FileOutputStream(RITCoversionTool.getRitVersionDir(ritBaseDir, "2.4.0.0"));
        m.write((OutputStream)fos, "TTL");
        m = RITCoversionTool.processSheet(myWorkBook.getSheetAt(0), "Reduced Inerface Taxonomy", "3.4.0.2");
        fos = new FileOutputStream(RITCoversionTool.getRitVersionDir(ritBaseDir, "3.4.0.2"));
        m.write((OutputStream)fos, "TTL");
    }

    public static Model processSheet(Sheet s, String label, String version) throws IOException {
        RITCoversionTool t = new RITCoversionTool();
        t.initModel(label, version);
        t.transform(s);
        return t.getModel();
    }

    public static Resource reify(Model m, Resource s, Property p, RDFNode v) {
        Resource axiom = m.createResource(OWL2.Axiom);
        axiom.addProperty(OWL2.annotatedSource, (RDFNode)s);
        axiom.addProperty(OWL2.annotatedProperty, (RDFNode)p);
        axiom.addProperty(OWL2.annotatedTarget, v);
        return axiom;
    }
}

