/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.cfg;

import cz.cvut.kbss.eccairs.schema.dao.SingeltonEccairsAccessFactory;
import cz.cvut.kbss.eccairs.schema.dao.cfg.EccairsAccessConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Configuration {
    private static final Logger LOG = LoggerFactory.getLogger((String)Configuration.class.getName());
    private static final String E5X_SCHEMA = "";
    public static final String SCHEMA_LANGUAGE = "W3C XML Schema 1.0";
    private static final String ECCAIRS_XSD_URL = "http://eccairsportal.jrc.ec.europa.eu/ECCAIRS5_dataBridge.xsd";
    private static final String ECCAIRS_XSD_FILE = "eccairs_schema/ECCAIRS5_dataBridge.xsd";
    public static SingeltonEccairsAccessFactory eaf = Configuration.getEccairAccessFactory();
    private static Properties configProperties;
    private static Schema eccairsSchema;

    private static synchronized Properties getConfigProperties(String onClasspath) {
        if (configProperties == null) {
            configProperties = Configuration.loadConfigProperties(onClasspath);
        }
        return configProperties;
    }

    private static Properties loadConfigProperties(String onClasspath) {
        try {
            InputStream is = Configuration.class.getResourceAsStream(onClasspath);
            Properties p = new Properties();
            p.load(is);
            return p;
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
            return null;
        }
    }

    public static SingeltonEccairsAccessFactory getEccairAccessFactory() {
        return Configuration.getEccairAccessFactory("/eccairs-tools-config.properties");
    }

    public static SingeltonEccairsAccessFactory getEccairAccessFactory(String propertiesOnClassPath) {
        if (eaf == null) {
            eaf = new SingeltonEccairsAccessFactory();
            eaf.setConfiguration(new EccairsAccessConfiguration(Configuration.getConfigProperties(propertiesOnClassPath)));
        }
        return eaf;
    }

    public static synchronized Schema getConfiguredSchema() throws MalformedURLException, SAXException {
        if (eccairsSchema == null) {
            eccairsSchema = Configuration.loadSchema();
        }
        return eccairsSchema;
    }

    private static Schema loadSchema() throws SAXException, MalformedURLException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL xsdFileUrl = Configuration.class.getClassLoader().getResource(ECCAIRS_XSD_FILE);
        if (xsdFileUrl == null) {
            LOG.warn("Schema file {} not found. Trying to load it from URL {}.", (Object)ECCAIRS_XSD_FILE, (Object)ECCAIRS_XSD_URL);
            return sf.newSchema(new URL(ECCAIRS_XSD_URL));
        }
        return sf.newSchema(xsdFileUrl);
    }

    public static void main(String[] args) throws Exception {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setValidating(false);
        parserFactory.setNamespaceAware(true);
        Schema s = Configuration.getConfiguredSchema();
        parserFactory.setSchema(s);
        SAXParser parser = parserFactory.newSAXParser();
        parser.parse(new File("d:\\downloads\\CD3C2049DD15E611B897002655546824\\CD3C2049DD15E611B897002655546824.xml"), new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                System.out.println(uri + "/" + localName);
            }
        });
    }
}

