/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.e5xml;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataValueUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DataValueUtils.class);
    public static final String BASE64BINARY = "http://www.w3.org/2001/XMLSchema/base64Binary";
    public static final String ECCAIRS_ENCODING = "x-UTF-16LE-BOM";
    public static final String DEFAULT_ENCODING = "UTF-8";

    public static String urlDecode(String input) {
        return DataValueUtils.urlDecode(input, DEFAULT_ENCODING);
    }

    public static String urlDecode(String input, String encoding) {
        try {
            return URLDecoder.decode(input, encoding);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error(String.format("Encoding %s not supported", encoding), (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            LOG.trace(String.format("The input string \"%s\"is not URL encoded.", input), (Throwable)ex);
        }
        return input;
    }

    public static String base64Decode(String input) {
        return DataValueUtils.base64Decode(input, DEFAULT_ENCODING);
    }

    public static String eccairsBase64Decode(String input) {
        return DataValueUtils.base64Decode(input, ECCAIRS_ENCODING);
    }

    public static String base64Decode(String input, String encoding) {
        String ret = input;
        try {
            ret = new String(Base64.getDecoder().decode(input), encoding);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error(String.format("Encoding %s not supported", encoding), (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            LOG.trace(String.format("The string %s is not base64 encoded.", input), (Throwable)ex);
        }
        return ret;
    }
}

