/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.e5xml.e5f;

import cz.cvut.kbss.eccairs.report.e5xml.DataValueUtils;
import cz.cvut.kbss.eccairs.report.e5xml.e5f.E5FXMLParser;
import cz.cvut.kbss.eccairs.report.model.Value;
import cz.cvut.kbss.eccairs.schema.dao.SingeltonEccairsAccessFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E5FXMLParserEccairs
extends E5FXMLParser {
    private static final Logger LOG = LoggerFactory.getLogger(E5FXMLParserEccairs.class);
    private RTFEditorKit rtfEditorKit = new RTFEditorKit();

    public E5FXMLParserEccairs(SingeltonEccairsAccessFactory eaf) {
        super(eaf);
    }

    public E5FXMLParserEccairs() {
    }

    @Override
    protected Value setTextValue(Value v, String val) {
        String txt;
        if ((v = super.setTextValue(v, val)) != null && (txt = v.getText()) != null && !txt.isEmpty()) {
            txt = DataValueUtils.eccairsBase64Decode(txt);
            txt = this.parseRTFOrReturnUnchanged(txt);
            txt = DataValueUtils.urlDecode(txt);
            v.setText(txt);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseRTFOrReturnUnchanged(String rtf) {
        InputStream is = null;
        try {
            is = IOUtils.toInputStream((String)rtf, (String)"UTF-8");
            Document d = this.rtfEditorKit.createDefaultDocument();
            this.rtfEditorKit.read(is, d, 0);
            if (d.getLength() > 0) {
                String str = d.getText(0, d.getLength());
                String string = str = str.trim();
                return string;
            }
        }
        catch (IOException ex) {
            LOG.trace(String.format("parseRTFOrReturnUnchanged failed to parse string \"%s\"", rtf), (Throwable)ex);
        }
        catch (BadLocationException ex) {
            LOG.trace(String.format("parseRTFOrReturnUnchanged \"bad document location\" (wrong index in document) for string \"%s\"", rtf), (Throwable)ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                LOG.trace("parseRTFOrReturnUnchanged can not close stream", (Throwable)ex);
            }
        }
        return rtf;
    }
}

