/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.e5xml.e5x;

import cz.cvut.kbss.eccairs.report.e5xml.e5x.E5XXMLParser;
import cz.cvut.kbss.eccairs.report.model.Context;
import cz.cvut.kbss.eccairs.report.model.Value;
import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E5XTISExtensionParser {
    private static final Logger LOG = LoggerFactory.getLogger(E5XTISExtensionParser.class);
    public static final String TISFactorsElement = "Factors";
    public static final String ATCContributingFactorElement = "ATCContributingFactor";
    public static final String ATCMitigatingFactorElement = "ATCMitigatingFactor";
    public static final String PilotContributingFactorElement = "PilotContributingFactor";
    public static final String TISFactorURI = "http://onto.fel.cvut.cz/ontologies/cz/ans/tis/factor";
    public static final String ATCContributingFactorURI = "http://onto.fel.cvut.cz/ontologies/cz/ans/tis/atc-contributing-factor";
    public static final String ATCMitigatingFactorURI = "http://onto.fel.cvut.cz/ontologies/cz/ans/tis/atc-mitigating-factor";
    public static final String PilotContributingFactorURI = "http://onto.fel.cvut.cz/ontologies/cz/ans/tis/pilot-contributing-factor";
    public static final String TISFactorBaseURI = "http://onto.fel.cvut.cz/ontologies/cz/ans/tis/event-type/";
    public static final String EccairsEventsID = "14";
    public static final String EccairsEventTypeID = "390";
    protected static Map<String, String> eventTypeMap = new HashMap<String, String>();
    private E5XXMLParser parentParser;
    protected EccairsAccess ea;

    public E5XTISExtensionParser(E5XXMLParser parentParser) {
        this.parentParser = parentParser;
    }

    public E5XTISExtensionParser() {
    }

    public boolean acceptENTITIESElemnt() {
        E5XXMLParser.SyntaxElement currentElement = this.parentParser.getCurrentElement();
        return TISFactorsElement.equals(currentElement.qName);
    }

    public void handleTISFacotrsElement() {
        if (this.ea == null) {
            this.ea = this.parentParser.getEa();
        }
        E5XXMLParser.SyntaxElement parentElement = this.parentParser.getParentElement();
        E5XXMLParser.SyntaxElement currentElement = this.parentParser.getCurrentElement();
        currentElement.el = parentElement.el;
        currentElement.part = "FACTORS";
    }

    public void handleTISFactorChildElement() {
        E5XXMLParser.SyntaxElement parentElement = this.parentParser.getParentElement();
        E5XXMLParser.SyntaxElement currentElement = this.parentParser.getCurrentElement();
        currentElement.type = E5XXMLParser.ElementType.Factor;
        currentElement.currentVal = new StringBuffer();
    }

    public void handleTISFactorChildElementTextValue() {
        E5XXMLParser.SyntaxElement parentElement = this.parentParser.getParentElement();
        E5XXMLParser.SyntaxElement currentElement = this.parentParser.getCurrentElement();
        String eccairsEventsURI = this.ea.getEntityURI(EccairsEventsID);
        String eccairsEventTypeURI = this.ea.getAttributeURI(EccairsEventTypeID);
        Context event = new Context();
        parentElement.el.addContext(event);
        HashSet<String> types = new HashSet<String>();
        event.setContextTypes(types);
        types.add(eccairsEventsURI);
        types.add(TISFactorURI);
        Context eventType = new Context();
        event.addContext(eventType);
        types = new HashSet();
        eventType.setContextTypes(types);
        types.add(eccairsEventTypeURI);
        String factorUri = eventTypeMap.get(currentElement.qName);
        if (factorUri != null) {
            types.add(factorUri);
        } else {
            LOG.warn("Could not resolve uri for the given tis factor element name {}.", (Object)currentElement.qName);
        }
        if (currentElement.currentVal != null && currentElement.currentVal.length() > 0) {
            try {
                String val = currentElement.currentVal.toString();
                StringBuilder path = new StringBuilder();
                for (String comp : val.split("/")) {
                    path.append("/").append(URLEncoder.encode(comp.trim(), "UTF-8"));
                }
                Value value = new Value();
                value.setCode(URI.create(TISFactorBaseURI + path.substring(1)));
                value.setCodeLabel(val);
                eventType.getValue().add(value);
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("Error url decoding a TIS factor label", (Throwable)ex);
            }
        }
    }

    static {
        eventTypeMap.put(ATCContributingFactorElement, ATCContributingFactorURI);
        eventTypeMap.put(ATCMitigatingFactorElement, ATCMitigatingFactorURI);
        eventTypeMap.put(PilotContributingFactorElement, PilotContributingFactorURI);
    }
}

