/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.model.dao;

import cz.cvut.kbss.eccairs.report.model.ConceptTermCollection;
import cz.cvut.kbss.eccairs.report.model.Context;
import cz.cvut.kbss.eccairs.report.model.EccairsReport;
import cz.cvut.kbss.eccairs.report.model.Identifiable;
import cz.cvut.kbss.eccairs.report.model.Value;
import cz.cvut.kbss.jopa.model.EntityManager;
import cz.cvut.kbss.jopa.model.descriptors.Descriptor;
import cz.cvut.kbss.jopa.model.descriptors.EntityDescriptor;
import cz.cvut.kbss.jopa.model.query.TypedQuery;
import cz.cvut.kbss.ucl.MappingEccairsData2Aso;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EccairsReportDao {
    private static final Logger LOG = LoggerFactory.getLogger(EccairsReportDao.class);
    protected EntityManager em;
    protected Set processed = new HashSet();

    public EccairsReportDao(EntityManager em) {
        this.em = em;
    }

    public String getQueryFindByReportingEntityAndEntityFileNumber(String reportingEntity, String fileNumber) {
        String reportingEntityVar = "?reportingEntity";
        String rhTypeVar = "?rhTypeVar";
        String query = "SELECT ?or{\n" + String.format("?or a <%s>;\n", "http://onto.fel.cvut.cz/ontologies/eccairs/model/eccairs_report") + String.format("    <%s> ?o.\n", "http://onto.fel.cvut.cz/ontologies/documentation/documents") + String.format("?o <%s> ?rh.\n", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-child-instance") + String.format("?rh a %s.\n", rhTypeVar) + MappingEccairsData2Aso.filterByNoVersionEntityId(rhTypeVar, "53") + MappingEccairsData2Aso.eccairsAttributePatternNoVersion("?rh", reportingEntityVar, "447", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-code-value") + MappingEccairsData2Aso.filterByNoVersionValueCode(reportingEntityVar, reportingEntity) + MappingEccairsData2Aso.eccairsAttributePatternNoVersion("?rh", "\"" + fileNumber + "\"@en", "438", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-text-value") + String.format("FILTER NOT EXISTS{?or a <%s>.}", "http://onto.fel.cvut.cz/ontologies/reporting-tool/model/report-from-eccairs-system") + "\n\n}";
        LOG.trace(query);
        return query;
    }

    public EccairsReport findByQuery(String query) {
        this.em.getTransaction().begin();
        TypedQuery q = this.em.createNativeQuery(query, EccairsReport.class);
        EccairsReport report = (EccairsReport)q.getSingleResult();
        this.em.getTransaction().commit();
        return report;
    }

    public List<EccairsReport> findByEccairsKey(String key) {
        this.em.getTransaction().begin();
        TypedQuery q = this.em.createNativeQuery("SELECT ?r {?r a ?eccairsReport. ?r ?hasEccairsKey ?key.}", EccairsReport.class);
        q.setParameter("eccairsReport", (Object)URI.create("http://onto.fel.cvut.cz/ontologies/eccairs/model/eccairs_report"));
        q.setParameter("hasEccairsKey", (Object)URI.create("http://onto.fel.cvut.cz/ontologies/eccairs/model/has-id"));
        q.setParameter("key", key, "en");
        List ret = q.getResultList();
        this.em.getTransaction().commit();
        return ret != null ? ret : Collections.EMPTY_LIST;
    }

    public List<EccairsReport> findByReportingEntityAndEntityFileNumber(EccairsReport report) {
        Context occurrence = report.getOccurrence();
        Context reportingHistory = occurrence.getEntityContext("53");
        String reportingEntity = null;
        String fileNumber = null;
        if (reportingHistory != null) {
            Value v = this.getSingleValue(reportingHistory, "447");
            if (v != null && v.getCode() != null) {
                String c = v.getCode().toString();
                reportingEntity = c.substring(c.lastIndexOf("/v-") + 3);
            }
            if ((v = this.getSingleValue(reportingHistory, "438")) != null && v.getCode() != null) {
                fileNumber = v.getText();
            }
        }
        if (reportingEntity != null && fileNumber != null) {
            return this.findByReportingEntityAndEntityFileNumber(reportingEntity, fileNumber);
        }
        return Collections.EMPTY_LIST;
    }

    protected Value getSingleValue(Context entityContext, String attributeId) {
        Context attributeContext = entityContext.getAttributeContext(attributeId);
        if (attributeContext != null && attributeContext.getValue() != null && !attributeContext.getValue().isEmpty()) {
            return (Value)attributeContext.getValue().stream().findFirst().get();
        }
        return null;
    }

    public List<EccairsReport> findByReportingEntityAndEntityFileNumber(String reportingEntity, String fileNumber) {
        String query = this.getQueryFindByReportingEntityAndEntityFileNumber(reportingEntity, fileNumber);
        TypedQuery q = this.em.createNativeQuery(query, EccairsReport.class);
        List foundReports = q.getResultList();
        return foundReports != null ? foundReports : Collections.EMPTY_LIST;
    }

    public EccairsReport readReport(String uri, Descriptor d) {
        EccairsReport er = (EccairsReport)this.em.find(EccairsReport.class, (Object)uri);
        return er;
    }

    public void safePersist(EccairsReport r, Descriptor d) {
        if (d == null) {
            d = new EntityDescriptor(URI.create(r.getUri()));
        }
        this.safePersist(r.getOccurrence(), d);
        if (r.getVocabularies() != null) {
            for (ConceptTermCollection tc : r.getVocabularies()) {
                this.safePersistFlat(tc, d);
            }
        }
        this.safePersistFlat(r, d);
    }

    public void update(EccairsReport er, Descriptor d) {
        this.em.getTransaction().begin();
        if (d != null) {
            this.em.merge((Object)er, d);
        } else {
            this.em.merge((Object)er);
        }
        this.em.getTransaction().commit();
    }

    protected void safePersistFlat(Identifiable i, Descriptor d) {
        if (!this.em.contains((Object)i)) {
            this.em.persist((Object)i, d);
            this.processed.add(i);
        } else {
            this.em.merge((Object)i, d);
        }
    }

    protected void safePersist(Context ctx, Descriptor d) {
        if (ctx != null) {
            Set<Context> contexts = ctx.getContexts();
            if (contexts != null) {
                contexts.stream().forEach(c -> this.safePersist((Context)c, d));
            }
            this.safePersistFlat(ctx, d);
        }
    }

    public void deleteReport(EccairsReport report) {
        this.em.createNativeQuery("DELETE{GRAPH ?g {?s ?p ?o.}} WHERE {GRAPH ?g {?s ?p ?o.}}").setParameter("g", (Object)URI.create(report.getUri())).executeUpdate();
    }
}

