/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.schema.dao.cfg;

import cz.cvut.kbss.eccairs.schema.dao.cfg.QueryExecFactoryFactory;
import cz.cvut.kbss.sparql.QueryExecFactory;
import java.util.Properties;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.atlas.web.auth.SimpleAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EccairsAccessConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger((String)EccairsAccessConfiguration.class.getName());
    public static final String FACTORY_PROP = "factory";
    public static final String ENDPOINT_PROP = "endpoint";
    public static final String USERNAME_PROP = "username";
    public static final String PASSWORD_PROP = "password";
    public static final String SERVER_PROP = "server";
    public static final String REPO_TEMPLATE_PROP = "repoIdTemplate";
    public static final String ECCAIRS_CONTEXST_TEMPLATE_PROP = "eccairsContextTemplate";
    public static final String DEFAULT_ECCAIRS_VERSION = "defaultEccairsVersion";
    private Properties configProperties;
    private QueryExecFactoryFactory f;

    public EccairsAccessConfiguration(Properties configProperties) {
        this.configProperties = configProperties;
        this.initFactory(configProperties);
    }

    private void initFactory(Properties p) {
        try {
            String factory = this.getFactory();
            this.f = (QueryExecFactoryFactory)Class.forName(factory).newInstance();
        }
        catch (ClassNotFoundException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (InstantiationException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            LOG.error(null, (Throwable)ex);
        }
    }

    public HttpAuthenticator getConfiguredAuthenticator(Properties p) {
        return new SimpleAuthenticator(p.getProperty(USERNAME_PROP), p.getProperty(PASSWORD_PROP).toCharArray());
    }

    public HttpAuthenticator getConfiguredAuthenticator() {
        return this.getConfiguredAuthenticator(this.configProperties);
    }

    public String getServerURL() {
        return this.configProperties.getProperty(SERVER_PROP);
    }

    public String getFactory() {
        return this.configProperties.getProperty(FACTORY_PROP);
    }

    public String getuserName() {
        return this.configProperties.getProperty(USERNAME_PROP);
    }

    public String getPassword() {
        return this.configProperties.getProperty(PASSWORD_PROP);
    }

    public String getRepositoryIdTemplate() {
        return this.configProperties.getProperty(REPO_TEMPLATE_PROP);
    }

    public String getEccairsContextTemplate() {
        return this.configProperties.getProperty(ECCAIRS_CONTEXST_TEMPLATE_PROP, "");
    }

    public String getUpdateEndpoint() {
        return this.configProperties.getProperty(ENDPOINT_PROP) + "/statements";
    }

    public String getDefaultEccairsVersion() {
        return this.configProperties.getProperty(DEFAULT_ECCAIRS_VERSION);
    }

    public String getRepositorySparqlEndpoint(String version) {
        return this.getServerURL() + "/" + String.format(this.getRepositoryIdTemplate(), version);
    }

    public String getEccairsContext(String version) {
        return String.format(this.getEccairsContextTemplate(), version);
    }

    public QueryExecFactoryFactory getFactoryInstance() {
        return this.f;
    }

    public QueryExecFactory getQueryExecFactoryECVersion(String version) {
        return this.getFactoryInstance().create(version, this);
    }

    public Properties getConfigurationProperties() {
        return this.configProperties;
    }
}

