/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ucl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RLPE5XMapperContext {
    private static final Logger LOG = LoggerFactory.getLogger((String)RLPE5XMapperContext.class.getName());
    protected static final DateParser defaultDateTimeFormat = new DateParser("yyyy-MM-dd'T'hh:mm:ss", "^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d");
    protected static final DateParser defaultDateTimeWithoutSecondsFormat = new DateParser("yyyy-MM-dd'T'hh:mm", "^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d");
    protected static final DateParser defaultDateFormat = new DateParser("yyyy-MM-dd", "^\\d\\d\\d\\d-\\d\\d-\\d\\d");
    protected static final DateParser czechDateFormat = new DateParser("dd-MM-yyyy", "^\\d\\d-\\d\\d-\\d\\d\\d\\d");
    protected static final List<DateParser> formats = Arrays.asList(defaultDateTimeFormat, defaultDateTimeWithoutSecondsFormat, defaultDateFormat, czechDateFormat);

    public static Date parse(String dateStr) {
        return RLPE5XMapperContext.parse(dateStr, TimeZone.getDefault());
    }

    public static Date parse(String dateStr, TimeZone tz) {
        for (DateParser parser : formats) {
            String format = parser.getFormatPattern();
            try {
                if (!parser.accepts(dateStr)) continue;
                Date date = parser.parse(dateStr, tz);
                LOG.trace("Successfully parsing date \"{}\" using date format \"{}\"", (Object)dateStr, (Object)format);
                return date;
            }
            catch (ParseException parseException) {
            }
        }
        LOG.trace("Could not parse date \"{}\".", (Object)dateStr);
        return null;
    }

    public static Long parseTime(String time) {
        return RLPE5XMapperContext.parseTime(time, TimeZone.getDefault());
    }

    public static Long parseTime(String time, TimeZone tz) {
        time = "1970-01-01T" + (String)time;
        Date t = RLPE5XMapperContext.parse((String)time, tz);
        return Optional.ofNullable(t).map(Date::getTime).orElse(0L);
    }

    public static Date parseDateTime(String str) {
        try {
            return defaultDateTimeFormat.parse(str, null);
        }
        catch (ParseException ex) {
            LOG.warn(null, (Throwable)ex);
            return null;
        }
    }

    public static Date parseDate(String str) {
        try {
            return defaultDateFormat.parse(str, null);
        }
        catch (ParseException ex) {
            LOG.warn(null, (Throwable)ex);
            return null;
        }
    }

    public static Date parseCzechDate(String str) {
        try {
            return czechDateFormat.parse(str, null);
        }
        catch (ParseException ex) {
            LOG.warn(null, (Throwable)ex);
            return null;
        }
    }

    public static DateParser getDefaultDateTimeFormat() {
        return defaultDateTimeFormat;
    }

    public static DateParser getDefaultDateTimeWithoutSecondsFormat() {
        return defaultDateTimeWithoutSecondsFormat;
    }

    public static DateParser getDefaultDateFormat() {
        return defaultDateFormat;
    }

    public static DateParser getCzechDateFormat() {
        return czechDateFormat;
    }

    public static List<DateParser> getFormats() {
        return formats;
    }

    public static class DateParser {
        protected final String formatPattern;
        protected final Pattern acceptPattern;
        protected final ThreadLocal<SimpleDateFormat> format;

        public DateParser(String formatPattern, String acceptPattern) {
            this.formatPattern = formatPattern;
            this.format = ThreadLocal.withInitial(() -> new SimpleDateFormat(formatPattern));
            this.acceptPattern = Pattern.compile(acceptPattern);
        }

        public boolean accepts(String input) {
            return this.acceptPattern.matcher(input).matches();
        }

        public Date parse(String input, TimeZone tz) throws ParseException {
            SimpleDateFormat formater = this.format.get();
            formater.setTimeZone(tz != null ? tz : TimeZone.getDefault());
            return formater.parse(input);
        }

        public Pattern getAcceptPattern() {
            return this.acceptPattern;
        }

        public ThreadLocal<SimpleDateFormat> getFormat() {
            return this.format;
        }

        public String getFormatPattern() {
            return this.formatPattern;
        }
    }
}

