<?xml version="1.0" encoding="UTF-8"?>

<!--
    Document   : e5x-transform.xsl
    Created on : 3. dubna 2017, 17:05
    Author     : user
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
 xmlns:ecc="http://eccairsportal.jrc.ec.europa.eu/ECCAIRS5_dataBridge.xsd"
 xmlns:tr="xalan://cz.cvut.kbss.eccairs.experiments.parsing.e5x.E5XParserExp"
 xmlns:jlm="xalan://java.lang.Math"
 xmlns:jstring="xalan://java.lang.String"
 xmlns:jsystem="xalan://java.lang.System">
    
    <xsl:output media-type="text/plain" />
    <xsl:variable name='nl'><xsl:text>&#xa;</xsl:text></xsl:variable>
    <xsl:variable name="tri" select="tr:new()"/>
    <!-- init the value from java code -->
    <xsl:param name="transformerHelper" select="$tri" />
    
    <!-- TODO customize transformation rules 
         syntax recommendation http://www.w3.org/TR/xslt 
    -->
<!--    <xsl:template match="/SET">
            <xsl:value-of select="name"/>
            <xsl:value-of select="jc:next"/>
    </xsl:template>-->
    <!--<xsl:template match="/SET/Occurrence">-->
    
    
    <xsl:template match="/SET">
        <xsl:value-of select="tr:handleSet($tri, .)"/>
        <xsl:for-each select="*">
            <xsl:call-template name="entityHandler"/>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="entityHandler">
        <xsl:value-of select="tr:handleChildEnity($tri,.)"/>
        <xsl:call-template name="attributes"/>
        <xsl:call-template name="entities"/>
        <xsl:call-template name="links"/>
    </xsl:template>
    
    
    <xsl:template name="entities">
        <xsl:for-each select="ENTITIES/*">
            <xsl:call-template name="entityHandler"/>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="links">
        <xsl:for-each select="LINKS/*">
           <xsl:value-of select="tr:handleLinkToEnity($tri,.)"/>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="attributes">
        <xsl:for-each select="ATTRIBUTES/*">
            <xsl:choose>
                <xsl:when test="EncodedText">
                    <xsl:value-of select="tr:handleAttribute($tri,., EncodedText, true())"/>
                </xsl:when>
                <xsl:when test="PlainText">
                    <xsl:value-of select="tr:handleAttribute($tri,., PlainText, false())"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="tr:handleAttribute($tri, ., ., false())"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
<!--    <xsl:template name="links" match="ecc:LINKS">
        
    </xsl:template>-->

</xsl:stylesheet>
