/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.schema.dao;

import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess;
import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess_v_2016_02_23;
import cz.cvut.kbss.eccairs.schema.dao.cfg.EccairsAccessConfiguration;
import cz.cvut.kbss.sparql.QueryExecFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingeltonEccairsAccessFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)SingeltonEccairsAccessFactory.class.getName());
    protected EccairsAccess eccairsAccessObject;
    protected Map<String, EccairsAccess> cachedEccairsAccessObjects = new HashMap<String, EccairsAccess>();
    protected EccairsAccessConfiguration configuration;

    public SingeltonEccairsAccessFactory(EccairsAccessConfiguration configuration) {
        this.configuration = configuration;
    }

    public SingeltonEccairsAccessFactory() {
    }

    public synchronized EccairsAccess getEccairsVersionOrDefault(String ecrVersion) {
        EccairsAccess ea = null;
        try {
            ea = this.getEccairsVersion(ecrVersion);
        }
        catch (Exception e) {
            LOG.error(String.format("Could not load eccairs schema version %s, using default version %s", ecrVersion, this.configuration.getDefaultEccairsVersion()), (Throwable)e);
        }
        if (ea == null) {
            ea = this.getEccairsVersion(this.configuration.getDefaultEccairsVersion());
        }
        return ea;
    }

    public synchronized EccairsAccess getEccairsVersion(String ecrVersion) {
        this.eccairsAccessObject = this.cachedEccairsAccessObjects.get(ecrVersion);
        if (this.eccairsAccessObject == null) {
            QueryExecFactory f = this.configuration.getQueryExecFactoryECVersion(ecrVersion);
            String eccairsContext = this.configuration.getEccairsContext(ecrVersion);
            this.eccairsAccessObject = this.createEccairsSchemaAccess(f, ecrVersion, eccairsContext);
            this.cachedEccairsAccessObjects.put(ecrVersion, this.eccairsAccessObject);
        }
        return this.eccairsAccessObject;
    }

    public EccairsAccess createEccairsSchemaAccess(QueryExecFactory f, String ecrVersion, String eccairsContext) {
        return new EccairsAccess_v_2016_02_23(f, ecrVersion, eccairsContext);
    }

    public EccairsAccessConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EccairsAccessConfiguration configuration) {
        this.configuration = configuration;
    }
}

