/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.e5xml;

import cz.cvut.kbss.commons.io.zip.ZipSource;
import cz.cvut.kbss.commons.io.zip.ZipSourceEntry;
import cz.cvut.kbss.eccairs.report.e5xml.E5XConstants;
import cz.cvut.kbss.eccairs.report.e5xml.E5XMLReportParser;
import cz.cvut.kbss.eccairs.report.e5xml.commons.NamedStream;
import cz.cvut.kbss.eccairs.report.e5xml.e5x.E5XXMLParser;
import cz.cvut.kbss.eccairs.report.model.EccairsReport;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.lang.StringUtils;
import org.jooq.lambda.Unchecked;

public class E5XMLLoader {
    protected E5XXMLParser e5xParser;
    protected E5XMLReportParser parser;
    protected Pattern pathPattern;
    protected NamedStream ns;

    public E5XMLLoader prepareFor(NamedStream ns) {
        this.ns = ns;
        if (StringUtils.endsWithIgnoreCase((String)ns.name, (String)".e5x")) {
            this.parser = this.e5xParser;
            this.pathPattern = E5XConstants.XML_FILE_PATH_PATTERNp;
        } else {
            this.parser = null;
            this.pathPattern = null;
        }
        return this;
    }

    public Stream<EccairsReport> loadData() {
        if (this.pathPattern == null) {
            return Stream.of(new EccairsReport[0]);
        }
        return this.loadDataImpl(this.ns, this.pathPattern, this.parser);
    }

    public Stream<EccairsReport> loadDataImpl(NamedStream ns, Pattern pathPattern, E5XMLReportParser parser) {
        return this.e5xmlEntiries().map(Unchecked.function(zse -> {
            EccairsReport r = this.loadRepoort(zse.getInputStream(), zse.getName(), parser);
            r.setUri(String.format("%s-i/%s/%s", "http://onto.fel.cvut.cz/ontologies/documentation/report", ns.name, zse.getName()));
            return r;
        }));
    }

    public EccairsReport loadRepoort(InputStream is, String reportFileName, E5XMLReportParser parser) throws IOException {
        parser.resetParser();
        parser.parseDocument(new NamedStream(reportFileName, (InputStream)new ProxyInputStream(is){

            public void close() throws IOException {
            }
        }));
        EccairsReport er = parser.getReport();
        er.setOriginalFile(reportFileName);
        return er;
    }

    public Stream<ZipSourceEntry> e5xmlEntiries() {
        if (this.pathPattern == null) {
            return Stream.of(new ZipSourceEntry[0]);
        }
        return E5XMLLoader.e5xmlEntiriesImpl(this.ns, this.pathPattern);
    }

    public static Stream<ZipSourceEntry> e5xmlEntiriesImpl(NamedStream ns, Pattern pathPattern) {
        return ZipSource.wrap((InputStream)ns.is).streamEntries().filter(e -> pathPattern.matcher(e.getName()).matches());
    }

    public void setE5xParser(E5XXMLParser e5xParser) {
        this.e5xParser = e5xParser;
    }

    public E5XXMLParser getE5xParser() {
        return this.e5xParser;
    }
}

