/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.e5xml;

import cz.cvut.kbss.commons.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class _E5XMLZipExtractor {
    private static final Logger LOG = LoggerFactory.getLogger((String)_E5XMLZipExtractor.class.getName());

    protected boolean predicate(ZipEntry ze) {
        return Pattern.matches(this.getPathPattern(), ze.getName()) && !ze.isDirectory();
    }

    protected Stream<ZipEntry> findEccairsDataFileInZipFile(Enumeration<? extends ZipEntry> en) {
        return StreamUtils.toStream(en).filter(x -> this.predicate((ZipEntry)x));
    }

    public Stream<ResultTuple> processFile(InputStream is, String streamName) {
        if (streamName.endsWith(this.getFileExtension())) {
            ZipInputStream zis = new ZipInputStream(is);
            return StreamUtils.streamUntil((Supplier)Unchecked.supplier(zis::getNextEntry), Objects::nonNull).filter(x -> this.predicate((ZipEntry)x)).map(Unchecked.function(x -> new ResultTuple(x.getName(), (InputStream)new ProxyInputStream(zis){

                public void close() throws IOException {
                }
            })));
        }
        return null;
    }

    public Stream<ResultTuple> processFile(String file) {
        if (file.endsWith(this.getFileExtension())) {
            try {
                ZipFile zf = new ZipFile(file);
                return this.findEccairsDataFileInZipFile(zf.entries()).map(x -> {
                    try {
                        return new ResultTuple(x.getName(), zf.getInputStream((ZipEntry)x));
                    }
                    catch (IOException ex) {
                        LOG.warn(null, (Throwable)ex);
                        return null;
                    }
                });
            }
            catch (IOException ex) {
                LOG.warn(null, (Throwable)ex);
            }
        }
        return null;
    }

    public abstract String getFileExtension();

    public abstract String getPathPattern();

    public static class ResultTuple {
        public String entryName;
        public InputStream entryStream;

        public ResultTuple(String entryName, InputStream entryStream) {
            this.entryName = entryName;
            this.entryStream = entryStream;
        }
    }
}

