/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.e5xml.commons;

import cz.cvut.kbss.eccairs.report.e5xml.commons._E5XMLAbstractLoader;
import cz.cvut.kbss.eccairs.report.e5xml.commons._E5XMLLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.PrintUtil;
import org.apache.jena.vocabulary.OWL2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class _E5FOccurrenceReportLoader
extends _E5XMLAbstractLoader {
    private static final Logger LOG = LoggerFactory.getLogger((String)_E5FOccurrenceReportLoader.class.getName());
    protected static String ECCAIRSBASE = "http://onto.fel.cvut.cz/ontologies/eccairs-%s/";
    protected static String formbaseRLP = "http://onto.fel.cvut.cz/ontologies/tis-xx.xx.xx/";
    protected static String formbaseUZPLN = "http://onto.fel.cvut.cz/ontologies/uzpln-376-1018-0.1/";
    protected _E5XMLLoader.EccairsCache ecache;
    protected OntModel ont = ModelFactory.createOntologyModel();
    protected XPath xpath = XPathFactory.newInstance().newXPath();
    protected String eccairsbase = "http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/";
    protected String rebase = "";
    protected Property hasPredefinedValue;
    protected Property hasValue;
    protected Map<String, String> formEntries = new HashMap<String, String>();
    protected Individual report;
    protected Individual entity;
    protected OntClass Report;
    protected OntClass Question;
    protected DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    protected DateFormat df1 = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssXXX");

    public _E5FOccurrenceReportLoader(_E5XMLLoader.EccairsCache ecache) {
        this.ecache = ecache;
        this.Report = this.ont.createClass("http://onto.fel.cvut.cz/ontologies/documentation/report");
        this.Question = this.ont.createClass("http://onto.fel.cvut.cz/ontologies/documentation/question");
        this.report = this.ont.createIndividual((Resource)this.Report);
        this.hasPredefinedValue = this.ont.getProperty(this.eccairsbase + "has-predefined-value");
        this.hasValue = this.ont.getProperty(this.eccairsbase + "has-value");
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, ParserConfigurationException, Exception {
    }

    @Override
    public void loadReport(Node occ, String sourceName) {
        try {
            List<Node> entities = this.evaluatePath(occ, "//E");
            for (Node e : entities) {
                String entityID = this.attrID(e);
                this.getAttribute(e, "ID");
                if (entityID == null) {
                    this.entity = this.ont.createIndividual(OWL2.Thing);
                    LOG.warn(String.format("The entity \"%s\" has no ID.", e.getTextContent()));
                    continue;
                }
                this.entity.addProperty(this.hasValue, (RDFNode)this.report);
                this.ecache.getEntity(entityID);
                this.encodeAttribute(e);
            }
        }
        catch (XPathExpressionException ex) {
            LOG.warn(null, (Throwable)ex);
        }
    }

    protected String attrID(Node val) throws XPathExpressionException {
        Node id = this.evaluateSinglePath(val, "./DV/@ID");
        return _E5FOccurrenceReportLoader.nullingId(_E5FOccurrenceReportLoader.getTextContent(id), x -> x.trim());
    }

    protected String attrText(Node val) throws XPathExpressionException {
        Node n = this.evaluateSinglePath(val, "./DV/@TEXT");
        if (n == null) {
            return null;
        }
        return _E5FOccurrenceReportLoader.nullingId(_E5FOccurrenceReportLoader.getTextContent(val), x -> x.trim());
    }

    public void encodeEntities(Node entity) throws XPathExpressionException {
        List<Node> attributes = this.evaluatePath(entity, ".//A");
        for (Node n : attributes) {
            this.encodeAttribute(n);
        }
    }

    public Resource encodeAttribute(Node attribute) throws XPathExpressionException {
        List<Node> values = this.evaluatePath(attribute, ".//V");
        String aid = this.getAttribute(attribute, "ID");
        String base = this.eccairsbase;
        String attrLabel = "";
        boolean eccairsAttribute = false;
        if (aid == null || aid.isEmpty()) {
            aid = "" + System.currentTimeMillis();
            LOG.warn(String.format("the %s (attribute) element has no ID. The text content of the element is : %s", attribute.getLocalName(), attribute.getTextContent()));
        } else if (!this.ecache.isAttribute(aid)) {
            base = formbaseUZPLN;
        } else {
            eccairsAttribute = true;
        }
        if (aid.contains("390")) {
            String string = "";
        }
        if (eccairsAttribute) {
            this.ecache.getAttributeLabel(aid);
            String airi = base + "a-" + aid;
            Property attributeResource = this.ont.getProperty(airi);
            List<Node> vals = this.evaluatePath(attribute, "./V");
            for (Node val : vals) {
                this.encodeValuation(aid, attributeResource, val);
            }
        } else {
            Property attributeResource = this.ont.getProperty(base + "a-unknown-" + System.currentTimeMillis());
            List<Node> vals = this.evaluatePath(attribute, "./V");
            for (Node val : vals) {
                this.encodeNonEccairsAttributeValuation(aid, attributeResource, attribute);
            }
        }
        return null;
    }

    public Resource encodeValuation(String aId, Property attr, Node val) {
        String text = "";
        Resource code = null;
        try {
            StmtIterator si;
            String plainText = this.plainText(val);
            String attrText = this.attrText(val);
            String attrId = this.attrID(val);
            boolean pt = false;
            boolean ai = false;
            Resource v = this.ont.createResource();
            this.report.addProperty(attr, (RDFNode)v);
            this.ecache.isValueType(aId, "PredefinedValueList");
            String dt = this.ecache.getDataType(aId);
            if (dt != null && dt.toLowerCase().contains("code")) {
                if (attrId != null) {
                    code = this.ont.getResource("http://mock.com");
                    if (code == null) {
                        code = this.ont.getResource("http://mock.com");
                    }
                    if (code == null && plainText != null) {
                        code = this.ont.getResource("http://mock.com");
                        if (code == null) {
                            code = this.ont.getResource("http://mock.com");
                        }
                        if (code != null) {
                            pt = true;
                        }
                    } else {
                        ai = true;
                    }
                    if (code != null) {
                        v.addProperty(this.hasPredefinedValue, (RDFNode)code);
                    }
                }
                if (!dt.contains("or") && dt.contains("and") && code == null) {
                    LOG.warn(String.format("code (ID=%s,textContent=%s )not found in eccairs for the value of attibute %s with data type %s", attrId, plainText, aId, dt));
                }
            }
            if (plainText != null && !pt) {
                v.addProperty(this.hasValue, plainText);
            }
            if (attrId != null && !ai) {
                v.addProperty(this.hasValue, attrId);
            }
            if (attrText != null) {
                v.addProperty(this.hasValue, attrText);
            }
            if ((si = v.listProperties(this.hasPredefinedValue)).hasNext()) {
                while (si.hasNext()) {
                    RDFNode n;
                    Statement s = si.nextStatement();
                    if (s == null || !(n = s.getObject()).isResource()) continue;
                    this.formEntries.put(aId, n.asResource().getURI());
                }
            } else {
                si = v.listProperties(this.hasValue);
                while (si.hasNext()) {
                    Statement s = si.nextStatement();
                    if (s == null) continue;
                    RDFNode n = s.getObject();
                    text = text + n.toString() + "\n";
                }
                this.formEntries.put(aId + "text", text);
            }
        }
        catch (XPathExpressionException ex) {
            LOG.warn(null, (Throwable)ex);
        }
        return code;
    }

    public void encodeNonEccairsAttributeValuation(String aid, Property attr, Node val) {
        String text = "";
        Resource code = null;
        try {
            Resource v = this.ont.createResource();
            String plainText = this.plainText(val);
            String attrText = this.attrText(val);
            String attrId = this.attrID(val);
            if (attrId == null) {
                attrId = "" + System.currentTimeMillis();
                code = this.ont.getResource(String.format("%sA-%s-V-%s", formbaseUZPLN, aid, attrId));
                v.addProperty(attr, (RDFNode)code);
            }
            if (plainText != null) {
                text = plainText;
            }
            if (attrId != null) {
                plainText = plainText + " " + attrId;
            }
            if (attrText != null) {
                plainText = plainText + " " + attrText;
            }
            if (code != null) {
                attr.addProperty(this.hasPredefinedValue, code);
            }
            attr.addProperty(this.hasValue, text);
            StmtIterator si = v.listProperties(this.hasPredefinedValue);
            if (si.hasNext()) {
                while (si.hasNext()) {
                    RDFNode n;
                    Statement s = si.nextStatement();
                    if (s == null || !(n = s.getObject()).isResource()) continue;
                    this.formEntries.put(aid, n.asResource().getURI());
                }
            } else {
                si = v.listProperties(this.hasValue);
                while (si.hasNext()) {
                    Statement s = si.nextStatement();
                    if (s == null) continue;
                    RDFNode n = s.getObject();
                    text = text + n.toString() + "\n";
                }
                this.formEntries.put(aid + "text", text);
            }
        }
        catch (XPathExpressionException ex) {
            LOG.warn(null, (Throwable)ex);
        }
    }

    public static void mappingOf376DataToRDF() {
        String queryStr1 = "SELECT * {?x ?y ?z} LIMIT 10";
        String queryStr2 = "PREFIX j.0: <http://onto.fel.cvut.cz/ontologies/eccairs-1.3.0.8/>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n# this is a comment\n# find allused properties ?p, not be confused with attributes!\nSELECT DISTINCT * {\n  ?x a j.0:Attribute.\n  ?x j.0:hasExplanation ?l.\n  filter (contains(?l,\"crew\") \n&& !contains(?l,\"injur\")\n&& !contains(?l,\"smoke\")\n&& !contains(?l,\"hours\")\n)\n}";
        QueryExecution qe = QueryExecutionFactory.sparqlService((String)"http://martin.inbas.cz/openrdf-sesame/repositories/eccairs-1.3.0.8", (String)queryStr2);
        ResultSet rs = qe.execSelect();
        PrintUtil.printOut((Iterator)rs);
        qe.close();
    }

    public static void testXPath() {
        try {
            XPath x = XPathFactory.newInstance().newXPath();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document d = dBuilder.parse(new File("d:\\downloads\\inbas\\data-brno-376\\dildar.veliskova@travelservice.aero_1448871120\\OCCS\\tmp.xml"));
            NodeList nl1 = (NodeList)x.evaluate("/*/text()", d, XPathConstants.NODESET);
            for (int i = 0; i < nl1.getLength(); ++i) {
                System.out.println(nl1.item(i).getTextContent());
            }
        }
        catch (ParserConfigurationException ex) {
            LOG.warn(null, (Throwable)ex);
        }
        catch (SAXException ex) {
            LOG.warn(null, (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.warn(null, (Throwable)ex);
        }
        catch (XPathExpressionException ex) {
            LOG.warn(null, (Throwable)ex);
        }
    }

    public static void printAllAttributeIds(Document d) throws XPathExpressionException {
        XPath x = XPathFactory.newInstance().newXPath();
        NodeList nl1 = (NodeList)x.evaluate("//*[@ID]/@ID", d.getChildNodes().item(0), XPathConstants.NODESET);
        if (nl1 == null) {
            return;
        }
        for (int i = 0; i < nl1.getLength(); ++i) {
            Node n = nl1.item(i);
            System.out.println(n.getTextContent());
        }
    }
}

