/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.e5xml.e5f;

import cz.cvut.kbss.eccairs.report.e5xml.AbstractE5XMLReportLoader;
import cz.cvut.kbss.eccairs.report.e5xml.e5x.EntityNameToIdMap;
import cz.cvut.kbss.eccairs.report.e5xml.e5x._E5XXMLToQAMConvertor;
import cz.cvut.kbss.eccairs.report.model.ConceptTermCollection;
import cz.cvut.kbss.eccairs.report.model.Context;
import cz.cvut.kbss.eccairs.report.model.EccairsReport;
import cz.cvut.kbss.eccairs.report.model.UnknownTerm;
import cz.cvut.kbss.eccairs.report.model.Value;
import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess;
import cz.cvut.kbss.eccairs.schema.dao.SingeltonEccairsAccessFactory;
import java.util.Objects;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class E5FXMLParser
extends AbstractE5XMLReportLoader {
    private static final Logger LOG = LoggerFactory.getLogger((String)_E5XXMLToQAMConvertor.class.getName());
    protected static final String attrTaxonomyVersion = "TaxonomyVersion";
    protected static final String attrTaxonomyName = "TaxonomyName";
    protected static final String attrAdditionalText = "AdditionalText";
    protected static final String attrAlternativeText = "AlternativeText";
    protected static final String attrAttributeId = "attributeId";
    protected static final String attrREF = "REF";
    protected static final String attrID = "ID";
    protected static final String occurrenceEl = "Occurrence";
    protected static final String attributesEl = "ATTRIBUTES";
    protected static final String entitiesEl = "ENTITIES";
    protected static final String linksEl = "LINKS";
    protected static final String plainTextEl = "PLAINTEXT";
    protected static final String encodedTextEl = "ENCODEDTEXT";
    protected static final String setEl = "SET";
    protected static final String VT_PredefinedValueList = "PredefinedValueList";
    protected static final String DT_CodeOrAlternativeText = "Code or Alternative Text";
    protected static final String DT_CodeAndAdditionalText = "Code and Additional Text";
    protected SingeltonEccairsAccessFactory eaf;
    protected EccairsAccess ea;
    protected Stack<SyntaxElement> elementStack = new Stack();
    protected SyntaxElement currentElement;
    protected SyntaxElement parentElement;
    protected EccairsReport report;
    protected ConceptTermCollection evocab;

    public E5FXMLParser(SingeltonEccairsAccessFactory eaf) {
        this.eaf = eaf;
    }

    public E5FXMLParser() {
        this(new SingeltonEccairsAccessFactory());
    }

    public SingeltonEccairsAccessFactory getEc() {
        return this.eaf;
    }

    public void setEc(SingeltonEccairsAccessFactory ec) {
        this.eaf = ec;
    }

    @Override
    public void resetParser() {
        this.ea = null;
        this.report = null;
        this.currentElement = null;
        this.parentElement = null;
        this.elementStack = new Stack();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.createChildContext(qName, attributes);
        qName = qName.toUpperCase();
        if (qName.contains(":")) {
            qName = qName.substring(qName.indexOf(":") + 1);
        }
        switch (qName) {
            case "SET": {
                this.handleSet();
                break;
            }
            case "PLAINTEXT": 
            case "ENCODEDTEXT": 
            case "ENTITIES": 
            case "ATTRIBUTES": 
            case "LINKS": {
                this.setCurrentPart(qName);
                break;
            }
            default: {
                LOG.trace(qName);
                this.handelOtherElements();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentElement.type == ElementType.Attribute) {
            this.handleAttributeValue();
        }
        this.moveToParentContext();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement.currentVal != null) {
            this.currentElement.currentVal.append(ch, start, length);
        }
    }

    public void handelOtherElements() {
        if (this.parentElement == null) {
            LOG.warn(String.format("Couldn't parse the file. The root element %s was not found.", setEl));
            return;
        }
        switch (this.parentElement.part) {
            case "ATTRIBUTES": {
                this.handleAttribute();
                break;
            }
            case "LINKS": 
            case "ENTITIES": {
                this.handleEntity();
            }
        }
        if (this.report.getOccurrence() == null) {
            this.report.setOccurrence(this.currentElement.el);
        }
    }

    protected void setCurrentPart(String part) {
        this.currentElement = this.parentElement;
        this.currentElement.part = part;
    }

    protected void createChildContext() {
        if (this.currentElement != null) {
            this.parentElement = this.elementStack.push(this.currentElement);
        }
        this.currentElement = new SyntaxElement();
    }

    protected void createChildContext(String qName, Attributes attributes) {
        this.createChildContext();
        this.currentElement.qName = qName;
        this.currentElement.attributes = attributes;
    }

    protected void moveToParentContext() {
        this.currentElement = this.parentElement;
        if (!this.elementStack.isEmpty()) {
            this.elementStack.pop();
            if (!this.elementStack.isEmpty()) {
                this.parentElement = this.elementStack.peek();
            }
        }
    }

    public void handleSet() {
        if (this.isPrintable(this.currentElement.qName) && this.currentElement.qName.toUpperCase().equals(setEl)) {
            this.report = new EccairsReport();
            this.report.setTaxonomyName(this.currentElement.attributes.getValue(attrTaxonomyName));
            this.report.setTaxonomyVersion(this.currentElement.attributes.getValue(attrTaxonomyVersion));
            String eccVersion = this.currentElement.attributes.getValue(attrTaxonomyVersion);
            if (this.isPrintable(eccVersion)) {
                this.ea = this.eaf.getEccairsVersion(eccVersion);
            }
            this.evocab = new ConceptTermCollection();
            this.evocab.setUri(this.ea != null ? this.ea.getUri() : this.eaf.getConfiguration().getEccairsContext(""));
            this.evocab.setName(this.report.getTaxonomyName());
            this.report.getVocabularies().add(this.evocab);
            this.currentElement.part = entitiesEl;
        }
    }

    protected String getEntityTypeId() {
        String eid = EntityNameToIdMap.getId(this.currentElement.qName);
        return !Objects.isNull(eid) ? eid : (this.ea != null ? this.ea.getEntityId(this.currentElement.qName.replace("_", " ")) : null);
    }

    protected String getEntityTypeURI() {
        String entityTypeId = this.getEntityTypeId();
        if (entityTypeId != null) {
            return this.ea.getEntityURI(entityTypeId);
        }
        UnknownTerm ut = this.createTermUnknownToEccairs(this.currentElement.qName);
        return ut.getUri();
    }

    protected UnknownTerm createTermUnknownToEccairs(String localName) {
        UnknownTerm ut = new UnknownTerm();
        ut.setLabel(localName);
        ut.setUri(String.format("http://onto.fel.cvut.cz/ontologies/documentation/occurrence_report#possible-concept-term-%s", this.currentElement.qName));
        this.evocab.getUnknownTerms().add(ut);
        return ut;
    }

    protected String getEntityInstanceId() {
        String entityInstanceID = null;
        switch (this.parentElement.part) {
            case "LINKS": {
                entityInstanceID = this.currentElement.attributes.getValue(attrREF);
                if (entityInstanceID != null) break;
                LOG.warn("reference to the entity <{0}> was not found!", (Object)this.currentElement.qName);
                return null;
            }
            case "ENTITIES": {
                entityInstanceID = this.currentElement.attributes.getValue(attrID);
            }
        }
        return entityInstanceID;
    }

    public String getAttributeTypeId() {
        return this.currentElement.attributes.getValue(attrAttributeId);
    }

    public String getAttributeTypeUri() {
        String attributeTypeId = this.getAttributeTypeId();
        String str = null;
        if (attributeTypeId != null) {
            str = this.ea.getAttributeURI(attributeTypeId);
            if (str != null) {
                return str;
            }
            str = attributeTypeId;
        } else {
            str = this.currentElement.qName;
        }
        this.currentElement.unknownTerm = true;
        UnknownTerm ut = this.createTermUnknownToEccairs(str);
        return ut.getUri();
    }

    public void handleEntity() {
        this.currentElement.el = new Context();
        String entityTypeURI = this.getEntityTypeURI();
        this.currentElement.el.setContextType(entityTypeURI);
        this.currentElement.el.setEccairsId(this.getEntityInstanceId());
        if (this.parentElement.el != null) {
            this.parentElement.el.addContext(this.currentElement.el);
        }
    }

    public void handleAttribute() {
        this.currentElement.el = new Context();
        String attributeTypeUri = this.getAttributeTypeUri();
        this.currentElement.el.setContextType(attributeTypeUri);
        this.currentElement.currentVal = new StringBuffer();
        this.currentElement.type = ElementType.Attribute;
        if (this.parentElement.el != null) {
            this.parentElement.el.addContext(this.currentElement.el);
        }
    }

    public void handleAttributeValue() {
        if (this.currentElement.currentVal != null) {
            String valueType;
            Value v = null;
            String elementTextContent = this.currentElement.currentVal.toString();
            this.currentElement.currentVal = new StringBuffer();
            String string = valueType = !this.currentElement.unknownTerm ? this.ea.getValueType(this.currentElement.el.getContextType()) : null;
            if (valueType != null && VT_PredefinedValueList.equals(valueType)) {
                String predefinedValueId = this.ea.getValueURI(this.currentElement.el.getContextType(), elementTextContent);
                if (predefinedValueId != null) {
                    v = new Value();
                    v.setCode(predefinedValueId);
                }
                String dataType = this.ea.getDataType(this.currentElement.el.getContextType());
                String text = null;
                if (null != dataType) {
                    switch (dataType) {
                        case "Code and Additional Text": {
                            text = this.currentElement.attributes.getValue(attrAdditionalText);
                            break;
                        }
                        case "Code or Alternative Text": {
                            text = this.currentElement.attributes.getValue(attrAlternativeText);
                        }
                    }
                }
                if (text != null) {
                    if (v == null) {
                        v = new Value();
                    }
                    v.setText(text);
                }
            } else if (this.isPrintable(elementTextContent)) {
                if (v == null) {
                    v = new Value();
                }
                v.setText(elementTextContent);
            }
            if (v != null) {
                this.currentElement.el.getValue().add(v);
            }
        }
    }

    protected boolean isPrintable(String s) {
        return s != null && !s.isEmpty() && !s.trim().isEmpty();
    }

    @Override
    public EccairsReport getReport() {
        return this.report;
    }

    public static class SyntaxElement {
        public ElementType type;
        public Context el;
        public String part;
        public Attributes attributes;
        public String qName;
        public StringBuffer currentVal;
        public boolean unknownTerm = false;
    }

    public static enum ElementType {
        Entity,
        Attribute;

    }
}

