/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.e5xml.e5x;

import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess;
import cz.cvut.kbss.eccairs.schema.dao.SingeltonEccairsAccessFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class _E5XXMLToQAMConvertor
extends DefaultHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)_E5XXMLToQAMConvertor.class.getName());
    protected static final OntModel voc = ModelFactory.createOntologyModel();
    protected static final String reportPrefix = "http://onto.fel.cvut.cz/ontologies/aviation/core#Report";
    protected static final String answerBASE = "http://onto.fel.cvut.cz/ontologies/documentation/answer_instance";
    protected static final String predefinedValueQName = "predefined-value";
    protected static final String textValueAnswerQName = "text-value";
    protected static final OntClass reportCls = voc.createClass("http://onto.fel.cvut.cz/ontologies/aviation/core#Report");
    protected static final OntClass eccEntity = voc.createClass("http://onto.fel.cvut.cz/ontologies/eccairs/model/entity");
    protected static final OntClass eccAttribute = voc.createClass("http://onto.fel.cvut.cz/ontologies/eccairs/model/attribute");
    protected static final OntClass questionCls = voc.createClass("http://onto.fel.cvut.cz/ontologies/documentation/question");
    protected static final Resource eccairsPredefinedValueQuestion = voc.createResource("http://onto.fel.cvut.cz/ontologies/eccairs/model/predefined-value");
    protected static final Resource eccairsTextQuestion = voc.createResource("http://onto.fel.cvut.cz/ontologies/eccairs/model/text");
    protected static final OntClass answerCls = voc.createClass("http://onto.fel.cvut.cz/ontologies/documentation/answer");
    protected static final Property hasRelatedQuestion = voc.createProperty("http://onto.fel.cvut.cz/ontologies/aviation/documentation#has_related_question");
    protected static final Property hasPart = voc.createProperty("http://onto.fel.cvut.cz/ontologies/ufo/has_part");
    protected static final Property hasAnswer = voc.createProperty("http://onto.fel.cvut.cz/ontologies/documentation/has_answer");
    protected static final Property hasValue = voc.createProperty("http://onto.fel.cvut.cz/ontologies/documentation/has_value");
    protected static final String attrTaxonomyVersion = "TaxonomyVersion";
    protected static final String attrAdditionalText = "AdditionalText";
    protected static final String attrAlternativeText = "AlternativeText";
    protected static final String attrAttributeId = "attributeId";
    protected static final String attrREF = "REF";
    protected static final String attrID = "ID";
    protected static final String setEl = "SET";
    protected static final String occurrenceEl = "Occurrence";
    protected static final String attributesEl = "ATTRIBUTES";
    protected static final String entitiesEl = "ENTITIES";
    protected static final String linksEl = "LINKS";
    protected static final String plainTextEl = "PLAINTEXT";
    protected static final String encodedTextEl = "ENCODEDTEXT";
    protected static final String VT_PredefinedValueList = "PredefinedValueList";
    protected static final String DT_CodeOrAlternativeText = "Code or Alternative Text";
    protected static final String DT_CodeAndAdditionalText = "Code and Additional Text";
    protected OntModel model;
    protected Stack<SyntaxElement> elementStack = new Stack();
    protected SyntaxElement currentElement;
    protected SyntaxElement parentElement;
    protected SingeltonEccairsAccessFactory ec;
    protected EccairsAccess ea;
    protected Map<String, Resource> id2answer = new HashMap<String, Resource>();

    public _E5XXMLToQAMConvertor() {
        this.ec = new SingeltonEccairsAccessFactory();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentElement.type == ElementType.Attribute) {
            this.createChildContext();
            this.handleAttributeValue();
            this.moveToParentContext();
        }
        this.moveToParentContext();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.createChildContext(qName, attributes);
        switch (qName = qName.toUpperCase()) {
            case "SET": {
                this.handleSet();
                break;
            }
            case "PLAINTEXT": 
            case "ENCODEDTEXT": 
            case "ENTITIES": 
            case "ATTRIBUTES": 
            case "LINKS": {
                this.setCurrentPart(qName);
                break;
            }
            default: {
                System.out.println(qName);
                this.handelOtherElements();
            }
        }
    }

    public void handelOtherElements() {
        if (this.parentElement == null) {
            LOG.warn(String.format("Couldn't parse the file. The root element %s was not found.", setEl));
            return;
        }
        if (this.parentElement.part == null) {
            this.parentElement.part = null;
        }
        switch (this.parentElement.part) {
            case "ATTRIBUTES": {
                this.handleAttribute();
                break;
            }
            case "LINKS": 
            case "ENTITIES": {
                this.setQuestionAnswerInContext(this.getEntityQuestion(), this.getEntityAnswer());
            }
        }
    }

    protected void setCurrentPart(String part) {
        this.currentElement = this.parentElement;
        this.currentElement.part = part;
    }

    protected void createChildContext() {
        if (this.currentElement != null) {
            this.parentElement = this.elementStack.push(this.currentElement);
        }
        this.currentElement = new SyntaxElement();
    }

    protected void createChildContext(String qName, Attributes attributes) {
        this.createChildContext();
        this.currentElement.qName = qName;
        this.currentElement.attributes = attributes;
    }

    protected void moveToParentContext() {
        this.currentElement = this.parentElement;
        if (!this.elementStack.isEmpty()) {
            this.elementStack.pop();
            if (!this.elementStack.isEmpty()) {
                this.parentElement = this.elementStack.peek();
            }
        }
    }

    public void setQuestionAnswerInContext(Resource question, Resource answer) {
        if (question == null || answer == null) {
            return;
        }
        question.addProperty(hasAnswer, (RDFNode)answer);
        if (this.parentElement.answer != null) {
            this.parentElement.answer.addProperty(hasPart, (RDFNode)answer);
        }
    }

    public void handleSet() {
        if (this.isPrintable(this.currentElement.qName) && this.currentElement.qName.toUpperCase().equals(setEl)) {
            String eccVersion = this.currentElement.attributes.getValue(attrTaxonomyVersion);
            if (eccVersion.equals("3.4.0.1")) {
                eccVersion = "3.4.0.2";
            }
            if (this.isPrintable(eccVersion)) {
                this.ea = this.ec.getEccairsVersion(eccVersion);
                this.model.setNsPrefix("eccairs-" + eccVersion, this.ea.getEccairsVersionNamespace());
            }
            this.currentElement.part = entitiesEl;
        }
    }

    protected Resource getEntityQuestion() {
        Resource question = null;
        String id = this.ea.getEntityId(this.currentElement.qName.replace("_", " "));
        if (id != null) {
            String questionURI = this.ea.getEntityURI(id);
            question = this.model.getResource(questionURI);
        }
        this.currentElement.question = question;
        return question;
    }

    protected Resource getEntityAnswer() {
        Resource answer;
        String entityID = null;
        switch (this.parentElement.part) {
            case "LINKS": {
                entityID = this.currentElement.attributes.getValue(attrREF);
                if (entityID != null) break;
                LOG.warn("reference to the entity <{0}> was not found!", (Object)this.currentElement.qName);
                return null;
            }
            case "ENTITIES": {
                entityID = this.currentElement.attributes.getValue(attrID);
            }
        }
        if (entityID != null && (answer = this.id2answer.get(entityID)) != null) {
            return answer;
        }
        String answerID = entityID == null ? String.valueOf(System.nanoTime()) : entityID;
        answer = this.model.getResource("http://onto.fel.cvut.cz/ontologies/documentation/answer_instance_" + this.currentElement.qName + "_" + answerID);
        if (entityID != null) {
            this.id2answer.put(entityID, answer);
        }
        answer.addProperty(RDF.type, (RDFNode)answerCls);
        this.currentElement.answer = answer;
        return answer;
    }

    public String getAttributeId() {
        return this.currentElement.attributes.getValue(attrAttributeId);
    }

    public boolean isAttribute() {
        String val = this.getAttributeId();
        return val != null;
    }

    public void handleAttribute() {
        if (this.isAttribute()) {
            this.currentElement.question = this.getAttributeQuestion();
            this.currentElement.answer = this.getGenericQuestionBasedAnswer();
            this.setQuestionAnswerInContext(this.currentElement.question, this.currentElement.answer);
            this.currentElement.currentVal = new StringBuffer();
            this.currentElement.type = ElementType.Attribute;
        } else {
            LOG.warn("attribute <{0}> has no ID.", (Object)this.currentElement.qName);
        }
    }

    public Resource getAttributeQuestion() {
        this.currentElement.elementID = this.getAttributeId();
        String questionURI = this.ea.getAttributeURI(this.currentElement.elementID);
        return this.model.getResource(questionURI);
    }

    public Resource getGenericQuestionBasedAnswer(String qName) {
        return this.model.getResource("http://onto.fel.cvut.cz/ontologies/documentation/answer_instance_" + qName + "_" + System.nanoTime());
    }

    public Resource getGenericQuestionBasedAnswer() {
        return this.getGenericQuestionBasedAnswer(this.currentElement.qName);
    }

    public void handleAttributeValue() {
        if (this.parentElement.currentVal != null) {
            String elementTextContent = this.parentElement.currentVal.toString();
            String valueType = this.ea.getValueType(this.parentElement.elementID);
            if (VT_PredefinedValueList.equals(valueType)) {
                String predefinedValueId = this.ea.getValueURI(this.parentElement.elementID, elementTextContent);
                if (predefinedValueId != null) {
                    Resource answer = this.getGenericQuestionBasedAnswer(predefinedValueQName);
                    this.setQuestionAnswerInContext(this.model.getResource(eccairsPredefinedValueQuestion.getURI()), answer);
                    answer.addProperty(hasValue, (RDFNode)this.model.getResource(predefinedValueId));
                }
                String dataType = this.ea.getDataType(this.parentElement.elementID);
                String text = null;
                if (DT_CodeAndAdditionalText.equals(dataType)) {
                    text = this.parentElement.attributes.getValue(attrAdditionalText);
                } else if (DT_CodeOrAlternativeText.equals(dataType)) {
                    text = this.parentElement.attributes.getValue(attrAlternativeText);
                }
                if (text != null) {
                    Resource answer = this.getGenericQuestionBasedAnswer(textValueAnswerQName);
                    this.setQuestionAnswerInContext(this.model.getResource(eccairsTextQuestion.getURI()), answer);
                    answer.addProperty(hasValue, text);
                }
            } else if (this.isPrintable(elementTextContent)) {
                Resource answer = this.getGenericQuestionBasedAnswer(textValueAnswerQName);
                this.setQuestionAnswerInContext(this.model.getResource(eccairsTextQuestion.getURI()), answer);
                answer.addProperty(hasValue, elementTextContent);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement.currentVal != null) {
            this.currentElement.currentVal.append(ch, start, length);
        }
    }

    protected boolean isPrintable(String s) {
        return s != null && !s.isEmpty() && !s.trim().isEmpty();
    }

    @Override
    public void startDocument() throws SAXException {
        this.model = ModelFactory.createOntologyModel();
        Ontology o = this.model.createOntology("http://onto.fel.cvut.cz/ontologies/aviation/core#Report_" + System.currentTimeMillis());
        this.model.setNsPrefix("avcore", "http://onto.fel.cvut.cz/ontologies/aviation/core#");
        this.model.setNsPrefix("eccairs", "http://onto.fel.cvut.cz/ontologies/eccairs/model/");
        this.model.setNsPrefix("doc", "http://onto.fel.cvut.cz/ontologies/documentation/");
        this.model.setNsPrefix("ufo", "http://onto.fel.cvut.cz/ontologies/ufo/");
    }

    @Override
    public void endDocument() throws SAXException {
    }

    public void prityPrint() {
    }

    public void parseDocument(String file) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(file, (DefaultHandler)this);
            this.model.write((OutputStream)System.out, "RDF/XML");
        }
        catch (IOException | ParserConfigurationException | SAXException se) {
            se.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String doc = "d:\\downloads\\inbas\\data-brno-376\\16FEDEF0BC91E511B897002655546824\\16FEDEF0BC91E511B897002655546824.xml";
        _E5XXMLToQAMConvertor c = new _E5XXMLToQAMConvertor();
        c.parseDocument(doc);
    }

    public static class SyntaxElement {
        public Resource question;
        public Resource answer;
        public String part;
        public ElementType type;
        public String elementID;
        public String answerID;
        public Attributes attributes;
        public String qName;
        public StringBuffer currentVal;

        public SyntaxElement() {
        }

        public SyntaxElement(Resource resource, Resource answer, String part, String qName) {
            this.question = resource;
            this.answer = answer;
            this.part = part;
            this.qName = qName;
        }

        public SyntaxElement(Resource resource) {
            this.question = resource;
        }
    }

    public static enum ElementType {
        Entity,
        Attribute;

    }
}

