/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs;

import cz.cvut.kbss.commons.utils.StreamUtils;
import cz.cvut.kbss.eccairs.Term;
import cz.cvut.kbss.eccairs.experiments.sparql.ext.eccairsVersionOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.openrdf.model.Resource;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.manager.RemoteRepositoryManager;

public class EccairsMergeModule {
    protected RepoLocation repoSource;
    protected RepoLocation repoTarget;
    protected List<String> eccairsVersionRepoEndpoints;

    public EccairsMergeModule(RepoLocation repoSource, RepoLocation repoTarget) {
        this();
        this.repoSource = repoSource;
        this.repoTarget = repoTarget;
    }

    public EccairsMergeModule() {
    }

    public RepoLocation getRepoSource() {
        return this.repoSource;
    }

    public void setRepoSource(RepoLocation repoSource) {
        this.repoSource = repoSource;
    }

    public RepoLocation getRepoTarget() {
        return this.repoTarget;
    }

    public void setRepoTarget(RepoLocation repoTarget) {
        this.repoTarget = repoTarget;
    }

    public List<String> getEccairsVersionRepoEndpoints() {
        return this.eccairsVersionRepoEndpoints;
    }

    public void setEccairsVersionRepoEndpoints(List<String> eccairsVersionRepoEndpoints) {
        this.eccairsVersionRepoEndpoints = eccairsVersionRepoEndpoints;
    }

    public void run() {
        String[] versions = eccairsVersionOrder.version;
        HashMap<String, Term> merged = new HashMap<String, Term>();
        long tt = 0L;
        for (int i = versions.length - 1; i > -1; --i) {
            long st = System.currentTimeMillis();
            System.out.println("merging version " + versions[i] + " ...");
            ResultSet resultSetTerms = this.fetchTermsFromVersion(versions[i]);
            long changed = this.merge(merged, resultSetTerms);
            st = System.currentTimeMillis() - st;
            tt += st;
            System.out.println(i + "-th iteration duration - " + (double)st / 1000.0);
            System.out.println("current merge size " + merged.size() + "; actual number of changes " + changed);
        }
        System.out.println("merge duration - " + (double)tt / 1000.0);
        System.out.println("total merge size " + merged.size());
        tt = System.currentTimeMillis();
        this.sendResultToRepo(merged);
        tt = System.currentTimeMillis() - tt;
        System.out.println("merge persist duration - " + (double)tt / 1000.0);
    }

    protected long merge(Map<String, Term> merged, ResultSet terms) {
        return StreamUtils.toStream((Iterator)terms, (int)0, (boolean)false).map(x -> {
            String termIri = x.getResource("unversionedTerm").getURI();
            Term t = (Term)merged.get(termIri);
            if (t == null) {
                t = new Term();
                merged.put(termIri, t);
            }
            boolean changed = false;
            t.setIRI(termIri);
            t.setVersionedIRI(x.getResource("termVersion").getURI());
            t.setLabel(x.getLiteral("label").getString());
            changed |= t.setNvlabel(x.getLiteral("nvlabel").getString());
            return changed |= t.setDescription(x.getLiteral("desc").getString());
        }).filter(x -> x).count();
    }

    protected void sendResultToRepo(Map<String, Term> merged) {
        try {
            RemoteRepositoryManager rrm = RemoteRepositoryManager.getInstance((String)"http://martin.inbas.cz/openrdf-sesame");
            Repository repo = rrm.getRepository("eccairs-merge-latest");
            repo.initialize();
            RepositoryConnection con = repo.getConnection();
            ValueFactory vf = repo.getValueFactory();
            con.begin();
            con.add(Term.toStatements(merged.values(), x -> x.toStatements(vf)), new Resource[]{vf.createURI("http://onto.fel.cvut.cz/ontologies/eccairs/aviation-latest")});
            con.commit();
        }
        catch (RepositoryException ex) {
            Logger.getLogger(EccairsMergeModule.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (RepositoryConfigException ex) {
            Logger.getLogger(EccairsMergeModule.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected ResultSet fetchTermsFromVersion(String version) {
        String query = "PREFIX e-model: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT DISTINCT *\n{\n    ?termVersion e-model:is-version-of ?unversionedTerm;\n      rdfs:label ?label;\n      e-model:has-description ?nvlabel;\n      e-model:has-detailed-description ?desc.\n}";
        String service = String.format("http://martin.inbas.cz/openrdf-sesame/repositories/eccairs-aviation-%s", version);
        return QueryExecutionFactory.sparqlService((String)service, (String)query).execSelect();
    }

    public static void main(String[] args) {
        EccairsMergeModule emm = new EccairsMergeModule();
        emm.run();
    }

    public static class RepoLocation {
        protected String endpoint;

        public RepoLocation(String endpoint) {
            this.endpoint = endpoint;
        }
    }
}

