/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.model.dao;

import cz.cvut.kbss.eccairs.report.model.ConceptTermCollection;
import cz.cvut.kbss.eccairs.report.model.Context;
import cz.cvut.kbss.eccairs.report.model.EccairsReport;
import cz.cvut.kbss.eccairs.report.model.Identifiable;
import cz.cvut.kbss.jopa.model.EntityManager;
import cz.cvut.kbss.jopa.model.descriptors.Descriptor;
import cz.cvut.kbss.jopa.model.descriptors.EntityDescriptor;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EccairsReportDao {
    private static final Logger LOG = LoggerFactory.getLogger(EccairsReportDao.class);
    protected EntityManager em;
    protected Set processed = new HashSet();

    public EccairsReportDao(EntityManager em) {
        this.em = em;
    }

    public EccairsReport readReport(String uri, Descriptor d) {
        EccairsReport er = (EccairsReport)this.em.find(EccairsReport.class, (Object)uri);
        return er;
    }

    public void safePersist(EccairsReport r, Descriptor d) {
        if (d == null) {
            d = new EntityDescriptor(URI.create(r.getUri()));
        }
        this.safePersist(r.getOccurrence(), d);
        for (ConceptTermCollection tc : r.getVocabularies()) {
            this.safePersistFlat(tc, d);
        }
        this.safePersistFlat(r, d);
    }

    protected void safePersistFlat(Identifiable i, Descriptor d) {
        if (!this.em.contains((Object)i)) {
            this.em.persist((Object)i, d);
            this.processed.add(i);
        } else {
            this.em.merge((Object)i, d);
        }
    }

    protected void safePersist(Context ctx, Descriptor d) {
        ctx.getContexts().stream().forEach(c -> this.safePersist((Context)c, d));
        this.safePersistFlat(ctx, d);
    }
}

