/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.schema.dao;

import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess;
import cz.cvut.kbss.eccairs.schema.dao.QueryExecFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EccairsAccess_v_2016_02_23
implements EccairsAccess {
    private static final Logger LOG = LoggerFactory.getLogger(EccairsAccess_v_2016_02_23.class);
    protected String eccairsVersion;
    protected String eccns;
    protected String eccmod = "http://onto.fel.cvut.cz/ontologies/eccairs/model/";
    protected String hasid = "eccairs:has-id";
    protected String dataType = "eccairs:has-data-type";
    protected String valueType = "eccairs:has-value-type";
    protected String description = "eccairs:has-description";
    protected String entity = "eccairs:entity";
    protected String attribute = "eccairs:attribute";
    protected String value = "eccairs:value";
    protected String type = "rdf:type";
    protected QueryExecFactory queryFactory;
    protected String detailedDescription = "eccairs:has-detailed-description";
    protected Map<String, String> atr2vals = new HashMap<String, String>();
    protected Map<String, String> entityName2IdCash = new HashMap<String, String>();
    protected Map<String, String> attributeCash = new HashMap<String, String>();
    protected Map<String, String> attributeValueTypeCash = new HashMap<String, String>();
    protected Map<String, String> attributeDataTypeCash = new HashMap<String, String>();
    protected QueryExecution currentQueryExecution;
    protected String locale = "en";
    protected String prefixes = "";
    protected Pattern entityUriPattern;
    protected Pattern attributeUriPattern;
    protected Pattern valueListUriPattern;
    protected Pattern valueUriPattern;
    protected String eccairsContext;
    protected String contextPattern = "%s";

    public EccairsAccess_v_2016_02_23(QueryExecFactory execFactory, String version, String eccairsContext) {
        this.queryFactory = execFactory;
        this.eccairsVersion = version;
        this.eccairsContext = eccairsContext;
        this.init();
    }

    public void init() {
        if (!this.eccairsContext.isEmpty()) {
            this.contextPattern = String.format("GRAPH <%s> {\n%s\n}", this.eccairsContext, this.contextPattern);
        }
        this.entityUriPattern = Pattern.compile(String.format("^%s/e-(\\w+)$", this.eccairsContext));
        this.attributeUriPattern = Pattern.compile(String.format("^%s/a-(\\w+)$", this.eccairsContext));
        this.valueListUriPattern = Pattern.compile(String.format("^%s/vl-a-(\\w+)$", this.eccairsContext));
        this.valueUriPattern = Pattern.compile(String.format("^%s/a-(\\w+)$", this.eccairsContext));
        this.initEccairsVersionDependentStrings();
        this.initEccairsMappingValueSpaces2AttributeIDs();
    }

    protected void initEccairsMappingValueSpaces2AttributeIDs() {
        String query = "SELECT DISTINCT (str(?aid) as ?id) (str(?vl) as ?vup)  {\n" + String.format(this.contextPattern, "  ?vl a eccairs:value-list.\n  ?a eccairs:has-child ?vl.\n  ?a a eccairs:attribute.\n  ?a eccairs:has-id ?aid.") + "}";
        ResultSet rs = this.getQueryExecution(query).execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            String aid = qs.get("id").asLiteral().getString();
            String uri = qs.get("vup").asLiteral().getString();
            if (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            String[] ups = uri.split("/");
            LOG.trace(String.format("%s - %s", aid, ups[ups.length - 1]));
            this.atr2vals.put(aid, ups[ups.length - 1]);
        }
        this.close();
    }

    protected void initEccairsVersionDependentStrings() {
        HashMap<String, String> prefs = new HashMap<String, String>();
        this.eccns = this.eccairsContext + "/";
        prefs.put("ecr", this.eccns);
        prefs.put("eccairs", this.eccmod);
        prefs.put("xsd", XSD.getURI());
        prefs.put("rdf", RDF.getURI());
        prefs.put("rdfs", RDFS.getURI());
        prefs.put("owl", OWL2.getURI());
        this.prefixes = prefs.entrySet().stream().map(x -> String.format("PREFIX %s: <%s>\n", x.getKey(), x.getValue())).collect(Collectors.joining());
    }

    @Override
    public String getEccairsVersion() {
        return this.eccairsVersion;
    }

    @Override
    public String getEccairsVersionNamespace() {
        return this.eccns;
    }

    @Override
    public String getUri() {
        return this.eccairsContext;
    }

    @Override
    public QueryExecFactory getQueryFactory() {
        return this.queryFactory;
    }

    @Override
    public void setEccairsVersion(String eccairsVersion) {
        this.eccairsVersion = eccairsVersion;
    }

    @Override
    public boolean isValueType(String attrid, String vt) {
        return vt.equals(this.getValueType(attrid));
    }

    @Override
    public String getValueType(String attrid) {
        return this.cachedProxy(attrid, this.attributeValueTypeCash, this::getValueTypeImpl);
    }

    protected String getValueTypeImpl(String attrid) {
        String d = "d";
        QuerySolution qs = this.getFirstSolution(this.executeSelect(EccairsAccess_v_2016_02_23.t(EccairsAccess_v_2016_02_23.uri(this.getAttributeURI(attrid)), this.valueType, EccairsAccess_v_2016_02_23.var(d)), d, new String[0]));
        return this.getValue(qs, x -> x.getLiteral(d).getString(), null);
    }

    @Override
    public String getDataType(String attrid) {
        return this.cachedProxy(attrid, this.attributeDataTypeCash, this::getDataTypeImpl);
    }

    protected String getDataTypeImpl(String attrid) {
        String d = "d";
        String dv = EccairsAccess_v_2016_02_23.var(d);
        QuerySolution qs = this.getFirstSolution(this.executeSelect(EccairsAccess_v_2016_02_23.t(EccairsAccess_v_2016_02_23.uri(this.getAttributeURI(attrid)), this.dataType, dv), d, new String[0]));
        String value = this.getValue(qs, x -> x.getLiteral(d).getString(), null);
        value = value.replaceAll("\\s+", " ");
        return value;
    }

    @Override
    public String getEntityId(String lable) {
        return this.cachedProxy(lable, this.entityName2IdCash, this::getEntityIdImpl);
    }

    protected String getEntityIdImpl(String lable) {
        String e = EccairsAccess_v_2016_02_23.var("e");
        String id = "id";
        String vid = EccairsAccess_v_2016_02_23.var(id);
        String d = "d";
        String vd = EccairsAccess_v_2016_02_23.var(d);
        QuerySolution qs = this.getFirstSolution(this.executeSelect(EccairsAccess_v_2016_02_23.g(EccairsAccess_v_2016_02_23.t(e, this.type, this.entity), EccairsAccess_v_2016_02_23.t(e, this.hasid, vid), EccairsAccess_v_2016_02_23.t(e, this.description, vd), EccairsAccess_v_2016_02_23.f(String.format("filter regex(str(%s),\"^%s$\", \"i\")", vd, lable))), id, d));
        return this.getValue(qs, x -> x.getLiteral(id).getLexicalForm(), null);
    }

    @Override
    public String getEntityURI(String entityid) {
        return this.attributeUriPattern.matcher(entityid).matches() ? entityid : String.format("%se-%s", this.eccns, entityid);
    }

    @Override
    public String getAttributeURI(String attrid) {
        return this.attributeUriPattern.matcher(attrid).matches() ? attrid : String.format("%sa-%s", this.eccns, attrid);
    }

    @Override
    public String getValueURI(String attrid, String valid) {
        return String.format("%s/v-%s", this.getValueListURI(attrid), valid);
    }

    @Override
    public String getValueListURI(String attrid) {
        Matcher m = this.attributeUriPattern.matcher(attrid);
        if (m.matches()) {
            attrid = m.group(1);
        }
        return String.format("%s/%s", this.eccairsContext, this.atr2vals.get(attrid));
    }

    @Override
    public boolean isEntity(String id) {
        return this.executeAsk(EccairsAccess_v_2016_02_23.t(EccairsAccess_v_2016_02_23.uri(this.getEntityURI(id)), this.type, this.entity));
    }

    @Override
    public boolean isAttribute(String id) {
        return this.executeAsk(EccairsAccess_v_2016_02_23.t(EccairsAccess_v_2016_02_23.uri(this.getAttributeURI(id)), this.type, this.attribute));
    }

    @Override
    public boolean isKnownValue(String vuri) {
        return this.executeAsk(EccairsAccess_v_2016_02_23.t(EccairsAccess_v_2016_02_23.uri(vuri), this.type, this.value));
    }

    @Override
    public boolean isKnownValue(String aid, String vid) {
        String u = this.getValueURI(aid, vid);
        return u == null ? false : this.isKnownValue(u);
    }

    @Override
    public String getEntityLabel(String id) {
        return this.getLabel(this.getEntityURI(id));
    }

    @Override
    public String getAttributeLabel(String id) {
        return this.getLabel(this.getAttributeURI(id));
    }

    @Override
    public String getValueLabel(String vuri) {
        return this.getLabel(vuri);
    }

    @Override
    public String getValueLabel(String aid, String id) {
        return this.getLabel(this.getValueURI(aid, id));
    }

    public String getLabel(String u) {
        String v = "v";
        QuerySolution qs = this.getFirstSolution(this.executeSelect(EccairsAccess_v_2016_02_23.t(EccairsAccess_v_2016_02_23.uri(u), this.description, EccairsAccess_v_2016_02_23.var(v)), v, new String[0]));
        Object ret = null;
        return this.getValue(qs, x -> x.getLiteral(v).getString(), null);
    }

    protected QueryExecution getQueryExecution(String query) {
        query = String.format("%s\n%s", this.prefixes, query);
        LOG.trace(query);
        try {
            this.currentQueryExecution = this.queryFactory.getExecution(query);
            return this.currentQueryExecution;
        }
        catch (QueryParseException e) {
            LOG.trace(query);
            throw e;
        }
    }

    public ResultSet executeSelect(QueryLine trs, String v, String ... vars) {
        return this.executeSelect(new QueryLine[]{trs}, v, vars);
    }

    public ResultSet executeSelect(QueryLine[] trs, String v, String ... vars) {
        String query = EccairsAccess_v_2016_02_23.select(this.contextPattern, trs, v, vars);
        return this.getQueryExecution(query).execSelect();
    }

    protected <I, O> O getValue(I i, Function<I, O> f, O defaultValue) {
        return i == null ? defaultValue : f.apply(i);
    }

    protected QuerySolution getFirstSolution(ResultSet rs) {
        QuerySolution ret = null;
        if (rs.hasNext()) {
            ret = rs.nextSolution();
        }
        return ret;
    }

    protected void close() {
        if (this.currentQueryExecution != null) {
            if (!this.currentQueryExecution.isClosed()) {
                this.currentQueryExecution.close();
            }
            this.currentQueryExecution = null;
        }
    }

    public boolean executeAsk(QueryLine trs) {
        return this.executeAsk(new QueryLine[]{trs});
    }

    public boolean executeAsk(QueryLine[] trs) {
        String query = EccairsAccess_v_2016_02_23.ask(this.contextPattern, trs);
        boolean result = this.getQueryExecution(query).execAsk();
        this.close();
        return result;
    }

    public static String select(String context, QueryLine[] trs, String v, String ... vars) {
        return "SELECT " + EccairsAccess_v_2016_02_23.var(v) + " " + Stream.of(vars).map(vv -> EccairsAccess_v_2016_02_23.var(vv)).collect(Collectors.joining(" ")) + "{\n" + String.format(context, EccairsAccess_v_2016_02_23.toPattern(trs)) + "\n}";
    }

    public static String select(String context, QueryLine trs, String v, String ... vars) {
        return EccairsAccess_v_2016_02_23.select(context, new QueryLine[]{trs}, v, vars);
    }

    public static String ask(String context, QueryLine trs) {
        return EccairsAccess_v_2016_02_23.ask(context, new QueryLine[]{trs});
    }

    public static String ask(String context, QueryLine[] trs) {
        return "ASK {" + String.format(context, EccairsAccess_v_2016_02_23.toPattern(trs)) + "\n}";
    }

    public static String integer(String n) {
        return String.format("\"%s\"^^xsd:int", n);
    }

    public static String literal(String n) {
        return String.format("\"%s\"", n);
    }

    public static String uri(String n) {
        return String.format("<%s>", n);
    }

    public static String var(String varname) {
        return "?" + varname;
    }

    public static String toPattern(QueryLine tr) {
        return tr.toString();
    }

    public static String toPattern(QueryLine[] trs) {
        return Stream.of(trs).map(x -> x.toString()).collect(Collectors.joining("\n"));
    }

    public static Triple t(String s, String p, String o) {
        return new Triple(s, p, o);
    }

    public static Filter f(String f) {
        return new Filter(f);
    }

    public static QueryLine[] g(QueryLine ... ts) {
        return ts;
    }

    protected String cachedProxy(String input, Map<String, String> cache, Function<String, String> function) {
        String output = cache.get(input);
        if (output == null && (output = function.apply(input)) != null) {
            cache.put(input, output);
        }
        return output;
    }

    public static class Triple
    extends QueryLine {
        public String s;
        public String p;
        public String o;

        public Triple(String s, String p, String o) {
            this.s = s;
            this.p = p;
            this.o = o;
        }

        protected String covertToQueryTerm(String el) {
            if (el.startsWith("http://")) {
                return "<" + el + ">";
            }
            if (el.indexOf(":") < 0 && !el.startsWith("<")) {
                return "?" + el;
            }
            return el;
        }

        public String toString() {
            return this.s + " " + this.p + " " + this.o + '.';
        }
    }

    public static class Filter
    extends QueryLine {
        public String f;

        public Filter(String f) {
            this.f = f;
        }

        public String toString() {
            return this.f;
        }
    }

    public static class QueryLine {
    }
}

