/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ucl.experiments;

import com.sun.mail.imap.IMAPFolder;
import cz.cvut.kbss.commons.io.NamedStream;
import cz.cvut.kbss.eccairs.cfg.Configuration;
import cz.cvut.kbss.eccairs.cfg.ConfigurationJopa;
import cz.cvut.kbss.eccairs.report.e5xml.E5XMLLoader;
import cz.cvut.kbss.eccairs.report.e5xml.e5x.E5XXMLParser;
import cz.cvut.kbss.eccairs.report.model.EccairsReport;
import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess;
import cz.cvut.kbss.eccairs.schema.dao.SingeltonEccairsAccessFactory;
import cz.cvut.kbss.jopa.Persistence;
import cz.cvut.kbss.jopa.model.EntityManagerFactoryImpl;
import cz.cvut.kbss.jopa.model.EntityManagerImpl;
import cz.cvut.kbss.jopa.model.descriptors.Descriptor;
import cz.cvut.kbss.jopa.model.descriptors.EntityDescriptor;
import cz.cvut.kbss.ucl.MappingEccairsData2Aso;
import cz.cvut.kbss.ucl.RLPE5XMapperContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.manager.RepositoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class _ScriptE5XDataFromEmail2RDFForMiro {
    private static final Logger LOG = LoggerFactory.getLogger((String)_ScriptE5XDataFromEmail2RDFForMiro.class.getName());
    protected static final String repository = "http://martin.inbas.cz/openrdf-sesame/repositories/sisel-dev";
    public static EntityManagerFactoryImpl emf = (EntityManagerFactoryImpl)Persistence.createEntityManagerFactory((String)"aaa", ConfigurationJopa.getPersistenceParams("http://martin.inbas.cz/openrdf-sesame/repositories/sisel-dev"));
    public static EntityManagerImpl em = (EntityManagerImpl)emf.createEntityManager();
    public static E5XXMLParser e5xParser = new E5XXMLParser(Configuration.getEccairAccessFactory());
    public static E5XMLLoader loader = new E5XMLLoader();
    public static SingeltonEccairsAccessFactory eaf = Configuration.getEccairAccessFactory();
    public static MappingEccairsData2Aso mapping = new MappingEccairsData2Aso(Configuration.getEccairAccessFactory());

    public static void main(String[] args) throws InterruptedException {
        _ScriptE5XDataFromEmail2RDFForMiro.loadInputStreamFromEmail();
    }

    public static void javaTmpFile() {
        try {
            File f = File.createTempFile("my_java_tmp_file.txt", ".tmp", new File("."));
            System.out.println("create tmp file : ");
            System.out.println(f.getAbsolutePath());
            PrintStream ps = new PrintStream(f);
            ps.print("Hello world!");
            System.out.println("tmp file deleted");
            System.out.println(f.getAbsolutePath());
            ps.print("Hello again!");
            System.out.println("write again to tmp file");
            System.out.println(f.getAbsolutePath());
            ps.close();
            System.out.println("tmp file closed");
            f.delete();
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
        }
    }

    public static void debugZipException() {
        InputStream is = null;
        try {
            String file = "d:\\downloads\\2FA6D6D1AE15E611B897002655546824.e5x";
            is = new FileInputStream(file);
            NamedStream ns = new NamedStream(file, is, file);
            _ScriptE5XDataFromEmail2RDFForMiro.loadData(ns);
        }
        catch (FileNotFoundException ex) {
            LOG.error(null, (Throwable)ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                LOG.error(null, (Throwable)ex);
            }
        }
    }

    public static void testJopaConfig() {
        em.getTransaction().begin();
        em.getTransaction().commit();
    }

    public static void randomTests() {
        String eccairsContext = "http://onto.fel.cvut.cz/ontologies/eccairs/aviation-3.4.0.2";
        Pattern entityUriPattern = Pattern.compile(String.format("^%s/e-(\\w+)$", eccairsContext));
        Pattern attributeUriPattern = Pattern.compile(String.format("^%s/a-(\\w+)$", eccairsContext));
        Pattern valueListUriPattern = Pattern.compile(String.format("^%s/vl-a-(\\w+)$", eccairsContext));
        Pattern valueUriPattern = Pattern.compile(String.format("^%s/a-(\\w+)$", eccairsContext));
        System.out.println(String.format("^%s/e-(\\w+)$", eccairsContext));
        System.out.println(String.format("^%s/a-(\\w+)$", eccairsContext));
        System.out.println(String.format("^%s/vl-a-(\\w+)$", eccairsContext));
        System.out.println(String.format("^%s/vl-a-(\\w+)$", eccairsContext));
        System.out.println(String.format("^%s/a-(\\w+)$", eccairsContext));
    }

    public static void testEccairsAccessAPI_AttributeIds() {
        EccairsAccess ea = Configuration.getEccairAccessFactory().getEccairsVersion("3.4.0.2");
        System.out.println(ea.getValueListURI("5"));
    }

    public static void testEccairsAccrssAPI() {
        EccairsAccess ea = Configuration.getEccairAccessFactory().getEccairsVersion("3.4.0.2");
        String id = "1";
        String l = ea.getEntityLabel(id);
        System.out.println(l);
        id = ea.getEntityId(l);
        System.out.println(id);
        String uri = ea.getEntityURI(id);
        System.out.println(uri);
        System.out.println(ea.getEntityLabel(uri));
        String aid = "1";
        String al = ea.getAttributeLabel(aid);
        System.out.println(al);
        String auri = ea.getAttributeURI(aid);
        System.out.println(auri);
        System.out.println(ea.getAttributeLabel(auri));
    }

    public static void executeUpdateExperiment() {
        try {
            Repository r = RepositoryProvider.getRepository((String)repository);
            r.initialize();
            RepositoryConnection c = r.getConnection();
            c.begin();
            Update u = c.prepareUpdate(QueryLanguage.SPARQL, "DELETE{  <http://onto.fel.cvut.cz/ontologies/ufo/Person> <x> <y>}WHERE{}", "<http://example.org");
            u.execute();
            c.commit();
        }
        catch (RepositoryException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (RepositoryConfigException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (MalformedQueryException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (UpdateExecutionException ex) {
            LOG.error(null, (Throwable)ex);
        }
    }

    public static void executeUpdate(String ... updates) {
        try {
            Repository r = RepositoryProvider.getRepository((String)repository);
            r.initialize();
            for (String update : updates) {
                RepositoryConnection c = r.getConnection();
                c.begin();
                System.out.println(update);
                Update u = c.prepareUpdate(QueryLanguage.SPARQL, update);
                u.execute();
                c.commit();
            }
        }
        catch (RepositoryException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (RepositoryConfigException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (MalformedQueryException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (UpdateExecutionException ex) {
            LOG.error(null, (Throwable)ex);
        }
    }

    public static void loadData(NamedStream ns) {
        loader.prepareFor(ns).loadData().forEach(rt -> _ScriptE5XDataFromEmail2RDFForMiro.persistAndMap(rt));
    }

    public static EccairsReport loadReportFromPlainFile(String f) throws IOException {
        return _ScriptE5XDataFromEmail2RDFForMiro.loadReportFromPlainFile(new NamedStream(f));
    }

    public static EccairsReport loadReportFromPlainFile(NamedStream ns) throws IOException {
        e5xParser.resetParser();
        e5xParser.parseDocument(ns);
        return e5xParser.getReport();
    }

    public static void persistAndMap(EccairsReport r) {
        if (r == null) {
            return;
        }
        String suri = "http://onto.fel.cvut.cz/ontologies/report-" + r.getOriginFileName() + "-001";
        URI context = URI.create(suri);
        em.getTransaction().begin();
        em.persist((Object)r, (Descriptor)new EntityDescriptor(context));
        em.getTransaction().commit();
        _ScriptE5XDataFromEmail2RDFForMiro.executeUpdate(mapping.getUFOTypesQuery(r.getTaxonomyVersion(), suri), mapping.generateEventsFromTypes(r.getTaxonomyVersion(), suri), mapping.generatePartOfRelationBetweenEvents(r.getTaxonomyVersion(), suri), mapping.fixOccurrenceReport(r.getTaxonomyVersion(), suri, r.getOccurrence()), mapping.fixOccurrenceAndEvents(r.getTaxonomyVersion(), suri, r.getOccurrence()));
    }

    public static void loadFromZipFile(String file) throws FileNotFoundException {
        NamedStream ns = new NamedStream(file);
        loader.prepareFor(ns).loadData().forEach(r -> _ScriptE5XDataFromEmail2RDFForMiro.persistAndMap(r));
    }

    public static void loadReportFromPlainFileExperiment() {
        try {
            EccairsReport r = _ScriptE5XDataFromEmail2RDFForMiro.loadReportFromPlainFile("d:\\downloads\\2CA4319E9716E611B897002655546824\\2CA4319E9716E611B897002655546824.xml");
            if (r != null) {
                System.out.println(r.getDomain());
            }
            String suri = "http://onto.fel.cvut.cz/ontologies/report-2CA4319E9716E611B897002655546824.xml";
            URI context = URI.create(suri);
            em.getTransaction().begin();
            em.persist((Object)r, (Descriptor)new EntityDescriptor(context));
            em.getTransaction().commit();
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
        }
    }

    public static List<NamedStream> loadInputStreamFromEmail() {
        List<NamedStream> ret = null;
        try {
            String host = "";
            String user = "ib-caa";
            String password = "";
            Properties properties = new Properties();
            properties.setProperty("mail.store.protocol", "imaps");
            properties.setProperty("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.setProperty("mail.imap.socketFactory.fallback", "false");
            properties.setProperty("mail.imap.socketFactory.port", "993");
            Session emailSession = Session.getDefaultInstance((Properties)properties);
            Store store = emailSession.getStore("imaps");
            store.connect("imap.feld.cvut.cz", user, "ilove376");
            Folder emailFolder = store.getFolder("INBOX");
            emailFolder.open(1);
            if (emailFolder instanceof IMAPFolder) {
                ret = _ScriptE5XDataFromEmail2RDFForMiro.workWithFolder((IMAPFolder)emailFolder);
            }
            emailFolder.close(false);
            store.close();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static List<NamedStream> workWithFolder(IMAPFolder emailFolder) {
        ArrayList<NamedStream> list = new ArrayList<NamedStream>();
        try {
            Message[] messages = emailFolder.getMessages(1, 1);
            System.out.println("messages.length---" + messages.length);
            for (Message message : messages) {
                Object oc = message.getContent();
                if (oc instanceof MimeMultipart) {
                    MimeMultipart cont = (MimeMultipart)oc;
                    for (int ii = 0; ii < cont.getCount(); ++ii) {
                        BodyPart bp = cont.getBodyPart(ii);
                        String name = bp.getDataHandler().getName();
                        InputStream is = bp.getDataHandler().getInputStream();
                        if (name == null || !StringUtils.endsWithIgnoreCase((String)name, (String)".e5x")) continue;
                        System.out.println("part name " + name);
                        System.out.println("content type :" + bp.getContentType());
                        if (is != null) {
                            NamedStream ns = new NamedStream(name, is, String.valueOf(emailFolder.getUID(message)));
                            loader.prepareFor(ns).loadData();
                            continue;
                        }
                        System.out.println("!!! no stream ");
                    }
                } else {
                    System.out.println("Text: " + oc.toString());
                }
                if (!(message.getContent() instanceof MimeMultipart)) continue;
                MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
            }
        }
        catch (MessagingException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
        }
        return list;
    }

    public static void dateExperiments() {
        RLPE5XMapperContext.parseDate("2016-05-08'T'19:24:00");
        RLPE5XMapperContext.parseDate("2016-05-08'T'19:24:00");
    }
}

