/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.e5xml.e5f;

import cz.cvut.kbss.commons.utils.URIUtils;
import cz.cvut.kbss.eccairs.report.e5xml.AbstractE5XMLReportLoader;
import cz.cvut.kbss.eccairs.report.e5xml.e5x._E5XXMLToQAMConvertor;
import cz.cvut.kbss.eccairs.report.model.ConceptTermCollection;
import cz.cvut.kbss.eccairs.report.model.Context;
import cz.cvut.kbss.eccairs.report.model.EccairsReport;
import cz.cvut.kbss.eccairs.report.model.Value;
import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess;
import cz.cvut.kbss.eccairs.schema.dao.SingeltonEccairsAccessFactory;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class E5FXMLParser
extends AbstractE5XMLReportLoader {
    private static final Logger LOG = LoggerFactory.getLogger((String)_E5XXMLToQAMConvertor.class.getName());
    protected static final String reportContextUri = "http://onto.fel.cvut.cz/ontologies/uzpln/occurrence-report/";
    protected static final String setEl = "SET";
    protected static final String attrTaxonomyVersion = "TAXONOMYVERSION";
    protected static final String attrTaxonomyName = "TAXONOMYNAME";
    protected static final String entity = "E";
    protected static final String attrEntityID = "ID";
    protected static final String attribute = "A";
    protected static final String attrAttributeID = "ID";
    protected static final String attrCUSTOMISATIONNAME = "CUSTOMISATIONNAME";
    protected static final String attrCUSTOMISATIONVERSION = "CUSTOMISATIONVERSION";
    protected static final String value = "V";
    protected static final String dataValue = "DV";
    protected static final String attrDataValueID = "ID";
    protected static final String attrDataValueText = "TEXT";
    protected static final String attrREF = "REF";
    protected static final String attrKEY = "KEY";
    protected static final String plainTextEl = "PLAINTEXT";
    protected static final String encodedTextEl = "ENCODEDTEXT";
    protected static final String VT_PredefinedValueList = "PredefinedValueList";
    protected static final String DT_CodeOrAlternativeText = "Code or Alternative Text";
    protected static final String DT_CodeAndAdditionalText = "Code and Additional Text";
    protected SingeltonEccairsAccessFactory eaf;
    protected EccairsAccess ea;
    protected Stack<SyntaxElement> elementStack = new Stack();
    protected SyntaxElement currentElement;
    protected SyntaxElement parentElement;
    protected SyntaxElement context;
    protected SyntaxElement attributeContext;
    protected SyntaxElement valueElement;
    protected SyntaxElement dataValueElement;
    protected EccairsReport report;
    protected ConceptTermCollection evocab;

    public E5FXMLParser(SingeltonEccairsAccessFactory eaf) {
        this.eaf = eaf;
    }

    public E5FXMLParser() {
        this(new SingeltonEccairsAccessFactory());
    }

    public SingeltonEccairsAccessFactory getEc() {
        return this.eaf;
    }

    public void setEc(SingeltonEccairsAccessFactory ec) {
        this.eaf = ec;
    }

    @Override
    public void resetParser() {
        this.ea = null;
        this.report = null;
        this.currentElement = null;
        this.parentElement = null;
        this.elementStack = new Stack();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.createChildContext(qName, attributes);
        qName = qName.toUpperCase();
        if (qName.contains(":")) {
            qName = qName.substring(qName.indexOf(":") + 1);
        }
        LOG.trace(qName);
        switch (qName) {
            case "SET": {
                this.handleSet();
                break;
            }
            default: {
                this.handelOtherElements();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (value.equals(qName)) {
            this.handleAttributeValue();
            this.dataValueElement = null;
            this.valueElement = null;
        }
        this.moveToParentContext();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement.currentVal != null) {
            this.currentElement.currentVal.append(ch, start, length);
        }
    }

    public void handelOtherElements() {
        if (this.parentElement == null) {
            LOG.warn(String.format("Couldn't parse the file. The root element %s was not found.", setEl));
            return;
        }
        switch (this.currentElement.qName) {
            case "A": {
                this.handleAttribute();
                break;
            }
            case "E": {
                this.handleEntity();
                break;
            }
            case "V": {
                this.currentElement.currentVal = new StringBuffer();
                this.valueElement = this.currentElement;
                break;
            }
            case "DV": {
                this.valueElement.currentVal = null;
                this.dataValueElement = this.currentElement;
            }
        }
        if (this.report.getOccurrence() == null) {
            this.report.setOccurrence(this.currentElement.el);
        }
    }

    protected void setCurrentPart(String part) {
        this.currentElement = this.parentElement;
        this.currentElement.part = part;
    }

    protected void createChildContext() {
        if (this.currentElement != null) {
            this.parentElement = this.elementStack.push(this.currentElement);
        }
        this.currentElement = new SyntaxElement();
    }

    protected void createChildContext(String qName, Attributes attributes) {
        this.createChildContext();
        this.currentElement.qName = qName;
        this.currentElement.attributes = attributes;
    }

    protected void moveToParentContext() {
        this.currentElement = this.parentElement;
        if (!this.elementStack.isEmpty()) {
            this.elementStack.pop();
            if (!this.elementStack.isEmpty()) {
                this.parentElement = this.elementStack.peek();
            }
            if (this.currentElement != null && this.currentElement.type == ElementType.Entity) {
                this.context = this.currentElement;
            }
        }
    }

    public void handleSet() {
        if (this.isPrintable(this.currentElement.qName) && this.currentElement.qName.toUpperCase().equals(setEl)) {
            this.report = new EccairsReport();
            this.report.setTaxonomyName(this.currentElement.attributes.getValue(attrTaxonomyName));
            this.report.setTaxonomyVersion("3.4.0.2");
            String eccVersion = this.report.getTaxonomyVersion();
            String eccairsKey = this.getElementKey();
            if (eccairsKey == null) {
                eccairsKey = "";
            }
            if (!(eccairsKey = eccairsKey.trim()).isEmpty()) {
                this.report.setEccairsKey(eccairsKey);
            }
            if (this.isPrintable(eccVersion)) {
                this.ea = this.eaf.getEccairsVersion(eccVersion);
            }
            this.evocab = new ConceptTermCollection();
            this.evocab.setUri(this.ea != null ? this.ea.getUri() : this.eaf.getConfiguration().getEccairsContext(""));
            this.evocab.setName(this.report.getTaxonomyName());
            this.report.getVocabularies().add(this.evocab);
        }
    }

    protected String getEntityTypeId() {
        return this.currentElement.attributes.getValue("ID");
    }

    protected String getEntityTypeURI() {
        String id = this.getEntityTypeId();
        String uri = null;
        if (id != null) {
            uri = this.ea.getEntityURI(id);
        } else {
            uri = this.createUnknownTermUri(reportContextUri, "context");
            this.currentElement.unknownTerm = true;
        }
        return uri;
    }

    public String createUnknownTermUri(String prefix, String type) {
        return URIUtils.getUniqueURI((String)prefix, (String)type);
    }

    protected void flagTermUnknownToEccairs(Context ctx, String label) {
        ctx.setLabel(label);
        ctx.setContextType("http://onto.fel.cvut.cz/ontologies/documentation/unknown_concept_term");
        this.evocab.getUnknownTerms().add(ctx.getUri());
    }

    protected String getEccairsEntityInstanceKey() {
        return this.getElementKey();
    }

    protected String getElementKey() {
        return this.currentElement.attributes.getValue(attrKEY);
    }

    public String getAttributeTypeId() {
        return this.currentElement.attributes.getValue("ID");
    }

    public String getAttributeTypeUri() {
        String id = this.getAttributeTypeId();
        String uri = null;
        if (id != null) {
            uri = this.ea.getAttributeURI(id);
        } else {
            uri = this.createUnknownTermUri(reportContextUri, "context");
            this.currentElement.unknownTerm = true;
        }
        return uri;
    }

    public void handleEntity() {
        this.currentElement.el = new Context();
        String entityTypeURI = this.getEntityTypeURI();
        this.currentElement.el.setContextType(entityTypeURI);
        this.currentElement.el.setEccairsKey(this.getEccairsEntityInstanceKey());
        if (this.currentElement.unknownTerm) {
            this.flagTermUnknownToEccairs(this.currentElement.el, this.currentElement.attributes.getValue("ID"));
        }
        this.context = this.currentElement;
        this.currentElement.type = ElementType.Entity;
        if (this.parentElement.el != null) {
            this.parentElement.el.addContext(this.currentElement.el);
        }
    }

    public void handleAttribute() {
        this.currentElement.el = new Context();
        String attributeTypeUri = this.getAttributeTypeUri();
        this.currentElement.el.setContextType(attributeTypeUri);
        this.currentElement.type = ElementType.Attribute;
        if (this.currentElement.unknownTerm) {
            this.flagTermUnknownToEccairs(this.currentElement.el, this.currentElement.attributes.getValue("ID"));
        }
        this.currentElement.type = ElementType.Attribute;
        if (this.parentElement.el != null) {
            this.parentElement.el.addContext(this.currentElement.el);
            this.attributeContext = this.currentElement;
        }
    }

    public void handleAttributeValue() {
        Value v = null;
        if (this.valueElement.currentVal != null) {
            String elementTextContent = this.valueElement.currentVal.toString().trim();
            if (!elementTextContent.isEmpty()) {
                v = new Value();
                v.setText(elementTextContent);
            }
        } else {
            String valueType;
            String elementTextContent = null;
            String string = valueType = !this.attributeContext.unknownTerm ? this.ea.getValueType(this.attributeContext.el.getContextType()) : null;
            if (valueType != null && VT_PredefinedValueList.equals(valueType)) {
                elementTextContent = this.dataValueElement.attributes.getValue("ID");
                v = this.setCodeValue(v, elementTextContent);
                elementTextContent = this.dataValueElement.attributes.getValue(attrDataValueText);
                v = this.setTextValue(v, elementTextContent);
            } else {
                elementTextContent = this.dataValueElement.attributes.getValue("ID");
                v = this.setTextValue(v, elementTextContent);
            }
        }
        if (v != null) {
            this.attributeContext.el.getValue().add(v);
        } else {
            this.context.el.getContexts().remove(this.attributeContext.el);
        }
    }

    protected Value setTextValue(Value v, String val) {
        if (val == null || (val = val.trim()).isEmpty()) {
            return v;
        }
        if (v == null) {
            v = new Value();
        }
        v.setText(val);
        return v;
    }

    protected Value setCodeValue(Value v, String id) {
        if (id == null || (id = id.trim()).isEmpty()) {
            return v;
        }
        if (v == null) {
            v = new Value();
        }
        String predefinedValueURI = this.ea.getValueURI(this.attributeContext.el.getContextType(), id);
        v.setCode(predefinedValueURI);
        return v;
    }

    protected boolean isPrintable(String s) {
        return s != null && !s.isEmpty() && !s.trim().isEmpty();
    }

    @Override
    public EccairsReport getReport() {
        return this.report;
    }

    public static class SyntaxElement {
        public ElementType type;
        public Context el;
        public String part;
        public Attributes attributes;
        public String qName;
        public StringBuffer currentVal;
        public boolean unknownTerm = false;
    }

    public static enum ElementType {
        Entity,
        Attribute;

    }
}

