/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.schema.dao;

import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess;
import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess_v_2016_02_23;
import cz.cvut.kbss.eccairs.schema.dao.QueryExecFactory;
import cz.cvut.kbss.eccairs.schema.dao.cfg.EccairsAccessConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingeltonEccairsAccessFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)SingeltonEccairsAccessFactory.class.getName());
    protected EccairsAccess eccairsAccessObject;
    protected Map<String, EccairsAccess> cachedEccairsAccessObjects = new HashMap<String, EccairsAccess>();
    protected EccairsAccessConfiguration configuration;

    public SingeltonEccairsAccessFactory(EccairsAccessConfiguration configuration) {
        this.configuration = configuration;
    }

    public SingeltonEccairsAccessFactory() {
    }

    public EccairsAccess getEccairsVersion(String ecrVersion) {
        this.eccairsAccessObject = this.cachedEccairsAccessObjects.get(ecrVersion);
        if (this.eccairsAccessObject == null) {
            QueryExecFactory f = this.configuration.getQueryExecFactoryECVersion(ecrVersion);
            this.eccairsAccessObject = new EccairsAccess_v_2016_02_23(f, ecrVersion, this.configuration.getEccairsContext(ecrVersion));
            this.cachedEccairsAccessObjects.put(ecrVersion, this.eccairsAccessObject);
        }
        return this.eccairsAccessObject;
    }

    public EccairsAccessConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EccairsAccessConfiguration configuration) {
        this.configuration = configuration;
    }
}

