/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ucl;

import cz.cvut.kbss.eccairs.Vocabulary;
import cz.cvut.kbss.eccairs.report.model.Context;
import cz.cvut.kbss.eccairs.report.model.EccairsReport;
import cz.cvut.kbss.eccairs.report.model.Value;
import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess;
import cz.cvut.kbss.eccairs.schema.dao.SingeltonEccairsAccessFactory;
import cz.cvut.kbss.jopa.model.EntityManager;
import cz.cvut.kbss.jopa.model.query.Query;
import cz.cvut.kbss.ucl.RLPE5XMapperContext;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingEccairsData2Aso {
    private static final Logger LOG = LoggerFactory.getLogger((String)MappingEccairsData2Aso.class.getName());
    protected SingeltonEccairsAccessFactory eaf;
    private static final int RANDOM_BOUND = 10000;
    private static final Random RANDOM = new Random();

    public MappingEccairsData2Aso(SingeltonEccairsAccessFactory eaf) {
        this.eaf = eaf;
    }

    public String getUFOTypesQuery(String version, String context) {
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\nPREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\nINSERT {\n    GRAPH <%2$s>{\n       ?entity a ?ufoType.\n    }\n}WHERE{\n    GRAPH <%2$s>{\n        ?entity a ?type.\n        ?entity a e-m:instance.\n    }\n   %3$s\n}";
        String[][] types = new String[][]{MappingEccairsData2Aso.strs("48", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Vehicle"), MappingEccairsData2Aso.strs("31", "http://onto.fel.cvut.cz/ontologies/aviation-safety/runway"), MappingEccairsData2Aso.strs("33", "http://onto.fel.cvut.cz/ontologies/ufo/Physical_object"), MappingEccairsData2Aso.strs("22", "http://onto.fel.cvut.cz/ontologies/documentation/logical_record"), MappingEccairsData2Aso.strs("13", "http://onto.fel.cvut.cz/ontologies/ufo/Physical_object"), MappingEccairsData2Aso.strs("28", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Weather"), MappingEccairsData2Aso.strs("2", "http://onto.fel.cvut.cz/ontologies/documentation/report"), MappingEccairsData2Aso.strs("1", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Aerodrome"), MappingEccairsData2Aso.strs("10", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Air_traffic_service"), MappingEccairsData2Aso.strs("9", "http://onto.fel.cvut.cz/ontologies/aviation-safety/air_traffic_management_agent"), MappingEccairsData2Aso.strs("17", "http://onto.fel.cvut.cz/ontologies/ufo/Agent"), MappingEccairsData2Aso.strs("16", "http://onto.fel.cvut.cz/ontologies/aviation/core/license"), MappingEccairsData2Aso.strs("24", "http://onto.fel.cvut.cz/ontologies/ufo/Event"), MappingEccairsData2Aso.strs("24", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Occurrence"), MappingEccairsData2Aso.strs("47", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Runway_incursion"), MappingEccairsData2Aso.strs("34", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Loss_of_Separation"), MappingEccairsData2Aso.strs("35", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Loss_of_Separation")};
        String vars = this.vars("type", "ufoType");
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        List rows = Stream.of(types).map(x -> this.row(this.uri(ea.getEntityURI(x[0])), this.uri(x[1]))).collect(Collectors.toList());
        return String.format(query, version, context, this.values(vars, rows.toArray()));
    }

    public String generateEventsFromTypes(String version, String context) {
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\nPREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\nINSERT {\n    GRAPH <%2$s>{\n\t?se a ufo:Event.\n" + String.format("     ?se <%s> ?vt.", "http://onto.fel.cvut.cz/ontologies/reporting-tool/has_event_type") + "\t?se a ?vt.\n" + "\t?occ ufo:has_part ?se.\n" + "    }\n" + "}WHERE{\n" + "    GRAPH <%2$s>{\n" + String.format("       ?occ a <%s>.\n", ea.getEntityURI("24")) + "       ?occ e-m:has-child-instance ?o.\n" + "       ?o a ?eventEntity.\n" + "       ?o e-m:has-child-instance ?x.\n" + "       ?x a ?eventType. \n" + "       ?x e-m:has-value ?v.\n" + "       ?v e-m:has-code-value ?vt.\n" + "       BIND( iri(concat(str(?o), \"-\", replace(str(?vt), \"^.*/v-([^/]*$)\", \"$1\") )) as ?se)\n" + "    }\n" + "    %3$s\n" + "}";
        String[][] data = new String[][]{MappingEccairsData2Aso.strs("14", "390"), MappingEccairsData2Aso.strs("14", "391")};
        String vars = this.vars("eventEntity", "eventType");
        List rows = Stream.of(data).map(x -> this.row(this.uri(ea.getEntityURI(x[0])), this.uri(ea.getAttributeURI(x[1])))).collect(Collectors.toList());
        return String.format(query, version, context, this.values(vars, rows.toArray()));
    }

    public String generatePartOfRelationBetweenEvents(String version, String context) {
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\nPREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\nINSERT {\n    GRAPH <%2$s>{\n       ?event1 ufo:has_part ?event2.    }\n}WHERE{\n    GRAPH <%2$s>{\n\t?event1 e-m:has-child-instance ?event2.\n\t?event1 a ufo:Event.\n\t?event2 a ufo:Event.\n    }\n}";
        return String.format(query, version, context);
    }

    public String createAutomatedImporterPerson(String context) {
        return "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\nPREFIX aviation-safety: <http://onto.fel.cvut.cz/ontologies/aviation-safety/>\nPREFIX doc: <http://onto.fel.cvut.cz/ontologies/documentation/>\nINSERT {\n" + String.format("    GRAPH <%s>{\n", context) + String.format("<%s> <%s> <%s>;\n", "http://onto.fel.cvut.cz/ointologies/tools/e5xml-data-importer-0001", RDF.type.toString(), "http://onto.fel.cvut.cz/ontologies/ufo/Person") + String.format(" <%s> \"%s\";\n", "http://xmlns.com/foaf/0.1/firstName", "importer") + String.format(" <%s> \"%s\";\n", "http://xmlns.com/foaf/0.1/lastName", "") + String.format(" <%s> \"%s\";\n", "http://xmlns.com/foaf/0.1/accountName", "e5xml-data-importer-0001") + "    }\n" + "}WHERE{}\n";
    }

    public String fixOccurrenceReport(String version, String context, Context eo) {
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        String reportingdDate = MappingEccairsData2Aso.getTextValConcat(eo, "\n\n", ea.getEntityURI("53"), ea.getAttributeURI("801"));
        if (reportingdDate == null || (reportingdDate = reportingdDate.trim()).isEmpty()) {
            reportingdDate = MappingEccairsData2Aso.getTextValConcat(eo, "\n\n", ea.getAttributeURI("434"));
        }
        if (reportingdDate == null || (reportingdDate = reportingdDate.trim()).isEmpty()) {
            LOG.trace("no creation date found");
            Calendar c = GregorianCalendar.getInstance();
            c.setTime(new Date(0L));
            reportingdDate = c.toInstant().toString();
        }
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\nPREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\nPREFIX aviation-safety: <http://onto.fel.cvut.cz/ontologies/aviation-safety/>\nPREFIX doc: <http://onto.fel.cvut.cz/ontologies/documentation/>\nINSERT {\n    GRAPH <%2$s>{\n" + String.format("?o <%s> ?tval;\n", "http://www.w3.org/2000/01/rdf-schema#label") + String.format(" a <%s>;\n", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Occurrence") + String.format(" <%s> ?oc;\n", "http://onto.fel.cvut.cz/ontologies/reporting-tool/has_event_type") + " a ?oc;\n" + String.format(" <%s> \"%s\"@en.\n", "http://onto.fel.cvut.cz/ontologies/documentation/has_key", MappingEccairsData2Aso.generateKey()) + String.format("?or <%s> \"%s\"^^xsd:long;\n", "http://onto.fel.cvut.cz/ontologies/documentation/has_file_number", MappingEccairsData2Aso.generateFileNumber()) + String.format("    <%s> \"%s\"^^xsd:dateTime;\n", Vocabulary.created, reportingdDate) + String.format("    <%s> 1;\n", "http://onto.fel.cvut.cz/ontologies/documentation/has_revision") + String.format("    a <%s>;\n", "http://onto.fel.cvut.cz/ontologies/documentation/occurrence_report") + String.format("    a <%s>;\n", "http://onto.fel.cvut.cz/ontologies/documentation/report") + String.format("    <%s> <%s>;\n", "http://onto.fel.cvut.cz/ontologies/documentation/has_reporting_phase", "http://onto.fel.cvut.cz/ontologies/documentation/not_processed") + String.format("    <%s> \"%s\"@en;\n", "http://onto.fel.cvut.cz/ontologies/documentation/has_key", MappingEccairsData2Aso.generateKey()) + String.format("    <%s> <%s>;\n", "http://onto.fel.cvut.cz/ontologies/documentation/has-author", "http://onto.fel.cvut.cz/ointologies/tools/e5xml-data-importer-0001") + String.format("    <%s> ?narrative;\n", "http://purl.org/dc/terms/description") + String.format("    <%s> ?occCls.\n", "http://onto.fel.cvut.cz/ontologies/documentation/has_severity_assessment") + "    }\n" + "}WHERE{\n" + "    GRAPH <%2$s>{\n" + "    {SELECT ?or ?o ?tval (sample(?occCat)  as ?oc) ?narrative ?reportingDate ?occCls{\n" + String.format("?or <%s> <%s>;\n", RDF.type, "http://onto.fel.cvut.cz/ontologies/eccairs/model/eccairs_report") + String.format("    <%s> ?o.\n", "http://onto.fel.cvut.cz/ontologies/documentation/documents") + String.format("?o <%s> ?ta, ?oca, ?ne, ?rh, ?ocl.\n", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-child-instance") + String.format("?oca a <%s>;\n", ea.getAttributeURI("430")) + String.format(" <%s>/<%s> ?occCat.\n", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-value", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-code-value") + String.format("?ocl a <%s>;\n", ea.getAttributeURI("431")) + String.format(" <%s>/<%s> ?occCls.\n", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-value", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-code-value") + String.format("?ta a <%s>;\n", ea.getAttributeURI("601")) + String.format(" <%s>/<%s>  ?tval.\n", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-value", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-text-value") + String.format("?ne a <%s>; <%s> [a <%s>; <%s>[<%s> ?narrative]]\n", ea.getEntityURI("22"), "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-child-instance", ea.getAttributeURI("425"), "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-value", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-text-value") + "      }GROUP BY ?or ?o ?tval ?narrative ?reportingDate ?occCls\n" + "    }\n" + "  }\n" + "}";
        return String.format(query, version, context);
    }

    public String fixOccurrenceAndEvents(String version, String context, Context eo) {
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        String occurrenceDate = MappingEccairsData2Aso.getTextValFirst(eo, ea.getAttributeURI("433"));
        Date startTime = null;
        if (occurrenceDate != null && !occurrenceDate.isEmpty()) {
            occurrenceDate = occurrenceDate.replaceAll("\\.", "-");
            String occurrenceTime = MappingEccairsData2Aso.getTextValFirst(eo, ea.getAttributeURI("457"));
            if (occurrenceTime != null && !occurrenceTime.isEmpty()) {
                String date = occurrenceDate + "T" + occurrenceTime;
                startTime = RLPE5XMapperContext.parseDateTime(date);
            } else {
                startTime = RLPE5XMapperContext.parseDate(occurrenceDate);
            }
        }
        if (startTime == null) {
            LOG.debug("start time could not be parsed, using current time.");
            startTime = new Date(0L);
        }
        Calendar inst = GregorianCalendar.getInstance();
        inst.setTime(startTime);
        Instant i1 = inst.toInstant();
        Instant i2 = i1.plusMillis(1000L);
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\nPREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\nPREFIX aviation-safety: <http://onto.fel.cvut.cz/ontologies/aviation-safety/>\nPREFIX doc: <http://onto.fel.cvut.cz/ontologies/documentation/>\nINSERT {\n    GRAPH <%2$s>{\n" + String.format("?e <%s> \"%s\"^^xsd:dateTime;\n", "http://onto.fel.cvut.cz/ontologies/aviation-safety/has_start_time", i1) + String.format(" <%s> \"%s\"^^xsd:dateTime;\n", "http://onto.fel.cvut.cz/ontologies/aviation-safety/has_end_time", i2) + "    }\n" + "}WHERE{\n" + "    GRAPH <%2$s>{\n" + String.format("?e a <%s>;\n", "http://onto.fel.cvut.cz/ontologies/ufo/Event") + "    }\n" + "}";
        return String.format(query, version, context);
    }

    public String[] getAllUpdates(EccairsReport r, String reportUri) {
        return new String[]{this.getUFOTypesQuery(r.getTaxonomyVersion(), reportUri), this.generateEventsFromTypes(r.getTaxonomyVersion(), reportUri), this.generatePartOfRelationBetweenEvents(r.getTaxonomyVersion(), reportUri), this.fixOccurrenceReport(r.getTaxonomyVersion(), reportUri, r.getOccurrence()), this.fixOccurrenceAndEvents(r.getTaxonomyVersion(), reportUri, r.getOccurrence())};
    }

    public void mapReport(EccairsReport r, EntityManager em, String context) {
        String[] updates;
        for (String update : updates = this.getAllUpdates(r, context)) {
            System.out.println(String.format("Executing SPARQL Update %s", update));
            Query q = em.createNativeQuery(update);
            q.executeUpdate();
        }
    }

    public static String generateKey() {
        String key = Long.toString(System.nanoTime());
        return key.concat(Integer.toString(RANDOM.nextInt(10000)));
    }

    public static Long generateFileNumber() {
        return System.currentTimeMillis();
    }

    public String vars(Object ... vars) {
        return Stream.of(vars).map(x -> "?" + x).collect(Collectors.joining(" "));
    }

    public String values(String vars, Object ... rows) {
        return String.format("VALUES (%s){\n%s\n}", vars, Stream.of(rows).map(x -> String.valueOf(x)).collect(Collectors.joining("\n")));
    }

    public String row(String ... s) {
        return String.format("(%s)", Stream.of(s).collect(Collectors.joining(" ")));
    }

    public String uri(String uri) {
        return String.format("<%s>", uri);
    }

    public static String[] strs(String ... strs) {
        return strs;
    }

    protected static Context getDescendentContext(Context c, String ... attributeUri) {
        Optional<Context> ot = MappingEccairsData2Aso.getDescendentContexts(c, attributeUri).findFirst();
        if (ot.isPresent()) {
            return ot.get();
        }
        return null;
    }

    protected static Stream<Context> getDescendentContexts(Stream<Context> in, String contextUri) {
        return in.flatMap(x -> x.getContexts().isEmpty() ? Stream.of(x) : MappingEccairsData2Aso.getDescendentContexts(x.getContexts().stream(), contextUri)).filter(x -> x.getContextTypes().contains(contextUri));
    }

    protected static Stream<Context> getDescendentContexts(Context c, String ... contextUri) {
        Stream<Context> s = Stream.of(c);
        for (String uri : contextUri) {
            s = s.flatMap(x -> x.getContexts().stream()).filter(x -> x.getContextTypes().contains(uri));
        }
        return s;
    }

    protected static URI getCodeValFirst(Context c, String ... attributeUri) {
        return MappingEccairsData2Aso.getAttributeValue(c, attributeUri).stream().map(x -> x.getCode()).findFirst().orElse(null);
    }

    protected static List<URI> getCodeValAll(Context c, String ... attributeUri) {
        return MappingEccairsData2Aso.getAttributeValue(c, attributeUri).stream().map(x -> x.getCode()).collect(Collectors.toList());
    }

    protected static String getTextValFirst(Context c, String ... attributeUri) {
        return MappingEccairsData2Aso.getAttributeValue(c, attributeUri).stream().map(x -> x.getText()).findFirst().orElse(null);
    }

    protected static String getTextValConcat(Context c, String sep, String ... attributeUri) {
        return MappingEccairsData2Aso.getAttributeValue(c, attributeUri).stream().map(x -> x.getText()).collect(Collectors.joining(sep));
    }

    protected static List<Value> getAttributeValue(Context c, String ... attributeUri) {
        Context ctx = MappingEccairsData2Aso.getDescendentContext(c, attributeUri);
        if (ctx != null) {
            return new ArrayList<Value>(ctx.getValue());
        }
        return Collections.EMPTY_LIST;
    }
}

