/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ucl.experiments;

import cz.cvut.kbss.eccairs.experiments.report.e5xml.commons._E5XMLAbstractLoader;
import cz.cvut.kbss.eccairs.experiments.report.e5xml.commons._OccurrenceLoader;
import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess_v_2016_02_23;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class _E5XOccurrenceReportLoaderRLP_XPathImpl
extends _E5XMLAbstractLoader {
    private static final Logger LOG = LoggerFactory.getLogger((String)_E5XOccurrenceReportLoaderRLP_XPathImpl.class.getName());
    protected Node d;
    protected String attributeIdPath = "//*[@attributeId =\"%\"]/@attributeId";
    protected String elementWithId = "//*[@attributeId =\"%s\"]";
    protected EccairsAccess_v_2016_02_23 ecache;
    protected Map<String, List<String>> vals = new HashMap<String, List<String>>();
    public static Map<String, EccairsAccess_v_2016_02_23> cachedEccairses = new HashMap<String, EccairsAccess_v_2016_02_23>();

    @Override
    public void loadReport(Node d, String sourceName) {
        try {
            this.sourceName = sourceName;
            System.out.println("processing " + sourceName);
            this.d = d;
            Node set = this.evaluateSinglePath(d, "/SET");
            if (set == null) {
                System.out.println("could not find the set element for source : " + sourceName);
                return;
            }
            String ecrVersion = this.getAttribute(set, "TaxonomyVersion");
            System.out.println(ecrVersion);
            EccairsAccess_v_2016_02_23 tmp = cachedEccairses.get(ecrVersion);
            if (tmp == null) {
                cachedEccairses.put(ecrVersion, tmp);
            }
            this.ecache = tmp;
        }
        catch (XPathExpressionException ex) {
            LOG.warn(null, (Throwable)ex);
        }
    }

    protected List<Node> getFieldValues(String id) {
        try {
            return this.evaluatePath(this.d, String.format(this.elementWithId, id));
        }
        catch (XPathExpressionException ex) {
            LOG.warn(null, (Throwable)ex);
            return null;
        }
    }

    protected Node getSingleFieldValue(String id) {
        try {
            return this.evaluateSinglePath(this.d, String.format(this.elementWithId, id));
        }
        catch (XPathExpressionException ex) {
            LOG.warn(null, (Throwable)ex);
            return null;
        }
    }

    @Override
    public String getTitle() {
        Node t = this.getSingleFieldValue("601");
        String title = this.plainText(t);
        if (title == null) {
            title = "NO-TITLE";
        }
        return title;
    }

    @Override
    public Date getOccurrenceStartDate() {
        Date date;
        Node dn = this.getSingleFieldValue("477");
        String d = this.plainText(dn);
        if (d == null || d.isEmpty()) {
            date = new Date();
        } else {
            try {
                date = this.df.parse(d);
            }
            catch (ParseException ex) {
                date = new Date();
                LOG.warn(null, (Throwable)ex);
            }
        }
        return date;
    }

    @Override
    public Date getOccurrenceEndDate() {
        return null;
    }

    @Override
    public String getOccurrenceCategory() {
        Node dn = this.getSingleFieldValue("430");
        String id = this.plainText(dn);
        if (id != null) {
            return this.ecache.getValueURI("430", id);
        }
        return null;
    }

    @Override
    public String getOccurrenceCategoryLabel() {
        String occuri = this.getOccurrenceCategory();
        if (occuri == null) {
            return "NO TITLE";
        }
        String lab = this.ecache.getLabel(occuri);
        return lab;
    }

    @Override
    public String getSeverityAssessment() {
        Node sevn = this.getSingleFieldValue("431");
        String sev = this.plainText(sevn);
        try {
            if (sev == null) {
                return null;
            }
            _OccurrenceLoader.OccurrenceSeverity svo = _OccurrenceLoader.OccurrenceSeverity.getById(sev);
            if (svo == null) {
                return null;
            }
            String sv = svo.toString();
            _OccurrenceLoader.OccurrenceSeverity.valueOf(sv);
            return sv;
        }
        catch (IllegalArgumentException ex) {
            LOG.warn(String.format("severity %s not found", sev));
            return null;
        }
    }

    @Override
    public Map<String, String> getEventTypes() {
        if (this.sourceName.contains("D3A971A33C94E511B897002655546824.xml")) {
            this.sourceName = this.sourceName;
        }
        List<Node> eventNodes = this.getFieldValues("390");
        HashMap<String, String> map = new HashMap<String, String>();
        for (Node en : eventNodes) {
            String eventId = this.plainText(en);
            if (eventId == null) continue;
            String eventURI = this.ecache.getValueURI("390", eventId);
            String eventLabel = this.ecache.getValueLabel("390", eventId);
            if (eventId == null) {
                eventLabel = "__NOT AN ECCAIRS EVENT TYPE__";
            }
            map.put(eventURI, eventLabel);
        }
        return map;
    }

    @Override
    public String getDescription() {
        return this.plainText(this.getSingleFieldValue("425"));
    }

    @Override
    public Date getReportCreatetionDate() {
        try {
            String date = this.plainText(this.getSingleFieldValue("801"));
            if (date == null || date.isEmpty()) {
                return new Date();
            }
            return this.df.parse(date);
        }
        catch (ParseException ex) {
            LOG.warn(null, (Throwable)ex);
            return new Date();
        }
    }

    @Override
    public String getSummary() {
        return "";
    }

    @Override
    public String getAuthorUserName() {
        return null;
    }

    @Override
    public String getAuthorFirstSecondName() {
        return null;
    }
}

