/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.experiments.report.e5xml.commons;

import cz.cvut.kbss.eccairs.experiments.report.e5xml.commons._E5XMLLoader;
import cz.cvut.kbss.eccairs.experiments.report.e5xml.commons._OccurrenceLoader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class _E5XMLAbstractLoader
implements _OccurrenceLoader {
    private static final Logger LOG = LoggerFactory.getLogger((String)_E5XMLAbstractLoader.class.getName());
    protected static String ECCAIRSBASE = "http://onto.fel.cvut.cz/ontologies/eccairs-%s/";
    protected static String formbaseRLP = "http://onto.fel.cvut.cz/ontologies/tis-xx.xx.xx/";
    protected static String formbaseUZPLN = "http://onto.fel.cvut.cz/ontologies/uzpln-376-1018-0.1/";
    protected _E5XMLLoader.EccairsCache ecache;
    protected OntModel ont = ModelFactory.createOntologyModel();
    protected XPath xpath = XPathFactory.newInstance().newXPath();
    protected String eccairsbase = "http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/";
    protected String rebase = "";
    protected Property hasPredefinedValue;
    protected Property hasValue;
    protected Map<String, String> formEntries = new HashMap<String, String>();
    protected Individual report;
    protected Individual entity;
    protected Stack<Individual> entityStack;
    protected OntClass Report;
    protected OntClass Question;
    protected DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    protected DateFormat df1 = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssXXX");
    protected String sourceName;

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    protected String plainText(Node val) {
        return _E5XMLAbstractLoader.nullingId(_E5XMLAbstractLoader.getTextContent(val), x -> x.trim());
    }

    public static String nullingId(String str) {
        if (str == null) {
            return null;
        }
        return str.isEmpty() ? null : str;
    }

    public static String nullingId(String str, Function<String, String> map) {
        if (str == null) {
            return null;
        }
        return (str = map.apply(str)).isEmpty() ? null : str;
    }

    public static String getTextContent(Node value) {
        if (value == null) {
            return null;
        }
        String textContent = value.getTextContent();
        if (textContent == null) {
            return null;
        }
        if (textContent.trim().isEmpty()) {
            return "";
        }
        return textContent;
    }

    protected String getAttribute(Node node, String attributeName) {
        Node attribute = node.getAttributes().getNamedItem(attributeName);
        return attribute != null ? attribute.getTextContent() : null;
    }

    protected List<Node> evaluatePath(Node n, String path) throws XPathExpressionException {
        return this.toList((NodeList)this.xpath.evaluate(path, n, XPathConstants.NODESET));
    }

    protected Node evaluateSinglePath(Node n, String path) throws XPathExpressionException {
        return (Node)this.xpath.evaluate(path, n, XPathConstants.NODE);
    }

    protected List<Node> toList(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        ArrayList<Node> ret = new ArrayList<Node>();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            ret.add(nodeList.item(j));
        }
        return ret;
    }

    @Override
    public Map<String, String> getValues() {
        return this.formEntries;
    }

    @Override
    public String getTitle() {
        String title = this.formEntries.get("601text");
        if (title == null) {
            title = "NO-TITLE";
        }
        return title;
    }

    @Override
    public Date getOccurrenceStartDate() {
        Date date;
        String d = this.formEntries.get("447text");
        if (d == null || d.isEmpty()) {
            date = new Date();
        } else {
            try {
                date = this.df.parse(d);
            }
            catch (ParseException ex) {
                date = new Date();
                LOG.warn(null, (Throwable)ex);
            }
        }
        return date;
    }

    @Override
    public Date getOccurrenceEndDate() {
        return null;
    }

    @Override
    public String getOccurrenceCategory() {
        return this.formEntries.get("430");
    }

    @Override
    public String getOccurrenceCategoryLabel() {
        String name = this.formEntries.get("430");
        if (name == null) {
            return "NO TITLE";
        }
        String lab = this.ecache.getLabel(name);
        if (lab == null || lab.trim().isEmpty()) {
            lab = this.ecache.getLabel1308(name);
        }
        return lab;
    }

    @Override
    public String getSeverityAssessment() {
        String sev = this.formEntries.get("432");
        try {
            if (sev == null) {
                return _OccurrenceLoader.OccurrenceSeverity.OCCURRENCE_WITHOUT_SAFETY_EFFECT.toString();
            }
            String sv = this.ecache.getLabel(sev);
            if (sv != null) {
                sv = sv.toUpperCase();
                sv = sv.replaceAll("\\s", "_");
            }
            _OccurrenceLoader.OccurrenceSeverity.valueOf(sv);
        }
        catch (IllegalArgumentException ex) {
            LOG.warn(String.format("severity %s not found", sev));
            return _OccurrenceLoader.OccurrenceSeverity.OCCURRENCE_WITHOUT_SAFETY_EFFECT.toString();
        }
        return sev;
    }

    @Override
    public Map<String, String> getEventTypes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getEventType() {
        String name = this.formEntries.get("390");
        return name;
    }

    @Override
    public String getEventTypeLabel() {
        String name = this.formEntries.get("390");
        if (name == null) {
            return "NO TITLE";
        }
        String lab = this.ecache.getLabel(name);
        if (lab == null || lab.trim().isEmpty()) {
            lab = this.ecache.getLabel1308(name);
        }
        return lab;
    }

    @Override
    public String getDescription() {
        return this.formEntries.get("425text");
    }

    @Override
    public Date getReportCreatetionDate() {
        try {
            String date = this.formEntries.get("434text");
            if (date == null || date.isEmpty()) {
                return new Date();
            }
            return this.df.parse(date);
        }
        catch (ParseException ex) {
            LOG.warn(null, (Throwable)ex);
            return new Date();
        }
    }

    @Override
    public String getSummary() {
        return "";
    }

    @Override
    public String getAuthorUserName() {
        String s = this.formEntries.get("869text");
        if (s == null) {
            return null;
        }
        return s.replaceFirst("\\s", "_");
    }

    @Override
    public String getAuthorFirstSecondName() {
        return this.formEntries.get("869text");
    }
}

