/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.experiments.report.e5xml.commons;

import cz.cvut.kbss.eccairs.experiments.report.e5xml.commons._E5FOccurrenceReportLoader;
import cz.cvut.kbss.eccairs.experiments.report.e5xml.commons._OccurrenceLoader;
import cz.cvut.kbss.ucl.experiments._E5XOccurrenceReportLoaderRLP_XPathImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.atlas.web.auth.SimpleAuthenticator;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class _E5XMLLoader {
    private static final Logger LOG = LoggerFactory.getLogger((String)_E5XMLLoader.class.getName());
    protected static EccairsCache ecache;
    protected static HttpAuthenticator authenticator;
    protected _OccurrenceLoader ol = null;

    public static void initEccairsCache() throws FileNotFoundException {
        authenticator = new SimpleAuthenticator("kostobog", "jmqlfa_3".toCharArray());
        ecache = new EccairsCache();
        ecache.setService("http://martin.inbas.cz/openrdf-sesame/repositories/eccairs-3.4.0.2");
    }

    public _OccurrenceLoader getOl() {
        return this.ol;
    }

    public void setOl(_OccurrenceLoader ol) {
        this.ol = ol;
    }

    protected _OccurrenceLoader get_OccurrenceLoaderE5X() {
        return new _E5XOccurrenceReportLoaderRLP_XPathImpl();
    }

    protected _OccurrenceLoader get_OccurrenceLoaderE5F() {
        return new _E5FOccurrenceReportLoader(ecache);
    }

    protected void getXMLContentFrom_e5(String file) throws SAXException, IOException, ParserConfigurationException, Exception {
        ZipFile zf = new ZipFile(file);
        List<ZipEntry> lze = null;
        if (file.endsWith(".e5f")) {
            lze = this.findEccairsDataFileInZipFile(zf.entries(), "^OCCS/.*\\.E4O$");
            this.ol = this.get_OccurrenceLoaderE5F();
        } else if (file.endsWith(".e5x")) {
            lze = this.findEccairsDataFileInZipFile(zf.entries(), "^.*\\.xml$");
            this.ol = this.get_OccurrenceLoaderE5X();
        } else {
            throw new Exception(String.format("cannot find eccairs data section in file %s.", file));
        }
        for (ZipEntry ze : lze) {
            InputStream is = zf.getInputStream(ze);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(is);
            this.ol.loadReport(doc, file + "/" + ze.getName());
            this.occurrenceReportImported();
        }
    }

    public static void eccairsCacheExperiment() {
        EccairsCache ec = new EccairsCache("http://martin.inbas.cz/openrdf-sesame/repositories/eccairs-1.3.0.8");
        System.out.println(ec.m.size());
        System.out.println(ec.hasValue("447", "6046"));
        System.out.println(ec.hasValue("454", "63"));
        System.out.println(ec.hasValue("454", "64"));
        System.out.println(ec.hasValue("453", "64"));
        System.out.println(ec.hasValue("455", "5"));
        System.out.println(ec.hasValue("431", "400"));
    }

    public abstract void occurrenceReportImported();

    protected List<ZipEntry> findEccairsDataFileInZipFile(Enumeration<? extends ZipEntry> en, String filePattern) throws IOException {
        ArrayList<ZipEntry> ret = new ArrayList<ZipEntry>();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            if (!Pattern.matches(filePattern, ze.getName()) || ze.isDirectory()) continue;
            ret.add(ze);
        }
        return ret;
    }

    public void processDataFolder(String folder, final String ... extensions) throws ParserConfigurationException, IOException, Exception {
        File[] files;
        File f = new File(folder);
        for (File file : files = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                int ret = name.lastIndexOf(".");
                if (ret > -1) {
                    String extension = name.substring(ret + 1);
                    return Stream.of(extensions).anyMatch(e -> e.equalsIgnoreCase(extension)) && !pathname.isDirectory();
                }
                return false;
            }
        })) {
            this.getXMLContentFrom_e5(file.getAbsolutePath());
        }
    }

    public static void main(String[] args) throws IOException, Exception {
        _E5XMLLoader.processE5XFiles("d:\\downloads\\inbas\\data-brno-376\\");
    }

    public static void experiment_0001(String[] args) throws IOException, Exception {
        _E5XMLLoader.initEccairsCache();
        ByteArrayOutputStream bops = new ByteArrayOutputStream();
        final PrintStream out = new PrintStream(bops);
        _E5XMLLoader l = new _E5XMLLoader(){

            @Override
            public void occurrenceReportImported() {
                Map<String, String> map = this.ol.getValues();
                map.entrySet().stream().map(x -> (String)x.getKey() + " - " + (String)x.getValue()).forEach(System.out::println);
                StringWriter sw = new StringWriter();
                out.println("");
                out.println("------------------------------------");
                out.println(this.ol.getTitle());
                out.println(this.ol.getOccurrenceStartDate());
                out.println(this.ol.getDescription());
                out.println(this.ol.getReportCreatetionDate());
                out.println(this.ol.getEventType());
                out.println(this.ol.getSeverityAssessment());
                out.println(this.ol.getAuthorUserName());
                out.println(this.ol.getAuthorFirstSecondName());
            }
        };
        l.processDataFolder("d:\\downloads\\inbas\\data-brno-376\\", new String[0]);
        System.out.println(bops.toString());
    }

    public static void processE5XFiles(String dir) throws IOException, Exception {
        ByteArrayOutputStream bops = new ByteArrayOutputStream();
        final PrintStream out = new PrintStream(bops);
        _E5XMLLoader l = new _E5XMLLoader(){

            @Override
            public void occurrenceReportImported() {
                out.println("processing " + this.ol.getSourceName());
                out.println("");
                out.println("------------------------------------");
                out.println(this.ol.getTitle());
                out.println(this.ol.getOccurrenceStartDate());
                out.println(this.ol.getDescription());
                out.println(this.ol.getReportCreatetionDate());
                out.println("Events:");
                out.println(this.ol.getEventTypes().entrySet().stream().map(x -> "\t" + (String)x.getKey() + " - " + (String)x.getValue()).collect(Collectors.joining("\n")));
                out.println(this.ol.getSeverityAssessment());
                out.println(this.ol.getOccurrenceCategory());
                out.println(this.ol.getOccurrenceCategoryLabel());
            }
        };
        l.processDataFolder(dir, "e5x");
        System.out.println(bops.toString());
    }

    public static void checkValueOfAttributes(String folder) throws IOException, Exception {
        _E5XMLLoader.initEccairsCache();
        _E5XMLLoader l = new _E5XMLLoader(){

            @Override
            public void occurrenceReportImported() {
            }

            @Override
            protected _OccurrenceLoader get_OccurrenceLoaderE5F() {
                return new _E5FOccurrenceReportLoader(ecache){

                    @Override
                    public void loadReport(Node occ, String fn) {
                        System.out.println(fn);
                        this.printAttribute(occ, "390");
                        this.printAttribute(occ, "425");
                        this.printAttribute(occ, "244");
                    }

                    protected void printAttribute(Node occ, String attributeId) {
                        Node d = null;
                        Node id = null;
                        try {
                            d = this.evaluateSinglePath(occ, String.format("//A[@ID=\"%s\"]", attributeId));
                            id = this.evaluateSinglePath(occ, String.format("//A[@ID=\"%s\"]//*[@ID]/@ID", attributeId));
                        }
                        catch (XPathExpressionException ex) {
                            LOG.warn(null, (Throwable)ex);
                        }
                        if (d != null) {
                            String desc = d.getTextContent();
                            if (!desc.trim().isEmpty()) {
                                System.out.println(String.format("\t%s - %s", attributeId, desc));
                            }
                            if (id != null && id.getTextContent() != null && !id.getTextContent().trim().isEmpty()) {
                                System.out.println(String.format("\t%s - %s", attributeId, id.getTextContent()));
                            }
                        } else {
                            System.out.println(String.format("\t%s - %s", attributeId, "not found"));
                        }
                    }
                };
            }
        };
        l.processDataFolder(folder, new String[0]);
    }

    public static void fix_0001_extract_occurrence_category(String folder) throws IOException, Exception {
        ResultSet rs = QueryExecutionFactory.sparqlService((String)"http://martin.inbas.cz/openrdf-sesame/repositories/reports-ucl-2016-02-03", (String)"PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX inb: <http://krizik.felk.cvut.cz/ontologies/inbas-2015#>\n\nSELECT ?x ?sd ?st {\n  ?x rdf:type inb:PreliminaryReport;\n     <http://purl.org/dc/terms/description> ?d;\n    inb:hasAuthor ?a;\n    inb:occurrenceStartTime ?t;\n    inb:hasOccurrence ?occ.\n   ?occ rdfs:label ?l.\n  BIND(str(?d)  as ?sd)\n  BIND(str(?t)  as ?st)\n}").execSelect();
        ArrayList<Resource> os = new ArrayList<Resource>();
        final ArrayList<String> ds = new ArrayList<String>();
        final ArrayList<String> ts = new ArrayList<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            os.add(qs.getResource("x"));
            ds.add(qs.getLiteral("sd").getString());
            ts.add(qs.getLiteral("st").getString());
        }
        _E5XMLLoader.initEccairsCache();
        _E5XMLLoader l = new _E5XMLLoader(){

            @Override
            public void occurrenceReportImported() {
            }

            @Override
            protected _OccurrenceLoader get_OccurrenceLoaderE5F() {
                return new _E5FOccurrenceReportLoader(ecache){

                    @Override
                    public void loadReport(Node occ, String fn) {
                        Node n = null;
                        Node t = null;
                        Node d = null;
                        try {
                            n = this.evaluateSinglePath(occ, "//A[@ID=\"430\"]//DV[@ID]/@ID");
                            t = this.evaluateSinglePath(occ, "//A[@ID=\"601\"]");
                            d = this.evaluateSinglePath(occ, "//A[@ID=\"425\"]");
                        }
                        catch (XPathExpressionException ex) {
                            LOG.warn(null, (Throwable)ex);
                        }
                        if (n != null) {
                            String time = t.getTextContent();
                            String desc = d.getTextContent();
                            int desci = ds.indexOf(desc);
                            int timei = ts.indexOf(desc);
                            System.out.println(desci + " " + timei);
                            System.out.println(n.getTextContent());
                        } else {
                            System.out.println("not found");
                        }
                    }
                };
            }
        };
        l.processDataFolder(folder, "e5f");
    }

    public static class EccairsCache {
        public Model m;
        protected String service;

        public EccairsCache() {
        }

        public void loadFromFile(String filepath) throws FileNotFoundException {
            this.m.read((InputStream)new FileInputStream(filepath), null);
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public EccairsCache(String service) {
            QueryExecution qe = authenticator != null ? QueryExecutionFactory.sparqlService((String)service, (String)"CONSTRUCT{\n  ?x ?y ?z.\n}WHERE{\n  GRAPH ?g{\n    ?x ?y ?z.\n  }\n}", (HttpAuthenticator)authenticator) : QueryExecutionFactory.sparqlService((String)service, (String)"CONSTRUCT{\n  ?x ?y ?z.\n}WHERE{\n  GRAPH ?g{\n    ?x ?y ?z.\n  }\n}");
            this.m = qe.execConstruct();
        }

        protected QueryExecution getQueryExecution(String query) {
            if (this.m != null) {
                return QueryExecutionFactory.create((String)query, (Model)this.m);
            }
            if (this.service != null) {
                if (authenticator != null) {
                    return QueryExecutionFactory.sparqlService((String)this.service, (String)query, (HttpAuthenticator)authenticator);
                }
                return QueryExecutionFactory.sparqlService((String)this.service, (String)query);
            }
            return null;
        }

        public boolean isValueType(String attrid, String valueType) {
            return this.getQueryExecution(String.format("PREFIX j.0: <http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nASK {\n j.0:a-%s a j.0:attribute;\n     j.0:has-value-type \"%s\"}", attrid, valueType)).execAsk();
        }

        public String getValueType(String attrid) {
            return this.getQueryExecution(String.format("PREFIX j.0: <http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nSelect ?vt {\n j.0:a-%s a j.0:attribute;\n     j.0:has-value-type ?vt}", attrid)).execSelect().nextSolution().getLiteral("vt").getString();
        }

        public String getDataType(String attrid) {
            return this.getQueryExecution(String.format("PREFIX j.0: <http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nSelect ?vt {\n j.0:a-%s a j.0:attribute;\n     j.0:has-data-type ?vt}", attrid)).execSelect().nextSolution().getLiteral("vt").getString();
        }

        public boolean hasValue(String attrId, String valueId) {
            if (!StringUtils.isNumeric((String)attrId)) {
                return false;
            }
            String query = String.format("PREFIX j.0: <http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nASK {\n j.0:a-%s j.0:has-child*/j.0:has-id \"%s\"^^xsd:int.}", attrId, valueId);
            return this.getQueryExecution(query).execAsk();
        }

        public String getEntity(String attrid) {
            return String.format("http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/e-%s", attrid);
        }

        public String getAttribute(String attrid) {
            return String.format("http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/a-%s", attrid);
        }

        public String getValue(String valid) {
            return String.format("http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/v-%s", valid);
        }

        public boolean isAttribute(String id) {
            String query = String.format("PREFIX j.0: <http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nASK {\n j.0:a-%s a j.0:attribute.}", id);
            return this.getQueryExecution(query).execAsk();
        }

        public Resource getValueWithCode(String aid, String vid) {
            String query = String.format("PREFIX j.0: <http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT ?v {\n  j.0:a-%s j.0:has-child* ?v.\n  ?v j.0:has-id \"%s\"^^xsd:int.\n}", aid, vid);
            ResultSet rs = this.getQueryExecution(query).execSelect();
            if (rs.hasNext()) {
                return rs.nextSolution().getResource("v");
            }
            return null;
        }

        public Resource getValueWithCode1308(String aid, String vid) {
            String query = String.format("PREFIX j.0: <http://onto.fel.cvut.cz/ontologies/eccairs-1.3.0.8/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT ?v {\n  j.0:A-%s j.0:hasChild* ?v.\n  ?v j.0:hasID \"%s\"^^xsd:int.\n}", aid, vid);
            ResultSet rs = QueryExecutionFactory.sparqlService((String)"https://dev.inbas.cz/openrdf-sesame/repositories/eccairs-1.3.0.8", (String)query, (HttpAuthenticator)authenticator).execSelect();
            if (rs.hasNext()) {
                return rs.nextSolution().getResource("v");
            }
            return null;
        }

        protected String getAttributeLabel(String id) {
            String query = String.format("PREFIX j.0: <http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT ?v {\n  j.0:a-%s j.0:has-description ?v.\n}", id);
            ResultSet rs = this.getQueryExecution(query).execSelect();
            if (rs.hasNext()) {
                return rs.nextSolution().getLiteral("v").getString();
            }
            return null;
        }

        protected String getValueLabel(String aid, String id) {
            String query = String.format("PREFIX j.0: <http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT ?v {\n  j.0:a-%s j.0:has-child* ?c.\n  ?c j.0:has-id \"%s\"^^xsd:int.\n  ?c j.0:has-description ?v.\n}", aid, id);
            ResultSet rs = this.getQueryExecution(query).execSelect();
            if (rs.hasNext()) {
                return rs.nextSolution().getLiteral("v").getString();
            }
            return null;
        }

        protected String getLabel(String uri) {
            String query = String.format("PREFIX j.0: <http://onto.fel.cvut.cz/ontologies/eccairs-3.4.0.2/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT ?d {\n  <%s> j.0:has-description ?d.\n}", uri);
            ResultSet rs = this.getQueryExecution(query).execSelect();
            if (rs.hasNext()) {
                return rs.nextSolution().getLiteral("d").getString();
            }
            return null;
        }

        protected String getLabel1308(String uri) {
            String query = String.format("PREFIX j.0: <http://onto.fel.cvut.cz/ontologies/eccairs-1.3.0.8/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT ?d {\n  <%s> j.0:hasDescription ?d.\n}", uri);
            ResultSet rs = QueryExecutionFactory.sparqlService((String)"https://dev.inbas.cz/openrdf-sesame/repositories/eccairs-1.3.0.8", (String)query, (HttpAuthenticator)authenticator).execSelect();
            if (rs.hasNext()) {
                return rs.nextSolution().getLiteral("d").getString();
            }
            return null;
        }
    }
}

