/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.experiments.report.model.dao.sparql;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EccairsReportQueryElement {
    protected String eccairsVersionPattern = "http://onto.fel.cvut.cz/ontologies/eccairs/aviation-";
    protected String graphPattern;
    protected String filters;
    protected String parentCtxId;
    protected List<EccairsReportQueryElement> childElements = new ArrayList<EccairsReportQueryElement>();

    public String getSparqlGraphPattern() {
        return "";
    }

    public String getSparqlFilter() {
        return "";
    }

    public String getParentCtxId() {
        return this.parentCtxId;
    }

    public void setParentCtxId(String parentCtxId) {
        this.parentCtxId = parentCtxId;
    }

    public String getElementId() {
        return null;
    }

    public EccairsReportQueryElement addQueryElements(EccairsReportQueryElement ... elements) {
        Stream.of(elements).forEach(el -> this.childElements.add((EccairsReportQueryElement)el));
        return this;
    }

    protected String getChildSparqlGraphPattern() {
        return this.childElements.stream().map(el -> {
            el.setParentCtxId(this.getElementId());
            return el.getSparqlGraphPattern();
        }).collect(Collectors.joining("\n"));
    }

    public EccairsReportQueryElement filterTypeVar(String var, String predicate) {
        return this;
    }

    public static void main(String[] args) {
        Report r = new Report();
        r.addQueryElements(new Ctx("e-24", "http://onto.fel.cvut.cz/ontologies/documentation/documents").addQueryElements(Block.optional().addQueryElements(Ctx.getAttributeContext("a-433", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-text-value"), Block.optional().addQueryElements(Ctx.getAttributeContext("a-457", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-text-value")))));
        System.out.println(r.getSparqlGraphPattern());
    }

    public static class Attr
    extends Ctx {
        protected String valProperty;
        protected Ctx attribute;

        public Attr(String attrId, String valProperty) {
            super(attrId, null);
            this.valProperty = valProperty;
        }

        protected String getValVar() {
            return this.getIdBasedVar("val");
        }

        @Override
        public String getSparqlGraphPattern() {
            return String.format("%s <%s> [ <%s> %s].\n", this.parentCtxId, "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-value", this.valProperty, this.getValVar());
        }
    }

    public static class Ctx
    extends EccairsReportQueryElement {
        protected String id;
        protected String relationToParent;

        public Ctx(String id, String relationToParent) {
            this.id = id;
            this.relationToParent = relationToParent;
        }

        public static Ctx getAttributeContext(String attrId, String valProperty) {
            Ctx attribute = new Ctx(attrId, "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-child-instance");
            attribute.addQueryElements(new Attr(attrId, valProperty));
            return attribute;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getElementId() {
            return this.getCtxVar();
        }

        @Override
        public String getSparqlGraphPattern() {
            String typeIdVar = this.getTypeIdVar();
            String ctxVar = this.getCtxVar();
            return String.format("%s <%s> %s.\n%s a %s.\n", this.parentCtxId, this.relationToParent, ctxVar, ctxVar, typeIdVar) + this.getFilters() + "\n" + this.getChildSparqlGraphPattern();
        }

        protected String getIdBasedVar(String prefix) {
            return String.format("?%s_%s", prefix, this.id.replace("-", "_"));
        }

        protected String getTypeIdVar() {
            return this.getIdBasedVar("Type");
        }

        protected String getCtxVar() {
            return this.getIdBasedVar("ctx");
        }

        public String getFilters() {
            String filters = "";
            String typeIdVar = this.getTypeIdVar();
            filters = filters + String.format("FILTER(contains(str(%s), \"/%s\"))\n", typeIdVar, this.id);
            filters = filters + String.format("FILTER(contains(str(%s), \"%s\"))", typeIdVar, this.eccairsVersionPattern);
            return filters;
        }
    }

    public static class Block
    extends EccairsReportQueryElement {
        protected String blockName;

        public Block(String blockName) {
            this.blockName = blockName;
        }

        @Override
        public String getSparqlGraphPattern() {
            return String.format("%s{%s\n}", this.blockName, this.getChildSparqlGraphPattern());
        }

        public static Block optional() {
            return new Block(Blocks.Optional.toString());
        }

        @Override
        public String getElementId() {
            return this.getParentCtxId();
        }
    }

    public static enum Blocks {
        Optional;

    }

    public static class Report
    extends EccairsReportQueryElement {
        @Override
        public String getSparqlGraphPattern() {
            return String.format("%s a <%s>.\n", this.getElementId(), "http://onto.fel.cvut.cz/ontologies/eccairs/model/eccairs_report") + "\n" + this.getChildSparqlGraphPattern();
        }

        @Override
        public String getElementId() {
            return "?eccreport";
        }
    }
}

