/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.eccairs.report.e5xml.e5f;

import cz.cvut.kbss.eccairs.report.e5xml.e5f.E5FXMLParser;
import cz.cvut.kbss.eccairs.report.model.Value;
import cz.cvut.kbss.eccairs.schema.dao.SingeltonEccairsAccessFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E5FXMLParserEccairs
extends E5FXMLParser {
    private static final Logger LOG = LoggerFactory.getLogger(E5FXMLParserEccairs.class);
    private String eccairsEncoding = "x-UTF-16LE-BOM";
    private String defaultEncoding = "UTF-8";

    public E5FXMLParserEccairs(SingeltonEccairsAccessFactory eaf) {
        super(eaf);
    }

    public E5FXMLParserEccairs() {
    }

    @Override
    protected Value setTextValue(Value v, String val) {
        if ((v = super.setTextValue(v, val)) != null) {
            String string = v.getText();
        }
        return v;
    }

    protected String urlDecode(String input) {
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error(String.format("Encoding %s not supported", this.defaultEncoding), (Throwable)ex);
            return input;
        }
    }

    protected String base64Decode(String input) {
        String ret = input;
        try {
            ret = new String(Base64.getDecoder().decode(input), this.eccairsEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error(String.format("Encoding %s not supported", this.eccairsEncoding), (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            LOG.trace(String.format("The string %s is not base64 encoded.", input), (Throwable)ex);
        }
        return ret;
    }
}

