/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.sparql;

import cz.cvut.kbss.sparql.QueryExecFactory;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericSparqlBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(GenericSparqlBuilder.class);
    protected QueryExecFactory queryFactory;
    protected QueryExecution currentQueryExecution;
    protected String prefixes = "";
    protected String contextPattern = "%s";

    public QueryExecFactory getQueryFactory() {
        return this.queryFactory;
    }

    public void setQueryFactory(QueryExecFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public String combineContextPattern(String outterContext) {
        this.contextPattern = String.format("GRAPH <%s> {\n%s\n}", outterContext, this.contextPattern);
        return this.contextPattern;
    }

    public String emptyContextPattern() {
        return "%";
    }

    protected QueryExecution getQueryExecution(String query) {
        query = String.format("%s\n%s", this.prefixes, query);
        LOG.trace(query);
        try {
            this.currentQueryExecution = this.queryFactory.getExecution(query);
            return this.currentQueryExecution;
        }
        catch (QueryParseException e) {
            LOG.trace(query);
            throw e;
        }
    }

    public void setPrefixes(Map<String, String> prefs) {
        this.prefixes = prefs.entrySet().stream().map(x -> String.format("PREFIX %s: <%s>\n", x.getKey(), x.getValue())).collect(Collectors.joining());
    }

    public String getPrefixes() {
        return this.prefixes;
    }

    public void setPrefixes(String prefixes) {
        this.prefixes = prefixes;
    }

    public ResultSet executeSelect(QueryLine trs, String v, String ... vars) {
        return this.executeSelect(new QueryLine[]{trs}, v, vars);
    }

    public ResultSet executeSelect(QueryLine[] trs, String v, String ... vars) {
        String query = GenericSparqlBuilder.select(this.contextPattern, trs, v, vars);
        return this.getQueryExecution(query).execSelect();
    }

    protected <I, O> O getValue(I i, Function<I, O> f, O defaultValue) {
        return i == null ? defaultValue : f.apply(i);
    }

    protected QuerySolution getFirstSolution(ResultSet rs) {
        QuerySolution ret = null;
        if (rs.hasNext()) {
            ret = rs.nextSolution();
        }
        return ret;
    }

    protected void close() {
        if (this.currentQueryExecution != null) {
            if (!this.currentQueryExecution.isClosed()) {
                this.currentQueryExecution.close();
            }
            this.currentQueryExecution = null;
        }
    }

    public boolean executeAsk(QueryLine trs) {
        return this.executeAsk(new QueryLine[]{trs});
    }

    public boolean executeAsk(QueryLine[] trs) {
        String query = GenericSparqlBuilder.ask(this.contextPattern, trs);
        boolean result = this.getQueryExecution(query).execAsk();
        this.close();
        return result;
    }

    public static String select(String context, QueryLine[] trs, String v, String ... vars) {
        return "SELECT " + GenericSparqlBuilder.var(v) + " " + Stream.of(vars).map(vv -> GenericSparqlBuilder.var(vv)).collect(Collectors.joining(" ")) + "{\n" + String.format(context, GenericSparqlBuilder.toPattern(trs)) + "\n}";
    }

    public static String select(String context, QueryLine trs, String v, String ... vars) {
        return GenericSparqlBuilder.select(context, new QueryLine[]{trs}, v, vars);
    }

    public static String ask(String context, QueryLine trs) {
        return GenericSparqlBuilder.ask(context, new QueryLine[]{trs});
    }

    public static String ask(String context, QueryLine[] trs) {
        return "ASK {" + String.format(context, GenericSparqlBuilder.toPattern(trs)) + "\n}";
    }

    public static String integer(String n) {
        return String.format("\"%s\"^^xsd:int", n);
    }

    public static String literal(String n) {
        return String.format("\"%s\"", n);
    }

    public static String uri(String n) {
        return String.format("<%s>", n);
    }

    public static String var(String varname) {
        return "?" + varname;
    }

    public static String toPattern(QueryLine tr) {
        return tr.toString();
    }

    public static String toPattern(QueryLine[] trs) {
        return Stream.of(trs).map(x -> x.toString()).collect(Collectors.joining("\n"));
    }

    public static Triple t(String s, String p, String o) {
        return new Triple(s, p, o);
    }

    public static Filter f(String f) {
        return new Filter(f);
    }

    public static QueryLine[] g(QueryLine ... ts) {
        return ts;
    }

    public static String vars(Object ... vars) {
        return Stream.of(vars).map(x -> "?" + x).collect(Collectors.joining(" "));
    }

    public static String values(String vars, Object ... rows) {
        return String.format("VALUES (%s){\n%s\n}", vars, GenericSparqlBuilder.table(rows));
    }

    public static String table(Object ... rows) {
        return Stream.of(rows).map(x -> String.valueOf(x)).collect(Collectors.joining("\n"));
    }

    public static String row(String ... s) {
        return String.format("(%s)", Stream.of(s).collect(Collectors.joining(" ")));
    }

    public static String updateQuery(String insert, String select) {
        return String.format("INSERT{%s}WHERE{%s}", insert, select);
    }

    public static class Triple
    extends QueryLine {
        public String s;
        public String p;
        public String o;

        public Triple(String s, String p, String o) {
            this.s = s;
            this.p = p;
            this.o = o;
        }

        protected String covertToQueryTerm(String el) {
            if (el.startsWith("http://")) {
                return "<" + el + ">";
            }
            if (el.indexOf(":") < 0 && !el.startsWith("<")) {
                return "?" + el;
            }
            return el;
        }

        public String toString() {
            return this.s + " " + this.p + " " + this.o + '.';
        }
    }

    public static class Filter
    extends QueryLine {
        public String f;

        public Filter(String f) {
            this.f = f;
        }

        public String toString() {
            return this.f;
        }
    }

    public static class QueryLine {
    }
}

