/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.sparql;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public interface QueryExecFactory {
    public static final String cacheQuery = "CONSTRUCT{\n  ?x ?y ?z.\n}WHERE{\n  GRAPH ?g{\n    ?x ?y ?z.\n  }\n}";

    public QueryExecution getExecution(String var1);

    public static QueryExecFactory getFactoryInMemoryFromFile(String filename) throws FileNotFoundException {
        Model m = ModelFactory.createDefaultModel();
        m.read((InputStream)new FileInputStream(filename), null);
        return QueryExecFactory.getFactory(m);
    }

    public static QueryExecFactory getFactoryInMemoryFromService(String service) throws FileNotFoundException {
        Model m = QueryExecutionFactory.sparqlService((String)service, (String)cacheQuery).execConstruct();
        return QueryExecFactory.getFactory(m);
    }

    public static QueryExecFactory getFactoryInMemoryFromService(String service, HttpAuthenticator authenticator) throws FileNotFoundException {
        Model m = QueryExecutionFactory.sparqlService((String)service, (String)cacheQuery, (HttpAuthenticator)authenticator).execConstruct();
        return QueryExecFactory.getFactory(m);
    }

    public static QueryExecFactory getFactory(final Model m) {
        return new QueryExecFactory(){

            @Override
            public QueryExecution getExecution(String query) {
                return QueryExecutionFactory.create((String)query, (Model)m);
            }
        };
    }

    public static QueryExecFactory getFactory(final String service) {
        return new QueryExecFactory(){

            @Override
            public QueryExecution getExecution(String query) {
                return QueryExecutionFactory.sparqlService((String)service, (String)query);
            }
        };
    }

    public static QueryExecFactory getFactory(final String service, final HttpAuthenticator authenticator) {
        return new QueryExecFactory(){

            @Override
            public QueryExecution getExecution(String query) {
                return QueryExecutionFactory.sparqlService((String)service, (String)query, (HttpAuthenticator)authenticator);
            }
        };
    }
}

