/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ucl;

import cz.cvut.kbss.eccairs.Vocabulary;
import cz.cvut.kbss.eccairs.report.model.Context;
import cz.cvut.kbss.eccairs.report.model.EccairsReport;
import cz.cvut.kbss.eccairs.report.model.Value;
import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess;
import cz.cvut.kbss.eccairs.schema.dao.SingeltonEccairsAccessFactory;
import cz.cvut.kbss.jopa.model.EntityManager;
import cz.cvut.kbss.jopa.model.query.Query;
import cz.cvut.kbss.sparql.GenericSparqlBuilder;
import cz.cvut.kbss.ucl.RLPE5XMapperContext;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingEccairsData2Aso
extends GenericSparqlBuilder {
    private static final Logger LOG = LoggerFactory.getLogger((String)MappingEccairsData2Aso.class.getName());
    public static final String noValueSelected = "http://onto.fel.cvut/ontologies/form/interaction/no_value_selected";
    protected SingeltonEccairsAccessFactory eaf;
    protected Map<String, String> defaultValues = new HashMap<String, String>();
    private static final int RANDOM_BOUND = 10000;
    private static final Random RANDOM = new Random();

    public MappingEccairsData2Aso(SingeltonEccairsAccessFactory eaf) {
        this.eaf = eaf;
        this.setDefaultValues();
    }

    protected void setDefaultValues() {
    }

    protected String getDefaultValue(String attributeId) {
        return this.defaultValues.getOrDefault(attributeId, noValueSelected);
    }

    public String getUFOTypesQuery(String version, String context) {
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\nPREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\nINSERT {\n    GRAPH <%2$s>{\n       ?entity a ?ufoType.\n    }\n}WHERE{\n    GRAPH <%2$s>{\n        ?entity a ?type.\n        ?entity a e-m:instance.\n    }\n   %3$s\n}";
        String[][] types = new String[][]{MappingEccairsData2Aso.arr("48", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Vehicle"), MappingEccairsData2Aso.arr("31", "http://onto.fel.cvut.cz/ontologies/aviation-safety/runway"), MappingEccairsData2Aso.arr("33", "http://onto.fel.cvut.cz/ontologies/ufo/Physical_object"), MappingEccairsData2Aso.arr("22", "http://onto.fel.cvut.cz/ontologies/documentation/logical_record"), MappingEccairsData2Aso.arr("13", "http://onto.fel.cvut.cz/ontologies/ufo/Physical_object"), MappingEccairsData2Aso.arr("28", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Weather"), MappingEccairsData2Aso.arr("2", "http://onto.fel.cvut.cz/ontologies/documentation/report"), MappingEccairsData2Aso.arr("1", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Aerodrome"), MappingEccairsData2Aso.arr("10", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Air_traffic_service"), MappingEccairsData2Aso.arr("9", "http://onto.fel.cvut.cz/ontologies/aviation-safety/air_traffic_management_agent"), MappingEccairsData2Aso.arr("17", "http://onto.fel.cvut.cz/ontologies/ufo/Agent"), MappingEccairsData2Aso.arr("16", "http://onto.fel.cvut.cz/ontologies/aviation/core/license"), MappingEccairsData2Aso.arr("24", "http://onto.fel.cvut.cz/ontologies/ufo/Event"), MappingEccairsData2Aso.arr("24", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Occurrence"), MappingEccairsData2Aso.arr("47", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Runway_incursion"), MappingEccairsData2Aso.arr("34", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Loss_of_Separation"), MappingEccairsData2Aso.arr("35", "http://onto.fel.cvut.cz/ontologies/aviation-safety/Loss_of_Separation")};
        String vars = MappingEccairsData2Aso.vars("type", "ufoType");
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        List rows = Stream.of(types).map(x -> MappingEccairsData2Aso.row(MappingEccairsData2Aso.uri(ea.getEntityURI(x[0])), MappingEccairsData2Aso.uri(x[1]))).collect(Collectors.toList());
        return String.format(query, version, context, MappingEccairsData2Aso.values(vars, rows.toArray()));
    }

    public String generateEventsFromTypes(String version, String context) {
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\nPREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\nINSERT {\n    GRAPH <%2$s>{\n\t?se a ufo:Event.\n" + String.format("     ?se <%s> ?vt.", "http://onto.fel.cvut.cz/ontologies/reporting-tool/has_event_type") + "\t?se a ?vt.\n\t?occ ufo:has_part ?se.\n    }\n}WHERE{\n    GRAPH <%2$s>{\n" + String.format("       ?occ a <%s>.\n", ea.getEntityURI("24")) + "       ?occ e-m:has-child-instance ?o.\n       ?o a ?eventEntity.\n       ?o e-m:has-child-instance ?x.\n       ?x a ?eventType. \n       ?x e-m:has-value ?v.\n       ?v e-m:has-code-value ?vt.\n       BIND( iri(concat(str(?o), \"-\", replace(str(?vt), \"^.*/v-([^/]*$)\", \"$1\") )) as ?se)\n    }\n    %3$s\n}";
        String[][] data = new String[][]{MappingEccairsData2Aso.arr("14", "390"), MappingEccairsData2Aso.arr("14", "391")};
        String vars = MappingEccairsData2Aso.vars("eventEntity", "eventType");
        List rows = Stream.of(data).map(x -> MappingEccairsData2Aso.row(MappingEccairsData2Aso.uri(ea.getEntityURI(x[0])), MappingEccairsData2Aso.uri(ea.getAttributeURI(x[1])))).collect(Collectors.toList());
        return String.format(query, version, context, MappingEccairsData2Aso.values(vars, rows.toArray()));
    }

    public String generatePartOfRelationBetweenEvents(String version, String context) {
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\nPREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\nINSERT {\n    GRAPH <%2$s>{\n       ?event1 ufo:has_part ?event2.    }\n}WHERE{\n    GRAPH <%2$s>{\n\t?event1 e-m:has-child-instance ?event2.\n\t?event1 a ufo:Event.\n\t?event2 a ufo:Event.\n    }\n}";
        return String.format(query, version, context);
    }

    public String createAutomatedImporterPerson(String context) {
        return "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\nPREFIX aviation-safety: <http://onto.fel.cvut.cz/ontologies/aviation-safety/>\nPREFIX doc: <http://onto.fel.cvut.cz/ontologies/documentation/>\nINSERT {\n" + String.format("    GRAPH <%s>{\n", context) + String.format("<%s> <%s> <%s>;\n", "http://onto.fel.cvut.cz/ointologies/tools/e5xml-data-importer-0001", RDF.type.toString(), "http://onto.fel.cvut.cz/ontologies/ufo/Person") + String.format(" <%s> \"%s\";\n", "http://xmlns.com/foaf/0.1/firstName", "importer") + String.format(" <%s> \"%s\";\n", "http://xmlns.com/foaf/0.1/lastName", "") + String.format(" <%s> \"%s\";\n", "http://xmlns.com/foaf/0.1/accountName", "e5xml-data-importer-0001") + "    }\n}WHERE{}\n";
    }

    public String fixOccurrenceReport(String version, String context, Context eo) {
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        String reportingdDate = MappingEccairsData2Aso.getTextValConcat(eo, "\n\n", ea.getEntityURI("53"), ea.getAttributeURI("801"));
        reportingdDate = reportingdDate != null && !(reportingdDate = reportingdDate.trim()).isEmpty() ? reportingdDate + "T00:00:00+00:00" : MappingEccairsData2Aso.getTextValConcat(eo, "\n\n", ea.getAttributeURI("434"));
        if (reportingdDate == null || (reportingdDate = reportingdDate.trim()).isEmpty()) {
            LOG.trace("no creation date found");
            Calendar c = GregorianCalendar.getInstance();
            c.setTime(new Date(0L));
            reportingdDate = c.toInstant().toString();
        }
        reportingdDate = this.checkAndFixDate(reportingdDate);
        return this.fixOccurrenceReport(version, context, reportingdDate, ea);
    }

    protected String checkAndFixDate(String date) {
        try {
            date = URLDecoder.decode(date, "UTF-8");
            Date d = RLPE5XMapperContext.parseDateTime(date);
            if (d == null) {
                date = "" + MappingEccairsData2Aso.dateToInstant(new Date());
            }
        }
        catch (UnsupportedEncodingException ex) {
            java.util.logging.Logger.getLogger(MappingEccairsData2Aso.class.getName()).log(Level.SEVERE, null, ex);
        }
        return date;
    }

    public String fixOccurrenceReport(String version, String context, String reportingdDate, EccairsAccess ea) {
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\nPREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\nPREFIX aviation-safety: <http://onto.fel.cvut.cz/ontologies/aviation-safety/>\nPREFIX doc: <http://onto.fel.cvut.cz/ontologies/documentation/>\nINSERT {\n    GRAPH <%2$s>{\n" + MappingEccairsData2Aso.t("?o", MappingEccairsData2Aso.uri("http://www.w3.org/2000/01/rdf-schema#label"), "?tval") + "\n" + MappingEccairsData2Aso.t("?o", "a", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/aviation-safety/Occurrence")) + "\n" + MappingEccairsData2Aso.t("?o", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/reporting-tool/has_event_type"), "?oc") + "\n" + MappingEccairsData2Aso.t("?o", "a", "?oc") + "\n" + MappingEccairsData2Aso.t("?o", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has_key"), MappingEccairsData2Aso.generateKeyS()) + "\n" + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has_file_number"), MappingEccairsData2Aso.generateFileNumberS()) + "\n" + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri(Vocabulary.created), MappingEccairsData2Aso.date(reportingdDate)) + "\n" + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has_revision"), "\"1\"^^xsd:integer") + "\n" + MappingEccairsData2Aso.t("?or", "a", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/occurrence_report")) + "\n" + MappingEccairsData2Aso.t("?or", "a", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/report")) + "\n" + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has_reporting_phase"), MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/not_processed")) + "\n" + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has_key"), MappingEccairsData2Aso.generateKeyS()) + "\n" + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has-author"), MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ointologies/tools/e5xml-data-importer-0001")) + "\n" + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://purl.org/dc/terms/description"), "?narrative") + MappingEccairsData2Aso.t("?or", MappingEccairsData2Aso.uri("http://onto.fel.cvut.cz/ontologies/documentation/has_severity_assessment"), "?occCls") + "    }\n}WHERE{\n    GRAPH <%2$s>{\n    {SELECT ?or ?o ?tval (sample(?occCat)  as ?oc) ?narrative ?reportingDate ?occCls{\n" + String.format("?or a <%s>;\n", "http://onto.fel.cvut.cz/ontologies/eccairs/model/eccairs_report") + String.format("    <%s> ?o.\n", "http://onto.fel.cvut.cz/ontologies/documentation/documents") + this.optionalEccairsAttributePattern("?o", "?occCat", "430", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-code-value", MappingEccairsData2Aso.uri(noValueSelected), ea) + this.optionalEccairsAttributePattern("?o", "?occCls", "431", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-code-value", MappingEccairsData2Aso.uri(noValueSelected), ea) + this.optionalEccairsAttributePattern("?o", "?tval", "601", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-text-value", "\"No title\"", ea) + "OPTIONAL{" + String.format("?ne a <%s>.\n", ea.getEntityURI("22")) + this.eccairsAttributePattern("?ne", "?narrative", "425", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-text-value", ea) + "}OPTIONAL{" + String.format("?rh a <%s>.\n", ea.getEntityURI("53")) + this.eccairsAttributePattern("?ne", "?reportingDate", "801", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-text-value", ea) + "}      }GROUP BY ?or ?o ?tval ?narrative ?reportingDate ?occCls\n    }\n  }\n}";
        return String.format(query, version, context);
    }

    protected String eccairsAttributePattern(String entityInstatnce, String valueVar, String attributeId, String attributeType, EccairsAccess ea) {
        return String.format("%s <%s> [a <%s>; <%s>[<%s> %s]].\n", entityInstatnce, "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-child-instance", ea.getAttributeURI(attributeId), "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-value", attributeType, valueVar);
    }

    protected String optionalEccairsAttributePattern(String entityInstatnce, String valueVar, String attributeId, String attributeType, String defaultValue, EccairsAccess ea) {
        String optionalValueVar = valueVar + "_Optional";
        return String.format("OPTIONAL{\n%s}\n" + (defaultValue != null ? String.format("BIND(IF(bound(%s), %s, %s) as %s)\n", optionalValueVar, optionalValueVar, defaultValue, valueVar) : ""), this.eccairsAttributePattern(entityInstatnce, optionalValueVar, attributeId, attributeType, ea));
    }

    public String fixOccurrenceAndEvents(String version, String context, Context eo) {
        EccairsAccess ea = this.eaf.getEccairsVersion(version);
        String occurrenceDate = MappingEccairsData2Aso.getTextValFirst(eo, ea.getAttributeURI("433"));
        Date startTime = null;
        if (occurrenceDate != null && !occurrenceDate.isEmpty()) {
            occurrenceDate = occurrenceDate.replaceAll("\\.", "-");
            String occurrenceTime = MappingEccairsData2Aso.getTextValFirst(eo, ea.getAttributeURI("457"));
            if (occurrenceTime != null && !occurrenceTime.isEmpty()) {
                String date = occurrenceDate + "T" + occurrenceTime;
                startTime = RLPE5XMapperContext.parseDateTime(date);
            } else {
                startTime = RLPE5XMapperContext.parseDate(occurrenceDate);
            }
        }
        if (startTime == null) {
            LOG.debug("start time could not be parsed, using current time.");
            startTime = new Date(0L);
        }
        Instant i1 = MappingEccairsData2Aso.dateToInstant(startTime);
        Instant i2 = i1.plusMillis(1000L);
        String query = "PREFIX e-m: <http://onto.fel.cvut.cz/ontologies/eccairs/model/>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX ufo: <http://onto.fel.cvut.cz/ontologies/ufo/>\nPREFIX eccv: <http://onto.fel.cvut.cz/ontologies/eccairs/aviation-%s/>\nPREFIX aviation-safety: <http://onto.fel.cvut.cz/ontologies/aviation-safety/>\nPREFIX doc: <http://onto.fel.cvut.cz/ontologies/documentation/>\nINSERT {\n    GRAPH <%2$s>{\n" + String.format("?e <%s> \"%s\"^^xsd:dateTime;\n", "http://onto.fel.cvut.cz/ontologies/aviation-safety/has_start_time", i1) + String.format(" <%s> \"%s\"^^xsd:dateTime;\n", "http://onto.fel.cvut.cz/ontologies/aviation-safety/has_end_time", i2) + "    }\n}WHERE{\n    GRAPH <%2$s>{\n" + String.format("?e a <%s>;\n", "http://onto.fel.cvut.cz/ontologies/ufo/Event") + "    }\n}";
        return String.format(query, version, context);
    }

    public static String[] arr(String ... els) {
        return els;
    }

    public String[] getAllUpdates(EccairsReport r, String context) {
        return new String[]{this.getUFOTypesQuery(r.getTaxonomyVersion(), context), this.generateEventsFromTypes(r.getTaxonomyVersion(), context), this.generatePartOfRelationBetweenEvents(r.getTaxonomyVersion(), context), this.fixOccurrenceReport(r.getTaxonomyVersion(), context, r.getOccurrence()), this.fixOccurrenceAndEvents(r.getTaxonomyVersion(), context, r.getOccurrence())};
    }

    public void mapReport(EccairsReport r, EntityManager em, String context) {
        String[] updates;
        for (String update : updates = this.getAllUpdates(r, context)) {
            System.out.println(String.format("Executing SPARQL Update %s", update));
            Query q = em.createNativeQuery(update);
            q.executeUpdate();
        }
    }

    public static Instant dateToInstant(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.toInstant();
    }

    public static String date(String date) {
        return String.format("\"%s\"^^xsd:dateTime", date);
    }

    public static String generateKeyS() {
        String key = Long.toString(System.nanoTime());
        return String.format("\"%s\"@en", "" + key.concat(Integer.toString(RANDOM.nextInt(10000))));
    }

    public static String generateFileNumberS() {
        return String.format("\"%s\"^^xsd:long", "" + System.currentTimeMillis());
    }

    protected static Context getDescendentContext(Context c, String ... attributeUri) {
        Optional<Context> ot = MappingEccairsData2Aso.getDescendentContexts(c, attributeUri).findFirst();
        if (ot.isPresent()) {
            return ot.get();
        }
        return null;
    }

    protected static Stream<Context> getDescendentContexts(Stream<Context> in, String contextUri) {
        return in.flatMap(x -> x.getContexts().isEmpty() ? Stream.of(x) : MappingEccairsData2Aso.getDescendentContexts(x.getContexts().stream(), contextUri)).filter(x -> x.getContextTypes().contains(contextUri));
    }

    protected static Stream<Context> getDescendentContexts(Context c, String ... contextUri) {
        Stream<Context> s = Stream.of(c);
        for (String uri : contextUri) {
            s = s.flatMap(x -> x.getContexts().stream()).filter(x -> x.getContextTypes().contains(uri));
        }
        return s;
    }

    protected static URI getCodeValFirst(Context c, String ... attributeUri) {
        return MappingEccairsData2Aso.getAttributeValue(c, attributeUri).stream().map(x -> x.getCode()).findFirst().orElse(null);
    }

    protected static List<URI> getCodeValAll(Context c, String ... attributeUri) {
        return MappingEccairsData2Aso.getAttributeValue(c, attributeUri).stream().map(x -> x.getCode()).collect(Collectors.toList());
    }

    protected static String getTextValFirst(Context c, String ... attributeUri) {
        return MappingEccairsData2Aso.getAttributeValue(c, attributeUri).stream().map(x -> x.getText()).findFirst().orElse(null);
    }

    protected static String getTextValConcat(Context c, String sep, String ... attributeUri) {
        return MappingEccairsData2Aso.getAttributeValue(c, attributeUri).stream().map(x -> x.getText()).collect(Collectors.joining(sep));
    }

    protected static List<Value> getAttributeValue(Context c, String ... attributeUri) {
        Context ctx = MappingEccairsData2Aso.getDescendentContext(c, attributeUri);
        if (ctx != null) {
            return new ArrayList<Value>(ctx.getValue());
        }
        return Collections.EMPTY_LIST;
    }
}

