/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ucl.experiments;

import cz.cvut.kbss.commons.utils.PropertyUtils;
import cz.cvut.kbss.eccairs.cfg.ConfigurationJopa;
import cz.cvut.kbss.eccairs.report.model.EccairsReport;
import cz.cvut.kbss.eccairs.report.model.dao.EccairsReportDao;
import cz.cvut.kbss.eccairs.schema.dao.EALimitedLocalEccairsSchemaAccess;
import cz.cvut.kbss.eccairs.schema.dao.EccairsAccess;
import cz.cvut.kbss.eccairs.schema.dao.SingeltonEccairsAccessFactory;
import cz.cvut.kbss.eccairs.schema.dao.cfg.EccairsAccessConfiguration;
import cz.cvut.kbss.jopa.Persistence;
import cz.cvut.kbss.jopa.model.EntityManager;
import cz.cvut.kbss.jopa.model.EntityManagerFactory;
import cz.cvut.kbss.jopa.model.descriptors.EntityDescriptor;
import cz.cvut.kbss.sparql.QueryExecFactory;
import cz.cvut.kbss.ucl.MappingEccairsData2Aso;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.util.PrintUtil;
import org.apache.jena.vocabulary.RDF;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.manager.RemoteRepositoryManager;

public class JenaReificationInference {
    public static void main(String[] args) throws Exception {
        JenaReificationInference.testUpdateQuery();
    }

    public static String trule(String s, String p, String o) {
        return String.format("(%s %s %s)", s, p, o);
    }

    public static String rule(String ruleName, String head, String ... body) {
        return String.format("[%s: %s -> %s]", ruleName, Stream.of(body).collect(Collectors.joining(", ")), head);
    }

    public static List<Rule> rules(String ... rs) {
        String rulesString = Stream.of(rs).collect(Collectors.joining("\n "));
        System.out.println(rulesString);
        return Rule.parseRules((String)rulesString);
    }

    public static void testUpdateQuery() throws Exception {
        String eccairsVersion = "3.4.0.2";
        String server = "http://localhost:8080/openrdf-sesame";
        String repoId = "UCL-05-04-2016-working-repo";
        String repository = server + "/repositories/" + repoId;
        Properties p = PropertyUtils.loadProperties((String)"/eccairs-tools-config.properties");
        EccairsAccessConfiguration eac = new EccairsAccessConfiguration(p);
        SingeltonEccairsAccessFactory eaf = new SingeltonEccairsAccessFactory(eac){

            @Override
            public EccairsAccess createEccairsSchemaAccess(QueryExecFactory f, String ecrVersion, String eccairsContext) {
                return new EALimitedLocalEccairsSchemaAccess(f, ecrVersion, eccairsContext);
            }
        };
        EccairsAccess ea = eaf.getEccairsVersion(eccairsVersion);
        MappingEccairsData2Aso mapping = new MappingEccairsData2Aso(eaf);
        String reportOriginalContext = "http://onto.fel.cvut.cz/ontologies/report-be15a7c3-1833-4cc1-ad8f-2bafffb4bca7";
        String reportContext = "http://tmp.context.com/11221122";
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"tmp", ConfigurationJopa.getPersistenceParams(repository));
        EntityManager em = emf.createEntityManager();
        EccairsReportDao erd = new EccairsReportDao(em);
        EntityDescriptor descriptor = new EntityDescriptor(URI.create(reportContext));
        em.getTransaction().begin();
        EccairsReport report = erd.readReport(reportOriginalContext, null);
        em.getTransaction().commit();
        RemoteRepositoryManager rrm = new RemoteRepositoryManager(server);
        rrm.initialize();
        Repository r = rrm.getRepository(repoId);
        r.initialize();
        RepositoryConnection conn = r.getConnection();
        conn.begin();
        conn.prepareUpdate(QueryLanguage.SPARQL, String.format("INSERT{GRAPH <%s>{?s ?p ?o}}WHERE {GRAPH <%s> {?s ?p ?o}}", reportContext, reportOriginalContext)).execute();
        conn.commit();
        em.getTransaction().begin();
        Stream.of(mapping.getAllUpdates(report, reportOriginalContext)).forEach(upd -> em.createNativeQuery(upd).addContext(URI.create(reportOriginalContext)).executeUpdate());
        em.getTransaction().commit();
    }

    public static void experiment2() {
        List<Rule> rules = JenaReificationInference.rules(JenaReificationInference.rule("txtVal", JenaReificationInference.trule("?E", "?PT", "?TV"), JenaReificationInference.trule("?E", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-child-instance", "?C"), JenaReificationInference.trule("?C", RDF.type.getURI(), "?PT"), String.format("notEqual(?PT,%s)", "http://onto.fel.cvut.cz/ontologies/eccairs/model/instance"), JenaReificationInference.trule("?C", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-value", "?V"), JenaReificationInference.trule("?V", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-text-value", "?TV")), JenaReificationInference.rule("codeVal", JenaReificationInference.trule("?E", "?PT", "?CV"), JenaReificationInference.trule("?E", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-child-instance", "?C"), JenaReificationInference.trule("?C", RDF.type.getURI(), "?PT"), String.format("notEqual(?PT,%s)", "http://onto.fel.cvut.cz/ontologies/eccairs/model/instance"), JenaReificationInference.trule("?C", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-value", "?V"), JenaReificationInference.trule("?V", "http://onto.fel.cvut.cz/ontologies/eccairs/model/has-code-value", "?CV")));
        System.out.println(rules.size());
        GenericRuleReasoner grr = new GenericRuleReasoner(rules);
        Model m = QueryExecutionFactory.sparqlService((String)"http://localhost:8080/openrdf-sesame/repositories/UCL-05-04-2016-working-repo", (String)"CONSTRUCT {?x ?y ?z} WHERE {?x ?y ?z.}").execConstruct();
        System.out.println(m.size());
        InfModel im = ModelFactory.createInfModel((Reasoner)grr, (Model)m);
        im.prepare();
        System.out.println(im.size());
        Model mm = ModelFactory.createDefaultModel();
        mm.add((Model)im);
        mm.remove(m);
        System.out.println(mm.size());
        mm.write((OutputStream)System.out, "TTL");
        Properties p = PropertyUtils.loadProperties((String)"/eccairs-tools-config.properties");
        EccairsAccessConfiguration eac = new EccairsAccessConfiguration(p);
        SingeltonEccairsAccessFactory eaf = new SingeltonEccairsAccessFactory(eac){

            @Override
            public EccairsAccess createEccairsSchemaAccess(QueryExecFactory f, String ecrVersion, String eccairsContext) {
                return new EALimitedLocalEccairsSchemaAccess(f, ecrVersion, eccairsContext);
            }
        };
        EccairsAccess ea = eaf.getEccairsVersion("3.4.0.2");
        RDFNode v = null;
        System.out.println("printing 430");
        PrintUtil.printOut((Iterator)im.listStatements(v, im.createProperty(ea.getAttributeURI("430")), v));
        System.out.println("printing 431");
        String s = ea.getAttributeURI("431");
        System.out.println(s);
        PrintUtil.printOut((Iterator)im.listStatements(v, im.createProperty(s), v));
    }

    public static void experiment1() {
        List rules = Rule.parseRules((String)"[(?T rdf:subject ?S), (?T rdf:predicate ?P), (?T rdf:object ?O) -> (?S ?P ?O)]");
        GenericRuleReasoner grr = new GenericRuleReasoner(rules);
        Model m = ModelFactory.createDefaultModel();
        m.add(m.getResource("t"), RDF.subject, (RDFNode)m.getResource("s"));
        m.add(m.getResource("t"), RDF.predicate, (RDFNode)m.getResource("p"));
        m.add(m.getResource("t"), RDF.object, (RDFNode)m.getResource("o"));
        m.write((OutputStream)System.out, "TTL");
        InfModel im = ModelFactory.createInfModel((Reasoner)grr, (Model)m);
        RDFNode v = null;
        StmtIterator iter = im.listStatements(v, m.getProperty("p"), v);
        PrintUtil.printOut((Iterator)iter);
    }
}

